/*
 * Decompiled with CFR 0.152.
 */
package android.support.wearable.watchface;

import android.annotation.TargetApi;
import android.graphics.Rect;
import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLSurface;
import android.opengl.GLES20;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.support.wearable.watchface.WatchFaceService;
import android.util.Log;
import android.view.Choreographer;
import android.view.SurfaceHolder;
import android.view.WindowInsets;

@TargetApi(value=21)
public abstract class Gles2WatchFaceService
extends WatchFaceService {
    private static final String TAG = "Gles2WatchFaceService";
    private static final boolean LOG_VERBOSE = false;
    private static final boolean TRACE_DRAW = false;
    private static final int[] EGL_CONFIG_ATTRIB_LIST = new int[]{12352, 4, 12324, 8, 12323, 8, 12322, 8, 12321, 8, 12344};
    private static final int[] EGL_CONTEXT_ATTRIB_LIST = new int[]{12440, 2, 12344};
    private static final int[] EGL_SURFACE_ATTRIB_LIST = new int[]{12344};

    @Override
    public Engine onCreateEngine() {
        return new Engine();
    }

    public class Engine
    extends WatchFaceService.Engine {
        private static final int MSG_INVALIDATE = 0;
        private EGLDisplay mEglDisplay;
        private EGLConfig mEglConfig;
        private EGLContext mEglContext;
        private EGLSurface mEglSurface;
        private boolean mDrawRequested;
        private boolean mDestroyed;
        private boolean mCalledOnGlContextCreated;
        private int mInsetLeft;
        private int mInsetBottom;
        private final Choreographer mChoreographer = Choreographer.getInstance();
        private final Choreographer.FrameCallback mFrameCallback = new Choreographer.FrameCallback(){

            public void doFrame(long frameTimeNs) {
                if (Engine.this.mDestroyed) {
                    return;
                }
                if (Engine.this.mDrawRequested) {
                    Engine.this.drawFrame();
                }
            }
        };
        private final Handler mHandler = new Handler(){

            public void handleMessage(Message message) {
                switch (message.what) {
                    case 0: {
                        Engine.this.invalidate();
                    }
                }
            }
        };

        public EGLDisplay initializeEglDisplay() {
            EGLDisplay result = EGL14.eglGetDisplay((int)0);
            if (result == EGL14.EGL_NO_DISPLAY) {
                throw new RuntimeException("eglGetDisplay returned EGL_NO_DISPLAY");
            }
            int[] version = new int[2];
            if (!EGL14.eglInitialize((EGLDisplay)result, (int[])version, (int)0, (int[])version, (int)1)) {
                throw new RuntimeException("eglInitialize failed");
            }
            if (Log.isLoggable((String)Gles2WatchFaceService.TAG, (int)3)) {
                Log.d((String)Gles2WatchFaceService.TAG, (String)("EGL version " + version[0] + "." + version[1]));
            }
            return result;
        }

        public EGLConfig chooseEglConfig(EGLDisplay eglDisplay) {
            int[] numEglConfigs = new int[1];
            EGLConfig[] eglConfigs = new EGLConfig[1];
            if (!EGL14.eglChooseConfig((EGLDisplay)eglDisplay, (int[])EGL_CONFIG_ATTRIB_LIST, (int)0, (EGLConfig[])eglConfigs, (int)0, (int)eglConfigs.length, (int[])numEglConfigs, (int)0)) {
                throw new RuntimeException("eglChooseConfig failed");
            }
            if (numEglConfigs[0] == 0) {
                throw new RuntimeException("no matching EGL configs");
            }
            return eglConfigs[0];
        }

        public EGLContext createEglContext(EGLDisplay eglDisplay, EGLConfig eglConfig) {
            EGLContext result = EGL14.eglCreateContext((EGLDisplay)eglDisplay, (EGLConfig)eglConfig, (EGLContext)EGL14.EGL_NO_CONTEXT, (int[])EGL_CONTEXT_ATTRIB_LIST, (int)0);
            if (result == EGL14.EGL_NO_CONTEXT) {
                throw new RuntimeException("eglCreateContext failed");
            }
            return result;
        }

        public EGLSurface createWindowSurface(EGLDisplay eglDisplay, EGLConfig eglConfig, SurfaceHolder surfaceHolder) {
            EGLSurface result = EGL14.eglCreateWindowSurface((EGLDisplay)eglDisplay, (EGLConfig)eglConfig, (Object)surfaceHolder.getSurface(), (int[])EGL_SURFACE_ATTRIB_LIST, (int)0);
            if (result == EGL14.EGL_NO_SURFACE) {
                throw new RuntimeException("eglCreateWindowSurface failed");
            }
            return result;
        }

        private void makeContextCurrent() {
            if (!EGL14.eglMakeCurrent((EGLDisplay)this.mEglDisplay, (EGLSurface)this.mEglSurface, (EGLSurface)this.mEglSurface, (EGLContext)this.mEglContext)) {
                throw new RuntimeException("eglMakeCurrent failed");
            }
        }

        @Override
        public void onCreate(SurfaceHolder surfaceHolder) {
            if (Log.isLoggable((String)Gles2WatchFaceService.TAG, (int)3)) {
                Log.d((String)Gles2WatchFaceService.TAG, (String)"onCreate");
            }
            super.onCreate(surfaceHolder);
            if (this.mEglDisplay == null) {
                this.mEglDisplay = this.initializeEglDisplay();
            }
            if (this.mEglConfig == null) {
                this.mEglConfig = this.chooseEglConfig(this.mEglDisplay);
            }
            if (this.mEglContext == null) {
                this.mEglContext = this.createEglContext(this.mEglDisplay, this.mEglConfig);
            }
        }

        @Override
        public void onDestroy() {
            this.mDestroyed = true;
            this.mHandler.removeMessages(0);
            this.mChoreographer.removeFrameCallback(this.mFrameCallback);
            super.onDestroy();
        }

        public void onGlContextCreated() {
        }

        public void onGlSurfaceCreated(int width, int height) {
        }

        public void onApplyWindowInsets(WindowInsets insets) {
            if (Log.isLoggable((String)Gles2WatchFaceService.TAG, (int)3)) {
                Log.d((String)Gles2WatchFaceService.TAG, (String)("onApplyWindowInsets: " + insets));
            }
            super.onApplyWindowInsets(insets);
            if (Build.VERSION.SDK_INT <= 21) {
                Rect bounds = this.getSurfaceHolder().getSurfaceFrame();
                this.mInsetLeft = insets.getSystemWindowInsetLeft();
                this.mInsetBottom = insets.getSystemWindowInsetBottom();
                this.makeContextCurrent();
                GLES20.glViewport((int)(-this.mInsetLeft), (int)(-this.mInsetBottom), (int)bounds.width(), (int)bounds.height());
            }
        }

        public final void onSurfaceChanged(SurfaceHolder holder, int format, int width, int height) {
            if (Log.isLoggable((String)Gles2WatchFaceService.TAG, (int)3)) {
                Log.d((String)Gles2WatchFaceService.TAG, (String)"onSurfaceChanged");
            }
            super.onSurfaceChanged(holder, format, width, height);
            if (this.mEglSurface != null && !EGL14.eglDestroySurface((EGLDisplay)this.mEglDisplay, (EGLSurface)this.mEglSurface)) {
                Log.w((String)Gles2WatchFaceService.TAG, (String)"eglDestroySurface failed");
            }
            this.mEglSurface = this.createWindowSurface(this.mEglDisplay, this.mEglConfig, holder);
            this.makeContextCurrent();
            GLES20.glViewport((int)(-this.mInsetLeft), (int)(-this.mInsetBottom), (int)width, (int)height);
            if (!this.mCalledOnGlContextCreated) {
                this.mCalledOnGlContextCreated = true;
                this.onGlContextCreated();
            }
            this.onGlSurfaceCreated(width, height);
            this.invalidate();
        }

        public final void onSurfaceRedrawNeeded(SurfaceHolder holder) {
            if (Log.isLoggable((String)Gles2WatchFaceService.TAG, (int)3)) {
                Log.d((String)Gles2WatchFaceService.TAG, (String)"onSurfaceRedrawNeeded");
            }
            super.onSurfaceRedrawNeeded(holder);
            this.drawFrame();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void onSurfaceDestroyed(SurfaceHolder holder) {
            if (Log.isLoggable((String)Gles2WatchFaceService.TAG, (int)3)) {
                Log.d((String)Gles2WatchFaceService.TAG, (String)"onSurfaceDestroyed");
            }
            try {
                if (!EGL14.eglDestroySurface((EGLDisplay)this.mEglDisplay, (EGLSurface)this.mEglSurface)) {
                    Log.w((String)Gles2WatchFaceService.TAG, (String)"eglDestroySurface failed");
                }
                this.mEglSurface = null;
            }
            finally {
                super.onSurfaceDestroyed(holder);
            }
        }

        public final void invalidate() {
            if (!this.mDrawRequested) {
                this.mDrawRequested = true;
                this.mChoreographer.postFrameCallback(this.mFrameCallback);
            }
        }

        public final void postInvalidate() {
            this.mHandler.sendEmptyMessage(0);
        }

        public void onDraw() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void drawFrame() {
            this.mDrawRequested = false;
            if (this.mEglSurface == null) {
                return;
            }
            this.makeContextCurrent();
            this.onDraw();
            if (!EGL14.eglSwapBuffers((EGLDisplay)this.mEglDisplay, (EGLSurface)this.mEglSurface)) {
                Log.w((String)Gles2WatchFaceService.TAG, (String)"eglSwapBuffers failed");
            }
        }
    }
}

