/*
 * Decompiled with CFR 0.152.
 */
package android.support.wearable.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.support.wearable.R;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.view.WindowInsets;
import android.widget.FrameLayout;
import android.widget.TextView;

@TargetApi(value=20)
public class WearableHeaderTextView
extends TextView {
    private static final String TAG = "WearableHeaderTextView";
    private int mCircularTextSize = 0;
    private int mCircularLayoutGravity = 0;

    public WearableHeaderTextView(Context context) {
        this(context, null);
    }

    public WearableHeaderTextView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public WearableHeaderTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.WearableHeaderTextView, 0, 0);
        this.mCircularLayoutGravity = a.getInt(R.styleable.WearableHeaderTextView_circular_layout_gravity, 0);
        this.mCircularTextSize = a.getDimensionPixelSize(R.styleable.WearableHeaderTextView_circular_text_size, 0);
        a.recycle();
    }

    public WindowInsets onApplyWindowInsets(WindowInsets insets) {
        if ((insets = super.onApplyWindowInsets(insets)).isRound()) {
            this.applyCircularStyles();
            this.requestLayout();
        }
        return insets;
    }

    private void applyCircularStyles() {
        if (this.mCircularLayoutGravity != 0) {
            FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)this.getLayoutParams();
            lp.gravity = this.mCircularLayoutGravity;
            this.setLayoutParams((ViewGroup.LayoutParams)lp);
        }
        if (this.mCircularTextSize != 0) {
            this.setTextSize(this.mCircularTextSize);
        }
    }
}

