/*
 * Decompiled with CFR 0.152.
 */
package android.support.wearable.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.wearable.R;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.WindowInsets;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.FrameLayout;
import android.widget.RemoteViews;
import java.util.ArrayList;

@RemoteViews.RemoteView
@TargetApi(value=21)
public class WearableFrameLayout
extends ViewGroup {
    private static final int DEFAULT_CHILD_GRAVITY = 0x800033;
    private static final String TAG = "WearableFrameLayout";
    @ViewDebug.ExportedProperty(category="measurement")
    boolean mMeasureAllChildren = false;
    @ViewDebug.ExportedProperty(category="drawing")
    private Drawable mForeground;
    private ColorStateList mForegroundTintList = null;
    private PorterDuff.Mode mForegroundTintMode = null;
    private boolean mHasForegroundTint = false;
    private boolean mHasForegroundTintMode = false;
    @ViewDebug.ExportedProperty(category="padding")
    private int mForegroundPaddingLeft = 0;
    @ViewDebug.ExportedProperty(category="padding")
    private int mForegroundPaddingTop = 0;
    @ViewDebug.ExportedProperty(category="padding")
    private int mForegroundPaddingRight = 0;
    @ViewDebug.ExportedProperty(category="padding")
    private int mForegroundPaddingBottom = 0;
    private final Rect mSelfBounds = new Rect();
    private final Rect mOverlayBounds = new Rect();
    @ViewDebug.ExportedProperty(category="drawing")
    private int mForegroundGravity = 119;
    @ViewDebug.ExportedProperty(category="drawing")
    private boolean mForegroundInPadding = true;
    boolean mForegroundBoundsChanged = false;
    private final ArrayList<View> mMatchParentChildren = new ArrayList(1);
    private boolean mRound = false;

    public WearableFrameLayout(Context context) {
        super(context);
    }

    public WearableFrameLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public WearableFrameLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public WearableFrameLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.WearableFrameLayout, defStyleAttr, defStyleRes);
        this.mForegroundGravity = a.getInt(R.styleable.WearableFrameLayout_android_foregroundGravity, this.mForegroundGravity);
        Drawable d = a.getDrawable(R.styleable.WearableFrameLayout_android_foreground);
        if (d != null) {
            this.setForeground(d);
        }
        if (a.getBoolean(R.styleable.WearableFrameLayout_android_measureAllChildren, false)) {
            this.setMeasureAllChildren(true);
        }
        if (a.hasValue(R.styleable.WearableFrameLayout_android_foregroundTint)) {
            this.mForegroundTintList = a.getColorStateList(R.styleable.WearableFrameLayout_android_foregroundTint);
            this.mHasForegroundTint = true;
        }
        a.recycle();
        this.applyForegroundTint();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.requestApplyInsets();
    }

    public WindowInsets onApplyWindowInsets(WindowInsets insets) {
        boolean changed = this.mRound != insets.isRound();
        this.mRound = insets.isRound();
        if (changed) {
            this.requestLayout();
        }
        return super.onApplyWindowInsets(insets);
    }

    public int getForegroundGravity() {
        return this.mForegroundGravity;
    }

    public void setForegroundGravity(int foregroundGravity) {
        if (this.mForegroundGravity != foregroundGravity) {
            if ((foregroundGravity & 0x800007) == 0) {
                foregroundGravity |= 0x800003;
            }
            if ((foregroundGravity & 0x70) == 0) {
                foregroundGravity |= 0x30;
            }
            this.mForegroundGravity = foregroundGravity;
            if (this.mForegroundGravity == 119 && this.mForeground != null) {
                Rect padding = new Rect();
                if (this.mForeground.getPadding(padding)) {
                    this.mForegroundPaddingLeft = padding.left;
                    this.mForegroundPaddingTop = padding.top;
                    this.mForegroundPaddingRight = padding.right;
                    this.mForegroundPaddingBottom = padding.bottom;
                }
            } else {
                this.mForegroundPaddingLeft = 0;
                this.mForegroundPaddingTop = 0;
                this.mForegroundPaddingRight = 0;
                this.mForegroundPaddingBottom = 0;
            }
            this.requestLayout();
        }
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        if (this.mForeground != null) {
            this.mForeground.setVisible(visibility == 0, false);
        }
    }

    protected boolean verifyDrawable(Drawable who) {
        return super.verifyDrawable(who) || who == this.mForeground;
    }

    public void jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        if (this.mForeground != null) {
            this.mForeground.jumpToCurrentState();
        }
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (this.mForeground != null && this.mForeground.isStateful()) {
            this.mForeground.setState(this.getDrawableState());
        }
    }

    public void drawableHotspotChanged(float x, float y) {
        super.drawableHotspotChanged(x, y);
        if (this.mForeground != null) {
            this.mForeground.setHotspot(x, y);
        }
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-1, -1);
    }

    public void setForeground(Drawable d) {
        if (this.mForeground != d) {
            if (this.mForeground != null) {
                this.mForeground.setCallback(null);
                this.unscheduleDrawable(this.mForeground);
            }
            this.mForeground = d;
            this.mForegroundPaddingLeft = 0;
            this.mForegroundPaddingTop = 0;
            this.mForegroundPaddingRight = 0;
            this.mForegroundPaddingBottom = 0;
            if (d != null) {
                Rect padding;
                this.setWillNotDraw(false);
                d.setCallback((Drawable.Callback)this);
                if (d.isStateful()) {
                    d.setState(this.getDrawableState());
                }
                this.applyForegroundTint();
                if (this.mForegroundGravity == 119 && d.getPadding(padding = new Rect())) {
                    this.mForegroundPaddingLeft = padding.left;
                    this.mForegroundPaddingTop = padding.top;
                    this.mForegroundPaddingRight = padding.right;
                    this.mForegroundPaddingBottom = padding.bottom;
                }
            } else {
                this.setWillNotDraw(true);
            }
            this.requestLayout();
            this.invalidate();
        }
    }

    public Drawable getForeground() {
        return this.mForeground;
    }

    public void setForegroundTintList(ColorStateList tint) {
        this.mForegroundTintList = tint;
        this.mHasForegroundTint = true;
        this.applyForegroundTint();
    }

    public void setForegroundInPadding(boolean value) {
        this.mForegroundInPadding = value;
    }

    public ColorStateList getForegroundTintList() {
        return this.mForegroundTintList;
    }

    public void setForegroundTintMode(PorterDuff.Mode tintMode) {
        this.mForegroundTintMode = tintMode;
        this.mHasForegroundTintMode = true;
        this.applyForegroundTint();
    }

    public PorterDuff.Mode getForegroundTintMode() {
        return this.mForegroundTintMode;
    }

    private void applyForegroundTint() {
        if (this.mForeground != null && (this.mHasForegroundTint || this.mHasForegroundTintMode)) {
            this.mForeground = this.mForeground.mutate();
            if (this.mHasForegroundTint) {
                this.mForeground.setTintList(this.mForegroundTintList);
            }
            if (this.mHasForegroundTintMode) {
                this.mForeground.setTintMode(this.mForegroundTintMode);
            }
            if (this.mForeground.isStateful()) {
                this.mForeground.setState(this.getDrawableState());
            }
        }
    }

    int getPaddingLeftWithForeground() {
        return this.mForegroundInPadding ? Math.max(this.getPaddingLeft(), this.mForegroundPaddingLeft) : this.getPaddingLeft() + this.mForegroundPaddingLeft;
    }

    int getPaddingRightWithForeground() {
        return this.mForegroundInPadding ? Math.max(this.getPaddingRight(), this.mForegroundPaddingRight) : this.getPaddingRight() + this.mForegroundPaddingRight;
    }

    private int getPaddingTopWithForeground() {
        return this.mForegroundInPadding ? Math.max(this.getPaddingTop(), this.mForegroundPaddingTop) : this.getPaddingTop() + this.mForegroundPaddingTop;
    }

    private int getPaddingBottomWithForeground() {
        return this.mForegroundInPadding ? Math.max(this.getPaddingBottom(), this.mForegroundPaddingBottom) : this.getPaddingBottom() + this.mForegroundPaddingBottom;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int count = this.getChildCount();
        boolean measureMatchParentChildren = View.MeasureSpec.getMode((int)widthMeasureSpec) != 0x40000000 || View.MeasureSpec.getMode((int)heightMeasureSpec) != 0x40000000;
        this.mMatchParentChildren.clear();
        int maxHeight = 0;
        int maxWidth = 0;
        int childState = 0;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (!this.mMeasureAllChildren && child.getVisibility() == 8) continue;
            this.measureChildWithMargins(child, widthMeasureSpec, 0, heightMeasureSpec, 0);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            maxWidth = Math.max(maxWidth, child.getMeasuredWidth() + this.getParamsLeftMargin(lp) + this.getParamsRightMargin(lp));
            maxHeight = Math.max(maxHeight, child.getMeasuredHeight() + this.getParamsTopMargin(lp) + this.getParamsBottomMargin(lp));
            childState = WearableFrameLayout.combineMeasuredStates((int)childState, (int)child.getMeasuredState());
            if (!measureMatchParentChildren || this.getParamsWidth(lp) != -1 && this.getParamsHeight(lp) != -1) continue;
            this.mMatchParentChildren.add(child);
        }
        maxWidth += this.getPaddingLeftWithForeground() + this.getPaddingRightWithForeground();
        maxHeight += this.getPaddingTopWithForeground() + this.getPaddingBottomWithForeground();
        maxHeight = Math.max(maxHeight, this.getSuggestedMinimumHeight());
        maxWidth = Math.max(maxWidth, this.getSuggestedMinimumWidth());
        Drawable drawable = this.getForeground();
        if (drawable != null) {
            maxHeight = Math.max(maxHeight, drawable.getMinimumHeight());
            maxWidth = Math.max(maxWidth, drawable.getMinimumWidth());
        }
        this.setMeasuredDimension(WearableFrameLayout.resolveSizeAndState((int)maxWidth, (int)widthMeasureSpec, (int)childState), WearableFrameLayout.resolveSizeAndState((int)maxHeight, (int)heightMeasureSpec, (int)(childState << 16)));
        count = this.mMatchParentChildren.size();
        if (count > 1) {
            for (int i = 0; i < count; ++i) {
                View child = this.mMatchParentChildren.get(i);
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                int childWidthMeasureSpec = this.getParamsWidth(lp) == -1 ? View.MeasureSpec.makeMeasureSpec((int)(this.getMeasuredWidth() - this.getPaddingLeftWithForeground() - this.getPaddingRightWithForeground() - this.getParamsLeftMargin(lp) - this.getParamsRightMargin(lp)), (int)0x40000000) : WearableFrameLayout.getChildMeasureSpec((int)widthMeasureSpec, (int)(this.getPaddingLeftWithForeground() + this.getPaddingRightWithForeground() + this.getParamsLeftMargin(lp) + this.getParamsRightMargin(lp)), (int)this.getParamsWidth(lp));
                int childHeightMeasureSpec = this.getParamsHeight(lp) == -1 ? View.MeasureSpec.makeMeasureSpec((int)(this.getMeasuredHeight() - this.getPaddingTopWithForeground() - this.getPaddingBottomWithForeground() - this.getParamsTopMargin(lp) - this.getParamsBottomMargin(lp)), (int)0x40000000) : WearableFrameLayout.getChildMeasureSpec((int)heightMeasureSpec, (int)(this.getPaddingTopWithForeground() + this.getPaddingBottomWithForeground() + this.getParamsTopMargin(lp) + this.getParamsBottomMargin(lp)), (int)this.getParamsHeight(lp));
                child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
            }
        }
    }

    protected void measureChildWithMargins(View child, int parentWidthMeasureSpec, int widthUsed, int parentHeightMeasureSpec, int heightUsed) {
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        int childWidthMeasureSpec = WearableFrameLayout.getChildMeasureSpec((int)parentWidthMeasureSpec, (int)(this.getPaddingLeft() + this.getPaddingRight() + this.getParamsLeftMargin(lp) + this.getParamsRightMargin(lp) + widthUsed), (int)this.getParamsWidth(lp));
        int childHeightMeasureSpec = WearableFrameLayout.getChildMeasureSpec((int)parentHeightMeasureSpec, (int)(this.getPaddingTop() + this.getPaddingBottom() + this.getParamsTopMargin(lp) + this.getParamsBottomMargin(lp) + heightUsed), (int)this.getParamsHeight(lp));
        child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.layoutChildren(left, top, right, bottom, false);
    }

    void layoutChildren(int left, int top, int right, int bottom, boolean forceLeftGravity) {
        int count = this.getChildCount();
        int parentLeft = this.getPaddingLeftWithForeground();
        int parentRight = right - left - this.getPaddingRightWithForeground();
        int parentTop = this.getPaddingTopWithForeground();
        int parentBottom = bottom - top - this.getPaddingBottomWithForeground();
        this.mForegroundBoundsChanged = true;
        for (int i = 0; i < count; ++i) {
            int childTop;
            int childLeft;
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int width = child.getMeasuredWidth();
            int height = child.getMeasuredHeight();
            int gravity = this.getParamsGravity(lp);
            if (gravity == -1) {
                gravity = 0x800033;
            }
            int layoutDirection = this.getLayoutDirection();
            int absoluteGravity = Gravity.getAbsoluteGravity((int)gravity, (int)layoutDirection);
            int verticalGravity = gravity & 0x70;
            switch (absoluteGravity & 7) {
                case 1: {
                    childLeft = parentLeft + (parentRight - parentLeft - width) / 2 + this.getParamsLeftMargin(lp) - this.getParamsRightMargin(lp);
                    break;
                }
                case 5: {
                    if (!forceLeftGravity) {
                        childLeft = parentRight - width - this.getParamsRightMargin(lp);
                        break;
                    }
                }
                default: {
                    childLeft = parentLeft + this.getParamsLeftMargin(lp);
                }
            }
            switch (verticalGravity) {
                case 48: {
                    childTop = parentTop + this.getParamsTopMargin(lp);
                    break;
                }
                case 16: {
                    childTop = parentTop + (parentBottom - parentTop - height) / 2 + this.getParamsTopMargin(lp) - this.getParamsBottomMargin(lp);
                    break;
                }
                case 80: {
                    childTop = parentBottom - height - this.getParamsBottomMargin(lp);
                    break;
                }
                default: {
                    childTop = parentTop + this.getParamsTopMargin(lp);
                }
            }
            child.layout(childLeft, childTop, childLeft + width, childTop + height);
        }
    }

    private int getParamsWidth(LayoutParams params) {
        return this.mRound ? params.widthRound : params.width;
    }

    private int getParamsHeight(LayoutParams params) {
        return this.mRound ? params.heightRound : params.height;
    }

    private int getParamsLeftMargin(LayoutParams params) {
        return this.mRound ? params.leftMarginRound : params.leftMargin;
    }

    private int getParamsTopMargin(LayoutParams params) {
        return this.mRound ? params.topMarginRound : params.topMargin;
    }

    private int getParamsRightMargin(LayoutParams params) {
        return this.mRound ? params.rightMarginRound : params.rightMargin;
    }

    private int getParamsBottomMargin(LayoutParams params) {
        return this.mRound ? params.bottomMarginRound : params.bottomMargin;
    }

    private int getParamsGravity(LayoutParams params) {
        return this.mRound ? params.gravityRound : params.gravity;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mForegroundBoundsChanged = true;
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.mForeground != null) {
            Drawable foreground = this.mForeground;
            if (this.mForegroundBoundsChanged) {
                this.mForegroundBoundsChanged = false;
                Rect selfBounds = this.mSelfBounds;
                Rect overlayBounds = this.mOverlayBounds;
                int w = this.getRight() - this.getLeft();
                int h = this.getBottom() - this.getTop();
                if (this.mForegroundInPadding) {
                    selfBounds.set(0, 0, w, h);
                } else {
                    selfBounds.set(this.getPaddingLeft(), this.getPaddingTop(), w - this.getPaddingRight(), h - this.getPaddingBottom());
                }
                int layoutDirection = this.getLayoutDirection();
                Gravity.apply((int)this.mForegroundGravity, (int)foreground.getIntrinsicWidth(), (int)foreground.getIntrinsicHeight(), (Rect)selfBounds, (Rect)overlayBounds, (int)layoutDirection);
                foreground.setBounds(overlayBounds);
            }
            foreground.draw(canvas);
        }
    }

    public void setMeasureAllChildren(boolean measureAll) {
        this.mMeasureAllChildren = measureAll;
    }

    public boolean getMeasureAllChildren() {
        return this.mMeasureAllChildren;
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    public boolean shouldDelayChildPressedState() {
        return false;
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams((LayoutParams)p);
    }

    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        event.setClassName((CharSequence)WearableFrameLayout.class.getName());
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.setClassName((CharSequence)WearableFrameLayout.class.getName());
    }

    public static class LayoutParams
    extends FrameLayout.LayoutParams {
        public int gravityRound = -1;
        public int widthRound;
        public int heightRound;
        public int leftMarginRound;
        public int topMarginRound;
        public int rightMarginRound;
        public int bottomMarginRound;

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
            TypedArray a = c.obtainStyledAttributes(attrs, R.styleable.WearableFrameLayout);
            this.gravityRound = a.getInt(R.styleable.WearableFrameLayout_layout_gravityRound, this.gravity);
            this.widthRound = a.getLayoutDimension(R.styleable.WearableFrameLayout_layout_widthRound, this.width);
            this.heightRound = a.getLayoutDimension(R.styleable.WearableFrameLayout_layout_heightRound, this.height);
            int marginRound = a.getDimensionPixelSize(R.styleable.WearableFrameLayout_layout_marginRound, -1);
            if (marginRound >= 0) {
                this.topMarginRound = this.bottomMarginRound = marginRound;
                this.rightMarginRound = this.bottomMarginRound;
                this.leftMarginRound = this.bottomMarginRound;
            } else {
                this.leftMarginRound = a.getDimensionPixelSize(R.styleable.WearableFrameLayout_layout_marginLeftRound, this.leftMargin);
                this.topMarginRound = a.getDimensionPixelSize(R.styleable.WearableFrameLayout_layout_marginTopRound, this.topMargin);
                this.rightMarginRound = a.getDimensionPixelSize(R.styleable.WearableFrameLayout_layout_marginRightRound, this.rightMargin);
                this.bottomMarginRound = a.getDimensionPixelSize(R.styleable.WearableFrameLayout_layout_marginBottomRound, this.bottomMargin);
            }
            a.recycle();
        }

        public LayoutParams(int width, int height, int gravity, int widthRound, int heightRound, int gravityRound) {
            super(width, height, gravity);
            this.widthRound = widthRound;
            this.heightRound = heightRound;
            this.gravityRound = gravityRound;
        }

        public LayoutParams(int width, int height, int gravity) {
            super(width, height, gravity);
            this.widthRound = width;
            this.heightRound = height;
            this.gravityRound = gravity;
        }

        public LayoutParams(int width, int height) {
            super(width, height);
            this.widthRound = width;
            this.heightRound = height;
        }

        public LayoutParams(LayoutParams source) {
            super((FrameLayout.LayoutParams)source);
            this.widthRound = source.widthRound;
            this.heightRound = source.heightRound;
            this.gravityRound = source.gravityRound;
            this.leftMarginRound = source.leftMarginRound;
            this.topMarginRound = source.topMarginRound;
            this.rightMarginRound = source.rightMarginRound;
            this.bottomMarginRound = source.bottomMarginRound;
        }
    }
}

