/*
 * Decompiled with CFR 0.152.
 */
package android.support.wearable.view;

import android.annotation.TargetApi;
import android.app.Fragment;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.graphics.Point;
import android.graphics.drawable.Drawable;
import android.support.wearable.view.GridPageOptions;
import android.support.wearable.view.GridPagerAdapter;
import android.view.View;
import android.view.ViewGroup;
import java.util.HashMap;
import java.util.Map;

@TargetApi(value=20)
public abstract class FragmentGridPagerAdapter
extends GridPagerAdapter {
    private static final int MAX_ROWS = 65535;
    private final FragmentManager mFragmentManager;
    private final Map<String, Point> mFragmentPositions;
    private final Map<Point, String> mFragmentTags;
    private FragmentTransaction mCurTransaction;
    private static final GridPageOptions.BackgroundListener NOOP_BACKGROUND_OBSERVER = new GridPageOptions.BackgroundListener(){

        @Override
        public void notifyBackgroundChanged() {
        }
    };

    public FragmentGridPagerAdapter(FragmentManager fm) {
        this.mFragmentManager = fm;
        this.mFragmentPositions = new HashMap<String, Point>();
        this.mFragmentTags = new HashMap<Point, String>();
    }

    private static String makeFragmentName(int viewId, long id2) {
        return "android:switcher:" + viewId + ":" + id2;
    }

    public abstract Fragment getFragment(int var1, int var2);

    public long getFragmentId(int row, int column) {
        return column * 65535 + row;
    }

    public Fragment instantiateItem(ViewGroup container, int row, int column) {
        if (this.mCurTransaction == null) {
            this.mCurTransaction = this.mFragmentManager.beginTransaction();
        }
        long itemId = this.getFragmentId(row, column);
        String tag = FragmentGridPagerAdapter.makeFragmentName(container.getId(), itemId);
        Fragment fragment = this.mFragmentManager.findFragmentByTag(tag);
        if (fragment == null) {
            fragment = this.getFragment(row, column);
            this.mCurTransaction.add(container.getId(), fragment, tag);
        }
        Point position = new Point(column, row);
        this.mFragmentTags.put(position, tag);
        this.mFragmentPositions.put(tag, position);
        if (fragment instanceof GridPageOptions) {
            GridPageOptions backgroundProvider = (GridPageOptions)fragment;
            backgroundProvider.setBackgroundListener(new BackgroundObserver(tag));
        }
        return fragment;
    }

    @Override
    public boolean isViewFromObject(View view, Object object) {
        return view == ((Fragment)object).getView();
    }

    @Override
    public void destroyItem(ViewGroup container, int row, int column, Object object) {
        Fragment fragment;
        if (this.mCurTransaction == null) {
            this.mCurTransaction = this.mFragmentManager.beginTransaction();
        }
        if ((fragment = (Fragment)object) instanceof GridPageOptions) {
            ((GridPageOptions)fragment).setBackgroundListener(NOOP_BACKGROUND_OBSERVER);
        }
        this.mCurTransaction.remove(fragment);
        Point position = new Point(column, row);
        this.mFragmentPositions.remove(fragment.getTag());
        this.mFragmentTags.remove(position);
    }

    public final Drawable getFragmentBackground(int row, int column) {
        String tag = this.mFragmentTags.get(new Point(column, row));
        Fragment f = this.mFragmentManager.findFragmentByTag(tag);
        Drawable bg = BACKGROUND_NONE;
        if (f instanceof GridPageOptions) {
            bg = ((GridPageOptions)f).getBackground();
        }
        return bg;
    }

    @Override
    public Drawable getBackgroundForPage(int row, int column) {
        return this.getFragmentBackground(row, column);
    }

    @Override
    public void finishUpdate(ViewGroup container) {
        if (this.mFragmentManager.isDestroyed()) {
            this.mCurTransaction = null;
            return;
        }
        if (this.mCurTransaction != null) {
            this.mCurTransaction.commitAllowingStateLoss();
            this.mCurTransaction = null;
            this.mFragmentManager.executePendingTransactions();
        }
    }

    private class BackgroundObserver
    implements GridPageOptions.BackgroundListener {
        private final String mTag;

        private BackgroundObserver(String tag) {
            this.mTag = tag;
        }

        @Override
        public void notifyBackgroundChanged() {
            Point pos = (Point)FragmentGridPagerAdapter.this.mFragmentPositions.get(this.mTag);
            if (pos != null) {
                FragmentGridPagerAdapter.this.notifyPageBackgroundChanged(pos.y, pos.x);
            }
        }
    }
}

