/*
 * Decompiled with CFR 0.152.
 */
package android.support.wearable.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.support.wearable.R;
import android.support.wearable.view.CircledImageView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;

@TargetApi(value=20)
public class DelayedConfirmationView
extends CircledImageView {
    private long mTotalTimeMs;
    private long mUpdateIntervalMs = 0L;
    private DelayedConfirmationListener mListener;
    private long mStartTimeMs;
    private long mCurrentTimeMs;
    private static final int DEFAULT_UPDATE_INTERVAL_MS = 33;
    private Handler mTimerHandler = new Handler(){

        public void handleMessage(Message msg) {
            DelayedConfirmationView.this.mCurrentTimeMs = SystemClock.elapsedRealtime();
            DelayedConfirmationView.this.invalidate();
            if (DelayedConfirmationView.this.mCurrentTimeMs - DelayedConfirmationView.this.mStartTimeMs < DelayedConfirmationView.this.mTotalTimeMs) {
                DelayedConfirmationView.this.mTimerHandler.sendEmptyMessageDelayed(0, DelayedConfirmationView.this.mUpdateIntervalMs);
            } else if (DelayedConfirmationView.this.mStartTimeMs > 0L && DelayedConfirmationView.this.mListener != null) {
                DelayedConfirmationView.this.mListener.onTimerFinished(DelayedConfirmationView.this);
            }
        }
    };

    public DelayedConfirmationView(Context context) {
        this(context, null);
    }

    public DelayedConfirmationView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DelayedConfirmationView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.DelayedConfirmationView, defStyle, 0);
        this.mUpdateIntervalMs = a.getInteger(R.styleable.DelayedConfirmationView_update_interval, 33);
        this.setProgress(0.0f);
        a.recycle();
    }

    public void setStartTimeMs(long time) {
        this.mStartTimeMs = time;
        this.invalidate();
    }

    public void setTotalTimeMs(long time) {
        this.mTotalTimeMs = time;
    }

    public void setListener(DelayedConfirmationListener listener) {
        this.mListener = listener;
    }

    public void start() {
        this.mStartTimeMs = SystemClock.elapsedRealtime();
        this.mCurrentTimeMs = SystemClock.elapsedRealtime();
        this.mTimerHandler.sendEmptyMessageDelayed(0, this.mUpdateIntervalMs);
    }

    public void reset() {
        this.mStartTimeMs = 0L;
        this.setProgress(0.0f);
        this.invalidate();
    }

    @Override
    protected void onDraw(Canvas canvas) {
        if (this.mStartTimeMs > 0L) {
            this.setProgress((float)(this.mCurrentTimeMs - this.mStartTimeMs) / (float)this.mTotalTimeMs);
        }
        super.onDraw(canvas);
    }

    public boolean onTouchEvent(MotionEvent event) {
        int action = event.getAction();
        switch (action) {
            case 0: 
            case 2: {
                if (this.mListener == null) break;
                this.mListener.onTimerSelected(this);
                break;
            }
        }
        return false;
    }

    public static interface DelayedConfirmationListener {
        public void onTimerFinished(View var1);

        public void onTimerSelected(View var1);
    }
}

