/*
 * Decompiled with CFR 0.152.
 */
package android.support.wearable.view;

import android.animation.ArgbEvaluator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RadialGradient;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.support.wearable.R;
import android.support.wearable.view.ProgressDrawable;
import android.util.AttributeSet;
import android.view.View;

@TargetApi(value=21)
public class CircledImageView
extends View {
    private static final ArgbEvaluator ARGB_EVALUATOR = new ArgbEvaluator();
    private Drawable mDrawable;
    private final RectF mOval;
    private final Paint mPaint;
    private ColorStateList mCircleColor;
    float mCircleRadius;
    private float mCircleRadiusPressed;
    private int mCircleBorderColor;
    private float mCircleBorderWidth;
    private float mProgress = 1.0f;
    private final float mShadowWidth;
    private float mShadowVisibility;
    private boolean mCircleHidden = false;
    private float mInitialCircleRadius;
    private boolean mPressed = false;
    private boolean mProgressIndeterminate;
    private ProgressDrawable mIndeterminateDrawable;
    private Rect mIndeterminateBounds = new Rect();
    private long mColorChangeAnimationDurationMs = 0L;
    private final Drawable.Callback mDrawableCallback = new Drawable.Callback(){

        public void invalidateDrawable(Drawable drawable2) {
            CircledImageView.this.invalidate();
        }

        public void scheduleDrawable(Drawable drawable2, Runnable runnable, long l) {
        }

        public void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
        }
    };
    private int mCurrentColor;
    private final ValueAnimator.AnimatorUpdateListener mAnimationListener = new ValueAnimator.AnimatorUpdateListener(){

        public void onAnimationUpdate(ValueAnimator animation) {
            CircledImageView.this.mCurrentColor = (Integer)animation.getAnimatedValue();
            CircledImageView.this.invalidate();
        }
    };
    private ValueAnimator mColorAnimator;

    public CircledImageView(Context context) {
        this(context, null);
    }

    public CircledImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CircledImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        float circlePadding;
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.CircledImageView);
        this.mDrawable = a.getDrawable(R.styleable.CircledImageView_android_src);
        this.mCircleColor = a.getColorStateList(R.styleable.CircledImageView_circle_color);
        if (this.mCircleColor == null) {
            this.mCircleColor = ColorStateList.valueOf((int)0x1060000);
        }
        this.mInitialCircleRadius = this.mCircleRadius = a.getDimension(R.styleable.CircledImageView_circle_radius, 0.0f);
        this.mCircleRadiusPressed = a.getDimension(R.styleable.CircledImageView_circle_radius_pressed, this.mCircleRadius);
        this.mCircleBorderColor = a.getColor(R.styleable.CircledImageView_circle_border_color, -16777216);
        this.mCircleBorderWidth = a.getDimension(R.styleable.CircledImageView_circle_border_width, 0.0f);
        if (this.mCircleBorderWidth > 0.0f) {
            this.mCircleRadius -= this.mCircleBorderWidth;
            this.mCircleRadiusPressed -= this.mCircleBorderWidth;
        }
        if ((circlePadding = a.getDimension(R.styleable.CircledImageView_circle_padding, 0.0f)) > 0.0f) {
            this.mCircleRadius -= circlePadding;
            this.mCircleRadiusPressed -= circlePadding;
        }
        this.mShadowWidth = a.getDimension(R.styleable.CircledImageView_shadow_width, 0.0f);
        a.recycle();
        this.mOval = new RectF();
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mIndeterminateDrawable = new ProgressDrawable();
        this.mIndeterminateDrawable.setCallback(this.mDrawableCallback);
        this.setWillNotDraw(false);
        this.setColorForCurrentState();
    }

    public void setCircleHidden(boolean circleHidden) {
        this.mCircleHidden = circleHidden;
        this.invalidate();
    }

    protected boolean onSetAlpha(int alpha) {
        return true;
    }

    protected void onDraw(Canvas canvas) {
        float circleRadius;
        int paddingLeft = this.getPaddingLeft();
        int paddingTop = this.getPaddingTop();
        float f = circleRadius = this.mPressed ? this.mCircleRadiusPressed : this.mCircleRadius;
        if (this.mShadowWidth > 0.0f && this.mShadowVisibility > 0.0f) {
            this.mOval.set((float)paddingLeft, (float)paddingTop, (float)(this.getWidth() - this.getPaddingRight()), (float)(this.getHeight() - this.getPaddingBottom()));
            float radius = circleRadius + this.mCircleBorderWidth + this.mShadowWidth * this.mShadowVisibility;
            this.mPaint.setColor(-16777216);
            this.mPaint.setAlpha(Math.round((float)this.mPaint.getAlpha() * this.getAlpha()));
            this.mPaint.setStyle(Paint.Style.FILL);
            this.mPaint.setShader((Shader)new RadialGradient(this.mOval.centerX(), this.mOval.centerY(), radius, new int[]{-16777216, 0}, new float[]{0.6f, 1.0f}, Shader.TileMode.MIRROR));
            canvas.drawCircle(this.mOval.centerX(), this.mOval.centerY(), radius, this.mPaint);
            this.mPaint.setShader(null);
        }
        if (this.mCircleBorderWidth > 0.0f) {
            this.mOval.set((float)paddingLeft, (float)paddingTop, (float)(this.getWidth() - this.getPaddingRight()), (float)(this.getHeight() - this.getPaddingBottom()));
            this.mOval.set(this.mOval.centerX() - circleRadius, this.mOval.centerY() - circleRadius, this.mOval.centerX() + circleRadius, this.mOval.centerY() + circleRadius);
            this.mPaint.setColor(this.mCircleBorderColor);
            this.mPaint.setAlpha(Math.round((float)this.mPaint.getAlpha() * this.getAlpha()));
            this.mPaint.setStyle(Paint.Style.STROKE);
            this.mPaint.setStrokeWidth(this.mCircleBorderWidth);
            if (this.mProgressIndeterminate) {
                this.mOval.roundOut(this.mIndeterminateBounds);
                this.mIndeterminateDrawable.setBounds(this.mIndeterminateBounds);
                this.mIndeterminateDrawable.setRingColor(this.mCircleBorderColor);
                this.mIndeterminateDrawable.setRingWidth(this.mCircleBorderWidth);
                this.mIndeterminateDrawable.draw(canvas);
            } else {
                canvas.drawArc(this.mOval, -90.0f, 360.0f * this.mProgress, false, this.mPaint);
            }
        }
        if (!this.mCircleHidden) {
            this.mOval.set((float)paddingLeft, (float)paddingTop, (float)(this.getWidth() - this.getPaddingRight()), (float)(this.getHeight() - this.getPaddingBottom()));
            this.mPaint.setColor(this.mCurrentColor);
            this.mPaint.setAlpha(Math.round((float)this.mPaint.getAlpha() * this.getAlpha()));
            this.mPaint.setStyle(Paint.Style.FILL);
            float centerX = this.mOval.centerX();
            float centerY = this.mOval.centerY();
            canvas.drawCircle(centerX, centerY, circleRadius, this.mPaint);
        }
        if (this.mDrawable != null) {
            this.mDrawable.setAlpha(Math.round(this.getAlpha() * 255.0f));
            this.mDrawable.draw(canvas);
        }
        super.onDraw(canvas);
    }

    private void setColorForCurrentState() {
        int newColor = this.mCircleColor.getColorForState(this.getDrawableState(), this.mCircleColor.getDefaultColor());
        if (this.mColorChangeAnimationDurationMs > 0L) {
            if (this.mColorAnimator != null) {
                this.mColorAnimator.cancel();
            } else {
                this.mColorAnimator = new ValueAnimator();
            }
            this.mColorAnimator.setIntValues(new int[]{this.mCurrentColor, newColor});
            this.mColorAnimator.setEvaluator((TypeEvaluator)ARGB_EVALUATOR);
            this.mColorAnimator.setDuration(this.mColorChangeAnimationDurationMs);
            this.mColorAnimator.addUpdateListener(this.mAnimationListener);
            this.mColorAnimator.start();
        } else {
            this.mCurrentColor = newColor;
            this.invalidate();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        float radius = this.mCircleRadius + this.mCircleBorderWidth + this.mShadowWidth * this.mShadowVisibility;
        float desiredWidth = radius * 2.0f;
        float desiredHeight = radius * 2.0f;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int width = widthMode == 0x40000000 ? widthSize : (widthMode == Integer.MIN_VALUE ? (int)Math.min(desiredWidth, (float)widthSize) : (int)desiredWidth);
        int height = heightMode == 0x40000000 ? heightSize : (heightMode == Integer.MIN_VALUE ? (int)Math.min(desiredHeight, (float)heightSize) : (int)desiredHeight);
        super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000));
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        if (this.mDrawable != null) {
            int nativeDrawableWidth = this.mDrawable.getIntrinsicWidth();
            int nativeDrawableHeight = this.mDrawable.getIntrinsicHeight();
            int viewWidth = this.getMeasuredWidth();
            int viewHeight = this.getMeasuredHeight();
            int drawableWidth = Math.min(nativeDrawableWidth, viewWidth);
            int drawableHeight = Math.min(nativeDrawableHeight, viewHeight);
            int drawableLeft = (viewWidth - drawableWidth) / 2;
            int drawableTop = (viewHeight - drawableHeight) / 2;
            this.mDrawable.setBounds(drawableLeft, drawableTop, drawableLeft + drawableWidth, drawableTop + drawableHeight);
        }
        super.onLayout(changed, left, top, right, bottom);
    }

    public void setImageDrawable(Drawable drawable2) {
        if (drawable2 != this.mDrawable) {
            boolean skipLayout;
            Drawable existingDrawable = this.mDrawable;
            this.mDrawable = drawable2;
            boolean bl = skipLayout = drawable2 != null && existingDrawable != null && existingDrawable.getIntrinsicHeight() == drawable2.getIntrinsicHeight() && existingDrawable.getIntrinsicWidth() == drawable2.getIntrinsicWidth();
            if (skipLayout) {
                this.mDrawable.setBounds(existingDrawable.getBounds());
            } else {
                this.requestLayout();
            }
            this.invalidate();
        }
    }

    public void setImageResource(int resId) {
        this.setImageDrawable(resId == 0 ? null : this.getContext().getDrawable(resId));
    }

    public float getCircleRadius() {
        return this.mCircleRadius;
    }

    public void setCircleRadius(float circleRadius) {
        this.mCircleRadius = circleRadius;
        this.invalidate();
    }

    public void setCircleRadiusPressed(float circleRadiusPressed) {
        this.mCircleRadiusPressed = circleRadiusPressed;
        this.invalidate();
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        this.setColorForCurrentState();
    }

    public void setCircleColor(int circleColor) {
        this.setCircleColorStateList(ColorStateList.valueOf((int)circleColor));
    }

    public void setCircleColorStateList(ColorStateList circleColor) {
        this.mCircleColor = circleColor;
        this.setColorForCurrentState();
        this.invalidate();
    }

    public ColorStateList getCircleColorStateList() {
        return this.mCircleColor;
    }

    public int getDefaultCircleColor() {
        return this.mCircleColor.getDefaultColor();
    }

    public void showIndeterminateProgress(boolean show) {
        this.mProgressIndeterminate = show;
        if (show) {
            this.mIndeterminateDrawable.startAnimation();
        } else {
            this.mIndeterminateDrawable.stopAnimation();
        }
    }

    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (visibility != 0) {
            this.showIndeterminateProgress(false);
        } else if (this.mProgressIndeterminate) {
            this.showIndeterminateProgress(true);
        }
    }

    public void setProgress(float progress) {
        if (this.mProgress != progress) {
            this.mProgress = progress;
            this.invalidate();
        }
    }

    public void setShadowVisibility(float shadowVisibility) {
        if (shadowVisibility != this.mShadowVisibility) {
            this.mShadowVisibility = shadowVisibility;
            this.invalidate();
        }
    }

    public float getInitialCircleRadius() {
        return this.mInitialCircleRadius;
    }

    public void setCircleBorderColor(int circleBorderColor) {
        this.mCircleBorderColor = circleBorderColor;
    }

    public void setCircleBorderWidth(float circleBorderWidth) {
        this.mCircleBorderWidth = circleBorderWidth;
        this.invalidate();
    }

    public void setPressed(boolean pressed) {
        super.setPressed(pressed);
        this.mPressed = pressed;
        this.invalidate();
    }

    public Drawable getImageDrawable() {
        return this.mDrawable;
    }

    public long getColorChangeAnimationDuration() {
        return this.mColorChangeAnimationDurationMs;
    }

    public void setColorChangeAnimationDuration(long mColorChangeAnimationDurationMs) {
        this.mColorChangeAnimationDurationMs = mColorChangeAnimationDurationMs;
    }
}

