/*
 * Decompiled with CFR 0.152.
 */
package android.support.wearable.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.wearable.R;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowInsets;
import android.widget.FrameLayout;

@TargetApi(value=20)
public class BoxInsetLayout
extends FrameLayout {
    private static float FACTOR = 0.146467f;
    private static final int DEFAULT_CHILD_GRAVITY = 0x800033;
    private Rect mForegroundPadding;
    private boolean mLastKnownRound;
    private Rect mInsets;

    public BoxInsetLayout(Context context) {
        this(context, null);
    }

    public BoxInsetLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BoxInsetLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        if (this.mForegroundPadding == null) {
            this.mForegroundPadding = new Rect();
        }
        if (this.mInsets == null) {
            this.mInsets = new Rect();
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.requestApplyInsets();
    }

    public WindowInsets onApplyWindowInsets(WindowInsets insets) {
        boolean round = (insets = super.onApplyWindowInsets(insets)).isRound();
        if (round != this.mLastKnownRound) {
            this.mLastKnownRound = round;
            this.requestLayout();
        }
        this.mInsets.set(insets.getSystemWindowInsetLeft(), insets.getSystemWindowInsetTop(), insets.getSystemWindowInsetRight(), insets.getSystemWindowInsetBottom());
        return insets;
    }

    public boolean isRound() {
        return this.mLastKnownRound;
    }

    public Rect getInsets() {
        return this.mInsets;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int count = this.getChildCount();
        int maxWidth = 0;
        int maxHeight = 0;
        int childState = 0;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int marginLeft = 0;
            int marginRight = 0;
            int marginTop = 0;
            int marginBottom = 0;
            if (this.mLastKnownRound) {
                if ((lp.boxedEdges & 1) == 0) {
                    marginLeft = lp.leftMargin;
                }
                if ((lp.boxedEdges & 4) == 0) {
                    marginRight = lp.rightMargin;
                }
                if ((lp.boxedEdges & 2) == 0) {
                    marginTop = lp.topMargin;
                }
                if ((lp.boxedEdges & 8) == 0) {
                    marginBottom = lp.bottomMargin;
                }
            } else {
                marginLeft = lp.leftMargin;
                marginTop = lp.topMargin;
                marginRight = lp.rightMargin;
                marginBottom = lp.bottomMargin;
            }
            this.measureChildWithMargins(child, widthMeasureSpec, 0, heightMeasureSpec, 0);
            maxWidth = Math.max(maxWidth, child.getMeasuredWidth() + marginLeft + marginRight);
            maxHeight = Math.max(maxHeight, child.getMeasuredHeight() + marginTop + marginBottom);
            childState = BoxInsetLayout.combineMeasuredStates((int)childState, (int)child.getMeasuredState());
        }
        maxWidth += this.getPaddingLeft() + this.mForegroundPadding.left + this.getPaddingRight() + this.mForegroundPadding.right;
        maxHeight += this.getPaddingTop() + this.mForegroundPadding.top + this.getPaddingBottom() + this.mForegroundPadding.bottom;
        maxHeight = Math.max(maxHeight, this.getSuggestedMinimumHeight());
        maxWidth = Math.max(maxWidth, this.getSuggestedMinimumWidth());
        Drawable drawable2 = this.getForeground();
        if (drawable2 != null) {
            maxHeight = Math.max(maxHeight, drawable2.getMinimumHeight());
            maxWidth = Math.max(maxWidth, drawable2.getMinimumWidth());
        }
        this.setMeasuredDimension(BoxInsetLayout.resolveSizeAndState((int)maxWidth, (int)widthMeasureSpec, (int)childState), BoxInsetLayout.resolveSizeAndState((int)maxHeight, (int)heightMeasureSpec, (int)(childState << 16)));
        int boxInset = (int)(FACTOR * (float)Math.max(this.getMeasuredWidth(), this.getMeasuredHeight()));
        for (int i = 0; i < count; ++i) {
            this.measureChild(widthMeasureSpec, heightMeasureSpec, boxInset, i);
        }
    }

    private void measureChild(int widthMeasureSpec, int heightMeasureSpec, int boxInset, int i) {
        View child = this.getChildAt(i);
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        int gravity = lp.gravity;
        if (gravity == -1) {
            gravity = 0x800033;
        }
        int verticalGravity = gravity & 0x70;
        int horizontalGravity = gravity & 7;
        int plwf = this.getPaddingLeft() + this.mForegroundPadding.left;
        int prwf = this.getPaddingRight() + this.mForegroundPadding.right;
        int ptwf = this.getPaddingTop() + this.mForegroundPadding.top;
        int pbwf = this.getPaddingBottom() + this.mForegroundPadding.bottom;
        int totalMargin = 0;
        int childLeftPadding = 0;
        int childRightPadding = 0;
        int childBottomPadding = 0;
        int childTopPadding = 0;
        if (this.mLastKnownRound && (lp.boxedEdges & 1) != 0) {
            if (lp.width == -1 || horizontalGravity == 3) {
                childLeftPadding = boxInset;
            }
        } else {
            totalMargin += plwf + lp.leftMargin;
        }
        if (this.mLastKnownRound && (lp.boxedEdges & 4) != 0) {
            if (lp.width == -1 || horizontalGravity == 5) {
                childRightPadding = boxInset;
            }
        } else {
            totalMargin += prwf + lp.rightMargin;
        }
        int childWidthMeasureSpec = BoxInsetLayout.getChildMeasureSpec((int)widthMeasureSpec, (int)totalMargin, (int)lp.width);
        totalMargin = 0;
        if (this.mLastKnownRound && (lp.boxedEdges & 2) != 0) {
            if (lp.height == -1 || verticalGravity == 48) {
                childTopPadding = boxInset;
            }
        } else {
            totalMargin += ptwf + lp.topMargin;
        }
        if (this.mLastKnownRound && (lp.boxedEdges & 8) != 0) {
            if (lp.height == -1 || verticalGravity == 80) {
                childBottomPadding = boxInset;
            }
        } else {
            totalMargin += pbwf + lp.bottomMargin;
        }
        int childHeightMeasureSpec = BoxInsetLayout.getChildMeasureSpec((int)heightMeasureSpec, (int)totalMargin, (int)lp.height);
        child.setPadding(childLeftPadding, childTopPadding, childRightPadding, childBottomPadding);
        child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int count = this.getChildCount();
        int parentLeft = this.getPaddingLeft() + this.mForegroundPadding.left;
        int parentRight = right - left - this.getPaddingRight() - this.mForegroundPadding.right;
        int parentTop = this.getPaddingTop() + this.mForegroundPadding.top;
        int parentBottom = bottom - top - this.getPaddingBottom() - this.mForegroundPadding.bottom;
        for (int i = 0; i < count; ++i) {
            int childTop;
            int childLeft;
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int width = child.getMeasuredWidth();
            int height = child.getMeasuredHeight();
            int gravity = lp.gravity;
            if (gravity == -1) {
                gravity = 0x800033;
            }
            int layoutDirection = this.getLayoutDirection();
            int absoluteGravity = Gravity.getAbsoluteGravity((int)gravity, (int)layoutDirection);
            int verticalGravity = gravity & 0x70;
            if (lp.width == -1) {
                childLeft = parentLeft + lp.leftMargin;
            } else {
                switch (absoluteGravity & 7) {
                    case 1: {
                        childLeft = parentLeft + (parentRight - parentLeft - width) / 2 + lp.leftMargin - lp.rightMargin;
                        break;
                    }
                    case 5: {
                        if (this.mLastKnownRound && (lp.boxedEdges & 4) != 0) {
                            childLeft = right - left - width;
                            break;
                        }
                        childLeft = parentRight - width - lp.rightMargin;
                        break;
                    }
                    default: {
                        childLeft = this.mLastKnownRound && (lp.boxedEdges & 1) != 0 ? 0 : parentLeft + lp.leftMargin;
                    }
                }
            }
            if (lp.height == -1) {
                childTop = parentTop + lp.topMargin;
            } else {
                switch (verticalGravity) {
                    case 48: {
                        if (this.mLastKnownRound && (lp.boxedEdges & 2) != 0) {
                            childTop = 0;
                            break;
                        }
                        childTop = parentTop + lp.topMargin;
                        break;
                    }
                    case 16: {
                        childTop = parentTop + (parentBottom - parentTop - height) / 2 + lp.topMargin - lp.bottomMargin;
                        break;
                    }
                    case 80: {
                        if (this.mLastKnownRound && (lp.boxedEdges & 8) != 0) {
                            childTop = bottom - top - height;
                            break;
                        }
                        childTop = parentBottom - height - lp.bottomMargin;
                        break;
                    }
                    default: {
                        childTop = parentTop + lp.topMargin;
                    }
                }
            }
            child.layout(childLeft, childTop, childLeft + width, childTop + height);
        }
    }

    public void setForeground(Drawable drawable2) {
        super.setForeground(drawable2);
        if (this.mForegroundPadding == null) {
            this.mForegroundPadding = new Rect();
        }
        drawable2.getPadding(this.mForegroundPadding);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    public static class LayoutParams
    extends FrameLayout.LayoutParams {
        public static final int BOX_NONE = 0;
        public static final int BOX_LEFT = 1;
        public static final int BOX_TOP = 2;
        public static final int BOX_RIGHT = 4;
        public static final int BOX_BOTTOM = 8;
        public static final int BOX_ALL = 15;
        public int boxedEdges = 0;

        public LayoutParams(Context context, AttributeSet attrs) {
            super(context, attrs);
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.BoxInsetLayout_Layout, 0, 0);
            this.boxedEdges = a.getInt(R.styleable.BoxInsetLayout_Layout_layout_box, 0);
            a.recycle();
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(int width, int height, int gravity) {
            super(width, height, gravity);
        }

        public LayoutParams(int width, int height, int gravity, int boxed) {
            super(width, height, gravity);
            this.boxedEdges = boxed;
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        public LayoutParams(FrameLayout.LayoutParams source) {
            super(source);
        }

        public LayoutParams(LayoutParams source) {
            super((FrameLayout.LayoutParams)source);
            this.boxedEdges = source.boxedEdges;
            this.gravity = source.gravity;
        }
    }
}

