/*
 * Decompiled with CFR 0.152.
 */
package android.support.wearable.view;

import android.animation.AnimatorInflater;
import android.animation.StateListAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Point;
import android.graphics.drawable.Drawable;
import android.support.wearable.R;
import android.support.wearable.view.ActionLabel;
import android.support.wearable.view.CircularButton;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowInsets;

@TargetApi(value=21)
public class ActionPage
extends ViewGroup {
    private static final String TAG = "ActionPage";
    private static final float CIRCLE_VERT_POSITION_SQUARE = 0.43f;
    private static final float CIRCLE_SIZE_RATIO = 0.45f;
    private static final float LABEL_WIDTH_RATIO = 0.892f;
    private static final float LABEL_WIDTH_RATIO_ROUND = 0.625f;
    private static final float LABEL_BOTTOM_MARGIN_RATIO_ROUND = 0.09375f;
    public static int SCALE_MODE_CENTER = 1;
    public static int SCALE_MODE_FIT = 0;
    private static final boolean DEBUG = false;
    private final ActionLabel mLabel;
    private final CircularButton mCircularButton;
    private int mButtonSize;
    private float mButtonRadius;
    private final Point mButtonCenter = new Point();
    private int mTextWidth;
    private int mTextHeight;
    private boolean mIsRound;
    private int mBottomInset;
    private boolean mInsetsApplied;

    public ActionPage(Context context) {
        this(context, null);
    }

    public ActionPage(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ActionPage(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, R.style.Widget_ActionPage);
    }

    public ActionPage(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.mCircularButton = new CircularButton(context);
        this.mLabel = new ActionLabel(context);
        this.mLabel.setGravity(17);
        this.mLabel.setMaxLines(2);
        float lineSpacingMult = 1.0f;
        float lineSpacingExtra = 0.0f;
        String fontFamily = null;
        int typefaceIndex = 1;
        int styleIndex = 0;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ActionPage, defStyleAttr, defStyleRes);
        for (int i = 0; i < a.getIndexCount(); ++i) {
            int attr = a.getIndex(i);
            if (attr == R.styleable.ActionPage_android_color) {
                this.mCircularButton.setColor(a.getColorStateList(attr));
                continue;
            }
            if (attr == R.styleable.ActionPage_android_src) {
                this.mCircularButton.setImageDrawable(a.getDrawable(attr));
                continue;
            }
            if (attr == R.styleable.ActionPage_imageScaleMode) {
                this.mCircularButton.setImageScaleMode(a.getInt(attr, 0));
                continue;
            }
            if (attr == R.styleable.ActionPage_rippleColor) {
                this.mCircularButton.setRippleColor(a.getColor(attr, -1));
                continue;
            }
            if (attr == R.styleable.ActionPage_pressedTranslationZ) {
                this.mCircularButton.setPressedTranslationZ(a.getDimension(attr, 0.0f));
                continue;
            }
            if (attr == R.styleable.ActionPage_android_text) {
                this.mLabel.setText(a.getText(attr));
                continue;
            }
            if (attr == R.styleable.ActionPage_minTextSize) {
                this.mLabel.setMinTextSize(0, a.getDimension(attr, 10.0f));
                continue;
            }
            if (attr == R.styleable.ActionPage_maxTextSize) {
                this.mLabel.setMaxTextSize(0, a.getDimension(attr, 60.0f));
                continue;
            }
            if (attr == R.styleable.ActionPage_android_textColor) {
                this.mLabel.setTextColor(a.getColorStateList(attr));
                continue;
            }
            if (attr == R.styleable.ActionPage_android_maxLines) {
                this.mLabel.setMaxLines(a.getInt(attr, 2));
                continue;
            }
            if (attr == R.styleable.ActionPage_android_fontFamily) {
                fontFamily = a.getString(attr);
                continue;
            }
            if (attr == R.styleable.ActionPage_android_typeface) {
                typefaceIndex = a.getInt(attr, typefaceIndex);
                continue;
            }
            if (attr == R.styleable.ActionPage_android_textStyle) {
                styleIndex = a.getInt(attr, styleIndex);
                continue;
            }
            if (attr == R.styleable.ActionPage_android_gravity) {
                this.mLabel.setGravity(a.getInt(attr, 17));
                continue;
            }
            if (attr == R.styleable.ActionPage_android_lineSpacingExtra) {
                lineSpacingExtra = a.getDimension(attr, lineSpacingExtra);
                continue;
            }
            if (attr == R.styleable.ActionPage_android_lineSpacingMultiplier) {
                lineSpacingMult = a.getDimension(attr, lineSpacingMult);
                continue;
            }
            if (attr != R.styleable.ActionPage_android_stateListAnimator) continue;
            this.mCircularButton.setStateListAnimator(AnimatorInflater.loadStateListAnimator((Context)context, (int)a.getResourceId(attr, 0)));
        }
        a.recycle();
        this.mLabel.setLineSpacing(lineSpacingExtra, lineSpacingMult);
        this.mLabel.setTypefaceFromAttrs(fontFamily, typefaceIndex, styleIndex);
        this.addView(this.mLabel);
        this.addView(this.mCircularButton);
    }

    public ActionLabel getLabel() {
        return this.mLabel;
    }

    public CircularButton getButton() {
        return this.mCircularButton;
    }

    public void setText(CharSequence text) {
        this.mLabel.setText(text);
    }

    public void setColor(int color) {
        this.mCircularButton.setColor(color);
    }

    public void setColor(ColorStateList color) {
        this.mCircularButton.setColor(color);
    }

    public void setImageDrawable(Drawable drawable) {
        this.mCircularButton.setImageDrawable(drawable);
    }

    public void setImageResource(int drawableRes) {
        this.mCircularButton.setImageResource(drawableRes);
    }

    public void setImageScaleMode(int scaleMode) {
        this.mCircularButton.setImageScaleMode(scaleMode);
    }

    public void setStateListAnimator(StateListAnimator stateListAnimator) {
        if (this.mCircularButton != null) {
            this.mCircularButton.setStateListAnimator(stateListAnimator);
        }
    }

    public void setOnClickListener(View.OnClickListener l) {
        this.mCircularButton.setOnClickListener(l);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.mCircularButton.setEnabled(enabled);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int height = this.getMeasuredHeight();
        int width = this.getMeasuredWidth();
        if (this.mCircularButton.getImageScaleMode() == 1 && this.mCircularButton.getImageDrawable() != null) {
            int maxSize = Math.min(width, height);
            this.mCircularButton.measure(View.MeasureSpec.makeMeasureSpec((int)maxSize, (int)Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec((int)maxSize, (int)Integer.MIN_VALUE));
            this.mButtonSize = Math.min(this.mCircularButton.getMeasuredWidth(), this.mCircularButton.getMeasuredHeight());
            this.mButtonRadius = (float)this.mButtonSize / 2.0f;
        } else {
            this.mButtonSize = (int)((float)Math.min(width, height) * 0.45f);
            this.mButtonRadius = (float)this.mButtonSize / 2.0f;
            this.mCircularButton.measure(View.MeasureSpec.makeMeasureSpec((int)this.mButtonSize, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)this.mButtonSize, (int)0x40000000));
        }
        if (this.mIsRound) {
            this.mButtonCenter.set(width / 2, height / 2);
            this.mTextWidth = (int)((float)width * 0.625f);
            this.mBottomInset = (int)((float)height * 0.09375f);
        } else {
            this.mButtonCenter.set(width / 2, (int)((float)height * 0.43f));
            this.mTextWidth = (int)((float)width * 0.892f);
        }
        this.mTextHeight = (int)((float)height - ((float)this.mButtonCenter.y + this.mButtonRadius) - (float)this.mBottomInset);
        this.mLabel.measure(View.MeasureSpec.makeMeasureSpec((int)this.mTextWidth, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)this.mTextHeight, (int)0x40000000));
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.mInsetsApplied) {
            this.requestApplyInsets();
        }
    }

    public WindowInsets onApplyWindowInsets(WindowInsets insets) {
        int insetBottom;
        this.mInsetsApplied = true;
        if (this.mIsRound != insets.isRound()) {
            this.mIsRound = insets.isRound();
            this.requestLayout();
        }
        if (this.mBottomInset != (insetBottom = insets.getSystemWindowInsetBottom())) {
            this.mBottomInset = insetBottom;
            this.requestLayout();
        }
        if (this.mIsRound) {
            this.mBottomInset = (int)Math.max((float)this.mBottomInset, 0.09375f * (float)this.getMeasuredHeight());
        }
        return insets;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int w = r - l;
        this.mCircularButton.layout((int)((float)this.mButtonCenter.x - this.mButtonRadius), (int)((float)this.mButtonCenter.y - this.mButtonRadius), (int)((float)this.mButtonCenter.x + this.mButtonRadius), (int)((float)this.mButtonCenter.y + this.mButtonRadius));
        int textHorizPadding = (int)((float)(w - this.mTextWidth) / 2.0f);
        this.mLabel.layout(textHorizPadding, this.mCircularButton.getBottom(), textHorizPadding + this.mTextWidth, this.mCircularButton.getBottom() + this.mTextHeight);
    }
}

