/*
 * Decompiled with CFR 0.152.
 */
package android.support.wearable.activity;

import android.animation.StateListAnimator;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.support.wearable.R;
import android.support.wearable.view.ActionLabel;
import android.support.wearable.view.ActionPage;
import android.view.View;
import android.widget.TextView;

@TargetApi(value=21)
public class ConfirmationActivity
extends Activity {
    public static final String EXTRA_MESSAGE = "message";
    public static final String EXTRA_ANIMATION_TYPE = "animation_type";
    public static final int SUCCESS_ANIMATION = 1;
    public static final int OPEN_ON_PHONE_ANIMATION = 2;
    public static final int FAILURE_ANIMATION = 3;
    private static final int TEXT_FADE_OFFSET_TIME_MS = 50;
    private static final int OPEN_ON_PHONE_ANIMATION_DURATION_MS = 1666;
    private static final int CONFIRMATION_ANIMATION_DURATION_MS = 1666;
    private ActionPage mActionPage;
    private final Handler mHandler = new Handler();

    public void onCreate(Bundle savedInstanceState) {
        long displayDurationMs;
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        int animationType = intent.getIntExtra(EXTRA_ANIMATION_TYPE, 1);
        String message = intent.getStringExtra(EXTRA_MESSAGE);
        this.mActionPage = new ActionPage((Context)this);
        if (animationType == 3) {
            this.setContentView(R.layout.error_layout);
            TextView text = (TextView)this.findViewById(R.id.message);
            text.setText((CharSequence)message);
            displayDurationMs = 2000L;
        } else {
            Drawable animatedDrawable;
            this.mActionPage.setColor(0);
            this.mActionPage.setStateListAnimator(new StateListAnimator());
            this.mActionPage.setImageScaleMode(ActionPage.SCALE_MODE_CENTER);
            this.setContentView((View)this.mActionPage);
            if (message != null) {
                this.mActionPage.setText(message);
            }
            switch (animationType) {
                case 2: {
                    animatedDrawable = this.getResources().getDrawable(R.drawable.open_on_phone_animation);
                    displayDurationMs = 1666L;
                    break;
                }
                case 1: {
                    animatedDrawable = this.getResources().getDrawable(R.drawable.generic_confirmation_animation);
                    displayDurationMs = 1666L;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown type of animation: " + animationType);
                }
            }
            this.mActionPage.setImageDrawable(animatedDrawable);
            final ActionLabel label = this.mActionPage.getLabel();
            long fadeDuration = label.animate().getDuration();
            final long fadeOutDelay = Math.max(0L, displayDurationMs - 2L * (50L + fadeDuration));
            ((Animatable)animatedDrawable).start();
            label.setAlpha(0.0f);
            label.animate().alpha(1.0f).setStartDelay(50L).withEndAction(new Runnable(){

                @Override
                public void run() {
                    label.animate().alpha(0.0f).setStartDelay(fadeOutDelay);
                }
            });
        }
        this.mActionPage.setKeepScreenOn(true);
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                ConfirmationActivity.this.finish();
                ConfirmationActivity.this.overridePendingTransition(0, 0x10A0001);
            }
        }, displayDurationMs);
    }

    private static long getAnimationDuration(AnimationDrawable animation) {
        int count = animation.getNumberOfFrames();
        long duration = 0L;
        for (int i = 0; i < count; ++i) {
            duration += (long)animation.getDuration(i);
        }
        return duration;
    }
}

