/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.result;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.fitness.data.Bucket;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawBucket;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.request.DataReadRequest;
import com.google.android.gms.fitness.result.zzc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DataReadResult
implements Result,
SafeParcelable {
    private final int zzCY;
    private final List<DataSet> zzajS;
    private final Status zzOt;
    private final List<Bucket> zzamP;
    private int zzamQ;
    private final List<DataSource> zzakc;
    private final List<DataType> zzamR;
    public static final Parcelable.Creator<DataReadResult> CREATOR = new zzc();

    DataReadResult(int versionCode, List<RawDataSet> dataSets, Status status, List<RawBucket> buckets, int batchCount, List<DataSource> uniqueDataSources, List<DataType> uniqueDataTypes) {
        this.zzCY = versionCode;
        this.zzOt = status;
        this.zzamQ = batchCount;
        this.zzakc = uniqueDataSources;
        this.zzamR = uniqueDataTypes;
        this.zzajS = new ArrayList<DataSet>(dataSets.size());
        for (RawDataSet object : dataSets) {
            this.zzajS.add(new DataSet(object, uniqueDataSources));
        }
        this.zzamP = new ArrayList<Bucket>(buckets.size());
        for (RawBucket rawBucket : buckets) {
            this.zzamP.add(new Bucket(rawBucket, uniqueDataSources));
        }
    }

    public DataReadResult(List<DataSet> dataSets, List<Bucket> buckets, Status status) {
        this.zzCY = 5;
        this.zzajS = dataSets;
        this.zzOt = status;
        this.zzamP = buckets;
        this.zzamQ = 1;
        this.zzakc = new ArrayList<DataSource>();
        this.zzamR = new ArrayList<DataType>();
    }

    public static DataReadResult zza(Status status, DataReadRequest dataReadRequest) {
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        for (DataSource object : dataReadRequest.getDataSources()) {
            arrayList.add(DataSet.create(object));
        }
        for (DataType dataType : dataReadRequest.getDataTypes()) {
            DataSource dataSource = new DataSource.Builder().setDataType(dataType).setType(1).setName("Default").build();
            arrayList.add(DataSet.create(dataSource));
        }
        return new DataReadResult(arrayList, Collections.emptyList(), status);
    }

    public DataSet getDataSet(DataType dataType) {
        for (DataSet dataSet : this.zzajS) {
            if (!dataType.equals(dataSet.getDataType())) continue;
            return dataSet;
        }
        throw new IllegalArgumentException(String.format("Attempting to read data for %s, which was not requested", dataType.getName()));
    }

    public DataSet getDataSet(DataSource dataSource) {
        for (DataSet dataSet : this.zzajS) {
            if (!dataSource.equals(dataSet.getDataSource())) continue;
            return dataSet;
        }
        throw new IllegalArgumentException(String.format("Attempting to read data for %s, which was not requested", dataSource.getStreamIdentifier()));
    }

    public List<DataSet> getDataSets() {
        return this.zzajS;
    }

    public List<Bucket> getBuckets() {
        return this.zzamP;
    }

    public int zzrt() {
        return this.zzamQ;
    }

    public void zzb(DataReadResult dataReadResult) {
        for (DataSet object : dataReadResult.getDataSets()) {
            this.zza(object, this.zzajS);
        }
        for (Bucket bucket : dataReadResult.getBuckets()) {
            this.zza(bucket, this.zzamP);
        }
    }

    private void zza(DataSet dataSet, List<DataSet> list) {
        for (DataSet dataSet2 : list) {
            if (!dataSet2.getDataSource().equals(dataSet.getDataSource())) continue;
            dataSet2.zzb(dataSet.getDataPoints());
            return;
        }
        list.add(dataSet);
    }

    private void zza(Bucket bucket, List<Bucket> list) {
        for (Bucket bucket2 : list) {
            if (!bucket2.zzb(bucket)) continue;
            for (DataSet dataSet : bucket.getDataSets()) {
                this.zza(dataSet, bucket2.getDataSets());
            }
            return;
        }
        this.zzamP.add(bucket);
    }

    public Status getStatus() {
        return this.zzOt;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof DataReadResult && this.zzc((DataReadResult)that);
    }

    private boolean zzc(DataReadResult dataReadResult) {
        return this.zzOt.equals((Object)dataReadResult.zzOt) && zzt.equal(this.zzajS, dataReadResult.zzajS) && zzt.equal(this.zzamP, dataReadResult.zzamP);
    }

    public int hashCode() {
        return zzt.hashCode((Object[])new Object[]{this.zzOt, this.zzajS, this.zzamP});
    }

    public String toString() {
        return zzt.zzt((Object)this).zzg("status", (Object)this.zzOt).zzg("dataSets", this.zzajS.size() > 5 ? this.zzajS.size() + " data sets" : this.zzajS).zzg("buckets", this.zzamP.size() > 5 ? this.zzamP.size() + " buckets" : this.zzamP).toString();
    }

    int getVersionCode() {
        return this.zzCY;
    }

    List<RawBucket> zzru() {
        ArrayList<RawBucket> arrayList = new ArrayList<RawBucket>(this.zzamP.size());
        for (Bucket bucket : this.zzamP) {
            arrayList.add(new RawBucket(bucket, this.zzakc, this.zzamR));
        }
        return arrayList;
    }

    List<RawDataSet> zzrv() {
        ArrayList<RawDataSet> arrayList = new ArrayList<RawDataSet>(this.zzajS.size());
        for (DataSet dataSet : this.zzajS) {
            arrayList.add(new RawDataSet(dataSet, this.zzakc, this.zzamR));
        }
        return arrayList;
    }

    List<DataSource> zzqA() {
        return this.zzakc;
    }

    List<DataType> zzrw() {
        return this.zzamR;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzc.zza(this, dest, flags);
    }
}

