/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.request.zzd;
import com.google.android.gms.internal.zzmu;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DataDeleteRequest
implements SafeParcelable {
    private final int zzCY;
    private final long zzKT;
    private final long zzajH;
    private final List<DataSource> zzalP;
    private final List<DataType> zzajQ;
    private final List<Session> zzalQ;
    private final boolean zzalR;
    private final boolean zzalS;
    private final zzmu zzalN;
    private final String zzMZ;
    public static final Parcelable.Creator<DataDeleteRequest> CREATOR = new zzd();

    DataDeleteRequest(int versionCode, long startTimeMillis, long endTimeMillis, List<DataSource> dataSources, List<DataType> dataTypes, List<Session> sessions, boolean deleteAllData, boolean deleteAllSessions, IBinder callback, String packageName) {
        this.zzCY = versionCode;
        this.zzKT = startTimeMillis;
        this.zzajH = endTimeMillis;
        this.zzalP = Collections.unmodifiableList(dataSources);
        this.zzajQ = Collections.unmodifiableList(dataTypes);
        this.zzalQ = sessions;
        this.zzalR = deleteAllData;
        this.zzalS = deleteAllSessions;
        this.zzalN = callback == null ? null : zzmu.zza.zzbF(callback);
        this.zzMZ = packageName;
    }

    private DataDeleteRequest(Builder builder) {
        this(builder.zzKT, builder.zzajH, builder.zzalP, builder.zzajQ, builder.zzalQ, builder.zzalR, builder.zzalS, null, null);
    }

    public DataDeleteRequest(DataDeleteRequest request, zzmu callback, String packageName) {
        this(request.zzKT, request.zzajH, request.zzalP, request.zzajQ, request.zzalQ, request.zzalR, request.zzalS, callback, packageName);
    }

    public DataDeleteRequest(long startTimeMillis, long endTimeMillis, List<DataSource> dataSources, List<DataType> dataTypes, List<Session> sessions, boolean deleteAllData, boolean deleteAllSessions, zzmu callback, String packageName) {
        this.zzCY = 2;
        this.zzKT = startTimeMillis;
        this.zzajH = endTimeMillis;
        this.zzalP = Collections.unmodifiableList(dataSources);
        this.zzajQ = Collections.unmodifiableList(dataTypes);
        this.zzalQ = sessions;
        this.zzalR = deleteAllData;
        this.zzalS = deleteAllSessions;
        this.zzalN = callback;
        this.zzMZ = packageName;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzKT, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzajH, TimeUnit.MILLISECONDS);
    }

    public List<DataSource> getDataSources() {
        return this.zzalP;
    }

    public List<DataType> getDataTypes() {
        return this.zzajQ;
    }

    public List<Session> getSessions() {
        return this.zzalQ;
    }

    public boolean deleteAllData() {
        return this.zzalR;
    }

    public boolean deleteAllSessions() {
        return this.zzalS;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof DataDeleteRequest && this.zzb((DataDeleteRequest)o);
    }

    private boolean zzb(DataDeleteRequest dataDeleteRequest) {
        return this.zzKT == dataDeleteRequest.zzKT && this.zzajH == dataDeleteRequest.zzajH && zzt.equal(this.zzalP, dataDeleteRequest.zzalP) && zzt.equal(this.zzajQ, dataDeleteRequest.zzajQ) && zzt.equal(this.zzalQ, dataDeleteRequest.zzalQ) && this.zzalR == dataDeleteRequest.zzalR && this.zzalS == dataDeleteRequest.zzalS;
    }

    public int hashCode() {
        return zzt.hashCode((Object[])new Object[]{this.zzKT, this.zzajH});
    }

    public String toString() {
        return zzt.zzt((Object)this).zzg("startTimeMillis", (Object)this.zzKT).zzg("endTimeMillis", (Object)this.zzajH).zzg("dataSources", this.zzalP).zzg("dateTypes", this.zzajQ).zzg("sessions", this.zzalQ).zzg("deleteAllData", (Object)this.zzalR).zzg("deleteAllSessions", (Object)this.zzalS).toString();
    }

    int getVersionCode() {
        return this.zzCY;
    }

    public boolean zzqV() {
        return this.zzalR;
    }

    public boolean zzqW() {
        return this.zzalS;
    }

    public long zzqs() {
        return this.zzajH;
    }

    public long zzkt() {
        return this.zzKT;
    }

    public IBinder zzqU() {
        return this.zzalN == null ? null : this.zzalN.asBinder();
    }

    public String getPackageName() {
        return this.zzMZ;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzd.zza(this, dest, flags);
    }

    public static class Builder {
        private long zzKT;
        private long zzajH;
        private List<DataSource> zzalP = new ArrayList<DataSource>();
        private List<DataType> zzajQ = new ArrayList<DataType>();
        private List<Session> zzalQ = new ArrayList<Session>();
        private boolean zzalR = false;
        private boolean zzalS = false;

        public Builder setTimeInterval(long startTime, long endTime, TimeUnit timeUnit) {
            zzu.zzb((startTime > 0L ? 1 : 0) != 0, (String)"Invalid start time :%d", (Object[])new Object[]{startTime});
            zzu.zzb((endTime > startTime ? 1 : 0) != 0, (String)"Invalid end time :%d", (Object[])new Object[]{endTime});
            this.zzKT = timeUnit.toMillis(startTime);
            this.zzajH = timeUnit.toMillis(endTime);
            return this;
        }

        public Builder deleteAllData() {
            zzu.zzb((this.zzajQ.isEmpty() && this.zzalP.isEmpty() ? 1 : 0) != 0, (String)"Specific data source/type already specified for deletion. DataSources: %s DataTypes: %s", (Object[])new Object[]{this.zzalP, this.zzajQ});
            this.zzalR = true;
            return this;
        }

        public Builder addDataSource(DataSource dataSource) {
            zzu.zzb((!this.zzalR ? 1 : 0) != 0, (Object)"All data is already marked for deletion");
            zzu.zzb((dataSource != null ? 1 : 0) != 0, (Object)"Must specify a valid data source");
            if (!this.zzalP.contains(dataSource)) {
                this.zzalP.add(dataSource);
            }
            return this;
        }

        public Builder addSession(Session session) {
            zzu.zzb((!this.zzalS ? 1 : 0) != 0, (Object)"All sessions already marked for deletion");
            zzu.zzb((session != null ? 1 : 0) != 0, (Object)"Must specify a valid session");
            zzu.zzb((session.getEndTime(TimeUnit.MILLISECONDS) > 0L ? 1 : 0) != 0, (Object)"Cannot delete an ongoing session. Please stop the session prior to deleting it");
            this.zzalQ.add(session);
            return this;
        }

        public Builder deleteAllSessions() {
            zzu.zzb((boolean)this.zzalQ.isEmpty(), (String)"Specific sessions already added for deletion: %s", (Object[])new Object[]{this.zzalQ});
            this.zzalS = true;
            return this;
        }

        public Builder addDataType(DataType dataType) {
            zzu.zzb((!this.zzalR ? 1 : 0) != 0, (Object)"All data is already marked for deletion");
            zzu.zzb((dataType != null ? 1 : 0) != 0, (Object)"Must specify a valid data type");
            if (!this.zzajQ.contains(dataType)) {
                this.zzajQ.add(dataType);
            }
            return this;
        }

        public DataDeleteRequest build() {
            zzu.zza((this.zzKT > 0L && this.zzajH > this.zzKT ? 1 : 0) != 0, (Object)"Must specify a valid time interval");
            boolean bl = this.zzalR || !this.zzalP.isEmpty() || !this.zzajQ.isEmpty();
            boolean bl2 = this.zzalS || !this.zzalQ.isEmpty();
            zzu.zza((bl || bl2 ? 1 : 0) != 0, (Object)"No data or session marked for deletion");
            this.zzqX();
            return new DataDeleteRequest(this);
        }

        private void zzqX() {
            if (this.zzalQ.isEmpty()) {
                return;
            }
            for (Session session : this.zzalQ) {
                zzu.zza((session.getStartTime(TimeUnit.MILLISECONDS) >= this.zzKT && session.getEndTime(TimeUnit.MILLISECONDS) <= this.zzajH ? 1 : 0) != 0, (String)"Session %s is outside the time interval [%d, %d]", (Object[])new Object[]{session, this.zzKT, this.zzajH});
            }
        }
    }
}

