/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.fitness.data.Bucket;
import com.google.android.gms.fitness.data.DataSet;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.data.zzm;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class RawBucket
implements SafeParcelable {
    final int zzCY;
    public final long zzKT;
    public final long zzajH;
    public final Session zzajJ;
    public final int zzakG;
    public final List<RawDataSet> zzajS;
    public final int zzajT;
    public final boolean zzajU;
    public static final Parcelable.Creator<RawBucket> CREATOR = new zzm();

    public RawBucket(int versionCode, long startTimeMillis, long endTimeMillis, Session session, int activity, List<RawDataSet> dataSets, int bucketType, boolean serverHasMoreData) {
        this.zzCY = versionCode;
        this.zzKT = startTimeMillis;
        this.zzajH = endTimeMillis;
        this.zzajJ = session;
        this.zzakG = activity;
        this.zzajS = dataSets;
        this.zzajT = bucketType;
        this.zzajU = serverHasMoreData;
    }

    public RawBucket(Bucket bucket, List<DataSource> uniqueDataSources, List<DataType> uniqueDataTypes) {
        this.zzCY = 2;
        this.zzKT = bucket.getStartTime(TimeUnit.MILLISECONDS);
        this.zzajH = bucket.getEndTime(TimeUnit.MILLISECONDS);
        this.zzajJ = bucket.getSession();
        this.zzakG = bucket.zzqq();
        this.zzajT = bucket.getBucketType();
        this.zzajU = bucket.zzqr();
        List<DataSet> list = bucket.getDataSets();
        this.zzajS = new ArrayList<RawDataSet>(list.size());
        for (DataSet dataSet : list) {
            this.zzajS.add(new RawDataSet(dataSet, uniqueDataSources, uniqueDataTypes));
        }
    }

    public boolean equals(Object o) {
        return this == o || o instanceof RawBucket && this.zza((RawBucket)o);
    }

    private boolean zza(RawBucket rawBucket) {
        return this.zzKT == rawBucket.zzKT && this.zzajH == rawBucket.zzajH && this.zzakG == rawBucket.zzakG && zzt.equal(this.zzajS, rawBucket.zzajS) && this.zzajT == rawBucket.zzajT && this.zzajU == rawBucket.zzajU;
    }

    public int hashCode() {
        return zzt.hashCode((Object[])new Object[]{this.zzKT, this.zzajH, this.zzajT});
    }

    public String toString() {
        return zzt.zzt((Object)this).zzg("startTime", (Object)this.zzKT).zzg("endTime", (Object)this.zzajH).zzg("activity", (Object)this.zzakG).zzg("dataSets", this.zzajS).zzg("bucketType", (Object)this.zzajT).zzg("serverHasMoreData", (Object)this.zzajU).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzm.zza(this, parcel, flags);
    }
}

