/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable.internal;

import android.content.Context;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.common.internal.zze;
import com.google.android.gms.common.internal.zzi;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.CapabilityApi;
import com.google.android.gms.wearable.Channel;
import com.google.android.gms.wearable.ChannelApi;
import com.google.android.gms.wearable.DataApi;
import com.google.android.gms.wearable.DataItemAsset;
import com.google.android.gms.wearable.DataItemBuffer;
import com.google.android.gms.wearable.MessageApi;
import com.google.android.gms.wearable.NodeApi;
import com.google.android.gms.wearable.PutDataRequest;
import com.google.android.gms.wearable.internal.zzar;
import com.google.android.gms.wearable.internal.zzat;
import com.google.android.gms.wearable.internal.zzau;
import com.google.android.gms.wearable.internal.zzbf;
import com.google.android.gms.wearable.internal.zzbj;
import com.google.android.gms.wearable.internal.zzbl;
import com.google.android.gms.wearable.internal.zzq;
import com.google.android.gms.wearable.zza;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;

public class zzbk
extends zzi<zzat> {
    private final ExecutorService zzaNb = Executors.newCachedThreadPool();
    private final zzau<zza.zza> zzaUR = new zzau();
    private final zzau<ChannelApi.ChannelListener> zzaUS = new zzau();
    private final zzau<DataApi.DataListener> zzaUT = new zzau();
    private final zzau<MessageApi.MessageListener> zzaUU = new zzau();
    private final zzau<NodeApi.NodeListener> zzaUV = new zzau();
    private final zzau<NodeApi.zza> zzaUW = new zzau();
    private final Map<String, zzau<CapabilityApi.CapabilityListener>> zzaUX = new HashMap<String, zzau<CapabilityApi.CapabilityListener>>();

    public zzbk(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, zze zze2) {
        super(context, looper, 14, connectionCallbacks, onConnectionFailedListener, zze2);
    }

    protected String getStartServiceAction() {
        return "com.google.android.gms.wearable.BIND";
    }

    protected String getServiceDescriptor() {
        return "com.google.android.gms.wearable.internal.IWearableService";
    }

    protected zzat zzdS(IBinder iBinder) {
        return zzat.zza.zzdQ(iBinder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        if (Log.isLoggable((String)"WearableClient", (int)2)) {
            Log.d((String)"WearableClient", (String)("onPostInitHandler: statusCode " + n));
        }
        if (n == 0) {
            this.zzaUR.zzdR(iBinder);
            this.zzaUT.zzdR(iBinder);
            this.zzaUU.zzdR(iBinder);
            this.zzaUV.zzdR(iBinder);
            this.zzaUW.zzdR(iBinder);
            Map<String, zzau<CapabilityApi.CapabilityListener>> map = this.zzaUX;
            synchronized (map) {
                for (zzau<CapabilityApi.CapabilityListener> zzau2 : this.zzaUX.values()) {
                    zzau2.zzdR(iBinder);
                }
            }
        }
        super.zza(n, iBinder, bundle, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        this.zzaUR.zzb(this);
        this.zzaUT.zzb(this);
        this.zzaUU.zzb(this);
        this.zzaUV.zzb(this);
        this.zzaUW.zzb(this);
        Map<String, zzau<CapabilityApi.CapabilityListener>> map = this.zzaUX;
        synchronized (map) {
            for (zzau<CapabilityApi.CapabilityListener> zzau2 : this.zzaUX.values()) {
                zzau2.zzb(this);
            }
        }
        super.disconnect();
    }

    public void zza(zza.zzb<DataApi.DataItemResult> zzb2, PutDataRequest putDataRequest) throws RemoteException {
        Map.Entry<String, Asset> entry22;
        for (Map.Entry<String, Asset> entry22 : putDataRequest.getAssets().entrySet()) {
            Asset asset = entry22.getValue();
            if (asset.getData() != null || asset.getDigest() != null || asset.getFd() != null || asset.getUri() != null) continue;
            throw new IllegalArgumentException("Put for " + putDataRequest.getUri() + " contains invalid asset: " + asset);
        }
        PutDataRequest putDataRequest2 = PutDataRequest.zzn(putDataRequest.getUri());
        putDataRequest2.setData(putDataRequest.getData());
        entry22 = new ArrayList();
        for (Map.Entry entry3 : putDataRequest.getAssets().entrySet()) {
            ParcelFileDescriptor[] parcelFileDescriptorArray;
            Asset asset = (Asset)entry3.getValue();
            if (asset.getData() == null) {
                putDataRequest2.putAsset((String)entry3.getKey(), (Asset)entry3.getValue());
                continue;
            }
            try {
                parcelFileDescriptorArray = ParcelFileDescriptor.createPipe();
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Unable to create ParcelFileDescriptor for asset in request: " + putDataRequest, iOException);
            }
            if (Log.isLoggable((String)"WearableClient", (int)3)) {
                Log.d((String)"WearableClient", (String)("processAssets: replacing data with FD in asset: " + asset + " read:" + parcelFileDescriptorArray[0] + " write:" + parcelFileDescriptorArray[1]));
            }
            putDataRequest2.putAsset((String)entry3.getKey(), Asset.createFromFd(parcelFileDescriptorArray[0]));
            FutureTask<Boolean> futureTask = this.zza(parcelFileDescriptorArray[1], asset.getData());
            entry22.add(futureTask);
            this.zzaNb.submit(futureTask);
        }
        ((zzat)this.zznM()).zza((zzar)new zzbj.zzq(zzb2, (List<FutureTask<Boolean>>)((Object)entry22)), putDataRequest2);
    }

    private FutureTask<Boolean> zza(final ParcelFileDescriptor parcelFileDescriptor, final byte[] byArray) {
        return new FutureTask<Boolean>(new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean zzBg() {
                if (Log.isLoggable((String)"WearableClient", (int)3)) {
                    Log.d((String)"WearableClient", (String)("processAssets: writing data to FD : " + parcelFileDescriptor));
                }
                ParcelFileDescriptor.AutoCloseOutputStream autoCloseOutputStream = new ParcelFileDescriptor.AutoCloseOutputStream(parcelFileDescriptor);
                try {
                    autoCloseOutputStream.write(byArray);
                    autoCloseOutputStream.flush();
                    if (Log.isLoggable((String)"WearableClient", (int)3)) {
                        Log.d((String)"WearableClient", (String)("processAssets: wrote data: " + parcelFileDescriptor));
                    }
                    Boolean bl = true;
                    return bl;
                }
                catch (IOException iOException) {
                    Log.w((String)"WearableClient", (String)("processAssets: writing data failed: " + parcelFileDescriptor));
                }
                finally {
                    try {
                        if (Log.isLoggable((String)"WearableClient", (int)3)) {
                            Log.d((String)"WearableClient", (String)("processAssets: closing: " + parcelFileDescriptor));
                        }
                        autoCloseOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                return false;
            }

            @Override
            public /* synthetic */ Object call() throws Exception {
                return this.zzBg();
            }
        });
    }

    public void zza(zza.zzb<DataApi.DataItemResult> zzb2, Uri uri) throws RemoteException {
        ((zzat)this.zznM()).zza((zzar)new zzbj.zzk(zzb2), uri);
    }

    public void zzl(zza.zzb<DataItemBuffer> zzb2) throws RemoteException {
        ((zzat)this.zznM()).zzb(new zzbj.zzl(zzb2));
    }

    public void zza(zza.zzb<DataItemBuffer> zzb2, Uri uri, int n) throws RemoteException {
        ((zzat)this.zznM()).zza((zzar)new zzbj.zzl(zzb2), uri, n);
    }

    public void zzb(zza.zzb<DataApi.DeleteDataItemsResult> zzb2, Uri uri, int n) throws RemoteException {
        ((zzat)this.zznM()).zzb((zzar)new zzbj.zze(zzb2), uri, n);
    }

    public void zza(zza.zzb<MessageApi.SendMessageResult> zzb2, String string, String string2, byte[] byArray) throws RemoteException {
        ((zzat)this.zznM()).zza(new zzbj.zzt(zzb2), string, string2, byArray);
    }

    public void zza(zza.zzb<DataApi.GetFdForAssetResult> zzb2, Asset asset) throws RemoteException {
        ((zzat)this.zznM()).zza((zzar)new zzbj.zzm(zzb2), asset);
    }

    public void zza(zza.zzb<DataApi.GetFdForAssetResult> zzb2, DataItemAsset dataItemAsset) throws RemoteException {
        this.zza(zzb2, Asset.createFromRef(dataItemAsset.getId()));
    }

    public void zzm(zza.zzb<NodeApi.GetLocalNodeResult> zzb2) throws RemoteException {
        ((zzat)this.zznM()).zzc(new zzbj.zzn(zzb2));
    }

    public void zzn(zza.zzb<NodeApi.GetConnectedNodesResult> zzb2) throws RemoteException {
        ((zzat)this.zznM()).zzd(new zzbj.zzj(zzb2));
    }

    public void zzg(zza.zzb<CapabilityApi.GetCapabilityResult> zzb2, String string, int n) throws RemoteException {
        ((zzat)this.zznM()).zza((zzar)new zzbj.zzg(zzb2), string, n);
    }

    public void zzd(zza.zzb<CapabilityApi.GetAllCapabilitiesResult> zzb2, int n) throws RemoteException {
        ((zzat)this.zznM()).zza((zzar)new zzbj.zzf(zzb2), n);
    }

    public void zzr(zza.zzb<CapabilityApi.AddLocalCapabilityResult> zzb2, String string) throws RemoteException {
        ((zzat)this.zznM()).zzd(new zzbj.zza(zzb2), string);
    }

    public void zzs(zza.zzb<CapabilityApi.RemoveLocalCapabilityResult> zzb2, String string) throws RemoteException {
        ((zzat)this.zznM()).zze(new zzbj.zzs(zzb2), string);
    }

    public void zze(zza.zzb<ChannelApi.OpenChannelResult> zzb2, String string, String string2) throws RemoteException {
        ((zzat)this.zznM()).zza((zzar)new zzbj.zzp(zzb2), string, string2);
    }

    public void zzt(zza.zzb<Status> zzb2, String string) throws RemoteException {
        ((zzat)this.zznM()).zzf(new zzbj.zzc(zzb2), string);
    }

    public void zzh(zza.zzb<Status> zzb2, String string, int n) throws RemoteException {
        ((zzat)this.zznM()).zzb((zzar)new zzbj.zzd(zzb2), string, n);
    }

    public void zzu(zza.zzb<Channel.GetInputStreamResult> zzb2, String string) throws RemoteException {
        zzq zzq2 = new zzq();
        ((zzat)this.zznM()).zza((zzar)new zzbj.zzh(zzb2, zzq2), zzq2, string);
    }

    public void zzv(zza.zzb<Channel.GetOutputStreamResult> zzb2, String string) throws RemoteException {
        zzq zzq2 = new zzq();
        ((zzat)this.zznM()).zzb((zzar)new zzbj.zzi(zzb2, zzq2), zzq2, string);
    }

    public void zza(zza.zzb<Status> zzb2, String string, Uri uri, boolean bl) {
        try {
            FutureTask<Void> futureTask = this.zzb(zzb2, string, uri, bl);
            this.zzaNb.submit(futureTask);
        }
        catch (RuntimeException runtimeException) {
            zzb2.zzr(new Status(8));
            throw runtimeException;
        }
    }

    public void zza(zza.zzb<Status> zzb2, String string, Uri uri, long l, long l2) {
        try {
            FutureTask<Void> futureTask = this.zzb(zzb2, string, uri, l, l2);
            this.zzaNb.submit(futureTask);
        }
        catch (RuntimeException runtimeException) {
            zzb2.zzr(new Status(8));
            throw runtimeException;
        }
    }

    public void zza(zza.zzb<Status> zzb2, DataApi.DataListener dataListener, IntentFilter[] intentFilterArray) throws RemoteException {
        this.zzaUT.zza(this, zzb2, dataListener, zzbl.zza(dataListener, intentFilterArray));
    }

    public void zza(zza.zzb<Status> zzb2, MessageApi.MessageListener messageListener, IntentFilter[] intentFilterArray) throws RemoteException {
        this.zzaUU.zza(this, zzb2, messageListener, zzbl.zza(messageListener, intentFilterArray));
    }

    public void zza(zza.zzb<Status> zzb2, NodeApi.NodeListener nodeListener) throws RemoteException {
        this.zzaUV.zza(this, zzb2, nodeListener, zzbl.zza(nodeListener));
    }

    private zzau<CapabilityApi.CapabilityListener> zzfh(String string) {
        zzau<CapabilityApi.CapabilityListener> zzau2 = this.zzaUX.get(string);
        if (zzau2 == null) {
            zzau2 = new zzau();
            this.zzaUX.put(string, zzau2);
        }
        return zzau2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(zza.zzb<Status> zzb2, CapabilityApi.CapabilityListener capabilityListener, String string) throws RemoteException {
        Map<String, zzau<CapabilityApi.CapabilityListener>> map = this.zzaUX;
        synchronized (map) {
            this.zzfh(string).zza(this, zzb2, capabilityListener, zzbl.zza(capabilityListener, string));
        }
    }

    public void zza(zza.zzb<Status> zzb2, ChannelApi.ChannelListener channelListener, String string) throws RemoteException {
        if (string == null) {
            this.zzaUS.zza(this, zzb2, channelListener, zzbl.zzb(channelListener));
        } else {
            zzbf zzbf2 = new zzbf(string, channelListener);
            this.zzaUS.zza(this, zzb2, zzbf2, zzbl.zza(zzbf2, string));
        }
    }

    public void zza(zza.zzb<Status> zzb2, DataApi.DataListener dataListener) throws RemoteException {
        this.zzaUT.zza(this, zzb2, dataListener);
    }

    public void zza(zza.zzb<Status> zzb2, MessageApi.MessageListener messageListener) throws RemoteException {
        this.zzaUU.zza(this, zzb2, messageListener);
    }

    public void zzb(zza.zzb<Status> zzb2, NodeApi.NodeListener nodeListener) throws RemoteException {
        this.zzaUV.zza(this, zzb2, nodeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzb(zza.zzb<Status> zzb2, CapabilityApi.CapabilityListener capabilityListener, String string) throws RemoteException {
        Map<String, zzau<CapabilityApi.CapabilityListener>> map = this.zzaUX;
        synchronized (map) {
            zzau<CapabilityApi.CapabilityListener> zzau2 = this.zzfh(string);
            zzau2.zza(this, zzb2, capabilityListener);
            if (zzau2.isEmpty()) {
                this.zzaUX.remove(string);
            }
        }
    }

    public void zzb(zza.zzb<Status> zzb2, ChannelApi.ChannelListener channelListener, String string) throws RemoteException {
        if (string == null) {
            this.zzaUS.zza(this, zzb2, channelListener);
        } else {
            zzbf zzbf2 = new zzbf(string, channelListener);
            this.zzaUS.zza(this, zzb2, zzbf2);
        }
    }

    private FutureTask<Void> zzb(final zza.zzb<Status> zzb2, final String string, final Uri uri, final boolean bl) {
        zzu.zzu(zzb2);
        zzu.zzu((Object)string);
        zzu.zzu((Object)uri);
        return new FutureTask<Object>(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ParcelFileDescriptor parcelFileDescriptor;
                if (Log.isLoggable((String)"WearableClient", (int)2)) {
                    Log.v((String)"WearableClient", (String)"Executing receiveFileFromChannelTask");
                }
                if (!"file".equals(uri.getScheme())) {
                    Log.w((String)"WearableClient", (String)"Channel.receiveFile used with non-file URI");
                    zzb2.zzr(new Status(10, "Channel.receiveFile used with non-file URI"));
                    return;
                }
                File file = new File(uri.getPath());
                int n = 0x20000000 | (bl ? 0x2000000 : 0);
                try {
                    parcelFileDescriptor = ParcelFileDescriptor.open((File)file, (int)n);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Log.w((String)"WearableClient", (String)("File couldn't be opened for Channel.receiveFile: " + file));
                    zzb2.zzr(new Status(13));
                    return;
                }
                try {
                    ((zzat)zzbk.this.zznM()).zza((zzar)new zzbj.zzu((zza.zzb<Status>)zzb2), string, parcelFileDescriptor);
                }
                catch (RemoteException remoteException) {
                    Log.w((String)"WearableClient", (String)"Channel.receiveFile failed.", (Throwable)remoteException);
                    zzb2.zzr(new Status(8));
                }
                finally {
                    try {
                        parcelFileDescriptor.close();
                    }
                    catch (IOException iOException) {
                        Log.w((String)"WearableClient", (String)"Failed to close targetFd", (Throwable)iOException);
                    }
                }
            }
        }, null);
    }

    private FutureTask<Void> zzb(final zza.zzb<Status> zzb2, final String string, final Uri uri, final long l, final long l2) {
        zzu.zzu(zzb2);
        zzu.zzu((Object)string);
        zzu.zzu((Object)uri);
        zzu.zzb((l >= 0L ? 1 : 0) != 0, (String)"startOffset is negative: %s", (Object[])new Object[]{l});
        zzu.zzb((l2 >= -1L ? 1 : 0) != 0, (String)"invalid length: %s", (Object[])new Object[]{l2});
        return new FutureTask<Object>(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ParcelFileDescriptor parcelFileDescriptor;
                if (Log.isLoggable((String)"WearableClient", (int)2)) {
                    Log.v((String)"WearableClient", (String)"Executing sendFileToChannelTask");
                }
                if (!"file".equals(uri.getScheme())) {
                    Log.w((String)"WearableClient", (String)"Channel.sendFile used with non-file URI");
                    zzb2.zzr(new Status(10, "Channel.sendFile used with non-file URI"));
                    return;
                }
                File file = new File(uri.getPath());
                try {
                    parcelFileDescriptor = ParcelFileDescriptor.open((File)file, (int)0x10000000);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Log.w((String)"WearableClient", (String)("File couldn't be opened for Channel.sendFile: " + file));
                    zzb2.zzr(new Status(13));
                    return;
                }
                try {
                    ((zzat)zzbk.this.zznM()).zza(new zzbj.zzr((zza.zzb<Status>)zzb2), string, parcelFileDescriptor, l, l2);
                }
                catch (RemoteException remoteException) {
                    Log.w((String)"WearableClient", (String)"Channel.sendFile failed.", (Throwable)remoteException);
                    zzb2.zzr(new Status(8));
                }
                finally {
                    try {
                        parcelFileDescriptor.close();
                    }
                    catch (IOException iOException) {
                        Log.w((String)"WearableClient", (String)"Failed to close sourceFd", (Throwable)iOException);
                    }
                }
            }
        }, null);
    }

    protected /* synthetic */ IInterface zzT(IBinder iBinder) {
        return this.zzdS(iBinder);
    }
}

