/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.accounts.Account;
import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzi;
import com.google.android.gms.identity.intents.UserAddressRequest;
import com.google.android.gms.internal.zznl;
import com.google.android.gms.internal.zznm;

public class zznk
extends zzi<zznm> {
    private Activity mActivity;
    private zza zzawz;
    private final String zzOx;
    private final int mTheme;

    public zznk(Activity activity, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, String string, int n) {
        super((Context)activity, looper, 12, connectionCallbacks, onConnectionFailedListener);
        this.zzOx = string;
        this.mActivity = activity;
        this.mTheme = n;
    }

    public boolean requiresAccount() {
        return true;
    }

    protected String getStartServiceAction() {
        return "com.google.android.gms.identity.service.BIND";
    }

    protected String getServiceDescriptor() {
        return "com.google.android.gms.identity.intents.internal.IAddressService";
    }

    protected zznm zzbO(IBinder iBinder) {
        return zznm.zza.zzbQ(iBinder);
    }

    public void disconnect() {
        super.disconnect();
        if (this.zzawz != null) {
            this.zzawz.setActivity(null);
            this.zzawz = null;
        }
    }

    protected zznm zzub() throws DeadObjectException {
        return (zznm)super.zznM();
    }

    protected void zzuc() {
        super.zznL();
    }

    public void zza(UserAddressRequest userAddressRequest, int n) {
        this.zzuc();
        this.zzawz = new zza(n, this.mActivity);
        try {
            Bundle bundle = new Bundle();
            String string = this.getContext().getPackageName();
            bundle.putString("com.google.android.gms.identity.intents.EXTRA_CALLING_PACKAGE_NAME", string);
            if (!TextUtils.isEmpty((CharSequence)this.zzOx)) {
                bundle.putParcelable("com.google.android.gms.identity.intents.EXTRA_ACCOUNT", (Parcelable)new Account(this.zzOx, "com.google"));
            }
            bundle.putInt("com.google.android.gms.identity.intents.EXTRA_THEME", this.mTheme);
            this.zzub().zza(this.zzawz, userAddressRequest, bundle);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"AddressClientImpl", (String)"Exception requesting user address", (Throwable)remoteException);
            Bundle bundle = new Bundle();
            bundle.putInt("com.google.android.gms.identity.intents.EXTRA_ERROR_CODE", 555);
            this.zzawz.zzh(1, bundle);
        }
    }

    protected /* synthetic */ IInterface zzT(IBinder iBinder) {
        return this.zzbO(iBinder);
    }

    public static final class zza
    extends zznl.zza {
        private final int zzZY;
        private Activity mActivity;

        public zza(int n, Activity activity) {
            this.zzZY = n;
            this.mActivity = activity;
        }

        @Override
        public void zzh(int n, Bundle bundle) {
            ConnectionResult connectionResult;
            if (n == 1) {
                Intent intent = new Intent();
                intent.putExtras(bundle);
                PendingIntent pendingIntent = this.mActivity.createPendingResult(this.zzZY, intent, 0x40000000);
                if (pendingIntent == null) {
                    return;
                }
                try {
                    pendingIntent.send(1);
                }
                catch (PendingIntent.CanceledException canceledException) {
                    Log.w((String)"AddressClientImpl", (String)"Exception settng pending result", (Throwable)canceledException);
                }
                return;
            }
            PendingIntent pendingIntent = null;
            if (bundle != null) {
                pendingIntent = (PendingIntent)bundle.getParcelable("com.google.android.gms.identity.intents.EXTRA_PENDING_INTENT");
            }
            if ((connectionResult = new ConnectionResult(n, pendingIntent)).hasResolution()) {
                try {
                    connectionResult.startResolutionForResult(this.mActivity, this.zzZY);
                }
                catch (IntentSender.SendIntentException sendIntentException) {
                    Log.w((String)"AddressClientImpl", (String)"Exception starting pending intent", (Throwable)sendIntentException);
                }
            } else {
                try {
                    PendingIntent pendingIntent2 = this.mActivity.createPendingResult(this.zzZY, new Intent(), 0x40000000);
                    if (pendingIntent2 != null) {
                        pendingIntent2.send(1);
                    }
                }
                catch (PendingIntent.CanceledException canceledException) {
                    Log.w((String)"AddressClientImpl", (String)"Exception setting pending result", (Throwable)canceledException);
                }
            }
        }

        private void setActivity(Activity activity) {
            this.mActivity = activity;
        }
    }
}

