/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.RemoteException;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.reward.client.RewardedVideoAdRequestParcel;
import com.google.android.gms.ads.internal.reward.client.zzd;
import com.google.android.gms.ads.internal.reward.mediation.client.RewardItemParcel;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.zzo;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.internal.zzef;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzgm;
import com.google.android.gms.internal.zzgp;
import com.google.android.gms.internal.zzgs;
import com.google.android.gms.internal.zzgv;
import com.google.android.gms.internal.zzha;
import java.util.HashMap;

@zzgd
public class zzgo
extends com.google.android.gms.ads.internal.zzb
implements zzgs {
    private zzd zzEN;
    private String zzEO;
    private boolean zzEP;
    private HashMap<String, zzgp> zzEQ = new HashMap();

    public zzgo(Context context, AdSizeParcel adSizeParcel, zzef zzef2, VersionInfoParcel versionInfoParcel) {
        super(context, adSizeParcel, null, zzef2, versionInfoParcel);
    }

    public void setUserId(String userId) {
        zzu.zzbY((String)"setUserId must be called on the main UI thread.");
        this.zzEO = userId;
    }

    public void zza(RewardedVideoAdRequestParcel rewardedVideoAdRequestParcel) {
        zzu.zzbY((String)"loadAd must be called on the main UI thread.");
        if (TextUtils.isEmpty((CharSequence)rewardedVideoAdRequestParcel.zzpG)) {
            zzb.zzaC("Invalid ad unit id. Aborting.");
            return;
        }
        this.zzEP = false;
        this.zzon.zzpG = rewardedVideoAdRequestParcel.zzpG;
        super.zza(rewardedVideoAdRequestParcel.zzCm);
    }

    @Override
    public boolean zzb(zzha.zza zza2) {
        if (zza2.errorCode != -2) {
            this.zzb(new zzha(zza2, null, null, null, null, null, null));
            return true;
        }
        this.zzon.zzqh = 0;
        this.zzon.zzpM = new zzgv(this.zzon.zzpH, this.zzEO, zza2, this);
        this.zzon.zzpM.zzgi();
        return true;
    }

    public zzgp zzao(String string2) {
        zzgp zzgp2 = this.zzEQ.get(string2);
        if (zzgp2 == null) {
            try {
                zzgp2 = new zzgp(this.zzoq.zzY(string2), this);
                this.zzEQ.put(string2, zzgp2);
            }
            catch (Exception exception) {
                zzb.zzd("Fail to instantiate adapter " + string2, exception);
            }
        }
        return zzgp2;
    }

    @Override
    public boolean zza(zzha zzha2, zzha zzha3) {
        if (this.zzEN != null) {
            try {
                this.zzEN.onRewardedVideoAdLoaded();
            }
            catch (RemoteException remoteException) {
                zzb.zzd("Could not call RewardedVideoAdListener.onAdLoaded().", remoteException);
            }
        }
        return true;
    }

    @Override
    public void pause() {
        zzu.zzbY((String)"pause must be called on the main UI thread.");
        for (String string2 : this.zzEQ.keySet()) {
            try {
                zzgp zzgp2 = this.zzEQ.get(string2);
                if (zzgp2 == null || zzgp2.zzfM() == null) continue;
                zzgp2.zzfM().pause();
            }
            catch (RemoteException remoteException) {
                zzb.zzaC("Fail to pause adapter: " + string2);
            }
        }
    }

    @Override
    public void resume() {
        zzu.zzbY((String)"resume must be called on the main UI thread.");
        for (String string2 : this.zzEQ.keySet()) {
            try {
                zzgp zzgp2 = this.zzEQ.get(string2);
                if (zzgp2 == null || zzgp2.zzfM() == null) continue;
                zzgp2.zzfM().resume();
            }
            catch (RemoteException remoteException) {
                zzb.zzaC("Fail to resume adapter: " + string2);
            }
        }
    }

    @Override
    public void destroy() {
        zzu.zzbY((String)"destroy must be called on the main UI thread.");
        for (String string2 : this.zzEQ.keySet()) {
            try {
                zzgp zzgp2 = this.zzEQ.get(string2);
                if (zzgp2 == null || zzgp2.zzfM() == null) continue;
                zzgp2.zzfM().destroy();
            }
            catch (RemoteException remoteException) {
                zzb.zzaC("Fail to destroy adapter: " + string2);
            }
        }
    }

    @Override
    protected boolean zze(int n) {
        zzb.zzaC("Failed to load ad: " + n);
        if (this.zzEN == null) {
            return false;
        }
        try {
            this.zzEN.onRewardedVideoAdFailedToLoad(n);
            return true;
        }
        catch (RemoteException remoteException) {
            zzb.zzd("Could not call RewardedVideoAdListener.onAdFailedToLoad().", remoteException);
            return false;
        }
    }

    public void zzfK() {
        zzu.zzbY((String)"showAd must be called on the main UI thread.");
        if (!this.isLoaded() || this.zzEP) {
            zzb.zzaC("The reward video has not loaded.");
            return;
        }
        this.zzEP = true;
        zzgp zzgp2 = this.zzao(this.zzon.zzpO.zzyb);
        if (zzgp2 != null && zzgp2.zzfM() != null) {
            try {
                zzgp2.zzfM().showVideo();
            }
            catch (RemoteException remoteException) {
                zzb.zzd("Could not call showVideo.", remoteException);
            }
        }
    }

    public boolean isLoaded() {
        zzu.zzbY((String)"isLoaded must be called on the main UI thread.");
        return this.zzon.zzpL == null && this.zzon.zzpM == null && this.zzon.zzpO != null;
    }

    public void zza(zzd zzd2) {
        zzu.zzbY((String)"setRewardedVideoAdListener must be called on the main UI thread.");
        this.zzEN = zzd2;
    }

    @Override
    public void onRewardedVideoAdOpened() {
        this.recordImpression();
        if (this.zzEN == null) {
            return;
        }
        try {
            this.zzEN.onRewardedVideoAdOpened();
        }
        catch (RemoteException remoteException) {
            zzb.zzd("Could not call RewardedVideoAdListener.onAdOpened().", remoteException);
        }
    }

    @Override
    public void onRewardedVideoStarted() {
        zzo.zzbG().zza(this.zzon.zzpH, this.zzon.zzpJ.zzGG, this.zzon.zzpO, this.zzon.zzpG, false, this.zzon.zzpO.zzxZ.zzxB);
        if (this.zzEN == null) {
            return;
        }
        try {
            this.zzEN.onRewardedVideoStarted();
        }
        catch (RemoteException remoteException) {
            zzb.zzd("Could not call RewardedVideoAdListener.onVideoStarted().", remoteException);
        }
    }

    @Override
    public void onRewardedVideoAdClosed() {
        if (this.zzEN == null) {
            return;
        }
        try {
            this.zzEN.onRewardedVideoAdClosed();
        }
        catch (RemoteException remoteException) {
            zzb.zzd("Could not call RewardedVideoAdListener.onAdClosed().", remoteException);
        }
    }

    @Override
    public void zza(RewardItemParcel rewardItemParcel) {
        zzo.zzbG().zza(this.zzon.zzpH, this.zzon.zzpJ.zzGG, this.zzon.zzpO, this.zzon.zzpG, false, this.zzon.zzpO.zzxZ.zzxC);
        if (this.zzEN == null) {
            return;
        }
        try {
            if (this.zzon.zzpO != null && this.zzon.zzpO.zzFm != null && !TextUtils.isEmpty((CharSequence)this.zzon.zzpO.zzFm.zzxK)) {
                this.zzEN.zza(new zzgm(this.zzon.zzpO.zzFm.zzxK, this.zzon.zzpO.zzFm.zzxL));
            } else {
                this.zzEN.zza(new zzgm(rewardItemParcel.type, rewardItemParcel.zzFk));
            }
        }
        catch (RemoteException remoteException) {
            zzb.zzd("Could not call RewardedVideoAdListener.onRewarded().", remoteException);
        }
    }

    @Override
    public void zzfL() {
        this.onAdClicked();
    }

    @Override
    public void onRewardedVideoAdLeftApplication() {
        if (this.zzEN == null) {
            return;
        }
        try {
            this.zzEN.onRewardedVideoAdLeftApplication();
        }
        catch (RemoteException remoteException) {
            zzb.zzd("Could not call RewardedVideoAdListener.onAdLeftApplication().", remoteException);
        }
    }
}

