/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.request;

import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import com.google.android.gms.ads.internal.request.zzk;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.zzo;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.zzlg;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class LargeParcelTeleporter
implements SafeParcelable {
    public static final Parcelable.Creator<LargeParcelTeleporter> CREATOR = new zzk();
    final int zzCY;
    ParcelFileDescriptor zzCZ;
    private Parcelable zzDa;
    private boolean zzDb;

    LargeParcelTeleporter(int versionCode, ParcelFileDescriptor parcelFileDescriptor) {
        this.zzCY = versionCode;
        this.zzCZ = parcelFileDescriptor;
        this.zzDa = null;
        this.zzDb = true;
    }

    public LargeParcelTeleporter(SafeParcelable teleportee) {
        this.zzCY = 1;
        this.zzCZ = null;
        this.zzDa = teleportee;
        this.zzDb = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends SafeParcelable> T zza(Parcelable.Creator<T> creator) {
        if (this.zzDb) {
            byte[] byArray;
            if (this.zzCZ == null) {
                zzb.zzaz("File descriptor is empty, returning null.");
                return null;
            }
            DataInputStream dataInputStream = new DataInputStream((InputStream)new ParcelFileDescriptor.AutoCloseInputStream(this.zzCZ));
            try {
                byArray = new byte[dataInputStream.readInt()];
                dataInputStream.readFully(byArray, 0, byArray.length);
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Could not read from parcel file descriptor", iOException);
            }
            finally {
                zzlg.zzb((Closeable)dataInputStream);
            }
            Parcel parcel = Parcel.obtain();
            try {
                parcel.unmarshall(byArray, 0, byArray.length);
                parcel.setDataPosition(0);
                this.zzDa = (SafeParcelable)creator.createFromParcel(parcel);
            }
            finally {
                parcel.recycle();
            }
            this.zzDb = false;
        }
        return (T)((SafeParcelable)this.zzDa);
    }

    public int describeContents() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToParcel(Parcel dest, int flags) {
        if (this.zzCZ == null) {
            byte[] byArray;
            Parcel parcel = Parcel.obtain();
            try {
                this.zzDa.writeToParcel(parcel, 0);
                byArray = parcel.marshall();
            }
            finally {
                parcel.recycle();
            }
            this.zzCZ = this.zzf(byArray);
        }
        zzk.zza(this, dest, flags);
    }

    protected <T> ParcelFileDescriptor zzf(byte[] byArray) {
        try {
            ParcelFileDescriptor[] parcelFileDescriptorArray = ParcelFileDescriptor.createPipe();
            ParcelFileDescriptor parcelFileDescriptor = parcelFileDescriptorArray[1];
            ParcelFileDescriptor.AutoCloseOutputStream autoCloseOutputStream = new ParcelFileDescriptor.AutoCloseOutputStream(parcelFileDescriptor);
            Runnable runnable = new Runnable((OutputStream)autoCloseOutputStream, byArray){
                final /* synthetic */ OutputStream zzDc;
                final /* synthetic */ byte[] zzDd;
                {
                    this.zzDc = outputStream;
                    this.zzDd = byArray;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    DataOutputStream dataOutputStream = new DataOutputStream(this.zzDc);
                    try {
                        dataOutputStream.writeInt(this.zzDd.length);
                        dataOutputStream.write(this.zzDd);
                    }
                    catch (IOException iOException) {
                        zzb.zzb("Error transporting the ad response", iOException);
                        zzo.zzby().zzc(iOException, true);
                    }
                    finally {
                        zzlg.zzb((Closeable)dataOutputStream);
                    }
                }
            };
            new Thread(runnable).start();
            return parcelFileDescriptorArray[0];
        }
        catch (IOException iOException) {
            zzb.zzb("Error transporting the ad response", iOException);
            zzo.zzby().zzc(iOException, true);
            return null;
        }
    }
}

