/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.internal;

import android.content.Context;
import android.os.Build;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.maps.internal.zzc;
import com.google.android.gms.maps.model.RuntimeRemoteException;

public class zzy {
    private static Context zzaCM;
    private static zzc zzaCN;

    public static zzc zzay(Context context) throws GooglePlayServicesNotAvailableException {
        zzu.zzu((Object)context);
        if (zzaCN != null) {
            return zzaCN;
        }
        zzy.zzaz(context);
        zzaCN = zzy.zzaA(context);
        try {
            zzaCN.zzd(zze.zzw((Object)zzy.getRemoteContext(context).getResources()), GooglePlayServicesUtil.GOOGLE_PLAY_SERVICES_VERSION_CODE);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return zzaCN;
    }

    public static boolean zzvE() {
        return false;
    }

    private static Class<?> zzvF() {
        try {
            if (Build.VERSION.SDK_INT < 15) {
                return Class.forName("com.google.android.gms.maps.internal.CreatorImplGmm6");
            }
            return Class.forName("com.google.android.gms.maps.internal.CreatorImpl");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
    }

    private static void zzaz(Context context) throws GooglePlayServicesNotAvailableException {
        int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)context);
        switch (n) {
            case 0: {
                return;
            }
        }
        throw new GooglePlayServicesNotAvailableException(n);
    }

    private static zzc zzaA(Context context) {
        if (zzy.zzvE()) {
            Log.i((String)zzy.class.getSimpleName(), (String)"Making Creator statically");
            Class<?> clazz = zzy.zzvF();
            return (zzc)zzy.zzc(clazz);
        }
        Log.i((String)zzy.class.getSimpleName(), (String)"Making Creator dynamically");
        IBinder iBinder = (IBinder)zzy.zza(zzy.getRemoteContext(context).getClassLoader(), "com.google.android.gms.maps.internal.CreatorImpl");
        return zzc.zza.zzcg(iBinder);
    }

    private static Context getRemoteContext(Context context) {
        if (zzaCM == null) {
            zzaCM = zzy.zzvE() ? context.getApplicationContext() : GooglePlayServicesUtil.getRemoteContext((Context)context);
        }
        return zzaCM;
    }

    private static <T> T zza(ClassLoader classLoader, String string) {
        try {
            return zzy.zzc(((ClassLoader)zzu.zzu((Object)classLoader)).loadClass(string));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException("Unable to find dynamic class " + string);
        }
    }

    private static <T> T zzc(Class<?> clazz) {
        try {
            return (T)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalStateException("Unable to instantiate the dynamic class " + clazz.getName());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException("Unable to call the default constructor of " + clazz.getName());
        }
    }
}

