/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.location.Location;
import android.os.Looper;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.common.internal.zze;
import com.google.android.gms.common.internal.zzi;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.location.GeofencingRequest;
import com.google.android.gms.location.LocationAvailability;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationSettingsRequest;
import com.google.android.gms.location.LocationSettingsResult;
import com.google.android.gms.location.LocationStatusCodes;
import com.google.android.gms.location.copresence.internal.CopresenceApiOptions;
import com.google.android.gms.location.internal.LocationRequestInternal;
import com.google.android.gms.location.internal.zzf;
import com.google.android.gms.location.internal.zzg;
import com.google.android.gms.location.internal.zzh;
import com.google.android.gms.location.internal.zzi;
import com.google.android.gms.location.zze;
import java.util.List;

public class zzj
extends com.google.android.gms.location.internal.zzb {
    private final zzi zzayR;
    private final com.google.android.gms.location.copresence.internal.zzb zzayS;

    public zzj(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, String string) {
        this(context, looper, connectionCallbacks, onConnectionFailedListener, string, new GoogleApiClient.Builder(context).zzmx());
    }

    public zzj(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, String string, zze zze2) {
        this(context, looper, connectionCallbacks, onConnectionFailedListener, string, zze2, CopresenceApiOptions.zzayn);
    }

    public zzj(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, String string, zze zze2, CopresenceApiOptions copresenceApiOptions) {
        super(context, looper, connectionCallbacks, onConnectionFailedListener, string, zze2);
        this.zzayR = new zzi(context, this.zzayq);
        this.zzayS = com.google.android.gms.location.copresence.internal.zzb.zza(context, zze2.getAccountName(), zze2.zzny(), this.zzayq, copresenceApiOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        zzi zzi2 = this.zzayR;
        synchronized (zzi2) {
            if (this.isConnected()) {
                try {
                    this.zzayR.removeAllListeners();
                    this.zzayR.zzux();
                }
                catch (Exception exception) {
                    Log.e((String)"LocationClientImpl", (String)"Client disconnected before listeners could be cleaned up", (Throwable)exception);
                }
            }
            super.disconnect();
        }
    }

    public boolean requiresAccount() {
        return true;
    }

    public void zza(long l, PendingIntent pendingIntent) throws RemoteException {
        this.zznL();
        zzu.zzu((Object)pendingIntent);
        zzu.zzb((l >= 0L ? 1 : 0) != 0, (Object)"detectionIntervalMillis must be >= 0");
        ((zzg)this.zznM()).zza(l, true, pendingIntent);
    }

    public void zza(PendingIntent pendingIntent) throws RemoteException {
        this.zznL();
        zzu.zzu((Object)pendingIntent);
        ((zzg)this.zznM()).zza(pendingIntent);
    }

    public void zza(GeofencingRequest geofencingRequest, PendingIntent pendingIntent, zze.zza zza2) throws RemoteException {
        this.zznL();
        zzu.zzb((Object)geofencingRequest, (Object)"geofencingRequest can't be null.");
        zzu.zzb((Object)pendingIntent, (Object)"PendingIntent must be specified.");
        zzu.zzb((Object)zza2, (Object)"OnAddGeofencesResultListener not provided.");
        zzb zzb2 = zza2 == null ? null : new zzb(zza2, this);
        ((zzg)this.zznM()).zza(geofencingRequest, pendingIntent, zzb2);
    }

    public void zza(PendingIntent pendingIntent, zze.zzb zzb2) throws RemoteException {
        this.zznL();
        zzu.zzb((Object)pendingIntent, (Object)"PendingIntent must be specified.");
        zzu.zzb((Object)zzb2, (Object)"OnRemoveGeofencesResultListener not provided.");
        zzb zzb3 = zzb2 == null ? null : new zzb(zzb2, this);
        ((zzg)this.zznM()).zza(pendingIntent, (zzf)zzb3, this.getContext().getPackageName());
    }

    public void zza(List<String> list, zze.zzb zzb2) throws RemoteException {
        this.zznL();
        zzu.zzb((list != null && list.size() > 0 ? 1 : 0) != 0, (Object)"geofenceRequestIds can't be null nor empty.");
        zzu.zzb((Object)zzb2, (Object)"OnRemoveGeofencesResultListener not provided.");
        String[] stringArray = list.toArray(new String[0]);
        zzb zzb3 = zzb2 == null ? null : new zzb(zzb2, this);
        ((zzg)this.zznM()).zza(stringArray, (zzf)zzb3, this.getContext().getPackageName());
    }

    public Location getLastLocation() {
        return this.zzayR.getLastLocation();
    }

    public LocationAvailability zzuw() {
        return this.zzayR.zzuw();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(LocationRequestInternal locationRequestInternal, LocationCallback locationCallback, Looper looper) throws RemoteException {
        zzi zzi2 = this.zzayR;
        synchronized (zzi2) {
            this.zzayR.zza(locationRequestInternal, locationCallback, looper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(LocationRequest locationRequest, LocationListener locationListener, Looper looper) throws RemoteException {
        zzi zzi2 = this.zzayR;
        synchronized (zzi2) {
            this.zzayR.zza(locationRequest, locationListener, looper);
        }
    }

    public void zzb(LocationRequest locationRequest, PendingIntent pendingIntent) throws RemoteException {
        this.zzayR.zzb(locationRequest, pendingIntent);
    }

    public void zza(LocationListener locationListener) throws RemoteException {
        this.zzayR.zza(locationListener);
    }

    public void zzd(PendingIntent pendingIntent) throws RemoteException {
        this.zzayR.zzd(pendingIntent);
    }

    public void zza(LocationCallback locationCallback) throws RemoteException {
        this.zzayR.zza(locationCallback);
    }

    public void zzac(boolean bl) throws RemoteException {
        this.zzayR.zzac(bl);
    }

    public void zzb(Location location) throws RemoteException {
        this.zzayR.zzb(location);
    }

    public void zza(LocationSettingsRequest locationSettingsRequest, zza.zzb<LocationSettingsResult> zzb2, String string) throws RemoteException {
        this.zznL();
        zzu.zzb((locationSettingsRequest != null ? 1 : 0) != 0, (Object)"locationSettingsRequest can't be null nor empty.");
        zzu.zzb((zzb2 != null ? 1 : 0) != 0, (Object)"listener can't be null.");
        zzd zzd2 = new zzd(zzb2);
        ((zzg)this.zznM()).zza(locationSettingsRequest, zzd2, string);
    }

    private final class zzc
    extends zzi.zzc<zze.zzb> {
        private final int zzTS;
        private final String[] zzayT;
        private final PendingIntent mPendingIntent;
        private final int zzayY;

        public zzc(int n, zze.zzb zzb2, int n2, String[] stringArray) {
            super((com.google.android.gms.common.internal.zzi)zzj.this, (Object)zzb2);
            com.google.android.gms.common.internal.zzb.zzU((n == 2 ? 1 : 0) != 0);
            this.zzayY = n;
            this.zzTS = LocationStatusCodes.zzgA(n2);
            this.zzayT = stringArray;
            this.mPendingIntent = null;
        }

        public zzc(int n, zze.zzb zzb2, int n2, PendingIntent pendingIntent) {
            super((com.google.android.gms.common.internal.zzi)zzj.this, (Object)zzb2);
            com.google.android.gms.common.internal.zzb.zzU((n == 1 ? 1 : 0) != 0);
            this.zzayY = n;
            this.zzTS = LocationStatusCodes.zzgA(n2);
            this.mPendingIntent = pendingIntent;
            this.zzayT = null;
        }

        protected void zza(zze.zzb zzb2) {
            if (zzb2 != null) {
                switch (this.zzayY) {
                    case 1: {
                        zzb2.zza(this.zzTS, this.mPendingIntent);
                        break;
                    }
                    case 2: {
                        zzb2.zzb(this.zzTS, this.zzayT);
                        break;
                    }
                    default: {
                        Log.wtf((String)"LocationClientImpl", (String)("Unsupported action: " + this.zzayY));
                    }
                }
            }
        }

        protected void zznP() {
        }

        protected /* synthetic */ void zzr(Object object) {
            this.zza((zze.zzb)object);
        }
    }

    private final class zza
    extends zzi.zzc<zze.zza> {
        private final int zzTS;
        private final String[] zzayT;

        public zza(zze.zza zza2, int n, String[] stringArray) {
            super((com.google.android.gms.common.internal.zzi)zzj.this, (Object)zza2);
            this.zzTS = LocationStatusCodes.zzgA(n);
            this.zzayT = stringArray;
        }

        protected void zza(zze.zza zza2) {
            if (zza2 != null) {
                zza2.zza(this.zzTS, this.zzayT);
            }
        }

        protected void zznP() {
        }

        protected /* synthetic */ void zzr(Object object) {
            this.zza((zze.zza)object);
        }
    }

    private static final class zzd
    extends zzh.zza {
        private zza.zzb<LocationSettingsResult> zzayZ;

        public zzd(zza.zzb<LocationSettingsResult> zzb2) {
            zzu.zzb((zzb2 != null ? 1 : 0) != 0, (Object)"listener can't be null.");
            this.zzayZ = zzb2;
        }

        @Override
        public void zza(LocationSettingsResult locationSettingsResult) throws RemoteException {
            this.zzayZ.zzm((Object)locationSettingsResult);
            this.zzayZ = null;
        }
    }

    private static final class zzb
    extends zzf.zza {
        private zze.zza zzayV;
        private zze.zzb zzayW;
        private zzj zzayX;

        public zzb(zze.zza zza2, zzj zzj2) {
            this.zzayV = zza2;
            this.zzayW = null;
            this.zzayX = zzj2;
        }

        public zzb(zze.zzb zzb2, zzj zzj2) {
            this.zzayW = zzb2;
            this.zzayV = null;
            this.zzayX = zzj2;
        }

        @Override
        public void zza(int n, String[] stringArray) throws RemoteException {
            if (this.zzayX == null) {
                Log.wtf((String)"LocationClientImpl", (String)"onAddGeofenceResult called multiple times");
                return;
            }
            zzj zzj2 = this.zzayX;
            ((Object)((Object)zzj2)).getClass();
            this.zzayX.zza(zzj2.new zza(this.zzayV, n, stringArray));
            this.zzayX = null;
            this.zzayV = null;
            this.zzayW = null;
        }

        @Override
        public void zzb(int n, String[] stringArray) {
            if (this.zzayX == null) {
                Log.wtf((String)"LocationClientImpl", (String)"onRemoveGeofencesByRequestIdsResult called multiple times");
                return;
            }
            zzj zzj2 = this.zzayX;
            ((Object)((Object)zzj2)).getClass();
            this.zzayX.zza(zzj2.new zzc(2, this.zzayW, n, stringArray));
            this.zzayX = null;
            this.zzayV = null;
            this.zzayW = null;
        }

        @Override
        public void zza(int n, PendingIntent pendingIntent) {
            if (this.zzayX == null) {
                Log.wtf((String)"LocationClientImpl", (String)"onRemoveGeofencesByPendingIntentResult called multiple times");
                return;
            }
            zzj zzj2 = this.zzayX;
            ((Object)((Object)zzj2)).getClass();
            this.zzayX.zza(zzj2.new zzc(1, this.zzayW, n, pendingIntent));
            this.zzayX = null;
            this.zzayV = null;
            this.zzayW = null;
        }
    }
}

