/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.gcm.GcmNetworkManager;
import com.google.android.gms.gcm.GcmTaskService;

public abstract class Task
implements Parcelable {
    public static final int NETWORK_STATE_CONNECTED = 0;
    public static final int NETWORK_STATE_UNMETERED = 1;
    public static final int NETWORK_STATE_ANY = 2;
    private final String zzawf;
    private final String mTag;
    private final boolean zzawg;
    private final boolean zzawh;
    private final int zzawi;
    private final boolean zzawj;
    protected static final long UNINITIALIZED = -1L;

    Task(Builder builder) {
        this.zzawf = builder.gcmTaskService;
        this.mTag = builder.tag;
        this.zzawg = builder.updateCurrent;
        this.zzawh = builder.isPersisted;
        this.zzawi = builder.requiredNetworkState;
        this.zzawj = builder.requiresCharging;
    }

    @Deprecated
    Task(Parcel in) {
        this.zzawf = in.readString();
        this.mTag = in.readString();
        this.zzawg = in.readInt() == 1;
        this.zzawh = in.readInt() == 1;
        this.zzawi = 2;
        this.zzawj = false;
    }

    public void toBundle(Bundle bundle) {
        bundle.putString("tag", this.mTag);
        bundle.putBoolean("update_current", this.zzawg);
        bundle.putBoolean("persisted", this.zzawh);
        bundle.putString("service", this.zzawf);
        bundle.putInt("requiredNetwork", this.zzawi);
        bundle.putBoolean("requiresCharging", this.zzawj);
    }

    public String getServiceName() {
        return this.zzawf;
    }

    public String getTag() {
        return this.mTag;
    }

    public boolean isUpdateCurrent() {
        return this.zzawg;
    }

    public boolean isPersisted() {
        return this.zzawh;
    }

    public int getRequiredNetwork() {
        return this.zzawi;
    }

    public boolean getRequiresCharging() {
        return this.zzawj;
    }

    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeString(this.zzawf);
        parcel.writeString(this.mTag);
        parcel.writeInt(this.zzawg ? 1 : 0);
        parcel.writeInt(this.zzawh ? 1 : 0);
    }

    public int describeContents() {
        return 0;
    }

    public static abstract class Builder {
        protected int requiredNetworkState;
        protected String gcmTaskService;
        protected String tag;
        protected boolean updateCurrent;
        protected boolean isPersisted;
        protected boolean requiresCharging;

        public abstract Builder setService(Class<? extends GcmTaskService> var1);

        public abstract Builder setRequiredNetwork(int var1);

        public abstract Builder setRequiresCharging(boolean var1);

        public abstract Builder setTag(String var1);

        public abstract Builder setUpdateCurrent(boolean var1);

        public abstract Builder setPersisted(boolean var1);

        public abstract Task build();

        protected void checkConditions() {
            zzu.zzb((this.gcmTaskService != null ? 1 : 0) != 0, (Object)"Must provide an endpoint for this task by calling setService(ComponentName).");
            GcmNetworkManager.zzcY(this.tag);
        }
    }
}

