/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.app.Service;
import android.content.Intent;
import android.os.IBinder;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.gcm.PendingCallback;
import com.google.android.gms.gcm.TaskParams;
import com.google.android.gms.gcm.zzb;
import java.util.HashSet;
import java.util.Set;

public abstract class GcmTaskService
extends Service {
    public static final String SERVICE_PERMISSION = "com.google.android.gms.permission.BIND_NETWORK_TASK_SERVICE";
    public static final String SERVICE_ACTION_EXECUTE_TASK = "com.google.android.gms.gcm.ACTION_TASK_READY";
    public static final String SERVICE_ACTION_INITIALIZE = "com.google.android.gms.gcm.SERVICE_ACTION_INITIALIZE";
    private final Set<String> zzavL = new HashSet<String>();
    private int zzavM;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int onStartCommand(Intent intent, int flags, int startId) {
        if (SERVICE_ACTION_EXECUTE_TASK.equals(intent.getAction())) {
            String string = intent.getStringExtra("tag");
            Parcelable parcelable = intent.getParcelableExtra("callback");
            if (parcelable == null || !(parcelable instanceof PendingCallback)) {
                Log.e((String)"GcmTaskService", (String)(this.getPackageName() + " " + string + ": Could not process request, invalid callback."));
                return 2;
            }
            Set<String> set = this.zzavL;
            synchronized (set) {
                this.zzavL.add(string);
                this.stopSelf(this.zzavM);
                this.zzavM = startId;
            }
            new zza(string, ((PendingCallback)parcelable).getIBinder()).start();
        } else if (SERVICE_ACTION_INITIALIZE.equals(intent.getAction())) {
            this.onInitializeTasks();
            Set<String> set = this.zzavL;
            synchronized (set) {
                this.zzavM = startId;
                if (this.zzavL.size() == 0) {
                    this.stopSelf(this.zzavM);
                }
            }
        }
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzdc(String string) {
        Set<String> set = this.zzavL;
        synchronized (set) {
            this.zzavL.remove(string);
            if (this.zzavL.size() == 0) {
                this.stopSelf(this.zzavM);
            }
        }
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    public abstract int onRunTask(TaskParams var1);

    public void onInitializeTasks() {
    }

    private class zza
    extends Thread {
        private final String mTag;
        private final zzb zzavN;

        zza(String string, IBinder iBinder) {
            this.mTag = string;
            this.zzavN = zzb.zza.zzbN(iBinder);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int n = GcmTaskService.this.onRunTask(new TaskParams(this.mTag));
            try {
                this.zzavN.zzgg(n);
            }
            catch (RemoteException remoteException) {
                Log.e((String)"GcmTaskService", (String)("Error reporting result of operation to scheduler for " + this.mTag));
            }
            finally {
                GcmTaskService.this.zzdc(this.mTag);
            }
        }
    }
}

