/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import android.content.IntentSender;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.internal.OpenFileIntentSenderRequest;
import com.google.android.gms.drive.internal.zzak;
import com.google.android.gms.drive.internal.zzs;
import com.google.android.gms.drive.query.Filter;
import com.google.android.gms.drive.query.internal.FilterHolder;
import com.google.android.gms.drive.query.internal.zzg;

public class OpenFileActivityBuilder {
    public static final String EXTRA_RESPONSE_DRIVE_ID = "response_drive_id";
    private String zzadv;
    private String[] zzadw;
    private Filter zzadx;
    private DriveId zzady;

    public OpenFileActivityBuilder setActivityTitle(String title) {
        this.zzadv = (String)zzu.zzu((Object)title);
        return this;
    }

    public OpenFileActivityBuilder setMimeType(String[] mimeTypes) {
        zzu.zzb((mimeTypes != null ? 1 : 0) != 0, (Object)"mimeTypes may not be null");
        this.zzadw = mimeTypes;
        return this;
    }

    public OpenFileActivityBuilder setSelectionFilter(Filter filter) {
        zzu.zzb((filter != null ? 1 : 0) != 0, (Object)"filter may not be null");
        zzu.zzb((!zzg.zza(filter) ? 1 : 0) != 0, (Object)"FullTextSearchFilter cannot be used as a selection filter");
        this.zzadx = filter;
        return this;
    }

    public OpenFileActivityBuilder setActivityStartFolder(DriveId folder) {
        this.zzady = (DriveId)zzu.zzu((Object)folder);
        return this;
    }

    public IntentSender build(GoogleApiClient apiClient) {
        zzu.zza((boolean)apiClient.isConnected(), (Object)"Client must be connected");
        if (this.zzadw == null) {
            this.zzadw = new String[0];
        }
        if (this.zzadw.length > 0 && this.zzadx != null) {
            throw new IllegalStateException("Cannot use a selection filter and set mimetypes simultaneously");
        }
        FilterHolder filterHolder = this.zzadx == null ? null : new FilterHolder(this.zzadx);
        try {
            zzak zzak2 = ((zzs)apiClient.zza(Drive.zzNX)).zzpB();
            return zzak2.zza(new OpenFileIntentSenderRequest(this.zzadv, this.zzadw, this.zzady, filterHolder));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Unable to connect Drive Play Service", remoteException);
        }
    }
}

