/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.snapshot;

import android.graphics.Bitmap;
import android.net.Uri;
import com.google.android.gms.common.data.BitmapTeleporter;
import com.google.android.gms.games.snapshot.SnapshotMetadata;
import com.google.android.gms.games.snapshot.SnapshotMetadataChangeEntity;

public abstract class SnapshotMetadataChange {
    public static final SnapshotMetadataChange EMPTY_CHANGE = new SnapshotMetadataChangeEntity();

    protected SnapshotMetadataChange() {
    }

    public abstract String getDescription();

    public abstract Long getPlayedTimeMillis();

    public abstract BitmapTeleporter zztQ();

    public abstract Bitmap getCoverImage();

    public abstract Long getProgressValue();

    public static final class Builder {
        private String zzakM;
        private Long zzavm;
        private Long zzavn;
        private BitmapTeleporter zzavo;
        private Uri zzavp;

        public Builder setDescription(String description) {
            this.zzakM = description;
            return this;
        }

        public Builder setPlayedTimeMillis(long playedTimeMillis) {
            this.zzavm = playedTimeMillis;
            return this;
        }

        public Builder setProgressValue(long progressValue) {
            this.zzavn = progressValue;
            return this;
        }

        public Builder setCoverImage(Bitmap coverImage) {
            this.zzavo = new BitmapTeleporter(coverImage);
            this.zzavp = null;
            return this;
        }

        public Builder fromMetadata(SnapshotMetadata metadata) {
            this.zzakM = metadata.getDescription();
            this.zzavm = metadata.getPlayedTime();
            this.zzavn = metadata.getProgressValue();
            if (this.zzavm == -1L) {
                this.zzavm = null;
            }
            this.zzavp = metadata.getCoverImageUri();
            if (this.zzavp != null) {
                this.zzavo = null;
            }
            return this;
        }

        public SnapshotMetadataChange build() {
            return new SnapshotMetadataChangeEntity(this.zzakM, this.zzavm, this.zzavo, this.zzavp, this.zzavn);
        }
    }
}

