/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.realtime;

import android.database.CharArrayBuffer;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.RoomEntityCreator;
import com.google.android.gms.internal.zzlc;
import java.util.ArrayList;

public final class RoomEntity
extends GamesDowngradeableSafeParcel
implements Room {
    public static final Parcelable.Creator<RoomEntity> CREATOR = new RoomEntityCreatorCompat();
    private final int zzCY;
    private final String zzapn;
    private final String zzauA;
    private final long zzaue;
    private final int zzauB;
    private final String zzakM;
    private final int zzaui;
    private final Bundle zzauy;
    private final ArrayList<ParticipantEntity> zzauh;
    private final int zzauC;

    public RoomEntity(Room room) {
        this.zzCY = 2;
        this.zzapn = room.getRoomId();
        this.zzauA = room.getCreatorId();
        this.zzaue = room.getCreationTimestamp();
        this.zzauB = room.getStatus();
        this.zzakM = room.getDescription();
        this.zzaui = room.getVariant();
        this.zzauy = room.getAutoMatchCriteria();
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        this.zzauh = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzauh.add((ParticipantEntity)((Participant)arrayList.get(i)).freeze());
        }
        this.zzauC = room.getAutoMatchWaitEstimateSeconds();
    }

    RoomEntity(int versionCode, String roomId, String creatorId, long creationTimestamp, int roomStatus, String description, int variant, Bundle autoMatchCriteria, ArrayList<ParticipantEntity> participants, int autoMatchWaitEstimateSeconds) {
        this.zzCY = versionCode;
        this.zzapn = roomId;
        this.zzauA = creatorId;
        this.zzaue = creationTimestamp;
        this.zzauB = roomStatus;
        this.zzakM = description;
        this.zzaui = variant;
        this.zzauy = autoMatchCriteria;
        this.zzauh = participants;
        this.zzauC = autoMatchWaitEstimateSeconds;
    }

    public int getVersionCode() {
        return this.zzCY;
    }

    @Override
    public String getRoomId() {
        return this.zzapn;
    }

    @Override
    public String getCreatorId() {
        return this.zzauA;
    }

    @Override
    public long getCreationTimestamp() {
        return this.zzaue;
    }

    @Override
    public int getStatus() {
        return this.zzauB;
    }

    @Override
    public String getDescription() {
        return this.zzakM;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        zzlc.zzb((String)this.zzakM, (CharArrayBuffer)dataOut);
    }

    @Override
    public int getVariant() {
        return this.zzaui;
    }

    @Override
    public Bundle getAutoMatchCriteria() {
        return this.zzauy;
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.zzauh);
    }

    @Override
    public int getAutoMatchWaitEstimateSeconds() {
        return this.zzauC;
    }

    @Override
    public int getParticipantStatus(String participantId) {
        return RoomEntity.zza((Room)this, participantId);
    }

    @Override
    public ArrayList<String> getParticipantIds() {
        return RoomEntity.zzc(this);
    }

    @Override
    public String getParticipantId(String playerId) {
        return RoomEntity.zzb(this, playerId);
    }

    @Override
    public Participant getParticipant(String participantId) {
        return RoomEntity.zzc(this, participantId);
    }

    public Room freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return RoomEntity.zza(this);
    }

    static int zza(Room room) {
        return zzt.hashCode((Object[])new Object[]{room.getRoomId(), room.getCreatorId(), room.getCreationTimestamp(), room.getStatus(), room.getDescription(), room.getVariant(), room.getAutoMatchCriteria(), room.getParticipants(), room.getAutoMatchWaitEstimateSeconds()});
    }

    public boolean equals(Object obj) {
        return RoomEntity.zza((Room)this, obj);
    }

    static boolean zza(Room room, Object object) {
        if (!(object instanceof Room)) {
            return false;
        }
        if (room == object) {
            return true;
        }
        Room room2 = (Room)object;
        return zzt.equal((Object)room2.getRoomId(), (Object)room.getRoomId()) && zzt.equal((Object)room2.getCreatorId(), (Object)room.getCreatorId()) && zzt.equal((Object)room2.getCreationTimestamp(), (Object)room.getCreationTimestamp()) && zzt.equal((Object)room2.getStatus(), (Object)room.getStatus()) && zzt.equal((Object)room2.getDescription(), (Object)room.getDescription()) && zzt.equal((Object)room2.getVariant(), (Object)room.getVariant()) && zzt.equal((Object)room2.getAutoMatchCriteria(), (Object)room.getAutoMatchCriteria()) && zzt.equal((Object)room2.getParticipants(), (Object)room.getParticipants()) && zzt.equal((Object)room2.getAutoMatchWaitEstimateSeconds(), (Object)room.getAutoMatchWaitEstimateSeconds());
    }

    public String toString() {
        return RoomEntity.zzb(this);
    }

    static String zzb(Room room) {
        return zzt.zzt((Object)room).zzg("RoomId", (Object)room.getRoomId()).zzg("CreatorId", (Object)room.getCreatorId()).zzg("CreationTimestamp", (Object)room.getCreationTimestamp()).zzg("RoomStatus", (Object)room.getStatus()).zzg("Description", (Object)room.getDescription()).zzg("Variant", (Object)room.getVariant()).zzg("AutoMatchCriteria", (Object)room.getAutoMatchCriteria()).zzg("Participants", (Object)room.getParticipants()).zzg("AutoMatchWaitEstimateSeconds", (Object)room.getAutoMatchWaitEstimateSeconds()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.zznF()) {
            RoomEntityCreator.zza(this, dest, flags);
        } else {
            dest.writeString(this.zzapn);
            dest.writeString(this.zzauA);
            dest.writeLong(this.zzaue);
            dest.writeInt(this.zzauB);
            dest.writeString(this.zzakM);
            dest.writeInt(this.zzaui);
            dest.writeBundle(this.zzauy);
            int n = this.zzauh.size();
            dest.writeInt(n);
            for (int i = 0; i < n; ++i) {
                this.zzauh.get(i).writeToParcel(dest, flags);
            }
        }
    }

    static int zza(Room room, String string) {
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant.getStatus();
        }
        throw new IllegalStateException("Participant " + string + " is not in room " + room.getRoomId());
    }

    static ArrayList<String> zzc(Room room) {
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        ArrayList<String> arrayList2 = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            arrayList2.add(participant.getParticipantId());
        }
        return arrayList2;
    }

    static String zzb(Room room, String string) {
        String string2 = null;
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            Player player = participant.getPlayer();
            if (player == null || !player.getPlayerId().equals(string)) continue;
            string2 = participant.getParticipantId();
            break;
        }
        return string2;
    }

    static Participant zzc(Room room, String string) {
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant;
        }
        throw new IllegalStateException("Participant " + string + " is not in match " + room.getRoomId());
    }

    static final class RoomEntityCreatorCompat
    extends RoomEntityCreator {
        RoomEntityCreatorCompat() {
        }

        @Override
        public RoomEntity zzdM(Parcel parcel) {
            int n;
            boolean bl = RoomEntity.zzd(RoomEntity.zznE());
            if (bl || RoomEntity.zzca((String)RoomEntity.class.getCanonicalName())) {
                return super.zzdM(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            long l = parcel.readLong();
            int n2 = parcel.readInt();
            String string3 = parcel.readString();
            int n3 = parcel.readInt();
            Bundle bundle = parcel.readBundle();
            int n4 = parcel.readInt();
            ArrayList<ParticipantEntity> arrayList = new ArrayList<ParticipantEntity>(n4);
            for (n = 0; n < n4; ++n) {
                arrayList.add((ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel));
            }
            n = -1;
            return new RoomEntity(2, string, string2, l, n2, string3, n3, bundle, arrayList, n);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.zzdM(x0);
        }
    }
}

