/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.internal.zzlc;

public final class LeaderboardScoreEntity
implements LeaderboardScore {
    private final long zzatD;
    private final String zzatE;
    private final String zzatF;
    private final long zzatG;
    private final long zzatH;
    private final String zzatI;
    private final Uri zzatJ;
    private final Uri zzatK;
    private final PlayerEntity zzatL;
    private final String zzatM;
    private final String zzatN;
    private final String zzatO;

    public LeaderboardScoreEntity(LeaderboardScore score) {
        this.zzatD = score.getRank();
        this.zzatE = (String)zzu.zzu((Object)score.getDisplayRank());
        this.zzatF = (String)zzu.zzu((Object)score.getDisplayScore());
        this.zzatG = score.getRawScore();
        this.zzatH = score.getTimestampMillis();
        this.zzatI = score.getScoreHolderDisplayName();
        this.zzatJ = score.getScoreHolderIconImageUri();
        this.zzatK = score.getScoreHolderHiResImageUri();
        Player player = score.getScoreHolder();
        this.zzatL = player == null ? null : (PlayerEntity)player.freeze();
        this.zzatM = score.getScoreTag();
        this.zzatN = score.getScoreHolderIconImageUrl();
        this.zzatO = score.getScoreHolderHiResImageUrl();
    }

    @Override
    public long getRank() {
        return this.zzatD;
    }

    @Override
    public String getDisplayRank() {
        return this.zzatE;
    }

    @Override
    public void getDisplayRank(CharArrayBuffer dataOut) {
        zzlc.zzb((String)this.zzatE, (CharArrayBuffer)dataOut);
    }

    @Override
    public String getDisplayScore() {
        return this.zzatF;
    }

    @Override
    public void getDisplayScore(CharArrayBuffer dataOut) {
        zzlc.zzb((String)this.zzatF, (CharArrayBuffer)dataOut);
    }

    @Override
    public long getRawScore() {
        return this.zzatG;
    }

    @Override
    public long getTimestampMillis() {
        return this.zzatH;
    }

    @Override
    public String getScoreHolderDisplayName() {
        if (this.zzatL == null) {
            return this.zzatI;
        }
        return this.zzatL.getDisplayName();
    }

    @Override
    public void getScoreHolderDisplayName(CharArrayBuffer dataOut) {
        if (this.zzatL == null) {
            zzlc.zzb((String)this.zzatI, (CharArrayBuffer)dataOut);
            return;
        }
        this.zzatL.getDisplayName(dataOut);
    }

    @Override
    public Uri getScoreHolderIconImageUri() {
        if (this.zzatL == null) {
            return this.zzatJ;
        }
        return this.zzatL.getIconImageUri();
    }

    @Override
    public String getScoreHolderIconImageUrl() {
        if (this.zzatL == null) {
            return this.zzatN;
        }
        return this.zzatL.getIconImageUrl();
    }

    @Override
    public Uri getScoreHolderHiResImageUri() {
        if (this.zzatL == null) {
            return this.zzatK;
        }
        return this.zzatL.getHiResImageUri();
    }

    @Override
    public String getScoreHolderHiResImageUrl() {
        if (this.zzatL == null) {
            return this.zzatO;
        }
        return this.zzatL.getHiResImageUrl();
    }

    @Override
    public Player getScoreHolder() {
        return this.zzatL;
    }

    @Override
    public String getScoreTag() {
        return this.zzatM;
    }

    public LeaderboardScore zztG() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return LeaderboardScoreEntity.zza(this);
    }

    static int zza(LeaderboardScore leaderboardScore) {
        return zzt.hashCode((Object[])new Object[]{leaderboardScore.getRank(), leaderboardScore.getDisplayRank(), leaderboardScore.getRawScore(), leaderboardScore.getDisplayScore(), leaderboardScore.getTimestampMillis(), leaderboardScore.getScoreHolderDisplayName(), leaderboardScore.getScoreHolderIconImageUri(), leaderboardScore.getScoreHolderHiResImageUri(), leaderboardScore.getScoreHolder()});
    }

    public boolean equals(Object obj) {
        return LeaderboardScoreEntity.zza(this, obj);
    }

    static boolean zza(LeaderboardScore leaderboardScore, Object object) {
        if (!(object instanceof LeaderboardScore)) {
            return false;
        }
        if (leaderboardScore == object) {
            return true;
        }
        LeaderboardScore leaderboardScore2 = (LeaderboardScore)object;
        return zzt.equal((Object)leaderboardScore2.getRank(), (Object)leaderboardScore.getRank()) && zzt.equal((Object)leaderboardScore2.getDisplayRank(), (Object)leaderboardScore.getDisplayRank()) && zzt.equal((Object)leaderboardScore2.getRawScore(), (Object)leaderboardScore.getRawScore()) && zzt.equal((Object)leaderboardScore2.getDisplayScore(), (Object)leaderboardScore.getDisplayScore()) && zzt.equal((Object)leaderboardScore2.getTimestampMillis(), (Object)leaderboardScore.getTimestampMillis()) && zzt.equal((Object)leaderboardScore2.getScoreHolderDisplayName(), (Object)leaderboardScore.getScoreHolderDisplayName()) && zzt.equal((Object)leaderboardScore2.getScoreHolderIconImageUri(), (Object)leaderboardScore.getScoreHolderIconImageUri()) && zzt.equal((Object)leaderboardScore2.getScoreHolderHiResImageUri(), (Object)leaderboardScore.getScoreHolderHiResImageUri()) && zzt.equal((Object)leaderboardScore2.getScoreHolder(), (Object)leaderboardScore.getScoreHolder()) && zzt.equal((Object)leaderboardScore2.getScoreTag(), (Object)leaderboardScore.getScoreTag());
    }

    public String toString() {
        return LeaderboardScoreEntity.zzb(this);
    }

    static String zzb(LeaderboardScore leaderboardScore) {
        return zzt.zzt((Object)leaderboardScore).zzg("Rank", (Object)leaderboardScore.getRank()).zzg("DisplayRank", (Object)leaderboardScore.getDisplayRank()).zzg("Score", (Object)leaderboardScore.getRawScore()).zzg("DisplayScore", (Object)leaderboardScore.getDisplayScore()).zzg("Timestamp", (Object)leaderboardScore.getTimestampMillis()).zzg("DisplayName", (Object)leaderboardScore.getScoreHolderDisplayName()).zzg("IconImageUri", (Object)leaderboardScore.getScoreHolderIconImageUri()).zzg("IconImageUrl", (Object)leaderboardScore.getScoreHolderIconImageUrl()).zzg("HiResImageUri", (Object)leaderboardScore.getScoreHolderHiResImageUri()).zzg("HiResImageUrl", (Object)leaderboardScore.getScoreHolderHiResImageUrl()).zzg("Player", (Object)(leaderboardScore.getScoreHolder() == null ? null : leaderboardScore.getScoreHolder())).zzg("ScoreTag", (Object)leaderboardScore.getScoreTag()).toString();
    }

    public /* synthetic */ Object freeze() {
        return this.zztG();
    }
}

