/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.zzc;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.PlayerLevel;
import com.google.android.gms.games.PlayerLevelInfo;
import com.google.android.gms.games.internal.player.MostRecentGameInfo;
import com.google.android.gms.games.internal.player.MostRecentGameInfoRef;
import com.google.android.gms.games.internal.player.PlayerColumnNames;

public final class PlayerRef
extends zzc
implements Player {
    private final PlayerColumnNames zzanX;
    private final PlayerLevelInfo zzanN;
    private final MostRecentGameInfoRef zzanY;

    public PlayerRef(DataHolder holder, int dataRow) {
        this(holder, dataRow, null);
    }

    public PlayerRef(DataHolder holder, int dataRow, String prefix) {
        super(holder, dataRow);
        this.zzanX = new PlayerColumnNames(prefix);
        this.zzanY = new MostRecentGameInfoRef(holder, dataRow, this.zzanX);
        if (this.zzrM()) {
            PlayerLevel playerLevel;
            int n = this.getInteger(this.zzanX.zzatf);
            int n2 = this.getInteger(this.zzanX.zzati);
            PlayerLevel playerLevel2 = playerLevel = new PlayerLevel(n, this.getLong(this.zzanX.zzatg), this.getLong(this.zzanX.zzath));
            if (n != n2) {
                playerLevel2 = new PlayerLevel(n2, this.getLong(this.zzanX.zzath), this.getLong(this.zzanX.zzatj));
            }
            this.zzanN = new PlayerLevelInfo(this.getLong(this.zzanX.zzate), this.getLong(this.zzanX.zzatk), playerLevel, playerLevel2);
        } else {
            this.zzanN = null;
        }
    }

    @Override
    public String getPlayerId() {
        return this.getString(this.zzanX.zzasV);
    }

    @Override
    public String getDisplayName() {
        return this.getString(this.zzanX.zzasW);
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        this.zza(this.zzanX.zzasW, dataOut);
    }

    @Override
    public boolean zzrJ() {
        return this.getBoolean(this.zzanX.zzatu);
    }

    @Override
    public boolean hasIconImage() {
        return this.getIconImageUri() != null;
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzbW(this.zzanX.zzasX);
    }

    @Override
    public String getIconImageUrl() {
        return this.getString(this.zzanX.zzasY);
    }

    @Override
    public boolean hasHiResImage() {
        return this.getHiResImageUri() != null;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.zzbW(this.zzanX.zzasZ);
    }

    @Override
    public String getHiResImageUrl() {
        return this.getString(this.zzanX.zzata);
    }

    @Override
    public long getRetrievedTimestamp() {
        return this.getLong(this.zzanX.zzatb);
    }

    @Override
    public long getLastPlayedWithTimestamp() {
        if (!this.zzbV(this.zzanX.zzatd) || this.zzbX(this.zzanX.zzatd)) {
            return -1L;
        }
        return this.getLong(this.zzanX.zzatd);
    }

    @Override
    public int zzrK() {
        return this.getInteger(this.zzanX.zzatc);
    }

    @Override
    public boolean isProfileVisible() {
        return this.getBoolean(this.zzanX.zzatn);
    }

    @Override
    public String getTitle() {
        return this.getString(this.zzanX.zzatl);
    }

    @Override
    public void getTitle(CharArrayBuffer dataOut) {
        this.zza(this.zzanX.zzatl, dataOut);
    }

    @Override
    public PlayerLevelInfo getLevelInfo() {
        return this.zzanN;
    }

    @Override
    public MostRecentGameInfo zzrL() {
        if (this.zzbX(this.zzanX.zzato)) {
            return null;
        }
        return this.zzanY;
    }

    public Player freeze() {
        return new PlayerEntity(this);
    }

    public int hashCode() {
        return PlayerEntity.zzb(this);
    }

    public boolean equals(Object obj) {
        return PlayerEntity.zza(this, obj);
    }

    public String toString() {
        return PlayerEntity.zzc(this);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        PlayerEntity playerEntity = (PlayerEntity)this.freeze();
        playerEntity.writeToParcel(dest, flags);
    }

    private boolean zzrM() {
        if (this.zzbX(this.zzanX.zzate)) {
            return false;
        }
        return this.getLong(this.zzanX.zzate) != -1L;
    }
}

