/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.games.PlayerLevelCreator;

public final class PlayerLevel
implements SafeParcelable {
    public static final Parcelable.Creator<PlayerLevel> CREATOR = new PlayerLevelCreator();
    private final int zzCY;
    private final int zzanQ;
    private final long zzanR;
    private final long zzanS;

    public PlayerLevel(int value, long minXp, long maxXp) {
        this(1, value, minXp, maxXp);
    }

    PlayerLevel(int versionCode, int levelNumber, long minXp, long maxXp) {
        zzu.zza((minXp >= 0L ? 1 : 0) != 0, (Object)"Min XP must be positive!");
        zzu.zza((maxXp > minXp ? 1 : 0) != 0, (Object)"Max XP must be more than min XP!");
        this.zzCY = versionCode;
        this.zzanQ = levelNumber;
        this.zzanR = minXp;
        this.zzanS = maxXp;
    }

    public int getVersionCode() {
        return this.zzCY;
    }

    public int getLevelNumber() {
        return this.zzanQ;
    }

    public long getMinXp() {
        return this.zzanR;
    }

    public long getMaxXp() {
        return this.zzanS;
    }

    public int hashCode() {
        return zzt.hashCode((Object[])new Object[]{this.zzanQ, this.zzanR, this.zzanS});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PlayerLevel)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        PlayerLevel playerLevel = (PlayerLevel)obj;
        return zzt.equal((Object)playerLevel.getLevelNumber(), (Object)this.getLevelNumber()) && zzt.equal((Object)playerLevel.getMinXp(), (Object)this.getMinXp()) && zzt.equal((Object)playerLevel.getMaxXp(), (Object)this.getMaxXp());
    }

    public String toString() {
        return zzt.zzt((Object)this).zzg("LevelNumber", (Object)this.getLevelNumber()).zzg("MinXp", (Object)this.getMinXp()).zzg("MaxXp", (Object)this.getMaxXp()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        PlayerLevelCreator.zza(this, out, flags);
    }
}

