/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.Context;
import com.google.android.gms.internal.zzaf;
import com.google.android.gms.internal.zzqf;
import com.google.android.gms.tagmanager.DataLayer;
import com.google.android.gms.tagmanager.zzah;
import com.google.android.gms.tagmanager.zzbg;
import com.google.android.gms.tagmanager.zzbo;
import com.google.android.gms.tagmanager.zzcb;
import com.google.android.gms.tagmanager.zzcp;
import com.google.android.gms.tagmanager.zzdf;
import com.google.android.gms.tagmanager.zzt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Container {
    private final Context mContext;
    private final String zzaKy;
    private final DataLayer zzaKz;
    private zzcp zzaKA;
    private Map<String, FunctionCallMacroCallback> zzaKB = new HashMap<String, FunctionCallMacroCallback>();
    private Map<String, FunctionCallTagCallback> zzaKC = new HashMap<String, FunctionCallTagCallback>();
    private volatile long zzaKD;
    private volatile String zzaKE = "";

    Container(Context context, DataLayer dataLayer, String containerId, long lastRefreshTime, zzqf.zzc resource) {
        this.mContext = context;
        this.zzaKz = dataLayer;
        this.zzaKy = containerId;
        this.zzaKD = lastRefreshTime;
        this.zza(resource);
    }

    Container(Context context, DataLayer dataLayer, String containerId, long lastRefreshTime, zzaf.zzj resource) {
        this.mContext = context;
        this.zzaKz = dataLayer;
        this.zzaKy = containerId;
        this.zzaKD = lastRefreshTime;
        this.zza(resource.zziO);
        if (resource.zziN != null) {
            this.zza(resource.zziN);
        }
    }

    public String getContainerId() {
        return this.zzaKy;
    }

    public boolean getBoolean(String key) {
        zzcp zzcp2 = this.zzyn();
        if (zzcp2 == null) {
            zzbg.zzaz("getBoolean called for closed container.");
            return zzdf.zzzN();
        }
        try {
            return zzdf.zzk(zzcp2.zzeD(key).getObject());
        }
        catch (Exception exception) {
            zzbg.zzaz("Calling getBoolean() threw an exception: " + exception.getMessage() + " Returning default value.");
            return zzdf.zzzN();
        }
    }

    public double getDouble(String key) {
        zzcp zzcp2 = this.zzyn();
        if (zzcp2 == null) {
            zzbg.zzaz("getDouble called for closed container.");
            return zzdf.zzzM();
        }
        try {
            return zzdf.zzj(zzcp2.zzeD(key).getObject());
        }
        catch (Exception exception) {
            zzbg.zzaz("Calling getDouble() threw an exception: " + exception.getMessage() + " Returning default value.");
            return zzdf.zzzM();
        }
    }

    public long getLong(String key) {
        zzcp zzcp2 = this.zzyn();
        if (zzcp2 == null) {
            zzbg.zzaz("getLong called for closed container.");
            return zzdf.zzzL();
        }
        try {
            return zzdf.zzi(zzcp2.zzeD(key).getObject());
        }
        catch (Exception exception) {
            zzbg.zzaz("Calling getLong() threw an exception: " + exception.getMessage() + " Returning default value.");
            return zzdf.zzzL();
        }
    }

    public String getString(String key) {
        zzcp zzcp2 = this.zzyn();
        if (zzcp2 == null) {
            zzbg.zzaz("getString called for closed container.");
            return zzdf.zzzP();
        }
        try {
            return zzdf.zzg(zzcp2.zzeD(key).getObject());
        }
        catch (Exception exception) {
            zzbg.zzaz("Calling getString() threw an exception: " + exception.getMessage() + " Returning default value.");
            return zzdf.zzzP();
        }
    }

    public long getLastRefreshTime() {
        return this.zzaKD;
    }

    public boolean isDefault() {
        return this.getLastRefreshTime() == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFunctionCallMacroCallback(String customMacroName, FunctionCallMacroCallback customMacroCallback) {
        if (customMacroCallback == null) {
            throw new NullPointerException("Macro handler must be non-null");
        }
        Map<String, FunctionCallMacroCallback> map = this.zzaKB;
        synchronized (map) {
            this.zzaKB.put(customMacroName, customMacroCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterFunctionCallMacroCallback(String customMacroName) {
        Map<String, FunctionCallMacroCallback> map = this.zzaKB;
        synchronized (map) {
            this.zzaKB.remove(customMacroName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FunctionCallMacroCallback zzef(String string) {
        Map<String, FunctionCallMacroCallback> map = this.zzaKB;
        synchronized (map) {
            return this.zzaKB.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFunctionCallTagCallback(String customTagName, FunctionCallTagCallback customTagCallback) {
        if (customTagCallback == null) {
            throw new NullPointerException("Tag callback must be non-null");
        }
        Map<String, FunctionCallTagCallback> map = this.zzaKC;
        synchronized (map) {
            this.zzaKC.put(customTagName, customTagCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterFunctionCallTagCallback(String customTagName) {
        Map<String, FunctionCallTagCallback> map = this.zzaKC;
        synchronized (map) {
            this.zzaKC.remove(customTagName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FunctionCallTagCallback zzeg(String string) {
        Map<String, FunctionCallTagCallback> map = this.zzaKC;
        synchronized (map) {
            return this.zzaKC.get(string);
        }
    }

    void zzeh(String string) {
        this.zzyn().zzeh(string);
    }

    String zzym() {
        return this.zzaKE;
    }

    private void zza(zzaf.zzf zzf2) {
        if (zzf2 == null) {
            throw new NullPointerException();
        }
        zzqf.zzc zzc2 = null;
        try {
            zzc2 = zzqf.zzb(zzf2);
        }
        catch (zzqf.zzg zzg2) {
            zzbg.zzaz("Not loading resource: " + (Object)((Object)zzf2) + " because it is invalid: " + zzg2.toString());
            return;
        }
        this.zza(zzc2);
    }

    private void zza(zzaf.zzi[] zziArray) {
        ArrayList<zzaf.zzi> arrayList = new ArrayList<zzaf.zzi>();
        for (zzaf.zzi zzi2 : zziArray) {
            arrayList.add(zzi2);
        }
        this.zzyn().zzs(arrayList);
    }

    private void zza(zzqf.zzc zzc2) {
        this.zzaKE = zzc2.getVersion();
        zzah zzah2 = this.zzei(this.zzaKE);
        zzcp zzcp2 = new zzcp(this.mContext, zzc2, this.zzaKz, new zza(), new zzb(), zzah2);
        this.zza(zzcp2);
        if (this.getBoolean("_gtm.loadEventEnabled")) {
            this.zzaKz.pushEvent("gtm.load", DataLayer.mapOf("gtm.id", this.zzaKy));
        }
    }

    zzah zzei(String string) {
        if (zzcb.zzzf().zzzg().equals((Object)zzcb.zza.zzaMK)) {
            // empty if block
        }
        return new zzbo();
    }

    private synchronized void zza(zzcp zzcp2) {
        this.zzaKA = zzcp2;
    }

    private synchronized zzcp zzyn() {
        return this.zzaKA;
    }

    void release() {
        this.zzaKA = null;
    }

    private class zzb
    implements zzt.zza {
        private zzb() {
        }

        @Override
        public Object zzd(String string, Map<String, Object> map) {
            FunctionCallTagCallback functionCallTagCallback = Container.this.zzeg(string);
            if (functionCallTagCallback != null) {
                functionCallTagCallback.execute(string, map);
            }
            return zzdf.zzzP();
        }
    }

    private class zza
    implements zzt.zza {
        private zza() {
        }

        @Override
        public Object zzd(String string, Map<String, Object> map) {
            FunctionCallMacroCallback functionCallMacroCallback = Container.this.zzef(string);
            return functionCallMacroCallback == null ? null : functionCallMacroCallback.getValue(string, map);
        }
    }

    public static interface FunctionCallTagCallback {
        public void execute(String var1, Map<String, Object> var2);
    }

    public static interface FunctionCallMacroCallback {
        public Object getValue(String var1, Map<String, Object> var2);
    }
}

