/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import com.google.android.gms.internal.zzai;
import com.google.android.gms.internal.zzaj;
import com.google.android.gms.internal.zzap;
import com.google.android.gms.internal.zzaq;
import com.google.android.gms.internal.zzre;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.UUID;

public abstract class zzak
implements zzaj {
    protected MotionEvent zzmR;
    protected DisplayMetrics zzmS;
    protected zzap zzmT;
    private zzaq zzmU;

    protected zzak(Context context, zzap zzap2, zzaq zzaq2) {
        this.zzmT = zzap2;
        this.zzmU = zzaq2;
        try {
            this.zzmS = context.getResources().getDisplayMetrics();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.zzmS = new DisplayMetrics();
            this.zzmS.density = 1.0f;
        }
    }

    protected abstract void zzc(Context var1);

    protected abstract void zzd(Context var1);

    @Override
    public String zzb(Context context) {
        return this.zza(context, null, false);
    }

    @Override
    public String zza(Context context, String string) {
        return this.zza(context, string, true);
    }

    @Override
    public void zza(MotionEvent motionEvent) {
        if (motionEvent.getAction() == 1) {
            if (this.zzmR != null) {
                this.zzmR.recycle();
            }
            this.zzmR = MotionEvent.obtain((MotionEvent)motionEvent);
        }
    }

    @Override
    public void zza(int n, int n2, int n3) {
        if (this.zzmR != null) {
            this.zzmR.recycle();
        }
        this.zzmR = MotionEvent.obtain((long)0L, (long)n3, (int)1, (float)((float)n * this.zzmS.density), (float)((float)n2 * this.zzmS.density), (float)0.0f, (float)0.0f, (int)0, (float)0.0f, (float)0.0f, (int)0, (int)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String zza(Context context, String string, boolean bl) {
        String string2;
        try {
            byte[] byArray;
            zzak zzak2 = this;
            synchronized (zzak2) {
                this.zzS();
                if (bl) {
                    this.zzd(context);
                } else {
                    this.zzc(context);
                }
                byArray = this.zzT();
            }
            string2 = byArray.length == 0 ? Integer.toString(5) : this.zza(byArray, string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            string2 = Integer.toString(7);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = Integer.toString(7);
        }
        catch (IOException iOException) {
            string2 = Integer.toString(3);
        }
        return string2;
    }

    protected void zza(int n, long l) throws IOException {
        this.zzmU.zzb(n, l);
    }

    protected void zza(int n, String string) throws IOException {
        this.zzmU.zzb(n, string);
    }

    private void zzS() {
        this.zzmU.reset();
    }

    private byte[] zzT() throws IOException {
        return this.zzmU.zzac();
    }

    String zza(byte[] byArray, String string) throws NoSuchAlgorithmException, UnsupportedEncodingException, IOException {
        byte[] byArray2;
        Object object;
        if (byArray.length > 239) {
            this.zzS();
            this.zza(20, 1L);
            byArray = this.zzT();
        }
        if (byArray.length < 239) {
            object = new byte[239 - byArray.length];
            new SecureRandom().nextBytes((byte[])object);
            byArray2 = ByteBuffer.allocate(240).put((byte)byArray.length).put(byArray).put((byte[])object).array();
        } else {
            byArray2 = ByteBuffer.allocate(240).put((byte)byArray.length).put(byArray).array();
        }
        object = MessageDigest.getInstance("MD5");
        ((MessageDigest)object).update(byArray2);
        byte[] byArray3 = ((MessageDigest)object).digest();
        byte[] byArray4 = ByteBuffer.allocate(256).put(byArray3).put(byArray2).array();
        byte[] byArray5 = new byte[256];
        new zzai().zzb(byArray4, byArray5);
        if (string != null && string.length() > 0) {
            this.zza(string, byArray5);
        }
        return this.zzmT.zza(byArray5, true);
    }

    void zza(String string, byte[] byArray) throws UnsupportedEncodingException {
        if (string.length() > 32) {
            string = string.substring(0, 32);
        }
        byte[] byArray2 = string.getBytes("UTF-8");
        new zzre(byArray2).zzy(byArray);
    }

    protected String zzk(String string) {
        if (string != null && string.matches("^[a-fA-F0-9]{8}-([a-fA-F0-9]{4}-){3}[a-fA-F0-9]{12}$")) {
            UUID uUID = UUID.fromString(string);
            byte[] byArray = new byte[16];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            byteBuffer.putLong(uUID.getMostSignificantBits());
            byteBuffer.putLong(uUID.getLeastSignificantBits());
            string = this.zzmT.zza(byArray, true);
        }
        return string;
    }
}

