/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.analytics.ecommerce.Product;
import com.google.android.gms.analytics.ecommerce.ProductAction;
import com.google.android.gms.analytics.ecommerce.Promotion;
import com.google.android.gms.analytics.internal.zzab;
import com.google.android.gms.analytics.internal.zzam;
import com.google.android.gms.analytics.internal.zzc;
import com.google.android.gms.analytics.internal.zze;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.analytics.internal.zzh;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.internal.zzim;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zzio;
import com.google.android.gms.internal.zzip;
import com.google.android.gms.internal.zzno;
import com.google.android.gms.internal.zznu;
import com.google.android.gms.internal.zznx;
import com.google.android.gms.internal.zzny;
import com.google.android.gms.internal.zznz;
import com.google.android.gms.internal.zzoa;
import com.google.android.gms.internal.zzob;
import com.google.android.gms.internal.zzoc;
import com.google.android.gms.internal.zzod;
import com.google.android.gms.internal.zzoe;
import com.google.android.gms.internal.zzof;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class zzb
extends zzc
implements zznu {
    private static DecimalFormat zzIk;
    private final zzf zzIa;
    private final String zztd;
    private final Uri zzIl;
    private final boolean zzIm;
    private final boolean zzIn;

    public zzb(zzf zzf2, String string) {
        this(zzf2, string, true, false);
    }

    public zzb(zzf zzf2, String string, boolean bl, boolean bl2) {
        super(zzf2);
        zzu.zzcj((String)string);
        this.zzIa = zzf2;
        this.zztd = string;
        this.zzIm = bl;
        this.zzIn = bl2;
        this.zzIl = zzb.zzaK(this.zztd);
    }

    static Uri zzaK(String string) {
        zzu.zzcj((String)string);
        Uri.Builder builder = new Uri.Builder();
        builder.scheme("uri");
        builder.authority("google-analytics.com");
        builder.path(string);
        return builder.build();
    }

    @Override
    public Uri zzhe() {
        return this.zzIl;
    }

    @Override
    public void zzb(zzno zzno2) {
        zzu.zzu((Object)zzno2);
        zzu.zzb((boolean)zzno2.zzvU(), (Object)"Can't deliver not submitted measurement");
        zzu.zzbZ((String)"deliver should be called on worker thread");
        zzno zzno3 = zzno2.zzvP();
        zzip zzip2 = zzno3.zze(zzip.class);
        if (TextUtils.isEmpty((CharSequence)zzip2.zzhw())) {
            this.zzhQ().zzg(zzb.zzc(zzno3), "Ignoring measurement without type");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)zzip2.getClientId())) {
            this.zzhQ().zzg(zzb.zzc(zzno3), "Ignoring measurement without client id");
            return;
        }
        if (this.zzIa.zzie().getAppOptOut()) {
            return;
        }
        double d = zzip2.zzhB();
        if (zzam.zza(d, zzip2.getClientId())) {
            this.zzb("Sampling enabled. Hit sampled out. sampling rate", d);
            return;
        }
        Map<String, String> map = zzb.zzc(zzno3);
        map.put("v", "1");
        map.put("_v", zze.zzJB);
        map.put("tid", this.zztd);
        if (this.zzIa.zzie().isDryRunEnabled()) {
            String string = zzb.zzz(map);
            this.zzc("Dry run is enabled. GoogleAnalytics would have sent", string);
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        zzam.zzb(hashMap, "uid", zzip2.getUserId());
        zznx zznx2 = zzno2.zzd(zznx.class);
        if (zznx2 != null) {
            zzam.zzb(hashMap, "an", zznx2.zzjL());
            zzam.zzb(hashMap, "aid", zznx2.zzsK());
            zzam.zzb(hashMap, "av", zznx2.zzjN());
            zzam.zzb(hashMap, "aiid", zznx2.zzwi());
        }
        zzh zzh2 = new zzh(0L, zzip2.getClientId(), this.zztd, !TextUtils.isEmpty((CharSequence)zzip2.zzhx()), 0L, hashMap);
        long l = this.zzhl().zza(zzh2);
        map.put("_s", String.valueOf(l));
        zzab zzab2 = new zzab(this.zzhQ(), map, zzno2.zzvS(), true);
        this.zzhl().zza(zzab2);
    }

    public static Map<String, String> zzc(zzno zzno2) {
        zznx zznx2;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        zzim zzim2;
        zzof zzof2;
        zzoe zzoe2;
        zzoc zzoc2;
        zzny zzny2;
        Object object5;
        Object object6;
        Object object7;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        zzio zzio2 = zzno2.zzd(zzio.class);
        if (zzio2 != null) {
            object7 = zzio2.zzhv().entrySet().iterator();
            while (object7.hasNext()) {
                object6 = (Map.Entry)object7.next();
                object5 = zzb.zzh(object6.getValue());
                if (object5 == null) continue;
                hashMap.put((String)object6.getKey(), (String)object5);
            }
        }
        if ((object7 = zzno2.zzd(zzip.class)) != null) {
            zzb.zza(hashMap, "t", ((zzip)object7).zzhw());
            zzb.zza(hashMap, "cid", ((zzip)object7).getClientId());
            zzb.zza(hashMap, "uid", ((zzip)object7).getUserId());
            zzb.zza(hashMap, "sc", ((zzip)object7).zzhz());
            zzb.zza(hashMap, "sf", ((zzip)object7).zzhB());
            zzb.zza(hashMap, "ni", ((zzip)object7).zzhA());
            zzb.zza(hashMap, "adid", ((zzip)object7).zzhx());
            zzb.zza(hashMap, "ate", ((zzip)object7).zzhy());
        }
        if ((object6 = zzno2.zzd(zzod.class)) != null) {
            zzb.zza(hashMap, "cd", ((zzod)object6).zzwB());
            zzb.zza(hashMap, "a", ((zzod)object6).zzbn());
            zzb.zza(hashMap, "dr", ((zzod)object6).zzwE());
        }
        if ((object5 = zzno2.zzd(zzob.class)) != null) {
            zzb.zza(hashMap, "ec", ((zzob)object5).zzwy());
            zzb.zza(hashMap, "ea", ((zzob)object5).getAction());
            zzb.zza(hashMap, "el", ((zzob)object5).getLabel());
            zzb.zza(hashMap, "ev", ((zzob)object5).getValue());
        }
        if ((zzny2 = zzno2.zzd(zzny.class)) != null) {
            zzb.zza(hashMap, "cn", zzny2.getName());
            zzb.zza(hashMap, "cs", zzny2.getSource());
            zzb.zza(hashMap, "cm", zzny2.zzwj());
            zzb.zza(hashMap, "ck", zzny2.zzwk());
            zzb.zza(hashMap, "cc", zzny2.getContent());
            zzb.zza(hashMap, "ci", zzny2.getId());
            zzb.zza(hashMap, "anid", zzny2.zzwl());
            zzb.zza(hashMap, "gclid", zzny2.zzwm());
            zzb.zza(hashMap, "dclid", zzny2.zzwn());
            zzb.zza(hashMap, "aclid", zzny2.zzwo());
        }
        if ((zzoc2 = zzno2.zzd(zzoc.class)) != null) {
            zzb.zza(hashMap, "exd", zzoc2.getDescription());
            zzb.zza(hashMap, "exf", zzoc2.zzwz());
        }
        if ((zzoe2 = zzno2.zzd(zzoe.class)) != null) {
            zzb.zza(hashMap, "sn", zzoe2.zzwI());
            zzb.zza(hashMap, "sa", zzoe2.getAction());
            zzb.zza(hashMap, "st", zzoe2.getTarget());
        }
        if ((zzof2 = zzno2.zzd(zzof.class)) != null) {
            zzb.zza(hashMap, "utv", zzof2.zzwJ());
            zzb.zza(hashMap, "utt", zzof2.getTimeInMillis());
            zzb.zza(hashMap, "utc", zzof2.zzwy());
            zzb.zza(hashMap, "utl", zzof2.getLabel());
        }
        if ((zzim2 = zzno2.zzd(zzim.class)) != null) {
            object4 = zzim2.zzht();
            object3 = object4.entrySet().iterator();
            while (object3.hasNext()) {
                object2 = (Map.Entry)object3.next();
                object = com.google.android.gms.analytics.zzc.zzO((Integer)object2.getKey());
                if (TextUtils.isEmpty((CharSequence)object)) continue;
                hashMap.put((String)object, (String)object2.getValue());
            }
        }
        if ((object4 = zzno2.zzd(zzin.class)) != null) {
            object3 = ((zzin)object4).zzhu();
            object2 = object3.entrySet().iterator();
            while (object2.hasNext()) {
                object = (Map.Entry)object2.next();
                Map.Entry<String, String> entry = com.google.android.gms.analytics.zzc.zzQ((Integer)object.getKey());
                if (TextUtils.isEmpty((CharSequence)((Object)entry))) continue;
                String entry2 = zzb.zza((Double)object.getValue());
                hashMap.put((String)((Object)entry), entry2);
            }
        }
        if ((object3 = zzno2.zzd(zzoa.class)) != null) {
            object2 = ((zzoa)object3).zzwu();
            if (object2 != null) {
                for (Map.Entry<String, String> entry : ((ProductAction)object2).build().entrySet()) {
                    if (entry.getKey().startsWith("&")) {
                        hashMap.put(((String)entry.getKey()).substring(1), (String)entry.getValue());
                        continue;
                    }
                    hashMap.put((String)entry.getKey(), (String)entry.getValue());
                }
            }
            int n = 1;
            for (Promotion promotion : ((zzoa)object3).zzwx()) {
                hashMap.putAll(promotion.zzaQ(com.google.android.gms.analytics.zzc.zzU(n)));
                ++n;
            }
            n = 1;
            for (Product product : ((zzoa)object3).zzwv()) {
                hashMap.putAll(product.zzaQ(com.google.android.gms.analytics.zzc.zzS(n)));
                ++n;
            }
            n = 1;
            for (Map.Entry<String, List<Product>> entry : ((zzoa)object3).zzww().entrySet()) {
                List<Product> list = entry.getValue();
                String string = com.google.android.gms.analytics.zzc.zzX(n);
                int n2 = 1;
                for (Product product : list) {
                    hashMap.putAll(product.zzaQ(string + com.google.android.gms.analytics.zzc.zzV(n2)));
                    ++n2;
                }
                if (!TextUtils.isEmpty((CharSequence)entry.getKey())) {
                    hashMap.put(string + "nm", entry.getKey());
                }
                ++n;
            }
        }
        if ((object2 = zzno2.zzd(zznz.class)) != null) {
            zzb.zza(hashMap, "ul", ((zznz)object2).getLanguage());
            zzb.zza(hashMap, "sd", ((zznz)object2).zzwp());
            zzb.zza(hashMap, "sr", ((zznz)object2).zzwq(), ((zznz)object2).zzwr());
            zzb.zza(hashMap, "vp", ((zznz)object2).zzws(), ((zznz)object2).zzwt());
        }
        if ((zznx2 = zzno2.zzd(zznx.class)) != null) {
            zzb.zza(hashMap, "an", zznx2.zzjL());
            zzb.zza(hashMap, "aid", zznx2.zzsK());
            zzb.zza(hashMap, "aiid", zznx2.zzwi());
            zzb.zza(hashMap, "av", zznx2.zzjN());
        }
        return hashMap;
    }

    private static void zza(Map<String, String> map, String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            map.put(string, string2);
        }
    }

    static String zza(double d) {
        if (zzIk == null) {
            zzIk = new DecimalFormat("0.######");
        }
        return zzIk.format(d);
    }

    private static void zza(Map<String, String> map, String string, double d) {
        if (d != 0.0) {
            map.put(string, zzb.zza(d));
        }
    }

    private static void zza(Map<String, String> map, String string, boolean bl) {
        if (bl) {
            map.put(string, "1");
        }
    }

    private static void zza(Map<String, String> map, String string, int n, int n2) {
        if (n > 0 && n2 > 0) {
            map.put(string, n + "x" + n2);
        }
    }

    private static String zzz(Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(entry.getKey());
            stringBuilder.append("=");
            stringBuilder.append(entry.getValue());
        }
        return stringBuilder.toString();
    }

    private static String zzh(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            String string = (String)object;
            if (!TextUtils.isEmpty((CharSequence)string)) {
                return string;
            }
            return null;
        }
        if (object instanceof Double) {
            Double d = (Double)object;
            if (d != 0.0) {
                return zzb.zza(d);
            }
            return null;
        }
        if (object instanceof Boolean) {
            if (object != Boolean.FALSE) {
                return "1";
            }
            return null;
        }
        return String.valueOf(object);
    }
}

