/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics.internal;

import android.content.Context;
import android.text.TextUtils;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.analytics.internal.zzaj;
import com.google.android.gms.analytics.internal.zzam;
import com.google.android.gms.analytics.internal.zzd;
import com.google.android.gms.analytics.internal.zzf;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Locale;

public class zza
extends zzd {
    public static boolean zzJk;
    private AdvertisingIdClient.Info zzJl;
    private final zzaj zzJm;
    private String zzJn;
    private boolean zzJo = false;
    private Object zzJp = new Object();

    zza(zzf zzf2) {
        super(zzf2);
        this.zzJm = new zzaj(zzf2.zzhP());
    }

    @Override
    protected void zzhn() {
    }

    public boolean zzhy() {
        this.zzia();
        AdvertisingIdClient.Info info = this.zzhD();
        if (info != null) {
            return !info.isLimitAdTrackingEnabled();
        }
        return false;
    }

    public String zzhC() {
        this.zzia();
        AdvertisingIdClient.Info info = this.zzhD();
        String string = null;
        if (info != null) {
            string = info.getId();
        }
        if (TextUtils.isEmpty(string)) {
            return null;
        }
        return string;
    }

    private synchronized AdvertisingIdClient.Info zzhD() {
        if (this.zzJm.zzv(1000L)) {
            this.zzJm.start();
            AdvertisingIdClient.Info info = this.zzhE();
            if (this.zza(this.zzJl, info)) {
                this.zzJl = info;
            } else {
                this.zzaX("Failed to reset client id on adid change. Not using adid");
                this.zzJl = new AdvertisingIdClient.Info("", false);
            }
        }
        return this.zzJl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zza(AdvertisingIdClient.Info info, AdvertisingIdClient.Info info2) {
        String string;
        String string2 = string = info2 == null ? null : info2.getId();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return true;
        }
        String string3 = this.zzhV().zziP();
        Object object = this.zzJp;
        synchronized (object) {
            String string4;
            if (!this.zzJo) {
                this.zzJn = this.zzhF();
                this.zzJo = true;
            } else if (TextUtils.isEmpty((CharSequence)this.zzJn)) {
                String string5 = string4 = info == null ? null : info.getId();
                if (string4 == null) {
                    return this.zzaS(string + string3);
                }
                this.zzJn = zza.zzaR(string4 + string3);
            }
            string4 = zza.zzaR(string + string3);
            if (TextUtils.isEmpty((CharSequence)string4)) {
                return false;
            }
            if (string4.equals(this.zzJn)) {
                return true;
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzJn)) {
                this.zzaT("Resetting the client id because Advertising Id changed.");
                string3 = this.zzhV().zziQ();
                this.zza("New client Id", string3);
            }
            return this.zzaS(string + string3);
        }
    }

    protected AdvertisingIdClient.Info zzhE() {
        AdvertisingIdClient.Info info;
        block3: {
            info = null;
            try {
                info = AdvertisingIdClient.getAdvertisingIdInfo(this.getContext());
            }
            catch (IllegalStateException illegalStateException) {
                this.zzaW("IllegalStateException getting Ad Id Info. If you would like to see Audience reports, please ensure that you have added '<meta-data android:name=\"com.google.android.gms.version\" android:value=\"@integer/google_play_services_version\" />' to your application manifest file. See http://goo.gl/naFqQk for details.");
            }
            catch (Throwable throwable) {
                if (zzJk) break block3;
                zzJk = true;
                this.zzd("Error getting advertiser id", throwable);
            }
        }
        return info;
    }

    private static String zzaR(String string) {
        MessageDigest messageDigest = zzam.zzbl("MD5");
        if (messageDigest == null) {
            return null;
        }
        return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest(string.getBytes())));
    }

    private boolean zzaS(String string) {
        try {
            String string2 = zza.zzaR(string);
            this.zzaT("Storing hashed adid.");
            Context context = this.getContext();
            FileOutputStream fileOutputStream = context.openFileOutput("gaClientIdData", 0);
            fileOutputStream.write(string2.getBytes());
            fileOutputStream.close();
            this.zzJn = string2;
            return true;
        }
        catch (IOException iOException) {
            this.zze("Error creating hash file", iOException);
            return false;
        }
    }

    protected String zzhF() {
        String string = null;
        try {
            FileInputStream fileInputStream = this.getContext().openFileInput("gaClientIdData");
            byte[] byArray = new byte[128];
            int n = fileInputStream.read(byArray, 0, 128);
            if (fileInputStream.available() > 0) {
                this.zzaW("Hash file seems corrupted, deleting it.");
                fileInputStream.close();
                this.getContext().deleteFile("gaClientIdData");
            } else if (n <= 0) {
                this.zzaT("Hash file is empty.");
                fileInputStream.close();
            } else {
                string = new String(byArray, 0, n);
                fileInputStream.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            this.zzd("Error reading Hash file, deleting it", iOException);
            this.getContext().deleteFile("gaClientIdData");
        }
        return string;
    }
}

