/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.fragment;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import com.google.android.gms.R;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.dynamic.zzf;
import com.google.android.gms.dynamic.zzh;
import com.google.android.gms.internal.zzqq;
import com.google.android.gms.internal.zzqr;
import com.google.android.gms.internal.zzqy;
import com.google.android.gms.wallet.MaskedWallet;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.fragment.WalletFragmentInitParams;
import com.google.android.gms.wallet.fragment.WalletFragmentOptions;
import com.google.android.gms.wallet.fragment.WalletFragmentStyle;

public final class SupportWalletFragment
extends Fragment {
    private zzb zzaRO;
    private boolean mCreated = false;
    private final zzh zzaRP = zzh.zza((Fragment)this);
    private final zzc zzaRQ = new zzc();
    private zza zzaRR = new zza(this);
    private final Fragment zzZX = this;
    private WalletFragmentOptions zzaRS;
    private WalletFragmentInitParams zzaRT;
    private MaskedWalletRequest zzaRU;
    private MaskedWallet zzaRV;
    private Boolean zzaRW;

    public static SupportWalletFragment newInstance(WalletFragmentOptions options) {
        SupportWalletFragment supportWalletFragment = new SupportWalletFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("extraWalletFragmentOptions", (Parcelable)options);
        supportWalletFragment.zzZX.setArguments(bundle);
        return supportWalletFragment;
    }

    public void initialize(WalletFragmentInitParams initParams) {
        if (this.zzaRO != null) {
            this.zzaRO.initialize(initParams);
            this.zzaRT = null;
        } else if (this.zzaRT == null) {
            this.zzaRT = initParams;
            if (this.zzaRU != null) {
                Log.w((String)"SupportWalletFragment", (String)"updateMaskedWalletRequest() was called before initialize()");
            }
            if (this.zzaRV != null) {
                Log.w((String)"SupportWalletFragment", (String)"updateMaskedWallet() was called before initialize()");
            }
        } else {
            Log.w((String)"SupportWalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once. Ignoring.");
        }
    }

    public void updateMaskedWalletRequest(MaskedWalletRequest request) {
        if (this.zzaRO != null) {
            this.zzaRO.updateMaskedWalletRequest(request);
            this.zzaRU = null;
        } else {
            this.zzaRU = request;
        }
    }

    public void updateMaskedWallet(MaskedWallet maskedWallet) {
        if (this.zzaRO != null) {
            this.zzaRO.updateMaskedWallet(maskedWallet);
            this.zzaRV = null;
        } else {
            this.zzaRV = maskedWallet;
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.zzaRO != null) {
            this.zzaRO.setEnabled(enabled);
            this.zzaRW = null;
        } else {
            this.zzaRW = enabled;
        }
    }

    public void setOnStateChangedListener(OnStateChangedListener listener) {
        this.zzaRR.zza(listener);
    }

    public int getState() {
        return this.zzaRO != null ? this.zzaRO.getState() : 0;
    }

    public void onInflate(Activity activity, AttributeSet attrs, Bundle savedInstanceState) {
        super.onInflate(activity, attrs, savedInstanceState);
        if (this.zzaRS == null) {
            this.zzaRS = WalletFragmentOptions.zza((Context)activity, attrs);
        }
        Bundle bundle = new Bundle();
        bundle.putParcelable("attrKeyWalletFragmentOptions", (Parcelable)this.zzaRS);
        this.zzaRQ.onInflate(activity, bundle, savedInstanceState);
    }

    public void onCreate(Bundle savedInstanceState) {
        WalletFragmentOptions walletFragmentOptions;
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            savedInstanceState.setClassLoader(WalletFragmentOptions.class.getClassLoader());
            WalletFragmentInitParams walletFragmentInitParams = (WalletFragmentInitParams)savedInstanceState.getParcelable("walletFragmentInitParams");
            if (walletFragmentInitParams != null) {
                if (this.zzaRT != null) {
                    Log.w((String)"SupportWalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once.Ignoring.");
                }
                this.zzaRT = walletFragmentInitParams;
            }
            if (this.zzaRU == null) {
                this.zzaRU = (MaskedWalletRequest)savedInstanceState.getParcelable("maskedWalletRequest");
            }
            if (this.zzaRV == null) {
                this.zzaRV = (MaskedWallet)savedInstanceState.getParcelable("maskedWallet");
            }
            if (savedInstanceState.containsKey("walletFragmentOptions")) {
                this.zzaRS = (WalletFragmentOptions)savedInstanceState.getParcelable("walletFragmentOptions");
            }
            if (savedInstanceState.containsKey("enabled")) {
                this.zzaRW = savedInstanceState.getBoolean("enabled");
            }
        } else if (this.zzZX.getArguments() != null && (walletFragmentOptions = (WalletFragmentOptions)this.zzZX.getArguments().getParcelable("extraWalletFragmentOptions")) != null) {
            walletFragmentOptions.zzaL((Context)this.zzZX.getActivity());
            this.zzaRS = walletFragmentOptions;
        }
        this.mCreated = true;
        this.zzaRQ.onCreate(savedInstanceState);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return this.zzaRQ.onCreateView(inflater, container, savedInstanceState);
    }

    public void onStart() {
        super.onStart();
        this.zzaRQ.onStart();
    }

    public void onResume() {
        super.onResume();
        this.zzaRQ.onResume();
        FragmentManager fragmentManager = this.zzZX.getActivity().getSupportFragmentManager();
        Fragment fragment = fragmentManager.findFragmentByTag("GooglePlayServicesErrorDialog");
        if (fragment != null) {
            fragmentManager.beginTransaction().remove(fragment).commit();
            int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.zzZX.getActivity());
            GooglePlayServicesUtil.showErrorDialogFragment((int)n, (Activity)this.zzZX.getActivity(), (int)-1);
        }
    }

    public void onPause() {
        super.onPause();
        this.zzaRQ.onPause();
    }

    public void onStop() {
        super.onStop();
        this.zzaRQ.onStop();
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.setClassLoader(WalletFragmentOptions.class.getClassLoader());
        this.zzaRQ.onSaveInstanceState(outState);
        if (this.zzaRT != null) {
            outState.putParcelable("walletFragmentInitParams", (Parcelable)this.zzaRT);
            this.zzaRT = null;
        }
        if (this.zzaRU != null) {
            outState.putParcelable("maskedWalletRequest", (Parcelable)this.zzaRU);
            this.zzaRU = null;
        }
        if (this.zzaRV != null) {
            outState.putParcelable("maskedWallet", (Parcelable)this.zzaRV);
            this.zzaRV = null;
        }
        if (this.zzaRS != null) {
            outState.putParcelable("walletFragmentOptions", (Parcelable)this.zzaRS);
            this.zzaRS = null;
        }
        if (this.zzaRW != null) {
            outState.putBoolean("enabled", this.zzaRW.booleanValue());
            this.zzaRW = null;
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.mCreated = false;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (this.zzaRO != null) {
            this.zzaRO.onActivityResult(requestCode, resultCode, data);
        }
    }

    public static interface OnStateChangedListener {
        public void onStateChanged(SupportWalletFragment var1, int var2, int var3, Bundle var4);
    }

    static class zza
    extends zzqr.zza {
        private OnStateChangedListener zzaRX;
        private final SupportWalletFragment zzaRY;

        zza(SupportWalletFragment supportWalletFragment) {
            this.zzaRY = supportWalletFragment;
        }

        @Override
        public void zza(int n, int n2, Bundle bundle) {
            if (this.zzaRX != null) {
                this.zzaRX.onStateChanged(this.zzaRY, n, n2, bundle);
            }
        }

        public void zza(OnStateChangedListener onStateChangedListener) {
            this.zzaRX = onStateChangedListener;
        }
    }

    private static class zzb
    implements LifecycleDelegate {
        private final zzqq zzaRZ;

        private zzb(zzqq zzqq2) {
            this.zzaRZ = zzqq2;
        }

        private void initialize(WalletFragmentInitParams startParams) {
            try {
                this.zzaRZ.initialize(startParams);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void setEnabled(boolean enabled) {
            try {
                this.zzaRZ.setEnabled(enabled);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void updateMaskedWalletRequest(MaskedWalletRequest request) {
            try {
                this.zzaRZ.updateMaskedWalletRequest(request);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void updateMaskedWallet(MaskedWallet maskedWallet) {
            try {
                this.zzaRZ.updateMaskedWallet(maskedWallet);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private int getState() {
            try {
                return this.zzaRZ.getState();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onInflate(Activity activity, Bundle attrs, Bundle savedInstanceState) {
            WalletFragmentOptions walletFragmentOptions = (WalletFragmentOptions)attrs.getParcelable("extraWalletFragmentOptions");
            try {
                this.zzaRZ.zza(zze.zzw((Object)activity), walletFragmentOptions, savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onCreate(Bundle savedInstanceState) {
            try {
                this.zzaRZ.onCreate(savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            try {
                zzd zzd2 = this.zzaRZ.onCreateView(zze.zzw((Object)inflater), zze.zzw((Object)container), savedInstanceState);
                return (View)zze.zzn((zzd)zzd2);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onStart() {
            try {
                this.zzaRZ.onStart();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onResume() {
            try {
                this.zzaRZ.onResume();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onPause() {
            try {
                this.zzaRZ.onPause();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onStop() {
            try {
                this.zzaRZ.onStop();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        public void onDestroyView() {
        }

        public void onDestroy() {
        }

        public void onLowMemory() {
        }

        public void onSaveInstanceState(Bundle outState) {
            try {
                this.zzaRZ.onSaveInstanceState(outState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void onActivityResult(int requestCode, int resultCode, Intent data) {
            try {
                this.zzaRZ.onActivityResult(requestCode, resultCode, data);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }
    }

    private class zzc
    extends com.google.android.gms.dynamic.zza<zzb>
    implements View.OnClickListener {
        private zzc() {
        }

        protected void zza(zzf<zzb> zzf2) {
            FragmentActivity fragmentActivity = SupportWalletFragment.this.zzZX.getActivity();
            if (SupportWalletFragment.this.zzaRO == null && SupportWalletFragment.this.mCreated && fragmentActivity != null) {
                try {
                    zzqq zzqq2 = zzqy.zza((Activity)fragmentActivity, (com.google.android.gms.dynamic.zzc)SupportWalletFragment.this.zzaRP, SupportWalletFragment.this.zzaRS, SupportWalletFragment.this.zzaRR);
                    SupportWalletFragment.this.zzaRO = new zzb(zzqq2);
                    SupportWalletFragment.this.zzaRS = null;
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    return;
                }
                zzf2.zza((LifecycleDelegate)SupportWalletFragment.this.zzaRO);
                if (SupportWalletFragment.this.zzaRT != null) {
                    SupportWalletFragment.this.zzaRO.initialize(SupportWalletFragment.this.zzaRT);
                    SupportWalletFragment.this.zzaRT = null;
                }
                if (SupportWalletFragment.this.zzaRU != null) {
                    SupportWalletFragment.this.zzaRO.updateMaskedWalletRequest(SupportWalletFragment.this.zzaRU);
                    SupportWalletFragment.this.zzaRU = null;
                }
                if (SupportWalletFragment.this.zzaRV != null) {
                    SupportWalletFragment.this.zzaRO.updateMaskedWallet(SupportWalletFragment.this.zzaRV);
                    SupportWalletFragment.this.zzaRV = null;
                }
                if (SupportWalletFragment.this.zzaRW != null) {
                    SupportWalletFragment.this.zzaRO.setEnabled(SupportWalletFragment.this.zzaRW);
                    SupportWalletFragment.this.zzaRW = null;
                }
            }
        }

        protected void zza(FrameLayout frameLayout) {
            WalletFragmentStyle walletFragmentStyle;
            Button button = new Button((Context)SupportWalletFragment.this.zzZX.getActivity());
            button.setText(R.string.wallet_buy_button_place_holder);
            int n = -1;
            int n2 = -2;
            if (SupportWalletFragment.this.zzaRS != null && (walletFragmentStyle = SupportWalletFragment.this.zzaRS.getFragmentStyle()) != null) {
                DisplayMetrics displayMetrics = SupportWalletFragment.this.zzZX.getResources().getDisplayMetrics();
                n = walletFragmentStyle.zza("buyButtonWidth", displayMetrics, n);
                n2 = walletFragmentStyle.zza("buyButtonHeight", displayMetrics, n2);
            }
            button.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            button.setOnClickListener((View.OnClickListener)this);
            frameLayout.addView((View)button);
        }

        public void onClick(View view) {
            FragmentActivity fragmentActivity = SupportWalletFragment.this.zzZX.getActivity();
            int n = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)fragmentActivity);
            GooglePlayServicesUtil.showErrorDialogFragment((int)n, (Activity)fragmentActivity, (int)-1);
        }
    }
}

