#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#include <stdint.h>
#include "wave.h"


uint32_t swap_4_bytes(uint32_t x)
{
    return ((x & 0x000000ff) << 24) |
           ((x & 0x0000ff00) << 8)  |
           ((x & 0x00ff0000) >> 8)  |
           ((x & 0xff000000) >> 24);
}

uint32_t swap_2_bytes(uint32_t x)
{
    return ((x & 0xff)   << 8) |
           ((x & 0xff00) >> 8);
}



unsigned char wave_buffer[0x10000];
int wave_ptr=0;

unsigned char highchunk[]={ 0xff,0xff,0xff };
unsigned char lowchunk[]={ 0,0,0};


void write0()
{
     printf("0");
    if(wave_ptr==0||wave_buffer[wave_ptr-1]<128)
    {
        memcpy(wave_buffer+wave_ptr, highchunk, sizeof(highchunk)); wave_ptr+=sizeof(highchunk);
        memcpy(wave_buffer+wave_ptr, highchunk, sizeof(highchunk)); wave_ptr+=sizeof(highchunk);
    }
    else
    {
        memcpy(wave_buffer+wave_ptr, lowchunk, sizeof(lowchunk)); wave_ptr+=sizeof(lowchunk);
        memcpy(wave_buffer+wave_ptr, lowchunk, sizeof(lowchunk)); wave_ptr+=sizeof(lowchunk);
    }
}
void write1()
{
     printf("1");
    if(wave_ptr==0||wave_buffer[wave_ptr-1]<128)
    {
        memcpy(wave_buffer+wave_ptr, highchunk, sizeof(highchunk)); wave_ptr+=sizeof(highchunk);
        memcpy(wave_buffer+wave_ptr, lowchunk, sizeof(lowchunk)); wave_ptr+=sizeof(lowchunk);
    }
    else
    {
        memcpy(wave_buffer+wave_ptr, lowchunk, sizeof(lowchunk)); wave_ptr+=sizeof(lowchunk);
        memcpy(wave_buffer+wave_ptr, highchunk, sizeof(highchunk)); wave_ptr+=sizeof(highchunk);
    }
}

int main()
{


    //A :
    //B ;
    //C <
    //D =
    //E >
    //F ?        
    char id[]={';', '0', '0', '0', '0', '8', '8', '9', '5', '6', '7', '3', '8', '0', '0', '1', '=', '9', '6', '6', '7', '?', '0'};		
																											
    int parity;
    for(int a=0; a<16; a++) write0(); //write 24 zeros
    for(int a=0; a<sizeof(id); a++)
    {
       parity=0;
       for(int b=0; b<4; b++)
       {
         if((id[a]>>b)%2==0) { write0(); }
         else { write1(); parity++; }
       }
       if(parity%2==0) write1();
       else write0();
       //printf(" ");
    }
    for(int a=0; a<16; a++) write0(); //write 8 zeros
    struct riff_chunk myriff;
    struct fmt_chunk myfmt;   
    myriff.chunk_id[0]='R'; myriff.chunk_id[1]='I'; myriff.chunk_id[2]='F'; myriff.chunk_id[3]='F';
    myriff.file_size=swap_4_bytes(wave_ptr+4+4+sizeof(myriff)+sizeof(myfmt));
    myriff.riff_type[0]='W'; myriff.riff_type[1]='A'; myriff.riff_type[2]='V'; myriff.riff_type[3]='E';
    myfmt.chunk_id[0]='f';  myfmt.chunk_id[1]='m';  myfmt.chunk_id[2]='t';  myfmt.chunk_id[3]=0x20;
    myfmt.chunk_size=swap_4_bytes(0x10);
    myfmt.compression_code=swap_2_bytes(1);
    myfmt.num_channels=swap_2_bytes(1);
    myfmt.sample_rate=swap_4_bytes(8192);
    myfmt.bytes_second=swap_4_bytes(8192);
    myfmt.block_align=swap_2_bytes(1);
    myfmt.bits_sample=swap_2_bytes(8);
    FILE *f=fopen("test.wav","wb");
    fwrite((void *)&myriff, 1, sizeof(myriff), f);
    fwrite((void *)&myfmt, 1, sizeof(myfmt), f);
    char data_chunk_id[]={ 'd', 'a', 't', 'a' }; fwrite(data_chunk_id, 1, sizeof(data_chunk_id), f);
	
	//int* dataSize = &wave_ptr;
	
	uint32_t pointer = swap_4_bytes(wave_ptr);
	
    fwrite(&pointer, 1, sizeof(pointer), f);
    //int a;
    fwrite(wave_buffer, 1, wave_ptr, f);            
    fclose(f);
    printf("\n"); system("PAUSE");
    return 0;
}
