//Magnetic Stripe Encoder
//by geohot

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

unsigned char wave_buffer[0x10000];
int wave_ptr=0;

#include "wave.h"

unsigned char highchunk[]={ 0xff,0xff,0xff,0xff,0xff };
unsigned char lowchunk[]={ 0,0,0,0,0 };


void write0()
{
     printf("0");
    if(wave_ptr==0||wave_buffer[wave_ptr-1]<128)
    {
        memcpy(wave_buffer+wave_ptr, highchunk, sizeof(highchunk)); wave_ptr+=sizeof(highchunk);
        memcpy(wave_buffer+wave_ptr, highchunk, sizeof(highchunk)); wave_ptr+=sizeof(highchunk);
    }
    else
    {
        memcpy(wave_buffer+wave_ptr, lowchunk, sizeof(lowchunk)); wave_ptr+=sizeof(lowchunk);
        memcpy(wave_buffer+wave_ptr, lowchunk, sizeof(lowchunk)); wave_ptr+=sizeof(lowchunk);
    }
}
void write1()
{
     printf("1");
    if(wave_ptr==0||wave_buffer[wave_ptr-1]<128)
    {
        memcpy(wave_buffer+wave_ptr, highchunk, sizeof(highchunk)); wave_ptr+=sizeof(highchunk);
        memcpy(wave_buffer+wave_ptr, lowchunk, sizeof(lowchunk)); wave_ptr+=sizeof(lowchunk);
    }
    else
    {
        memcpy(wave_buffer+wave_ptr, lowchunk, sizeof(lowchunk)); wave_ptr+=sizeof(lowchunk);
        memcpy(wave_buffer+wave_ptr, highchunk, sizeof(highchunk)); wave_ptr+=sizeof(highchunk);
    }
}

int main()
{
    //A :
    //B ;
    //C <
    //D =
    //E >
    //F ?        
    char id[]={';', 'S', 'S', 'S', 'S', 'S', 'S', 'S', 'S', 'S', '=', 'I', 'I', '4', '7', '?', '>'};		//Put your data in this array
																											
    int parity;
    for(int a=0; a<16; a++) write0(); //write 24 zeros
    for(int a=0; a<sizeof(id); a++)
    {
       parity=0;
       for(int b=0; b<4; b++)
       {
         if((id[a]>>b)%2==0) { write0(); }
         else { write1(); parity++; }
       }
       if(parity%2==0) write1();
       else write0();
       //printf(" ");
    }
    for(int a=0; a<16; a++) write0(); //write 8 zeros
    struct riff_chunk myriff;
    struct fmt_chunk myfmt;   
    myriff.chunk_id[0]='R'; myriff.chunk_id[1]='I'; myriff.chunk_id[2]='F'; myriff.chunk_id[3]='F';
    myriff.file_size=wave_ptr+4+4+sizeof(myriff)+sizeof(myfmt);
    myriff.riff_type[0]='W'; myriff.riff_type[1]='A'; myriff.riff_type[2]='V'; myriff.riff_type[3]='E';
    myfmt.chunk_id[0]='f';  myfmt.chunk_id[1]='m';  myfmt.chunk_id[2]='t';  myfmt.chunk_id[3]=0x20;
    myfmt.chunk_size=0x10;
    myfmt.compression_code=1;
    myfmt.num_channels=1;
    myfmt.sample_rate=8192;
    myfmt.bytes_second=8192;
    myfmt.block_align=1;
    myfmt.bits_sample=8;
    FILE *f=fopen("test.wav","wb");
    fwrite((void *)&myriff, 1, sizeof(myriff), f);
    fwrite((void *)&myfmt, 1, sizeof(myfmt), f);
    char data_chunk_id[]={ 'd', 'a', 't', 'a' }; fwrite(data_chunk_id, 1, sizeof(data_chunk_id), f);
    fwrite(&wave_ptr, 1, sizeof(wave_ptr), f);
    int a;
    fwrite(wave_buffer, 1, wave_ptr, f);            
    fclose(f);
    printf("\n"); system("PAUSE");
    return 0;
}
