// MINIJukebox - version 1.0
// MINI Jukebox is copyright 2016-2017 Allan Murray and is free to use and modify for non-commercial use.
//
// MINI Jukebox uses freeware third party components:
// GAudio Sound Library (http://www.softpedia.com/get/Multimedia/Audio/Other-AUDIO-Tools/GAudio-Sound-Library.shtml)
// FreeImage Image Library (http://freeimage.sourceforge.net/)
// Digital-7 freeware font (http://www.1001fonts.com/digital-7-font.html)

unit jukebase;

{$mode delphi}

interface

uses
  Classes, SysUtils,strutils;


function listdirectories(var  filelist:TStringList;dir:string;flag:integer):integer;
function getsongname(name1:string):string;
function getartistname(name1:string):string;
function getalbumname(name1:string):string;
implementation


function getsongname(name1:string):string;
var
   name2:string;
   c:integer;
begin

     name2:=ReplaceStr(name1,'_',' ');
     name2:=LeftStr(name2,length(name2)-4);

     if  (name2[1]>='0') and (name2[1]<='9') then name2:=RightStr(name2,length(name2)-1);
     if  (name2[1]>='0') and (name2[1]<='9') then name2:=RightStr(name2,length(name2)-1);

     name2:=trim(name2);
      if  (name2[1]='.')  then name2:=RightStr(name2,length(name2)-1);
      if  (name2[1]='-')  then name2:=RightStr(name2,length(name2)-1);
       name2:=trim(name2);

   for c:=1 to length(name2) do begin
       if  (name2[c]='(') or (name2[c]='-') then begin
      name2:=leftStr(name2,c-1);
      break
      end;
     end;

 getsongname:=trim(name2);
end;

function getartistname(name1:string):string;
var
   name2:string;
   c:integer;
begin

     name2:=ReplaceStr(name1,'_',' ');

     if  (name2[1]>='0') and (name2[1]<='9') then name2:=RightStr(name2,length(name2)-1);
     if  (name2[1]>='0') and (name2[1]<='9') then name2:=RightStr(name2,length(name2)-1);

     name2:=trim(name2);
      if  (name2[1]='.')  then name2:=RightStr(name2,length(name2)-1);
      if  (name2[1]='-')  then name2:=RightStr(name2,length(name2)-1);
       name2:=trim(name2);

   for c:=1 to length(name2) do begin
     if  (name2[c]='(') or (name2[c]='-') then begin
      name2:=leftStr(name2,c-1);
      break
      end;
     end;

      if ( trim(name2)='VA') then name2:='Various Artists';
 getartistname:=trim(name2);
end;

function getalbumname(name1:string):string;
var
   name2:string;
   c:integer;
begin

     name2:=ReplaceStr(name1,'_',' ');

     if  (name2[1]>='0') and (name2[1]<='9') then name2:=RightStr(name2,length(name2)-1);
     if  (name2[1]>='0') and (name2[1]<='9') then name2:=RightStr(name2,length(name2)-1);

     name2:=trim(name2);
      if  (name2[1]='.')  then name2:=RightStr(name2,length(name2)-1);
      if  (name2[1]='-')  then name2:=RightStr(name2,length(name2)-1);
       name2:=trim(name2);

       for c:=1 to length(name2)-1 do begin
         if  (name2[c]='-') then begin
          name2:=rightStr(name2,length(name2)-c);
            getalbumname:=trim(name2);
            exit;
          end;
         end;

 getalbumname:=' ';
end;


function listdirectories(var  filelist:TStringList;dir:string;flag:integer):integer;
var
   bf,bfo,ext:string;
   TheFile : TSearchRec ;
   count,r:integer;
begin
      if (filelist=nil) then filelist:= TStringList.Create
      else  filelist.clear;

       ext:='';
       if (flag=1) then ext:='.jpg';
       if (flag=2) then ext:='.mp3';


	  bf:=dir+'*'+ext;
	  count:=0;
	  r :=FindFirst(bf,faanyfile,TheFile);
	  if r<>0 then
      begin
	     listdirectories:=0;
	     exit;
	    end;

	  bfo:=TheFile.Name;

          if (bfo[1]<>'.')  and  ((TheFile.Attr and faHidden) <>faHidden)  and ((TheFile.Attr and faSysFile) <>faSysFile) then begin
         if (flag<>0) or ((TheFile.Attr and faDirectory) = faDirectory) then begin
         count:=count+1;
         filelist.Add(bfo);
         end;
         end;


   while (FindNext(TheFile)=0) do
     begin
       bfo:=TheFile.Name;
      if (bfo[1]<>'.')  and  ((TheFile.Attr and faHidden) <>faHidden)  and ((TheFile.Attr and faSysFile) <>faSysFile) then begin
     if (flag<>0) or ((TheFile.Attr and faDirectory) = faDirectory) then begin
      count:=count+1;
      filelist.Add(bfo);
      end;
      end;

     end;

   FindClose(TheFile);
  listdirectories:=count;
end;


end.

