{$MODE DELPHI}
unit FreeImage;

interface

uses
  Windows;

// ==========================================================
// Delphi wrapper for FreeImage 3
//
// Design and implementation by
// - Simon Beavis
// - Peter Bystrm
// - Anatoliy Pulyaevskiy (xvel84@rambler.ru)
//
// This file is part of FreeImage 3
//
// COVERED CODE IS PROVIDED UNDER THIS LICENSE ON AN "AS IS" BASIS, WITHOUT WARRANTY
// OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, WITHOUT LIMITATION, WARRANTIES
// THAT THE COVERED CODE IS FREE OF DEFECTS, MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE
// OR NON-INFRINGING. THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE COVERED
// CODE IS WITH YOU. SHOULD ANY COVERED CODE PROVE DEFECTIVE IN ANY RESPECT, YOU (NOT
// THE INITIAL DEVELOPER OR ANY OTHER CONTRIBUTOR) ASSUME THE COST OF ANY NECESSARY
// SERVICING, REPAIR OR CORRECTION. THIS DISCLAIMER OF WARRANTY CONSTITUTES AN ESSENTIAL
// PART OF THIS LICENSE. NO USE OF ANY COVERED CODE IS AUTHORIZED HEREUNDER EXCEPT UNDER
// THIS DISCLAIMER.
//
// Use at your own risk!
// ==========================================================

{ following statement removed for Free Pascal - 4 is the default value, so it is not needed. }
// Having trouble with enums? - Changed to Int;
// { $MINENUMSIZE 4} // Make sure enums are stored as an integer to be compatible with C/C++

// --------------------------------------------------------------------------
// Version information ------------------------------------------------------
// --------------------------------------------------------------------------
const
  FREEIMAGE_MAJOR_VERSION  = 3;
  FREEIMAGE_MINOR_VERSION  = 9;
  FREEIMAGE_RELEASE_SERIAL = 3;

const
  FIDLL = 'FreeImage.dll';

// --------------------------------------------------------------------------
// Windows types used in the library ----------------------------------------
// --------------------------------------------------------------------------
type
  WININT   = longint;
  WINFLOAT = Single;
  PCardinal=^Cardinal;
// --------------------------------------------------------------------------
// Types used in the library (specific to FreeImage) ------------------------
// --------------------------------------------------------------------------
type
{ 48-bit RGB }
  FIRGB16  = record
               red   : WORD;
               green : WORD;
               blue  : WORD;
             end;

{ 64-bit RGBA }
  FIRGBA16 = record
               red   : WORD;
               green : WORD;
               blue  : WORD;
               alpha : WORD;
             end;

{ 96-bit RGB Float }
  FIRGBF   = record
              red   : WINFLOAT;
              green : WINFLOAT;
              blue  : WINFLOAT;
            end;

{ 128-bit RGB Float }
  FIRGBFA  = record
              red   : WINFLOAT;
              green : WINFLOAT;
              blue  : WINFLOAT;
              alpha : WINFLOAT;
            end;

{ Data structure for COMPLEX type (complex number) }
  FICOMPLEX = record
                r : double; // real part
                i : double; // imaginary part
              end;

// --------------------------------------------------------------------------
// Bitmap types -------------------------------------------------------------
// --------------------------------------------------------------------------
type
  FIBITMAP  =  record
                data : PVOID;
              end;
  PFIBITMAP = ^FIBITMAP;

  FIMULTIBITMAP  = record
                     data : PVOID;
                   end;
  PFIMULTIBITMAP = ^FIMULTIBITMAP;

// --------------------------------------------------------------------------
// Indexes for byte arrays, masks and shifts for treating pixels as words ---
// These coincide with the order of RGBQUAD and RGBTRIPLE -------------------
// Little Endian (x86 / MS Windows, Linux) : BGR(A) order -------------------
// --------------------------------------------------------------------------
const
  FI_RGBA_RED         = 2;
  FI_RGBA_GREEN       = 1;
  FI_RGBA_BLUE        = 0;
  FI_RGBA_ALPHA       = 3;
  FI_RGBA_RED_MASK    = $00FF0000;
  FI_RGBA_GREEN_MASK  = $0000FF00;
  FI_RGBA_BLUE_MASK   = $000000FF;
  FI_RGBA_ALPHA_MASK  = $FF000000;
  FI_RGBA_RED_SHIFT   = 16;
  FI_RGBA_GREEN_SHIFT = 8;
  FI_RGBA_BLUE_SHIFT  = 0;
  FI_RGBA_ALPHA_SHIFT = 24;

  FI_RGBA_RGB_MASK    = FI_RGBA_RED_MASK or FI_RGBA_GREEN_MASK or FI_RGBA_BLUE_MASK;

// --------------------------------------------------------------------------
// The 16bit macros only include masks and shifts, --------------------------
// since each color element is not byte aligned -----------------------------
// --------------------------------------------------------------------------
const
  FI16_555_RED_MASK      = $7C00;
  FI16_555_GREEN_MASK    = $03E0;
  FI16_555_BLUE_MASK     = $001F;
  FI16_555_RED_SHIFT     = 10;
  FI16_555_GREEN_SHIFT   = 5;
  FI16_555_BLUE_SHIFT    = 0;

  FI16_565_RED_MASK      = $F800;
  FI16_565_GREEN_MASK    = $07E0;
  FI16_565_BLUE_MASK     = $001F;
  FI16_565_RED_SHIFT     = 11;
  FI16_565_GREEN_SHIFT   = 5;
  FI16_565_BLUE_SHIFT    = 0;

// --------------------------------------------------------------------------
// ICC profile support ------------------------------------------------------
// --------------------------------------------------------------------------
const
  FIICC_DEFAULT       = $0;
  FIICC_COLOR_IS_CMYK = $1;

type
  FIICCPROFILE  = record
                    flags : WORD;    // info flag
                    size  : DWORD;   // profile's size measured in bytes
                    data  : PVOID;   // points to a block of contiguous memory containing the profile
                  end;
  PFIICCPROFILE = ^FIICCPROFILE;

// --------------------------------------------------------------------------
// Important enums ----------------------------------------------------------
// --------------------------------------------------------------------------

type
  // I/O image format identifiers.
  FREE_IMAGE_FORMAT = WININT;

const
  FIF_UNKNOWN = -1;
  FIF_BMP     =  0;
  FIF_ICO     =  1;
  FIF_JPEG    =  2;
  FIF_JNG     =  3;
  FIF_KOALA   =  4;
  FIF_LBM     =  5;
  FIF_IFF     =  FIF_LBM;
  FIF_MNG     =  6;
  FIF_PBM     =  7;
  FIF_PBMRAW  =  8;
  FIF_PCD     =  9;
  FIF_PCX     = 10;
  FIF_PGM     = 11;
  FIF_PGMRAW  = 12;
  FIF_PNG     = 13;
  FIF_PPM     = 14;
  FIF_PPMRAW  = 15;
  FIF_RAS     = 16;
  FIF_TARGA   = 17;
  FIF_TIFF    = 18;
  FIF_WBMP    = 19;
  FIF_PSD     = 20;
  FIF_CUT     = 21;
  FIF_XBM     = 22;
  FIF_XPM     = 23;
  FIF_DDS     = 24;
  FIF_GIF     = 25;
  FIF_HDR     = 26;
  FIF_FAXG3   = 27;
  FIF_SGI     = 28;

type
  // Image type used in FreeImage.
  FREE_IMAGE_TYPE = WININT;

const
  FIT_UNKNOWN =  0;    // unknown type
  FIT_BITMAP  =  1;    // standard image           : 1-, 4-, 8-, 16-, 24-, 32-bit
  FIT_UINT16  =  2;    // array of unsigned short  : unsigned 16-bit
  FIT_INT16   =  3;    // array of short           : signed 16-bit
  FIT_UINT32  =  4;    // array of unsigned long   : unsigned 32-bit
  FIT_INT32   =  5;    // array of long            : signed 32-bit
  FIT_FLOAT   =  6;    // array of float           : 32-bit IEEE floating point
  FIT_DOUBLE  =  7;    // array of double          : 64-bit IEEE floating point
  FIT_COMPLEX =  8;    // array of FICOMPLEX       : 2 x 64-bit IEEE floating point
  FIT_RGB16   =  9;    // 48-bit RGB image         : 3 x 16-bit
  FIT_RGBA16  = 10;    // 64-bit RGBA image        : 4 x 16-bit
  FIT_RGBF    = 11;    // 96-bit RGB float image   : 3 x 32-bit IEEE floating point
  FIT_RGBAF   = 12;    // 128-bit RGBA float image : 4 x 32-bit IEEE floating point

type
  // Image color type used in FreeImage.
  FREE_IMAGE_COLOR_TYPE = WININT;

const
  FIC_MINISWHITE = 0;    // min value is white
  FIC_MINISBLACK = 1;    // min value is black
  FIC_RGB        = 2;    // RGB color model
  FIC_PALETTE    = 3;    // color map indexed
  IC_RGBALPHA    = 4;    // RGB color model with alpha channel
  FIC_CMYK       = 5;    // CMYK color model

type
  // Color quantization algorithms. Constants used in FreeImage_ColorQuantize.
  FREE_IMAGE_QUANTIZE = WININT;

const
  FIQ_WUQUANT = 0;    // Xiaolin Wu color quantization algorithm
  FIQ_NNQUANT = 1;    // NeuQuant neural-net quantization algorithm by Anthony Dekker                        );

type
  // Dithering algorithms. Constants used FreeImage_Dither.
  FREE_IMAGE_DITHER = WININT;

const
  FID_FS           = 0;    // Floyd & Steinberg error diffusion
  FID_BAYER4x4     = 1;    // Bayer ordered dispersed dot dithering (order 2 dithering matrix)
  FID_BAYER8x8     = 2;    // Bayer ordered dispersed dot dithering (order 3 dithering matrix)
  FID_CLUSTER6x6   = 3;    // Ordered clustered dot dithering (order 3 - 6x6 matrix)
  FID_CLUSTER8x8   = 4;    // Ordered clustered dot dithering (order 4 - 8x8 matrix)
  FID_CLUSTER16x16 = 5;    // Ordered clustered dot dithering (order 8 - 16x16 matrix)
  FID_BAYER16x16   = 6;    // Bayer ordered dispersed dot dithering (order 4 dithering matrix)

type
  // Lossless JPEG transformations. Constants used in FreeImage_JPEGTransform
  FREE_IMAGE_JPEG_OPERATION = WININT;

const
  FIJPEG_OP_NONE       = 0;    // no transformation
  FIJPEG_OP_FLIP_H     = 1;    // horizontal flip
  FIJPEG_OP_FLIP_V     = 2;    // vertical flip
  FIJPEG_OP_TRANSPOSE  = 3;    // transpose across UL-to-LR axis
  FIJPEG_OP_TRANSVERSE = 4;    // transpose across UR-to-LL axis
  FIJPEG_OP_ROTATE_90  = 5;    // 90-degree clockwise rotation
  FIJPEG_OP_ROTATE_180 = 6;    // 180-degree rotation
  FIJPEG_OP_ROTATE_270 = 7;    // 270-degree clockwise (or 90 ccw)

type
  // Tone mapping operators. Constants used in FreeImage_ToneMapping.
  FREE_IMAGE_TMO = WININT;

const
  FITMO_DRAGO03    = 0;    // Adaptive logarithmic mapping (F. Drago, 2003)
  FITMO_REINHARD05 = 1;    // Dynamic range reduction inspired by photoreceptor physiology (E. Reinhard, 2005)

type
  // Upsampling / downsampling filters. Constants used in FreeImage_Rescale.
  FREE_IMAGE_FILTER = WININT;

const
  FILTER_BOX        = 0;   // Box, pulse, Fourier window, 1st order (constant) b-spline
  FILTER_BICUBIC    = 1;   // Mitchell & Netravali's two-param cubic filter
  FILTER_BILINEAR   = 2;   // Bilinear filter
  FILTER_BSPLINE    = 3;   // 4th order (cubic) b-spline
  FILTER_CATMULLROM = 4;   // Catmull-Rom spline, Overhauser spline
  FILTER_LANCZOS3   = 5;   // Lanczos3 filter

type
  // Color channels. Constants used in color manipulation routines.
  FREE_IMAGE_COLOR_CHANNEL = WININT;

const
  FICC_RGB   = 0;   // Use red, green and blue channels
  FICC_RED   = 1;   // Use red channel
  FICC_GREEN = 2;   // Use green channel
  FICC_BLUE  = 3;   // Use blue channel
  FICC_ALPHA = 4;   // Use alpha channel
  FICC_BLACK = 5;   // Use black channel
  FICC_REAL  = 6;   // Complex images: use real part
  FICC_IMAG  = 7;   // Complex images: use imaginary part
  FICC_MAG   = 8;   // Complex images: use magnitude
  FICC_PHASE = 9;   // Complex images: use phase

// --------------------------------------------------------------------------
// MetaData support ---------------------------------------------------------
// --------------------------------------------------------------------------

type
  // Tag data type information (based on TIFF specifications)
  FREE_IMAGE_MDTYPE = WININT;

const
  FIDT_NOTYPE    =  0;   // placeholder
  FIDT_BYTE      =  1;   // 8-bit unsigned integer
  FIDT_ASCII     =  2;   // 8-bit bytes w/ last byte null
  FIDT_SHORT     =  3;   // 16-bit unsigned integer
  FIDT_LONG      =  4;   // 32-bit unsigned integer
  FIDT_RATIONAL  =  5;   // 64-bit unsigned fraction
  FIDT_SBYTE     =  6;   // 8-bit signed integer
  FIDT_UNDEFINED =  7;   // 8-bit untyped data
  FIDT_SSHORT    =  8;   // 16-bit signed integer
  FIDT_SLONG     =  9;   // 32-bit signed integer
  FIDT_SRATIONAL = 10;   // 64-bit signed fraction
  FIDT_FLOAT     = 11;   // 32-bit IEEE floating point
  FIDT_DOUBLE    = 12;   // 64-bit IEEE floating point
  FIDT_IFD       = 13;   // 32-bit unsigned integer (offset)
  FIDT_PALETTE   = 14;   // 32-bit RGBQUAD

type
  // Metadata models supported by FreeImage
  FREE_IMAGE_MDMODEL = WININT;

const
  FIMD_NODATA         = -1;
  FIMD_COMMENTS       =  0;     // single comment or keywords
  FIMD_EXIF_MAIN      =  1;     // Exif-TIFF metadata
  FIMD_EXIF_EXIF      =  2;     // Exif-specific metadata
  FIMD_EXIF_GPS       =  3;     // Exif GPS metadata
  FIMD_EXIF_MAKERNOTE =  4;     // Exif maker note metadata
  FIMD_EXIF_INTEROP   =  5;     // Exif interoperability metadata
  FIMD_IPTC           =  6;     // IPTC/NAA metadata
  FIMD_XMP            =  7;     // Abobe XMP metadata
  FIMD_GEOTIFF        =  8;     // GeoTIFF metadata
  FIMD_ANIMATION      =  9;     // Animation metadata
  FIMD_CUSTOM         = 10;     // Used to attach other metadata types to a dib

type
  // Handle to a metadata model
  FIMETADATA  = record
                  data : PVOID;
                end;
  PFIMETADATA = ^FIMETADATA;

  // Handle to a FreeImage tag
  FITAG  = record
             data : PVOID;
           end;
  PFITAG = ^FITAG;

// --------------------------------------------------------------------------
// File IO routines ---------------------------------------------------------
// --------------------------------------------------------------------------
type
  FI_Handle = PVOID;
//  PCardinal = ^Cardinal;
//  PInt     = ^Integer;


const
  // constants used in FreeImage_Seek for Origin parameter
  SEEK_SET = 0;
  SEEK_CUR = 1;
  SEEK_END = 2;

// --------------------------------------------------------------------------
// Plugin routines ----------------------------------------------------------
// --------------------------------------------------------------------------


// --------------------------------------------------------------------------
// Load/Save flag constants -------------------------------------------------
// --------------------------------------------------------------------------
const
  BMP_DEFAULT         = 0;
  BMP_SAVE_RLE        = 1;

  CUT_DEFAULT         = 0;

  DDS_DEFAULT         = 0;

  FAXG3_DEFAULT       = 0;

  GIF_DEFAULT         = 0;
  GIF_LOAD256         = 1;     // Load the image as a 256 color image with ununsed palette entries, if it's 16 or 2 color
  GIF_PLAYBACK        = 2;     // 'Play' the GIF to generate each frame (as 32bpp) instead of returning raw frame data when loading

  HDR_DEFAULT         = 0;

  ICO_DEFAULT         = 0;
  ICO_MAKEALPHA       = 0;     // convert to 32bpp and create an alpha channel from the AND-mask when loading

  IFF_DEFAULT         = 0;

  JPEG_DEFAULT        = $0000; // loading (see JPEG_FAST); saving (see JPEG_QUALITYGOOD)
  JPEG_FAST           = $0001; // load the file as fast as possible, sacrificing some quality
  JPEG_ACCURATE       = $0002; // load the file with the best quality, sacrificing some speed
  JPEG_CMYK           = $0004; // load separated CMYK "as is" (use | to combine with other flags)
  JPEG_QUALITYSUPERB  = $0080; // save with superb quality (100:1)
  JPEG_QUALITYGOOD    = $0100; // save with good quality (75:1)
  JPEG_QUALITYNORMAL  = $0200; // save with normal quality (50:1)
  JPEG_QUALITYAVERAGE = $0400; // save with average quality (25:1)
  JPEG_QUALITYBAD     = $0800; // save with bad quality (10:1)
//  JPEG_CMYK           = $1000; // load separated CMYK "as is" (use | to combine with other flags)
  JPEG_PROGRESSIVE    = $2000; // save as a progressive-JPEG (use | to combine with other save flags)


  KOALA_DEFAULT       = 0;

  LBM_DEFAULT         = 0;

  MNG_DEFAULT         = 0;

  PCD_DEFAULT         = 0;
  PCD_BASE            = 1;     // load the bitmap sized 768 x 512
  PCD_BASEDIV4        = 2;     // load the bitmap sized 384 x 256
  PCD_BASEDIV16       = 3;     // load the bitmap sized 192 x 128

  PCX_DEFAULT         = 0;

  PNG_DEFAULT         = 0;
  PNG_IGNOREGAMMA     = 1;     // avoid gamma correction

  PNM_DEFAULT         = 0;
  PNM_SAVE_RAW        = 0;     // If set the writer saves in RAW format (i.e. P4, P5 or P6)
  PNM_SAVE_ASCII      = 1;     // If set the writer saves in ASCII format (i.e. P1, P2 or P3)

  PSD_DEFAULT         = 0;

  RAS_DEFAULT         = 0;

  SGI_DEFAULT         = 0;

  TARGA_DEFAULT       = 0;
  TARGA_LOAD_RGB888   = 1;     // If set the loader converts RGB555 and ARGB8888 -> RGB888.

  TIFF_DEFAULT        = 0;
  TIFF_CMYK	          = $0001;  // reads/stores tags for separated CMYK (use | to combine with compression flags)
  TIFF_PACKBITS       = $0100;  // save using PACKBITS compression
  TIFF_DEFLATE        = $0200;  // save using DEFLATE compression
  TIFF_ADOBE_DEFLATE  = $0400;  // save using ADOBE DEFLATE compression
  TIFF_NONE           = $0800;  // save without any compression
  TIFF_CCITTFAX3      = $1000;  // save using CCITT Group 3 fax encoding
  TIFF_CCITTFAX4      = $2000;  // save using CCITT Group 4 fax encoding
  TIFF_LZW            = $4000; 	// save using LZW compression
  TIFF_JPEG           = $8000;	// save using JPEG compression

  WBMP_DEFAULT        = 0;

  XBM_DEFAULT         = 0;

  XPM_DEFAULT         = 0;

// --------------------------------------------------------------------------
// Init/Error routines ------------------------------------------------------
// --------------------------------------------------------------------------

type
 FI_FreeImage_Threshold= function ( dib : PFIBITMAP; T : Byte) : PFIBITMAP; stdcall; //external FIDLL name '_FreeImage_Threshold@8';
 FI_FreeImage_Unload  =  procedure ( dib : PFIBITMAP);  stdcall; //external FIDLL name '_FreeImage_Unload@4';
 FI_FreeImage_GetWidth   = function ( dib : PFIBITMAP ) : Cardinal; stdcall; //external FIDLL name '_FreeImage_GetWidth@4';
 FI_FreeImage_GetHeight  =  function ( dib : PFIBITMAP ) : Cardinal; stdcall; //external FIDLL name '_FreeImage_GetHeight@4';
 FI_FreeImage_GetVersion =function(): PChar; stdcall; //external FIDLL name '_FreeImage_GetVersion@0';
 FI_FreeImage_Initialise =procedure(load_local_plugins_only : boolean ); stdcall; //external FIDLL name '_FreeImage_Initialise@4';
 FI_FreeImage_DeInitialise =procedure();  stdcall; //external FIDLL name '_FreeImage_DeInitialise@0';
 FI_FreeImage_Copy =function ( dib:PFIBITMAP; left: WININT; top:WININT;right:WININT; bottom: WININT ) : PFIBITMAP; stdcall; //external FIDLL name '_FreeImage_Copy@20';
 FI_FreeImage_Rescale =function ( dib:PFIBITMAP; dst_width:WININT; dst_height:WININT; filter:FREE_IMAGE_FILTER ) : PFIBITMAP; stdcall;// external FIDLL name '_FreeImage_Rescale@16';
 FI_FreeImage_Invert =function ( dib: PFIBITMAP ) : Boolean; stdcall; //external FIDLL name '_FreeImage_Invert@4';
 FI_FreeImage_GetInfoHeader =function ( dib : PFIBITMAP ) : PBITMAPINFOHEADER;     stdcall; //external FIDLL name '_FreeImage_GetInfoHeader@4';
 FI_FreeImage_GetBits =function ( dib: PFIBITMAP ) : PByte; stdcall; //external FIDLL name '_FreeImage_GetBits@4';
 FI_FreeImage_GetInfo =function ( dib: PFIBITMAP ) : PBITMAPINFO; stdcall; //external FIDLL name '_FreeImage_GetInfo@4';
 FI_FreeImage_Load =function ( fif:FREE_IMAGE_FORMAT; filename : PChar; flags:WININT  ) : PFIBITMAP; stdcall; //external FIDLL name '_FreeImage_Load@12';
 FI_FreeImage_GetFIFFromFilename =function  ( fname:PChar ) : FREE_IMAGE_FORMAT; stdcall; //external FIDLL Name '_FreeImage_GetFIFFromFilename@4';


 var
 hFreeImage: HMODULE = 0;//t3
 FreeImage_Threshold:FI_FreeImage_Threshold=nil;
 FreeImage_Unload:FI_FreeImage_Unload=nil;
 FreeImage_GetWidth:FI_FreeImage_GetWidth=nil;
 FreeImage_GetHeight:FI_FreeImage_GetHeight=nil;
 FreeImage_GetVersion:FI_FreeImage_GetVersion=nil;
 FreeImage_Initialise:FI_FreeImage_Initialise=nil;
 FreeImage_DeInitialise:FI_FreeImage_DeInitialise=nil;
 FreeImage_Copy:FI_FreeImage_Copy=nil;
 FreeImage_Rescale:FI_FreeImage_Rescale=nil;
 FreeImage_Invert:FI_FreeImage_Invert=nil;
 FreeImage_GetInfoHeader:FI_FreeImage_GetInfoHeader=nil;
 FreeImage_GetBits:FI_FreeImage_GetBits=nil;
 FreeImage_GetInfo:FI_FreeImage_GetInfo=nil;
 FreeImage_Load:FI_FreeImage_Load=nil;
 FreeImage_GetFIFFromFilename:FI_FreeImage_GetFIFFromFilename  =nil;


function FreeImage_Init():boolean;
procedure FreeImage_Close();



{ following statement removed for Free Pascal - 4 is the default value, so don't change it here (see beginning of unit). }
//  { $MINENUMSIZE 1}


implementation

// Extra function

function FreeImage_Init():boolean;
var
p:pointer;
begin

    hFreeImage:= LoadLibrary(FIDLL);
    if hFreeImage=0 then begin FreeImage_Init:=false; exit; end;

   p:= GetProcAddress(hFreeImage,'_FreeImage_Threshold@8');
   if (p=nil)  then begin  hFreeImage:=0; FreeImage_Init:=false; exit; end;
   @FreeImage_Threshold:=p;

   p:= GetProcAddress(hFreeImage,'_FreeImage_Unload@4');
    if (p=nil)  then begin  hFreeImage:=0; FreeImage_Init:=false; exit; end;
   @FreeImage_Unload:=p;

    p:= GetProcAddress(hFreeImage,'_FreeImage_GetWidth@4');
    if (p=nil)  then begin  hFreeImage:=0; FreeImage_Init:=false; exit; end;
    @FreeImage_GetWidth:=p;

    p:= GetProcAddress(hFreeImage,'_FreeImage_GetHeight@4');
    if (p=nil)  then begin  hFreeImage:=0; FreeImage_Init:=false; exit; end;
    @FreeImage_GetHeight:=p;

    p:= GetProcAddress(hFreeImage,'_FreeImage_GetVersion@0');
    if (p=nil)  then begin  hFreeImage:=0; FreeImage_Init:=false; exit; end;
    @FreeImage_GetVersion:=p;

    p:= GetProcAddress(hFreeImage,'_FreeImage_Initialise@4');
    if (p=nil)  then begin  hFreeImage:=0; FreeImage_Init:=false; exit; end;
    @FreeImage_Initialise:=p;

    p:= GetProcAddress(hFreeImage,'_FreeImage_DeInitialise@0');
    if (p=nil)  then begin  hFreeImage:=0; FreeImage_Init:=false; exit; end;
    @FreeImage_DeInitialise:=p;

    p:= GetProcAddress(hFreeImage,'_FreeImage_Copy@20');
    if (p=nil)  then begin  hFreeImage:=0; FreeImage_Init:=false; exit; end;
    @FreeImage_Copy:=p;

    p:= GetProcAddress(hFreeImage,'_FreeImage_Rescale@16');
    if (p=nil)  then begin  hFreeImage:=0; FreeImage_Init:=false; exit; end;
    @FreeImage_Rescale:=p;

    p:= GetProcAddress(hFreeImage,'_FreeImage_Invert@4');
    if (p=nil)  then begin  hFreeImage:=0; FreeImage_Init:=false; exit; end;
    @FreeImage_Invert:=p;

    p:= GetProcAddress(hFreeImage,'_FreeImage_GetInfoHeader@4');
    if (p=nil)  then begin  hFreeImage:=0; FreeImage_Init:=false; exit; end;
    @FreeImage_GetInfoHeader:=p;

    p:= GetProcAddress(hFreeImage,'_FreeImage_GetBits@4');
    if (p=nil)  then begin  hFreeImage:=0; FreeImage_Init:=false; exit; end;
    @FreeImage_GetBits:=p;

    p:= GetProcAddress(hFreeImage,'_FreeImage_GetInfo@4');
    if (p=nil)  then begin  hFreeImage:=0; FreeImage_Init:=false; exit; end;
    @FreeImage_GetInfo:=p;

    p:= GetProcAddress(hFreeImage,'_FreeImage_Load@12');
    if (p=nil)  then begin  hFreeImage:=0; FreeImage_Init:=false; exit; end;
    @FreeImage_Load:=p;

    p:= GetProcAddress(hFreeImage,'_FreeImage_GetFIFFromFilename@4');
    if (p=nil)  then begin  hFreeImage:=0; FreeImage_Init:=false; exit; end;
    @FreeImage_GetFIFFromFilename:=p;

   FreeImage_Initialise(FALSE);
   FreeImage_Init:=true;
end;


procedure FreeImage_Close();
begin

if hFreeImage<>0 then begin
  FreeImage_DeInitialise;
  freeLibrary(hFreeImage);
  hFreeImage:=0;
end;

end;


end.

