// MINIJukebox - version 1.0
// MINI Jukebox is copyright 2016-2017 Allan Murray and is free to use and modify for non-commercial use.
//
// MINI Jukebox uses freeware third party components:
// GAudio Sound Library (http://www.softpedia.com/get/Multimedia/Audio/Other-AUDIO-Tools/GAudio-Sound-Library.shtml)
// FreeImage Image Library (http://freeimage.sourceforge.net/)
// Digital-7 freeware font (http://www.1001fonts.com/digital-7-font.html)
 

program MINIJukebox;

{$MODE DELPHI}
{$APPTYPE GUI}
{$X+} 
{$H+}



Uses classes,windows, sysutils, gaudio,FreeImage, jukebase,crt;

Const
	AppName = 'MINIJukebox';
         albumsize=120;
         PreviewName = 'Preview';

            cardwidth=300;
            cardheight=500;
             inv=false;

type int=integer;




Var
AMessage   	: Msg;
WindowClass	: WndClass;
hInstance  	: longint;
songplaying,songnext:string;
skinbmp,tempbmp:HBITMAP;
skindc,tempdc:HDC;
c:int;

bbrush:hbrush;

hwndTask:hwnd;
pPoint:point;
hwindow, previewpanel:hwnd;
PreviewClass: WndClass;

gs:pgsource;
image:hbitmap;
FI_bmp: PFIBITMAP;
hdcs:HDC;
     bm:  BITMAP ;
     osize:ulong;
 dlist,tlist,jlist,playlist:TStringList;
 musicpath:string;
         ss,cpic,currenttrack:string;
        currentalbumnum:integer;

        Lfont_dig:LOGFONT;
        Hfont_dig:Hfont;
        Lfont_t1:LOGFONT;
        Hfont_t1:Hfont;
        Lfont_t2:LOGFONT;
        Hfont_t2:Hfont;
        Lfont_t3:LOGFONT;
        Hfont_t3:Hfont;
       display:string;
       playing:boolean;

numtracks:array[1..2000] of int;


procedure playnextsong();forward;

procedure nextsong(gsource:pgsource);
begin
 gaudio_source_destroy(gs);
  playnextsong();

end;


procedure playnextsong();
 var
        albumnum,tracknum:integer;
        entry:string;
 begin
   playing:=false;

   if playlist.count=0 then begin
   songplaying:=' ';
   invalidaterect(hwindow,nil,inv);
   exit;
   end;

    entry:=playlist.strings[0];
    playlist.delete(0);

    if length(entry)<>4 then exit;


    try
    ss:=entry[3]+entry[4];
    tracknum:=strtoint(ss);
    ss:=entry[1]+entry[2];
    albumnum:=strtoint(ss);
    except
      exit;
    end;

      if (albumnum<1) or (albumnum>dlist.count) then begin
      display:=' ER ';
      invalidaterect(previewpanel,nil,true);
      exit;
      end;

     c:=listdirectories(tlist,musicpath+dlist.strings[albumnum-1]+'\',2);

      if (tracknum<1) or (tracknum>tlist.count) then begin
      display:=' ER ';
      invalidaterect(previewpanel,nil,true);
      exit;
      end;


      songplaying:=getsongname(tlist.strings[tracknum-1]);

      currenttrack:=musicpath+dlist.strings[albumnum-1]+'\'+tlist.strings[tracknum-1];
      gs:=gaudio_source_create_from_file(pchar(@currenttrack[1]),0);
      gaudio_source_play(gs,0);
      gaudio_source_set_finish_callback(gs,@nextsong);
      invalidaterect(previewpanel,nil,true);
       invalidaterect(hwindow,nil,inv);

      playing:=true;
 end;






Function PanelProc(Window:HWnd;AMessage,WParam,LParam:Longint): Longint;stdcall;export;
var
ps      :   PAINTSTRUCT ;
hsdc    :   HDC;
screct:   RECT;

begin

  	PanelProc := 0;

  	Case AMessage Of

                   WM_PAINT:
                   begin

                      hsdc:=BeginPaint(Window,@ps);


                      getclientrect(previewpanel,screct);
                      fillrect(hsdc,screct,getstockobject(black_brush));

                      ss:=display+#0;
                      if length(display)>4 then ss[5]:=#0;

                      SetBkMode(hsdc,TRANSPARENT);
                      SetTextColor(hsdc,RGB(255,0,0));
                      selectobject(hsdc,Hfont_dig);
                      TextOut(hsdc,30,10,pchar(ss),length(display));

                      EndPaint(Window,@ps);
                      DeleteDC(hsdc);

                      if length(display)>=4 then begin
                         delay(800);
                         display:='';
                         invalidaterect(previewpanel,nil,inv);
                      end;

                 PanelProc:=1;
                 exit;
                 end;


  	end;

  	PanelProc := DefWindowProc(Window,AMessage,WParam,LParam);

end;



procedure addfigure(fig:string);
var
tracknum,albumnum,c:integer;
tracknum2,albumnum2:integer;
st:string;
begin

 if length(display)>=4 then display:='';
 display:=display+fig;
 invalidaterect(previewpanel,nil,true);

 if length(display)<>4 then exit;

 if (display='9999') then begin
 if playing then begin
   gaudio_source_stop(gs);
   gaudio_source_destroy(gs);
 end;
 playlist.clear;
 playing:=false;
 invalidaterect(hwindow,nil,inv);
 exit;
 end;

 try
 ss:=display[3]+display[4];
 tracknum:=strtoint(ss);
 ss:=display[1]+display[2];
 albumnum:=strtoint(ss);
 except
   tracknum:=0;
    albumnum:=0;
 end;


       if (tracknum=0) and (albumnum=0) then begin
         for c:=1 to  100 do begin
                albumnum2:=random(dlist.count)+1;
                tracknum2:=random(numtracks[albumnum2])+1;
            st:='';
            if (albumnum2<10) then st:=st+'0';
            st:=st+inttostr(albumnum2);
            if (tracknum2<10) then st:=st+'0';
            st:=st+inttostr(tracknum2);
            playlist.add(st);
         end;
      end;


       if (albumnum<0) or (albumnum>dlist.count) then begin
      display:=' ER ';
      invalidaterect(previewpanel,nil,true);
      exit;
      end;

      if (tracknum=0) then begin
         for c:=1 to  numtracks[albumnum] do begin
            st:='';
            if (albumnum<10) then st:=st+'0';
            st:=st+inttostr(albumnum);
            if (c<10) then st:=st+'0';
            st:=st+inttostr(c);
            playlist.add(st);
         end;
      end;



      if (tracknum<0) or (tracknum>numtracks[albumnum]) then begin
      display:=' ER ';
      invalidaterect(previewpanel,nil,true);
      exit;
      end;

     if ((tracknum>0) and (albumnum>0)) then playlist.add(display);



 if not playing then  playnextsong();
  invalidaterect(hwindow,nil,inv);
end;

procedure paintplaylist(hsdc:HDC;xpos,ypos:integer);
var
ss:string;
begin

     if (length(songplaying)=0) or not playing then exit;
     ss:=songplaying;

    SetTextColor(hsdc,RGB(255,255,0));
    SetBkMode(hsdc,TRANSPARENT);
    selectobject(hsdc,Hfont_t3);

       TextOut(hsdc,xpos,ypos-40-30,pchar(ss),length(ss));

           if ( playlist.count>0) then   songnext:='....'
           else songnext:='';

   if (length(songnext)=0) then exit;
     ss:=songnext;
     TextOut(hsdc,xpos,ypos-40-10,pchar(ss),length(ss));
     SetBkMode(hsdc,OPAQUE);
end;

procedure paintCard(hsdc:HDC;x1,y1:ulong; album:ushort);
var
htdc:hdc;
x,y,space:ulong;
crect:rect;
ntracks:integer;
begin

 x:=x1-cardwidth div 2;
 y:=y1;
 crect.top:=y;
 crect.left:=x;
 crect.right:=x+cardwidth;
 crect.bottom:=y+cardheight;
 fillrect(hsdc,crect,bbrush);
  x:=x+10;
  y:=y+10;


  if (album<1) or (album>dlist.count) then exit;

 c:=listdirectories(jlist,musicpath+dlist.strings[album-1]+'\',1);
 ss:='';
 for c:=1 to  jlist.count do begin
 ss:=ss+jlist.strings[c-1]+#10+#13;
 end;


 c:=listdirectories(tlist,musicpath+dlist.strings[album-1]+'\',2);
 ss:='';
 for c:=1 to  tlist.count do begin
 ss:=ss+tlist.strings[c-1]+#10+#13;
 end;

 //IMAGE

 if jlist.count>0 then begin
 cpic:=musicpath+dlist.strings[album-1]+'\'+jlist.strings[0];
FI_bmp:=FreeImage_Load(FreeImage_GetFIFFromFilename(pchar(@cpic[1])),pchar(@cpic[1]), 0);
 if (FI_bmp=nil) then begin
 messagebox(0,'err',pchar(@cpic[1]),0);
 exit;
 end;
 hdcs:=GetDC(hwindow);
 Image:=CreateDIBitmap(hdcs, FreeImage_GetInfoHeader(FI_bmp)^,CBM_INIT, FreeImage_GetBits(FI_bmp), FreeImage_GetInfo(FI_bmp)^, DIB_RGB_COLORS);
 ReleaseDC(hwindow,hdcs);
FreeImage_Unload(FI_bmp);
GetObject(image, sizeof(BITMAP),@bm);
osize:= bm.bmWidth;
if bm.bmHeight<bm.bmWidth then osize:=bm.bmHeight;

htdc:=CreateCompatibleDC(hsdc);
 SelectObject(htdc,image);
 SetStretchBltMode(hsdc,HALFTONE);
 SetStretchBltMode(htdc,HALFTONE);
 StretchBlt(hSdc ,
  x1+(cardwidth div 2)- albumsize-10
 , y+36-18  -20,albumsize, albumsize,  htdc, 0,0,osize,osize,SRCCOPY);
  DeleteDC(htdc);
    end;


// BIG NUMBER

  SetBkMode(hsdc,OPAQUE);
 SetTextColor(hsdc,RGB(255,255,255));
 SetBkColor(hsdc,RGB(0,0,0));
 selectobject(hsdc,Hfont_t2);
  ss:=inttostr(album);
  if length(ss)=1 then ss:='0'+ss;
  TextOut(hsdc,x,y+36,pchar(ss),length(ss));

 //ALBUM TITLE & ARTIST

 SetBkMode(hsdc,TRANSPARENT);
 selectobject(hsdc,Hfont_t1);
 ss:=getalbumname(dlist.strings[album-1]);
 SetTextColor(hsdc,RGB(0,0,0));

 TextOut(hsdc,x,y,pchar(ss),length(ss));
 ss:=getartistname(dlist.strings[album-1]);
 TextOut(hsdc,x,y+14,pchar(ss),length(ss));
  SetBkMode(hsdc,OPAQUE);

  //TRACKS
       ntracks:=tlist.count;
       if ntracks>20 then ntracks:=20;
  space:=17;
  if ntracks<16 then space:=round(space*(16/ntracks));
  if space>40 then space:=40;

 for c:=1 to ntracks do begin
    SetTextColor(hsdc,RGB(255,255,255));
    SetBkColor(hsdc,RGB(0,0,0));
    SetBkMode(hsdc,OPAQUE);
    selectobject(hsdc,Hfont_t1);

    ss:=inttostr(c);
    if length(ss)=1 then ss:='0'+ss;

    TextOut(hsdc,x+5,y+albumsize+(c*space)-12,pchar(ss),length(ss));

    ss:=tlist.strings[c-1];
    ss:=getsongname(ss);
    SetBkColor(hsdc,RGB(255,255,255));
    SetTextColor(hsdc,RGB(0,0,0));
    SetBkMode(hsdc,TRANSPARENT);
    TextOut(hsdc,x+30,y+albumsize+(c*space)-12,pchar(ss),length(ss));
 end;


end;



Function WindowProc (Window:HWnd;AMessage,WParam,LParam:Longint): Longint;stdcall;export;
var
ps      :   PAINTSTRUCT ;
hsdc  :   HDC;
begin

  	WindowProc := 0;
  
  	Case AMessage Of


    WM_TIMER:
     begin
    Mouse_Event(MOUSEEVENTF_ABSOLUTE OR MOUSEEVENTF_LEFTDOWN, 40, 40, 0, 0);
    Sleep(40);
    Mouse_Event(MOUSEEVENTF_ABSOLUTE OR MOUSEEVENTF_LEFTUP,40,40, 0, 0);
           SetTimer(hWindow,1,1000,nil);
           windowproc:=1;
           exit;
     end;

      WM_KEYDOWN:
        begin

            if (wParam=VK_0) or (wParam=VK_NUMPAD0)then
              begin
               addfigure('0');
              end;

            if (wParam=VK_1) or (wParam=VK_NUMPAD1)then
               begin
               addfigure('1');
               end;

            if (wParam=VK_2) or (wParam=VK_NUMPAD2)then
               begin
               addfigure('2');
               end;

            if (wParam=VK_3) or (wParam=VK_NUMPAD3)then
               begin
               addfigure('3');
               end;

            if (wParam=VK_4) or (wParam=VK_NUMPAD4)then
               begin
               addfigure('4');
               end;

            if (wParam=VK_5) or (wParam=VK_NUMPAD5)then
               begin
               addfigure('5');
               end;

            if (wParam=VK_6) or (wParam=VK_NUMPAD6)then
               begin
               addfigure('6');
               end;

            if (wParam=VK_7) or (wParam=VK_NUMPAD7)then
               begin
               addfigure('7');
               end;

            if (wParam=VK_8) or (wParam=VK_NUMPAD8)then
               begin
               addfigure('8');
               end;

            if (wParam=VK_9) or (wParam=VK_NUMPAD9)then
               begin
               addfigure('9');
               end;

            if (wParam=VK_A)or (wParam=VK_SUBTRACT)then
               begin
                if currentalbumnum>3 then begin
                 currentalbumnum :=currentalbumnum-3;
                 invalidaterect(hwindow,nil,inv);
                end else begin
                  if (currentalbumnum)>1 then begin
                 currentalbumnum :=1;
                 invalidaterect(hwindow,nil,inv);
                   end;
                 end;
               end;

            if (wParam=VK_S)or (wParam=VK_ADD)then
               begin
                if (currentalbumnum+3)<(dlist.count-1) then begin
                 currentalbumnum :=currentalbumnum +3;
                 invalidaterect(hwindow,nil,inv);
                end else begin
                   if (currentalbumnum+3)<(dlist.count) then begin
                 currentalbumnum :=dlist.count-3;
                 invalidaterect(hwindow,nil,inv);
                   end;
                end;
               end;

            if (wParam=VK_R)or (wParam=VK_DECIMAL)then
               begin
                display:='';
                invalidaterect(previewpanel,nil,true);
               end;

            if (wParam=VK_ESCAPE) then
              begin
              destroywindow(hwindow);
              end;


            if wParam=VK_left then
              begin
              end;

            if wParam=VK_right then
              begin
              end;

         windowproc:=0;
         exit;
        end;

      WM_KEYUP:
        begin

         windowproc:=0;
         exit;
        end;



                   WM_PAINT:
                   begin

                 hsdc :=BeginPaint(window, @ps);

                if (tempdc=0) then begin
                  tempdc:=createcompatibledc(hsdc);
                  tempBmp:=CreateCompatibleBitmap(hsdc,1024,768);
 	       SelectObject(tempdc,tempBmp);
               end;

                BitBlt(tempdc,0,0,1024,768,skindc,0,0,SRCCOPY);

                 paintplaylist(tempdc,(512-(cardwidth+10))-cardwidth div 2,768-cardheight-2);
                 paintcard(tempdc,512-(cardwidth+10),768-cardheight-20,currentalbumnum);
                 paintcard(tempdc,512,768-cardheight-20,currentalbumnum+1);
                 paintcard(tempdc,512+(cardwidth+10),768-cardheight-20,currentalbumnum+2);

                 BitBlt(hsdc,0,0,1024,768,tempdc,0,0,SRCCOPY);

                 EndPaint(window, @ps);
                 DeleteDC(hsdc);

                    UpdateWindow(previewpanel);
                 windowproc:=1;
                 exit;
                 end;


   	wm_Destroy:begin
           FreeImage_Close();
           hwndTask:=FindWindow('Shell_TrayWnd','');
           ShowWindow(hwndTask, SW_SHOW);
           	PostQuitMessage (0);
            exit;


        end;

  	end;
  
  	WindowProc := DefWindowProc(Window,AMessage,WParam,LParam);

end;




procedure createpanel(parent:hwnd);
var
rrect:rect;
begin



 with PreviewClass do
   begin
    Style :=    cs_hRedraw or cs_vRedraw;
    lpfnWndProc := WndProc(@PanelProc);
    cbClsExtra := 0;
    cbWndExtra := 0;
    hInstance := system.MainInstance;
    hIcon := LoadIcon (0,idi_Application);
    hCursor := LoadCursor (0,idc_Arrow);
    hbrBackground := HBRUSH(GetStockObject(BLACK_BRUSH));
    lpszMenuName := 'Files';
    lpszClassName := PreviewName;
   end;



 RegisterClass (PreviewClass);

 rrect.left:=(1024 div 2) -100;//520;
 rrect.top:=150-10;
 rrect.bottom:=rrect.top+100;
 rrect.right:=rrect.left+200;

 previewpanel := CreateWindow (PreviewName,'CR8-Jukebox',WS_CHILD or WS_DLGFRAME,
                 rrect.left,rrect.top,rrect.right-rrect.left ,rrect.bottom-rrect.top
                 ,parent,0, hInstance, Nil);

  ShowWindow(previewpanel,SW_SHOW);

end;


//MAIN LOOP

Begin




           Lfont_dig.lfHeight:=-72;
      Lfont_dig.lfWidth:=0;
      Lfont_dig.lfEscapement:=0;
      Lfont_dig.lfOrientation:=0;
      Lfont_dig.lfWeight:=FW_MEDIUM;
      Lfont_dig.lfItalic:=byte(FALSE);
      Lfont_dig.lfUnderline:=byte(FALSE);
      Lfont_dig.lfStrikeOut:=byte(FALSE);
      Lfont_dig.lfCharSet:=ANSI_CHARSET;
      Lfont_dig.lfOutPrecision:=OUT_CHARACTER_PRECIS;
      Lfont_dig.lfQuality:=DEFAULT_QUALITY;
      Lfont_dig.lfPitchAndFamily:=DEFAULT_PITCH;
      Lfont_dig.lfFaceName :='Digital-7 Mono';
      Hfont_dig:=CreateFontIndirect(@Lfont_dig);


      Lfont_t1:=Lfont_dig;
      Lfont_t1.lfHeight:=-14;
      Lfont_t1.lfWeight:=FW_BOLD;
      Lfont_t1.lfFaceName :='Arial';
      Hfont_t1:=CreateFontIndirect(@Lfont_t1);

      Lfont_t2:=Lfont_dig;
      Lfont_t2.lfHeight:=-32;
      Lfont_t2.lfWeight:=FW_BOLD;
      Lfont_t2.lfFaceName :='Arial';
      Hfont_t2:=CreateFontIndirect(@Lfont_t2);


            Lfont_t3:=Lfont_dig;
            Lfont_t3.lfHeight:=-18;
            Lfont_t3.lfWeight:=FW_BOLD;
            Lfont_t3.lfFaceName :='Arial';
            Hfont_t3:=CreateFontIndirect(@Lfont_t3);

      bbrush:=createsolidbrush(RGB(247,241,200));

  	hInstance := system.MainInstance;

 
  	With WindowClass Do
    	Begin
      	Style := cs_hRedraw Or cs_vRedraw;
      	lpfnWndProc := WndProc(@WindowProc);
      	cbClsExtra := 0;
      	cbWndExtra := 0;
      	hInstance := system.MainInstance;
      	hIcon :=LoadIcon (system.MainInstance,MAKEINTRESOURCE(234));
       	hCursor := LoadCursor (0,idc_Arrow);
        hbrBackground := HBRUSH(GetStockObject(BLACK_BRUSH));
      	lpszMenuName := 'Files';
      	lpszClassName := AppName;
    end;

        dlist:=nil;
        tlist:=nil;
        jlist:=nil;
        playlist:=nil;
        display:='';
    
    RegisterClass (WindowClass);

     
    hWindow := CreateWindow (AppName,'CR8-Jukebox',ws_OverlappedWindow or WS_CLIPCHILDREN,
                    0,0,1024,
                    768+80,0,0, hInstance, Nil);




    gaudio_init('addons');


         musicpath:='C:\MUSIC\';

        c:=listdirectories(dlist,musicpath,0);

        ss:='';
        for c:=1 to  dlist.count do begin
        ss:=ss+dlist.strings[c-1]+#10+#13;
        numtracks[c]:=listdirectories(jlist,musicpath+dlist.strings[c-1]+'\',2);
        end;

        currentalbumnum:=1;

        c:=listdirectories(jlist,musicpath+dlist.strings[currentalbumnum-1]+'\',1);
        ss:='';
        for c:=1 to  jlist.count do begin
        ss:=ss+jlist.strings[c-1]+#10+#13;
        end;


        c:=listdirectories(tlist,musicpath+dlist.strings[currentalbumnum-1]+'\',2);
        ss:='';
        for c:=1 to  tlist.count do begin
        ss:=ss+tlist.strings[c-1]+#10+#13;
        end;

       if not FreeImage_Init()  then begin
         messagebox(0,'err','1',0);
         exit;
         end;




        invalidaterect(hwindow,nil,inv);
        playing:=false;


    ShowWindow(hwindow, SW_SHOW);


    ClientToScreen( hwindow,pPoint);
    SetWindowPos(hwindow,HWND_TOPMOST, -pPoint.x,-pPoint.y,1024+40,768+80,SWP_SHOWWINDOW);

    UpdateWindow(hWindow);

    createpanel(hwindow);


       if ( AddFontResource('digital-7 (mono).ttf')=0 ) then
       begin
       messagebox(0,'','g',0);
       end;

        skinbmp:=LoadImage( hInstance,'skin5.bmp',IMAGE_BITMAP,1024,768,LR_LOADFROMFILE);
        if skinbmp=0 then messagebox(0,'','b',0);
        skindc:=createcompatibledc(0);
       selectobject(skindc,skinbmp);


     hwndTask:=FindWindow('Shell_TrayWnd','');
        tempdc:=0;


           songplaying:='';
           songnext:='';
       playlist:= TStringList.Create;
       playnextsong();

              ShowCursor(false);
              setfocus(hwindow);
              SetTimer(hWindow,1,1000,nil);
     while GetMessage(@AMessage,0,0,0) do begin
      	TranslateMessage(AMessage);
    	DispatchMessage(AMessage);
  	end;
        
end.








