'*******************************************************************************
$regfile = "m8def.dat"                                      'ATMEGA8L
$crystal = 4000000                                          '4 MHz internal
$baud = 9600
$lib "single.lbx"
'$sim
'************************** PORT CONFIGURATIONS --******************************
Config Lcd = 16 * 2
Config Lcdbus = 4
Config Lcdmode = Port
Config Lcdpin = Pin , Db4 = Portd.4 , Db5 = Portd.5 , Db6 = Portd.6 , Db7 = Portd.7 , E = Portd.3 , Rs = Portd.2
'*******************************************************************************
Config Com1 = Dummy , Synchrone = 0 , Parity = None , Stopbits = 1 , Databits = 8 , Clockpol = 0
Config Adc = Single , Prescaler = Auto , Reference = Internal
Declare Function Mavgcurrent(byval Z As Single)as Single    'declare function for moving avg window for current
Declare Function Mavgvoltage(byval Zv As Single)as Single   'declare function for moving avg window for voltage
'*******************************************************************************
Config Portb.0 = Output                                     'piezzo buzzer
Config Portc.3 = Output                                     'red LED
Config Pinc.5 = Input                                       'button A
Config Pinc.4 = Input                                       'button B

Config Pinc.0 = Input                                       'current sense input
Config Pinc.1 = Input                                       'voltage sense input
'*******************************************************************************
Dim W As Word , M As Word                                   'for adc 10bit number
Dim X As Single , Y As Single , I As Single , P As Single , Q As Single , V As Single , Pow As Single
Dim K As String * 6 , L As String * 6 , T As String * 6
Dim Xc As Byte

Dim F(15)as Single                                          'array for moving current averages
Dim Sum As Single                                           'sum for current
Dim Fv(15) As Single                                        'array for moving voltage averages
Dim Sumv As Single                                          'sum for voltage
Dim R As Byte                                               'for calculating average of moving average window variables

Dim C As Bit                                                'used in selecting display mode
C = 0
Dim S As Bit                                                'used in enabling serial transmission
S = 0
Dim Up As Byte                                              'used in updating display
Up = 0
'*******************************************************************************
Cursor Off

Startprog:
Reset Portc.3                                               'reset red LED
Cls
Lcd "LOADING"
For Xc = 1 To 16 Step 1
  Locate 2 , Xc
  Lcd ">"
  Waitms 70
Next Xc
Waitms 70
Cls
Lcd "    ABHISHEK"
Lowerline
Lcd " SMART DEVICES!"
Sound Portb.0 , 1000 , 180
Wait 1
Cls
Lcd "  DIGITAL POWER"
Lowerline
Lcd "   SUPPLY v2.0"
Sound Portb.0 , 1000 , 180
Wait 1

Cls
Lcd "CURRENT:"
Lowerline
Lcd "VOLTAGE:"
Locate 1 , 15
Lcd "A "
Locate 2 , 15
Lcd "V "
'***************************** MAIN LOOP ***************************************
Do

If Pinc.5 = 0 Then                                          'button A is pressed(display mode)
    If C = 0 Then
         C = 1
         Sound Portb.0 , 1000 , 180
         Cls
         Lcd "POWER:"
         Locate 1 , 13
         Lcd "Watt"
         Locate 2 , 1
         Lcd "C:"
         Locate 2 , 9
         Lcd "V:"
    Else
         C = 0
         Sound Portb.0 , 1000 , 180
         Cls
         Lcd "CURRENT:"
         Lowerline
         Lcd "VOLTAGE:"
         Locate 1 , 15
         Lcd "A "
         Locate 2 , 15
         Lcd "V "
    End If
End If

If Pinc.4 = 0 Then                                          'button B is pressed(serial enable)
    If S = 0 Then                                           'enable the serial transmission
       Cls
       Lcd "SERIAL  TRANSMIT"
       Lowerline
       Lcd "     ENABLED"

       Sound Portb.0 , 1000 , 180
       S = 1                                                'set serial status flag
       Set Portc.3                                          'enable the red LED
    Else                                                    'disable the serial transmission
       Cls
       Lcd "SERIAL  TRANSMIT"
       Lowerline
       Lcd "    DISABLED"

       Sound Portb.0 , 1000 , 180
       S = 0
       Reset Portc.3                                        'disable the red LED
    End If

    Cls

    If C = 0 Then                                           'recover the display
         Lcd "CURRENT:"
         Lowerline
         Lcd "VOLTAGE:"
         Locate 1 , 15
         Lcd "A "
         Locate 2 , 15
         Lcd "V "
    Else
         Lcd "POWER:"
         Locate 1 , 13
         Lcd "Watt"
         Locate 2 , 1
         Lcd "C:"
         Locate 2 , 9
         Lcd "V:"
    End If
End If

W = Getadc(0)                                               'current
Waitms 2
M = Getadc(1)                                               'voltage
Waitms 2

Y = 0.0025024 * W                                           '0.0025024 = resolution for 10 bit ADC
P = Y \ 1.7                                                 'current sense resistor voltage (1.7 = gain of op-amp)
I = P \ 0.3                                                 'true current through load [R(shunt)=0.3 ohm]
I = Abs(i)
I = Mavgcurrent(i)
K = Fusing(i , "000.&&")

X = 0.0025024 * M                                           '0.0025024 = resolution for 10 bit ADC
Q = X \ 0.0879                                              'voltage acoss main output of LM338
V = Q - P                                                   'true voltage across load after deducing that of shunt drop
V = Abs(v)
V = Mavgvoltage(v)
L = Fusing(v , "000.&&")

Pow = I * V                                                 'calculation of instantaneous power
Pow = Abs(pow)
T = Fusing(pow , "000.&")

If Up = 30 Then                                             'update the display after fixed interval
      Up = 0                                                'release the counter
      If C = 0 Then                                         'only current and voltage
         Locate 1 , 9
         Lcd "      "
         Locate 1 , 9
         Lcd K
         Locate 2 , 9
         Lcd "      "
         Locate 2 , 9
         Lcd L
      Else                                                  'current,voltage and power
         Locate 1 , 7
         Lcd "      "
         Locate 1 , 7
         Lcd T
         Locate 2 , 3
         Lcd "      "
         Locate 2 , 3
         Lcd K
         Locate 2 , 11
         Lcd "      "
         Locate 2 , 11
         Lcd L
      End If

      If S = 1 Then                                         'request for sending acquired data over serial output
         Print "A" ; K ; "B" ; L ; "C" ; T ; "D"
      End If
End If



Incr Up
Loop
End                                                         'end program
'**********************************************************************************************
Function Mavgcurrent(byval Z As Single)as Single            'function for moving averages window for current

'shift the array downward and enter new data on top
F(15) = F(14)
F(14) = F(13)
F(13) = F(12)
F(12) = F(11)
F(11) = F(10)
F(10) = F(9)
F(9) = F(8)
F(8) = F(7)
F(7) = F(6)
F(6) = F(5)
F(5) = F(4)
F(4) = F(3)
F(3) = F(2)
F(2) = F(1)
F(1) = Z                                                    'data entered on top

Sum = 0
For R = 1 To 15 Step 1                                      'calculate sum of all variables
  Sum = Sum + F(r)
Next R

Sum = Sum \ 15                                              'calculate the average
Mavgcurrent = Sum                                           'return the mean value

End Function
'**********************************************************************************************
Function Mavgvoltage(byval Zv As Single)as Single           'function for moving averages window for voltage

'shift the array downward and enter new data on top
Fv(15) = Fv(14)
Fv(14) = Fv(13)
Fv(13) = Fv(12)
Fv(12) = Fv(11)
Fv(11) = Fv(10)
Fv(10) = Fv(9)
Fv(9) = Fv(8)
Fv(8) = Fv(7)
Fv(7) = Fv(6)
Fv(6) = Fv(5)
Fv(5) = Fv(4)
Fv(4) = Fv(3)
Fv(3) = Fv(2)
Fv(2) = Fv(1)
Fv(1) = Zv                                                  'data entered on top

Sumv = 0
For R = 1 To 15 Step 1                                      'calculate sum of all variables
  Sumv = Sumv + Fv(r)
Next R

Sumv = Sumv \ 15                                            'calculate the average
Mavgvoltage = Sumv                                          'return the mean value

End Function
'**********************************************************************************************