/******************************************************
 Digi Test - 4x4
    Basic Testing of any MCU, with attached 4 LEDs  + 4 buttons using only 5 I/O lines (Audio separately optional)
    Test Operations execise Buttons, Leds, timing, interrupts, EEPROM storage   and optionally buzzer &/or speaker
    from: https://www.instructables.com/member/RonM9

 Ron Miller Jan 2018  
*******************************************************/

#include <avr/sleep.h>
//#include "DigiKeyboard.h"

// constants won't change. They're used here to set pin numbers:
// =================  hardware dependant section  ===================
// Changes are done here when components or their configuration chages
// these pin assignments are for AVR MSUs
//bool volHigh = false;   // only useful with speakers, and some passive piezo
// speaker with a sm inline cap. are generally a little louder. (+ provides level isolation)
// but sm inline cap. significantly reduces effect of 'volHigh'

/*************** DigiBoard ATtiny-85 Active HIGH configuration *******************/
//#include "DigiKeyboard.h"
    #define ONBOARD_LED  1
    #define PROBE 0
    const byte BEEPPIN = PB5;
    const int SPEAKERPIN = PB5;
    #define ACTIVE_BUZZER false
    const int button[] = {PB0, PB1, PB2, PB4}; //The four button input pins
    #define PRESSED_STATE 1
    #define BTN_ENB PB3
    const int nleds=4;
    const int lites[]  = {PB0, PB1, PB2, PB4};     //the LED pins
    #define ON_STATE 1
    const byte colorSet[] = { 0, 0x1, 0x2, 0x4, 0x8, 0x0F };

const bool debugPrt=false;
// =====================================================
// Button stuff

bool btnChanged = false;
bool btn1Changed = false;
bool btn2Changed = false;
bool btn3Changed = false;
bool btn4Changed = false;

// made into a function: #define btnPressed (btnChanged && Btn)
#define btn1Pressed (btn1Changed && btn1)
#define btn2Pressed (btn2Changed && btn2)
#define btn3Pressed (btn3Changed && btn3)
#define btn4Pressed (btn4Changed && btn4)

#define  DEBOUNCE_CNT 2
int debounceCnt;
byte btnState = 0, btnNum, priorBtn;
bool btn1 = false;
bool btn2 = false;
bool btn3 = false;
bool btn4 = false;
bool Btn = false; // Buttons collectively
bool ESC = false;
bool time2Escape = false;
int x;

volatile unsigned long myMillis=0; 
unsigned long msec, usecs; 
unsigned int mySecs=0, secsIdle=0;

unsigned int msCnt;
unsigned long t0,t1,t2;
//bool isLit, incDone = false, decDue = false;

int escCnt=0;
unsigned int idleCnt=0, loopCnt;

// =====================================================
//   LED display stuff

bool lit[14], dim[14], brt[14];  // 12 (1-12) plus [0] &[13] for over flow calculations
byte levelOn[14]; // for lighting 0-10 levels
//byte cell[14];  // working buffer
bool dimOn; // true if any led is 'dim' on
int spriteOne, spriteTwo; // mobile hightlights
int heartBeat=0;
int darkOne;      // a mobile dark spot, normally momentary
int spritePtr;    // sprite that is not seen
int cursorPtr;
int litLED=0; // the number of The 'lit' Led
int dimIt=0; // the number of the led to 'dim' off 
int flashLed, blinkLed;
byte allColor=0;  //  0: none, bits: 1:RED, 2:YEL, 3:GRN, 4:BLUE, 5:ALL

byte func, nextFunc;
int algo;
//int Vcc, v3;

/************************ ATtiny 1ms interupt support ***************************/
void timer1_init(void)
{
  // start the timer, prescaler
    TCCR1 = (1<<CTC1)|(7<<CS10);   // CTC  mode, div64
    OCR1C = 0.001 * F_CPU/64 - 1;  // 1ms, F_CPU @16MHz, div64
    TIMSK |= (1<<OCIE1A);
    return;
}

ISR(TIMER1_COMPA_vect)
{
  myMillis++;
  if (myMillis%1000 == 0) { // every 1 second
    if (heartBeat) spriteOne=(spriteOne==0)? heartBeat : 0;
    mySecs++;
    secsIdle++;
  }
  oneMilliUpdate();
}


// the setup routine runs once on power up or when you press reset:
//===============================================================================
void setup() {
  
  // initialize serial communication and its Baud rate
  //Serial.begin(115200);
  //Serial.println("ATtiny_Test_4x4 ");

  pinMode(ONBOARD_LED, OUTPUT);
//  digitalWrite(ONBOARD_LED, HIGH);  also goes to buzz in  this project so don't do this
  pinMode(A0, INPUT);   // used as floating open input for real world generated Randomness
  pinMode(PROBE, INPUT);

  pinMode(BEEPPIN, OUTPUT);  // declare BEEPPIN to be an output:
  digitalWrite(BEEPPIN, LOW);
  pinMode(SPEAKERPIN, OUTPUT);

  if (BTN_ENB!=0) {
    pinMode(BTN_ENB,OUTPUT); 
    digitalWrite(BTN_ENB, !PRESSED_STATE);
  }

  for (int x = 0; x < 4; x++) // Button pins are inputs
  {
    pinMode(button[x], INPUT);  // button pins are inputs
    digitalWrite(button[x], LOW);  // enable internal pull-up; buttons start in high position; negative logic
  }

  for (int x = 0; x < nleds; x++) // LED pins are outputs
  {                               // if buttons & leds
    pinMode(lites[x], OUTPUT);
    digitalWrite(lites[x], (ON_STATE==LOW));  // start w/ LEDs off
  }

  func=1;
  nextFunc=0;
  //nextFunc=2; // ********* if you want to automatically start with a given function set its # here

  delay (100);

//  pinMode(BEEPPIN, OUTPUT);  // declare BEEPPIN to be an output:
  digitalWrite(lites[0], ON_STATE);   beep(60); delay(440);  
  digitalWrite(lites[1], ON_STATE);   Beep(60); delay(440);  
  digitalWrite(lites[2], ON_STATE);   buZZ(40); delay(460); // give a little less as it is more potent
  digitalWrite(lites[3], ON_STATE);   genTone(1600,60);
  delay(1000);
  //  display update should later turn the LEDs back off

  cli();    // Disable interrupts
  // setp ATtiny Timer1 compare based interupt
  timer1_init();
  sei();    // Enable interrupts
  heartBeat=1;
}


// the loop routine runs over and over again forever:
// ===============================================================================
void loop() {
  unsigned int x;
  int pos, lastPos;
  int n=0, cnt=0, cntMax=0;
  bool toggle;
  int dir[4];
  int maxDir, maxSum;
  unsigned int sum;
  int tst[4];
  byte ans, keyCode;
  bool ackd, pause, equal;
  unsigned int mCnt;
  int minCnt;
  byte hits1,hits4;
  bool doit;
  bool btnOccured;
  long pattern;
  byte patcell[14];
  int divr, state;
  int deltaOne, deltaPtr, beet;
  bool gMute;
  byte speed;
  int spdCnt[] = {1000,500,250,100};
  byte maxFunc;
  bool faceoff, flip, doingChallenge;
  

  digitalWrite(ONBOARD_LED, LOW);

  clearDisp();  //  delay(1000);

  while(heartBeat && !Btn) {scanBtns();}  // wait for first button press
  heartBeat=0;
  
  cursorPtr = 0;
  // select a function 1-3
  dim[1]=dim[2]=dim[3]=true;//dim[4]=dim[5]=true;
  spriteOne=func;
  maxFunc=3; // The number of functions to selected from
  
  scanBtns();
  while(Btn) {scanBtns();} // wait for no button

  if (nextFunc) {
    spriteOne = nextFunc;   // use 'spriteOne' as the working selection
    nextFunc = 0;
  } else {
    while (! btn1) {
      delay(5);
      scanBtns();
      if (btn2Pressed) spriteOne = (spriteOne==1)?  nleds : spriteOne-1;  // -- move left
      if (btn3Pressed) spriteOne = (spriteOne%maxFunc) + 1; // ++ moves right
      if (btn4Pressed) spriteOne = (spriteOne%maxFunc) + 1; // allow most play with only 2 buttons (1&4)
      if (escCnt>300) {btnReporting(); return;}
    }
  }

  func = spriteOne;
  clearDisp();
  while(Btn) scanBtns(); // wait for button release

  cnt = 0;
  pause=ackd=false;
  nextFunc = 0;
  //Serial.print(" FUNC: "); //Serial.println(func);
  switch (func) {
    case 1:
      //  =====================================
      btnReporting();
      break;

    case 2:
      //  =====================================
      Scales();
//      VOMeter();
      //pingPong();
      break;

    case 3:
      Timer();
      break;

    case 4:
//      Scales();
      break;

  }  // end of switch structure
  allColor=5;
  Beep(50);

}

// ************************  broke out Functions  *******************************

// ************************   Loops   *******************************

/******/
void btnReporting() {
  short int cnt, aVal, avTemp;

  Beep(100);
  clearDisp();

  priorBtn = -1;  // prevent false double-ESC detection 
  wait_BtnRelease(); // wait for no button
  
  while (1) {
    // highlight any change with the onBrd Led
    digitalWrite(ONBOARD_LED, btnChanged);

    lit[1] = btn1;
    lit[2] = btn2;
    lit[3] = btn3;
    lit[4] = btn4;
//    update_ledDisplay();  // be sure to see a miss key read
    delay(2); // extra time extends ECS timeout peroid (1.5 -> 3 secs)
    // ------------------- button reporting
    if (btnPressed()) {
//      if (btn1) ;//Serial.print("[Btn1] "); else //Serial.print("       ");
//      if (btn2) ;//Serial.print("[Btn2] "); else //Serial.print("       ");
//      if (btn3) ;//Serial.print("[Btn3] "); else //Serial.print("       ");
//      if (btn4) ;//Serial.print("[Btn4] "); else //Serial.print("       ");
      //Serial.println(" ");

      if (time2Escape) {    // new btn pushed while in Esc timeout state
        beep(50);
        clearDisp();
  //      update_ledDisplay();
        while (ESC || Btn) scanBtns();
        return;
      } 
    }
    spriteOne = (ESC)? 4 : 0;
  }
}

/************/
void  Scales()  { //  =====================================   Scales thru Leds and audio levels
  int cnt, dir, lvl;
  bool tomove, waiting;
  byte n, c;

    escCnt=ESC=0;
      while (!ESC) {
        clearDisp();
        lvl=0;
        wait_BtnRelease();
        waiting=true;
        while (!btn4) {  // ------------------- step thru standard set of lights and sound
          delay(1);
          scanBtns();
          if (waiting && !Btn) {
            // ------------- create a 'Waiting' display banner
            n=(myMillis/1000)%nleds;
            //c = (n&1)? 1 : nleds;                 // toogle between 1st and last Led
            //c = (n/(nleds/2)) + 2*(n%4);            // Step thru odd then even Leds
            c =(nleds/2)*(n&1) + (n>>1);             // pop back&fore lower-upper section
            //c = (n&0xFC) + ((n<<1)&2) + ((n>>1)&1);  // reverse the lower two bits, ~ skippy travel
            dimIt=c+1;
          } else {
            dimIt=0;
            waiting=false;
            // lvls: 0=off,  1=dim,  2=lit,  3=brt,  4=flash
            if (btn2Pressed) lvl = (lvl==0)?  4 : lvl-1;  // -- down
            if (btn3Pressed) lvl = (lvl+1) % 5;           // ++ up
            dim[myMillis%nleds+1] = (lvl==1);  // note this is dependant on ISR
            lit[myMillis%nleds+1] = (lvl==2);
            brt[myMillis%nleds+1] = (lvl==3);
            if (lvl==4) {
              for (int i=1; i<=nleds; i++) {  // flash odd & even LEDs in opposition
                lit[i] = (((myMillis/333)%2) == (i&1));
              }
              delay(1);
            }
            
            if (Btn && !btn4) {
              while (Btn && lvl==1) {genTone(150,20); scanBtns();}
              while (Btn && lvl==2) {beep(20); scanBtns();}
              while (Btn && lvl==3) {Beep(20); scanBtns();}
              while (Btn && lvl==4) {buZZ(30); scanBtns();}
            }
            //delay(1);
          }
        }
        
        clearDisp();
        lvl=0;
        if (!ESC) wait_BtnRelease();
        waiting=true;
        while (!btn4) {  // ------------- step thru the scale of tones and levels of lit
          delay(1);
          scanBtns();
          if (waiting && !Btn) {
            n=(myMillis/1000)%4;
            c=((n&1)<<1) + (n>>1);  // reverse the two bits
            litLED = c+1;
          } else {
            litLED=0;
            waiting=false;
            if (btn2Pressed) lvl = (lvl==0)?  10 : lvl-1;  // -- down
            if (btn3Pressed) lvl = (lvl+1) % 11; // ++ up
            levelOn[myMillis%nleds+1]=lvl;
            if ((btnChanged && Btn) || btn1) genTone(200+40*lvl,150);
            //delay(1);
          }
        }

        cnt=1;
        dir=1;      
        clearDisp();
        tomove=true;
        if (!ESC) wait_BtnRelease();
        // ---------------------------   Cylon helmet scan (also interesting would be Kit 2000 grill display)
        while (!btn4) {
            //sweeps a group of LEDs back&forth with a Wiz-a-Wom ...     ~1sec to cross
            // every 1/6 sec move lite, 1st right then left accross display, & appears to overrun
            // hold for 1 counts on the ends, with sweeping noise
          msec=millis(); // use instead of myMilli so as not to be interupt ISR dependant
          if (tomove && (msec%(1000/(nleds))<100))  {  // cadence to result in ~1sec across displ
            tomove=false;
            if (!(cnt<1 || cnt>nleds)) {  // setup 2 cnt pause on ends, special to work with only 4 leds  !!!
              lit[cnt]=lit[cnt+dir]=true;
              //delay(50);          // allow for dim tail
              lit[cnt-dir]=false; //
            }
            cnt=cnt+dir;
            if (cnt<-1) {cnt=1; dir=1;}               // for use to work with 4 leds  !!!
            if (cnt>(nleds+2)) {cnt=nleds; dir=-1;}   //  "
            delay(1);
          }
          if (msec%(1000/(nleds))>100) tomove=true;
          // produce sound of WhiZ-a-woom
          if ((dir==1 && cnt==1)         || (dir<0 && cnt==nleds))      genTone(150,20);  // Wiz
          if ((dir==1 && cnt==2)         || (dir<0 && cnt==(nleds-1)))  genTone(200,20);  // -a-
          if ((dir==1 && cnt>2 && cnt<5) || (dir<0 && cnt>(nleds-4) && cnt<(nleds-1)))  genTone(100,20);  // woom
          scanBtns();
        }
        
        clearDisp();
        if (!ESC) wait_BtnRelease();
        // ---------------------------------  futuristic effect, simplied for space
        while (!btn4) {
          cnt=(cnt+1)%32;
          n = (cnt<16)? cnt : 31-cnt;
          litLED=n%nleds+1;
          genTone(400+100*n, 100);
          delay(1);
          scanBtns();
        }

        if (!ESC) wait_BtnRelease();
      }
}
/*********/

void  Timer()  { //  =====================================   Timer  (+ Stop-Watch functions)
                 // modified to track sets of 15 seconds, for use with a display of only 4 LEDs
  int  pos, minCnt, secs, n;
  bool toggle, timing, paused;
  unsigned int mCnt;
  unsigned long mStart, msecs;

  int ver=1;    // ver 1 uses delay()     ver 2 uses a 1 millisecond ISR interurpt routine

  while (1) {
      clearDisp();
      mStart=myMillis;
      msecs=millis();
      mCnt=0;
      minCnt=0;
      pos=1;
      toggle=false;
      paused=false;
      timing=true;
      while(timing) {
        secsIdle=0; // block Idle timeout
        if (ver==2) {
          while (mCnt == (myMillis-mStart)) {}  // wait for ISR to change 'myMillis'
          mCnt=myMillis-mStart;
        } else {
          while (msecs==millis()) {;}
          msecs++;
          mCnt++;
        }
        //update_ledDisplay();

        scanBtns();
        if (ESC) return;
        if (btn1Pressed) timing=false;    // Restart
        if (btn2Pressed) ver=2;     // switch to ver=2 using the ISR
        if (btn4Pressed) paused= !paused;   // toggle in/out of a paused state
        if (paused) {
          wait_BtnRelease();
          while (paused) {
            secs = mCnt%15000 / 1000; // seconds into this 15 sec period
            if (0==secs) {
              spriteOne = pos;
              noBtnDelay(1000);
            } else {
              for (byte s=1; s<=secs; s++) {
                spriteOne = pos;  noBtnDelay(50);
                spriteOne = 0;  noBtnDelay(200);    
              }
            }
            spriteOne = 0;
            noBtnDelay(1000);   // wait upto  1 sec, given no buttons pressed
            if (btnState>0) {
              paused=false;
              wait_BtnRelease();
            }
          }
        }
        if (time2Escape) return;
        
        if (mCnt%500 == 0) { // once a second lite then noLite then adv the sprite
          toggle = !toggle;
          if (toggle) {
            spriteOne =0;
          } else {
            spriteOne = pos;
          }
        }
          
        if (mCnt%15000 == 0) {    // little beep every 15 seconds
          spriteOne = pos;  // be sure it is lit
          beep(20);
          pos = pos%4 + 1;  // 4*15 for 60secs / Min.
          idleCnt=0;  // keep from timing out
        }
        if (mCnt>=60000) {  // every Minute
          clearDisp();
          mCnt=1;
          minCnt++;   // inc Minute count
          for (n=1; n<=minCnt; n++) {
            dim[n]=true;
            spriteOne = (n-1)%nleds + 1;
            beep(50); delay(300);
          }
          litLED=spriteOne; // add extra brightness on the Led of the current Minute
          pos=1 + mCnt/15000;
        }
      }
  }
}

// ===================================================================================
//        Display Output Processing

// ----------------------
void clearDisp() {
//    allColor=0;
    litLED=0;
    spriteOne = 0;
    spriteTwo = 0;
    darkOne = 0;
    flashLed=0;
    blinkLed=0;
    for (int i=0; i<=nleds; i++) {
      dim[i] =false;
      lit[i]=false;
      brt[i]=false;
      levelOn[i]=0;
    }
}

/*******
// -----------------------
void showLevel(byte level) {
  int n;
  clearDisp();
  for (int i=0; i<level; i++) {
    n = (i%nleds)+1;
    dim[n]=true;
    spriteOne=n;
    delay(100);
  }
  delay(100);
}
****/

//  ---------------------  Display Update  - Needs to be called ~ every One Milli-Second
void oneMilliUpdate() {
  bool on[13];
  int ledSet, ledn, Lite;
  unsigned int ledTime, colorBits;
  int i, n, set;
  bool flashTime, blinkTime;
  
  msCnt++;
  
  for (i=1; i<=nleds; i++) on[i]=0; // init working array

  // ------------- as called for, Light all Leds prepesented by bits
//  if (allColor != 0) {
//      colorBits = colorSet[allColor];
//      for (i=0; i<nleds; i++) {
//        on[i+1] = (colorBits>>i) & 1;
//      }
//  } else 
  {

    // -------------- determine which Leds its time to illuminate
    ledTime = msCnt;
    if (ledTime%9 == 0) {                 // 1/9 cadence time to show 'dim'
      for (i=1; i<=nleds; i++) {on[i]=dim[i];}
      on[dimIt]= !on[dimIt];  // if off make it dim, if dim make it off
    } else if (ledTime%3 == 1) {          // 1/3 of the time process 'lit'
      for (i=1; i<=nleds; i++) on[i]=lit[i];
      on[litLED] = true;
    }
    for (i=1; i<=nleds; i++) {  // provide for lighting of 0-10 levels 
      if (levelOn[i]>(ledTime%10)) on[i]=true;
    }
    
    for (i=1; i<=nleds; i++) if (brt[i]) on[i]=true;
    on[spriteOne] = true;
    on[spriteTwo] = true;
    on[darkOne] = false;
    flashTime = ((msCnt%500) < 200);  // 150ms out of 500ms turn it on
    if (flashTime && flashLed) on[flashLed] = !on[flashLed];

    blinkTime = (mySecs%2);  // every other second flash the led, otherwise leave it be
    if (blinkTime && blinkLed) on[blinkLed] = flashTime;
  }
  
  // -------------- drive the resulting Leds of interest
  for (i=0; i<nleds; i++) {
    ledn = i+1;
    Lite = lites[i];
    digitalWrite(Lite, (on[ledn]==ON_STATE));
  }
}


// ===================================================================================
//        Button Input Processing

bool btnPressed() {
  scanBtns();
  return(btnChanged && Btn);
}

void noBtnDelay(int msec) {
  while (!Btn && msec-->0) {
    delay(1);
    scanBtns();
  }
}

void wait_BtnRelease() {
  escCnt=0;
  while (btnState!=0 || btnChanged) {  // cares about keys except FuncKey
    delay(1);
    scanBtns();
    if (ESC) return;
  }
  escCnt=0;
  ESC=time2Escape=false;
}

void scanBtns() { // -----------------  main Button processing
  bool b1,b2,b3,b4;
  byte i,k;
  byte currState;

  if (secsIdle>5*60) { // every 5 mins.
    secsIdle=0;
    beep(100); beep(100); // say HEY! Don't forget me
  }
  btnChanged = btn1Changed = btn2Changed = btn3Changed = btn4Changed = false;

  currState=-1;
  debounceCnt = 0;
  while (currState!=btnState && (++debounceCnt<=DEBOUNCE_CNT)) {
    if (debounceCnt>1)   delayMicroseconds(500);
    if (BTN_ENB!=0) {
      // ----- setup for button reading
      cli();
      digitalWrite(BTN_ENB, PRESSED_STATE);
      pinMode(button[0], INPUT); pinMode(button[1], INPUT); pinMode(button[2], INPUT); pinMode(button[3], INPUT); 
      b1 = PRESSED_STATE == digitalRead(button[0]);  // read the button inputs
      b2 = PRESSED_STATE == digitalRead(button[1]);
      b3 = PRESSED_STATE == digitalRead(button[2]);
      b4 = PRESSED_STATE == digitalRead(button[3]);
      pinMode(button[0], OUTPUT); pinMode(button[1], OUTPUT); pinMode(button[2], OUTPUT); pinMode(button[3], OUTPUT);
      digitalWrite(BTN_ENB, 0==PRESSED_STATE);  // ----- Undo setup for button reading
      sei();    // Enable interrupts
      
    } else {
      b1 = PRESSED_STATE == digitalRead(button[0]);  // read the button inputs
      b2 = PRESSED_STATE == digitalRead(button[1]);
      b3 = PRESSED_STATE == digitalRead(button[2]);
      b4 = PRESSED_STATE == digitalRead(button[3]);
    }
//    currState = (((b4<1 + b3)<1) + b2)<1 + b1;  //  does not work with type 'bool'
    currState = (b1)? 1:0;
    if (b2) currState += 2;   // encode btn #s, so any combination is unique
    if (b3) currState += 4;
    if (b4) currState += 8;
  }

  
  if (currState != btnState) {  // the 'button state' has changed
      secsIdle=0;
      debounceCnt = 0;
      priorBtn = btnState;
      btnState = currState;
      btnChanged=true;
  
      btnNum = (b1)? 1 : ((b2)? 2 : ((b3)? 3 : ((b4)? 4 : 0)));  // logical button # (1-4)  // assumes only 1 btn pressed
      Btn = b1 || b2 || b3 || b4;
      if(b1 != btn1) {btn1 = b1; btn1Changed = true;}
      if(b2 != btn2) {btn2 = b2; btn2Changed = true;}
      if(b3 != btn3) {btn3 = b3; btn3Changed = true;}
      if(b4 != btn4) {btn4 = b4; btn4Changed = true;}
  }
  if (btn4) escCnt++;
  else if (!btnChanged) escCnt=0;
  
  ESC = (escCnt>1500);  // takes <2secs given Btns check ~ every msec
  time2Escape = ESC;
}

// ===================================================================================
//        Audio Output Processing

void beep(int delayms){  // works for both Buzzers & Speakers
  for (int i=0; i<delayms; i++) {         // wait for a delayms ms
    digitalWrite ( BEEPPIN, HIGH); 
    delayMicroseconds(500);    
    digitalWrite ( BEEPPIN, LOW);
    delayMicroseconds(500);
  }
}  

void Beep(unsigned short int delayms){  // higher freq & longer dury cycle
  delayms = 2 * delayms / 3;
  for (int i=0; i<delayms; i++) {         // wait for a delayms ms
    digitalWrite ( BEEPPIN, HIGH); 
    delayMicroseconds(666);    
    digitalWrite ( BEEPPIN, LOW);
    delayMicroseconds(333);
    digitalWrite ( BEEPPIN, HIGH); 
    delayMicroseconds(333);    
    digitalWrite ( BEEPPIN, LOW);
    delayMicroseconds(166);
  }
  digitalWrite ( BEEPPIN, LOW);;
}


void buZZ(int msec){
  if (ACTIVE_BUZZER) {  // sound the Buzzer, works with true 'active' Buzzers only
    digitalWrite ( BEEPPIN, HIGH);
    delay(msec);
    digitalWrite ( BEEPPIN, LOW);
  } else {      // fake buzzer, uses more time to replace the punch of a real BuZZer
    //genTone(1400,2*msec);
    genTone(1200,msec/2);  genTone(1250,msec);
    // BEST ? ...
    //genTone(1200,msec/2);   genTone(1150,msec/2);  genTone(1250,msec/2);
    //speakerBuzz(2*msec);  // more advanced buZZer simulation
  }
}


// ---------------------  tone() type Audio Output
//                        true tone audio with a Speaker;  fine with Passive buzzer
//                        only almost, sort of, ok with Active Buzzer, due to Moiré interference patterns

//   Generate Tone frequencies with out using "tone()" (saving 1500 program bytes & 21 ram bytes) 
//     sounding almost as good
void genTone(int toneVal, int delayms){       // Generate a specified TONE
  byte pinState = 0;       // 0 turns it off

  if (toneVal==0) {delay(delayms); return;}
  pinMode(SPEAKERPIN, OUTPUT);

  int msCnt = ( (long) delayms * toneVal) / 1000;
  for (int i=0; i<(2*msCnt); i++) {         // wait for a delayms ms
//    if (volHigh) digitalWrite ( SPEAKERNEG, pinState); // set NEG lead to opposite of + lead
    pinState = 1 - pinState;
    digitalWrite ( SPEAKERPIN, pinState); 
    delayMicroseconds((1000000L/toneVal)/2);
    //update_ledDisplay();  
  }
  digitalWrite ( SPEAKERPIN, LOW);
//  digitalWrite ( SPEAKERNEG, LOW);
}

