$fn=30;

//=================================================
// MAGIC BUTTON - 2017 ALLAN MURRAY
// PARAMETERS:

DOBASE=1; //=1 to generate base
DOSHELL=0;//=1 to generate shell
DOSCREW_HOLES=0;//=1 for mouning holes in base

WIDTH=38; //Minimum 38mm
SIDE_EDGE_RADIUS=6;  //Minimun=WIDTH/2 (=round)
TOP_EDGE_RADIUS=2.9;  //Must be < SIDE_EDGE_RADIUS/2
LED_ANGLE=0; //=0 LED points horizontally

//=================================================

// BEST NOT TO CHANGE THESE:
w=WIDTH;
d=WIDTH;
h=20; //Height 
rw=SIDE_EDGE_RADIUS;
rh=TOP_EDGE_RADIUS;
r=4;
wall=1.5; //Shell wall thickness

w2=w-2*wall;
d2=d-2*wall;
rw2=rw-wall;

w3=w-2*(wall+0.5);
d3=d-2*(wall+0.5);
rw3=rw-(wall+0.5);


if (DOSHELL==1) {//SHELL----

difference(){
translate([0,0,-h]) 
difference()
 
    {
   
translate([-w/2+rw,-d/2+rw,0]) 
        
        
hull() {
for (i=[0:3])
translate([(i % 2) * (w-2*rw), (i - i % 2) * (d/2-rw), 0]) {
cylinder(r=rw, h=1);
translate([0, 0, h-rh]) 
rotate_extrude()
translate([rw-rh, 0, 0])
circle(r = rh);
}
}
 
cylinder(r1=13,r2=14.8, h=21);
 
 

translate([0,0,((h-wall)/2-0.1)-11.1]) 
union(){
cube([w2-(2*rw2),d2,h-wall],true);
cube([w2,d2-(2*rw2),h-wall],true); 
    
translate([d2/2-rw2,w2/2-rw2,-(h-wall)/2])    
cylinder(r=rw2, h=h-wall);   
   
translate([d2/2-rw2,-(w2/2-rw2),-(h-wall)/2])    
cylinder(r=rw2, h=h-wall); 
    
translate([-(d2/2-rw2),-(w2/2-rw2),-(h-wall)/2])    
cylinder(r=rw2, h=h-wall);   
    
translate([-(d2/2-rw2),(w2/2-rw2),-(h-wall)/2])    
cylinder(r=rw2, h=h-wall);     
}

}



rotate([0,0,0])
translate([0,0,-12]) 
import("pcb.stl");


rotate([0,00,0])
translate([12,0,-12])
rotate([0,90-LED_ANGLE,0])
cylinder(r=3,h=d);

}




translate([0,-(w/2-2.25-wall+0.9),-h+1.5]) 
difference(){
 translate([0,0,5]) 
cube([10,4.5,10],true);
 translate([0,0,0.9]) 
cube([8.5,3.5,2],true);
}

translate([0,w/2-2.25-wall+0.9,-h+1.5]) 
difference(){
 translate([0,0,5]) 
cube([10,4.5,10],true);
 translate([0,0,0.9]) 
cube([8.5,3.5,2],true);
}


}//---SHELL


if (DOBASE==1) {//---BASE

 
//BASE INNER---
translate([0,0,-(h+0.5)+0.9]) 
union(){
difference(){
union(){
cube([w3-(2*rw3),d3,1],true);
cube([w3,d3-(2*rw3),1],true);  
  
translate([d3/2-rw3,w3/2-rw3,-0.5])    
cylinder(r=rw3, h=1);   
   
translate([d3/2-rw3,-(w3/2-rw3),-0.5])    
cylinder(r=rw3, h=1); 
    
translate([-(d3/2-rw3),-(w3/2-rw3),-0.5])    
cylinder(r=rw3, h=1);   
    
translate([-(d3/2-rw3),(w3/2-rw3),-0.5])    
cylinder(r=rw3, h=1); 
  
//BASE---
translate([0,0,-1]) 
union(){
cube([w-(2*rw),d,1],true);
cube([w,d-(2*rw),1],true);  
  
translate([d/2-rw,w/2-rw,-0.5])    
cylinder(r=rw, h=1);   
   
translate([d/2-rw,-(w/2-rw),-0.5])    
cylinder(r=rw, h=1); 
    
translate([-(d/2-rw),-(w/2-rw),-0.5])    
cylinder(r=rw, h=1);   
    
translate([-(d/2-rw),(w/2-rw),-0.5])    
cylinder(r=rw, h=1);      
}
//---BASE
}

if (DOSCREW_HOLES==1) {
translate([-(d3/2-3),-(w3/2-3),-5])    
cylinder(r=1.5, h=10); 
translate([(d3/2-3),(w3/2-3),-5])    
cylinder(r=1.5, h=10); 
}

 translate([0,0,1.5])
 cube([26,26,4],true);
}


 translate([-(1+5.5),w3/2-wall-0.5,0])
cube([2,4,2.5],true);
 translate([1+5.5,w3/2-wall-0.5,0])
cube([2,4,2.5],true);
 
 translate([-(1+5.5),-(w3/2-wall-0.5),0])
cube([2,4,2.5],true);
 translate([1+5.5,-(w3/2-wall-0.5),0])
cube([2,4,2.5],true);

rotate([0,0,-22.5+180+90+90])
translate([0,1.5+10,-0.1])
cube([2,3,1],true);

rotate([0,0,-22.5+180+90])
translate([0,1.5+10,-0.1])
cube([2,3,1],true);

rotate([0,0,-22.5+180])
translate([0,1.5+10,-0.1])
cube([2,3,1],true);

}
//---BASE INNER


}//---BASE

 
 
