//Laptop Control Box 
//- Code written by Carl Gordon, 12/2/17
//Code listens to signals sent from an Arduino circuit over serial usb connection.

PImage BG;
PImage squares;
//app icons
PImage defaultIcon;

//6 SOFTWARE STATES
//TOOL ICONS
PImage PS, Sublime, Processing, Sip, Github, Arduino;
//BROWSER ICONS
PImage Firefox, Youtube, Stuff, Weather, Google;
//MEDIA ICONS
PImage Spotify, Series, Steam, Netflix;
//UTILITY ICONS
PImage Terminal, Calculator, LaunchPad, Launcher,volumePlus,volumeMinus;
//SOCIAL ICONS
PImage Messenger, Quora, Instructables, Gmail;
//LIFESTYLE ICONS
PImage Calendar, FocusMatrix, Stickies, Evernote;
//image push
float push1;
float push2;
float push3;
float push4;

//softstate tells us which of the 6 states the software is currently in
String softstate;
int shuffle=0;

int toolshuffle=0;

int colDrive=0;
int[] myColors = { 1, 2, 3, 4, 5, 6 };
//
import processing.serial.*;

Serial myPort;  // Create object from Serial class
//val is the number recieved from the Arduino
//1= top left button
//2= top right button
//3= bottom left button
//4= bottom right button
//5= Side toggle button
//val is initialized as 0
int val=0;      // Data received from the serial port
//
void setup() {
  //frameRate(24);
  size(720, 540);
  background(0);

  //ARDUINO CONNECTION
  //My Laptop reads the Arduino on Serial.list()[5] but yours may be different
  String portName = Serial.list()[5];
  myPort = new Serial(this, portName, 9600);
  //Load all images
  BG = loadImage("BG2.jpg");
  //ICONS
  defaultIcon = loadImage("default_Icon.png");
  squares = loadImage("squares.png");
  //tools
  Sip = loadImage("sip_Icon.png");
  PS = loadImage("PS_Icon.png");
  Sublime = loadImage("sublime_Icon.png");
  Processing = loadImage("Processing_Icon.png");
  Github = loadImage("github_Icon.png");
  Arduino= loadImage("arduino_Icon.png");
  //media
  Spotify = loadImage("spotify_Icon.png");
  Series = loadImage("series_Icon.png");
  Steam = loadImage("steam_Icon.png");
  Netflix = loadImage("netflix_Icon.png");
  //browser
  Firefox = loadImage("firefox_Icon.png");
  Youtube=loadImage("youtube_Icon.png");
  Stuff=loadImage("stuff_Icon.png");
  Weather=loadImage("weather_Icon.png");
  Google=loadImage("google_Icon.png");
  //utility
  Terminal = loadImage("terminal_Icon.png");
  LaunchPad = loadImage("launchpad_Icon.png");
  Launcher = loadImage("launcher_Icon.png");
  Calculator = loadImage("calculator_Icon.png");
  volumePlus = loadImage("volumeplus_Icon.png");
  volumeMinus = loadImage("volumeminus_Icon.png");
  //social
  Quora=loadImage("quora_Icon.png");
  Gmail=loadImage("gmail_Icon.png");
  Messenger = loadImage("messenger_Icon.png");
  Instructables=loadImage("instructables_Icon.png");
  //lifestyle
  Evernote = loadImage("evernote_Icon.png");
  Calendar = loadImage("calendar_Icon.png");
  FocusMatrix = loadImage("focusmatrix_Icon.png");
  Stickies = loadImage("stickies_Icon.png");
}
void draw() {

  if ( myPort.available() > 0) {  // If data is available,
    val = myPort.read();         // read it and store it in val
  }
  //Center all images
  imageMode(CENTER);
  rectMode(CENTER);

  //Place Background
  image(BG, mouseX, mouseY);
  //Place squares
  image(squares, width/2, height/2);

  //Icon placements
  //left column
  int col_X = 275;
  int col_Y1 = 185;
  int col_Y2 = 355;
  //right column
  int col2_X = 448;
  int col2_Y1 = 185;
  int col2_Y2 = 355;

  //SHUFFLE protocol - arduino
  //Increment shuffle by 1 everytime the side button is pressed
  if (val==5) {
    shuffle+=1;
  }
  //reset shuffle to 0 if it exceeds 5
  if (shuffle>5) {
    //reset shuffle
    shuffle=0;
  }
  colDrive = myColors [shuffle];

  if (push1>=10) {
    push1=0;
  }
  if (push2>=10) {
    push2=0;
  }
  if (push3>=10) {
    push3=0;
  }
  if (push4>=10) {
    push4=0;
  }

  //push drive
  if (val==1) {
    push1+=10;
  }
  if (val==2) {
    push2+=10;
  }
  if (val==3) {
    push3+=10;
  }
  if (val==4) {
    push4+=10;
  }

  //state decoder

  if (colDrive==1) {
    //toolswitch
    toolSwitch(width/2, height-60);
    //SOFTWARES SHOW TOOL APPS
    if (toolshuffle==0) {
      softstate="Tools - Web Design";
      //set 1 - Web Design
      //left
      image(Firefox, col_X, col_Y1, 100+push1, 100+push1);
      image(Sip, col_X, col_Y2, 100+push3, 100+push3);
      //right
      image(Sublime, col2_X, col2_Y1, 100+push2, 100+push2);
      image(Terminal, col2_X, col2_Y2, 100+push4, 100+push4);

      //launch protocol - arduino
      if (val==1) {
        launch("/Applications/Firefox.app");
      }
      if (val==2) {
        launch("/Applications/Sublime Text.app");
      }
      if (val==3) {
        launch("/Applications/Sip.app");
      }
      if (val==4) {
        launch("/Applications/Utilities/Terminal.app");
      }

      //end TOOL APPS
    } else {
      softstate="Tools 2 - Product Design";
      //set 1 - Product Design
      //left
      //arduino
      image(Processing, col_X, col_Y1, 100+push1, 100+push1);
      //sketch up
      image(Github, col_X, col_Y2, 100+push3, 100+push3);
      //right
      //123D
      image(PS, col2_X, col2_Y1, 100+push2, 100+push2);
      //meshmixer
      image(Arduino, col2_X, col2_Y2, 100+push4, 100+push4);

      //launch protocol - arduino
      if (val==1) {
        launch("/Applications/Processing.app");
      }
      if (val==2) {
        launch("/Applications/Adobe Photoshop Elements 10/Adobe Photoshop Elements 10");
      }
      if (val==3) {
        launch("/Applications/GitHub Desktop.app");
      }
      if (val==4) {
        launch("/Applications/Arduino.app");
      }

      //end TOOL APPS
    }
  }
  if (colDrive==2) {
    softstate="Media";
    //SOFTWARES SHOW MEDIA APPS
    //set 2 - Media Apps
    //left
    image(Spotify, col_X, col_Y1, 100+push1, 100+push1);
    image(Steam, col_X, col_Y2, 100+push3, 100+push3);
    //right
    image(Series, col2_X, col2_Y1, 100+push2, 100+push2);
    image(Netflix, col2_X, col2_Y2, 100+push4, 100+push4);

    //launch protocol - arduino
    if (val==1) {
      launch("/Applications/Spotify.app");
    }
    if (val==2) {
      launch("/Users/macuser/Documents/Series");
    }
    if (val==3) {
      launch("/Applications/Steam.app");
    }
    if (val==4) {
      link("https://www.netflix.com/nz/");
    }

    //end Media Apps
  }
  if (colDrive==3) {
    softstate="Browser";
    //SOFTWARES SHOW Browser APPS

    //set 3 - Browser
    //left
    image(Google, col_X, col_Y1, 100+push1, 100+push1);
    image(Stuff, col_X, col_Y2, 100+push3, 100+push3);
    //right
    image(Youtube, col2_X, col2_Y1, 100+push2, 100+push2);
    image(Weather, col2_X, col2_Y2, 100+push4, 100+push4);
    //launch protocol - arduino
    if (val==1) {
      link("https://www.google.co.nz/");
    }
    if (val==2) {
      link("https://www.youtube.com/");
    }
    if (val==3) {
      link("http://www.stuff.co.nz/");
    }
    if (val==4) {
      launch("/Applications/Weather Live Free.app");
      //link("http://www.metservice.com/national/home?gclid=CJ7F_ID9h9ICFRVxvAod29sErg");
    }

    //end Browser Apps
  }
  if (colDrive==4) {
    softstate="Utility";
    //SOFTWARES SHOW Utilities

    //set 4 - Utility
    //left
    image(volumeMinus, col_X, col_Y1, 100+push1, 100+push1);
    image(Calculator, col_X, col_Y2, 100+push3, 100+push3);
    //right
    image(volumePlus, col2_X, col2_Y1, 100+push2, 100+push2);
    image(LaunchPad, col2_X, col2_Y2, 100+push4, 100+push4);

    //launch protocol - arduino
    if (val==1) {
      launch("/Applications/LowVolume.app");
    }
    if (val==2) {
      launch("/Applications/MaxVolume.app");
    }
    if (val==3) {
      launch("/Applications/Calculator.app");
      //launch("/Applications/LowVolume.app");
    }
    if (val==4) {
      launch("/Applications/Launchpad.app");
    }
    //end Utility Apps
  }
  if (colDrive==5) {
    softstate="Social";
    //SOFTWARES SHOW Social

    //set 5 - Social
    //left
    image(Gmail, col_X, col_Y1, 100+push1, 100+push1);
    image(Instructables, col_X, col_Y2, 100+push3, 100+push3);
    //right
    image(Messenger, col2_X, col2_Y1, 100+push2, 100+push2);
    image(Quora, col2_X, col2_Y2, 100+push4, 100+push4);

    //launch protocol - arduino
    if (val==1) {
      link("https://mail.google.com/mail/u/0/#inbox");
    }
    if (val==2) {
      launch("/Applications/FreeChat for Facebook Messenger.app");
    }
    if (val==3) {
      link("https://www.instructables.com/");
    }
    if (val==4) {
      link("https://www.quora.com/");
    }
    //end Social Apps
  }
  if (colDrive==6) {
    softstate="Lifestyle";
    //SOFTWARES SHOW Lifestyle

    //set 6 - Lifestyle
    //left
    image(Calendar, col_X, col_Y1, 100+push1, 100+push1);
    image(Stickies, col_X, col_Y2, 100+push3, 100+push3);
    //right
    image(FocusMatrix, col2_X, col2_Y1, 100+push2, 100+push2);
    image(Evernote, col2_X, col2_Y2, 100+push4, 100+push4);

    //launch protocol - arduino
    if (val==1) {
      link("https://calendar.google.com/calendar/render?pli=1#main_7");
    }
    if (val==2) {
      launch("/Applications/Focus Matrix.app");
    }
    if (val==3) {
      launch("/Applications/Stickies.app");
      //launch("/Applications/LowVolume.app");
    }
    if (val==4) {
      launch("/Applications/Evernote.app");
    }
    //end Lifestyle Apps
  }
  //
  //println(myColors[shuffle]);
  println(softstate);
  //saveFrame("Movie/frame-######.png");

  //println("X "+mouseX);
  //println("Y "+mouseY);
}
void toolSwitch(int x, int y) {
  noStroke();

  //Toolset 1
  if (keyPressed) {
    if (key=='1') {
      toolshuffle=0;
    }
  }
  if (mouseX>312 && mouseX<362) {
    if (mouseY>469 && mouseY<499) {
      if (mousePressed) {
        toolshuffle=0;
      }
    }
  }
  if (toolshuffle==0) {
    fill(0, 80);
  } else {
    fill(255);
  }
  rect(x, y, 100, 30);

  //Toolset 2
  if (keyPressed) {
    if (key=='2') {
      toolshuffle=1;
    }
  }
  if (mouseX>362 && mouseX<411) {
    if (mouseY>469 && mouseY<499) {
      if (mousePressed) {
        toolshuffle=1;
      }
    }
  }
  if (toolshuffle==1) {
    fill(0, 80);
  } else {

    fill(255);
  }

  rect(x+25, y, 50, 30);
}