#include <L293.h>
//L293(pinLeftMotorFwd, pinLeftMotorBak, pinLeftMotorVel, pinRightMotorFwd, pinRightMotorBak, pinRightMotorVel);
L293 follower(9,10,5,11,12,6);
//forward(leftMotorVelocity,rightMotorVelocity);

/*
                                         ______________
                                        |     |__|     | 
  LEFT MOTOR VELOCITY(pinLeftMotorVel) [| 1         16 |] LOGIC VCC(+5V)
                                        |              |
   LEFT MOTOR FORWARD(pinLeftMotorFwd) [| 2         15 |] RIGHT MOTOR FORWARD(pinRightMotorFwd) 
                                        |              |  
                     LEFT MOTOR WIRE 1 [| 3    L    14 |] RIGHT MOTOR WIRE 1
                                        |      2       |   
                                   GND [| 4    9    13 |] GND
                                        |      3       |                  
                                   GND [| 5         12 |] GND
                                        |              |                 
                     LEFT MOTOR WIRE 2 [| 6         11 |] RIGHT MOTOR WIRE 2
                                        |              |   
      LEFT MOTOR BACK(pinLeftMotorBak) [| 7         10 |] RIGHT MOTOR BACK(pinRightMotorBak)
                                        |              |     
                            MOTORS VCC [| 8          9 |] RIGHT MOTOR VELOCITY(pinRightMotorVel)
                                        |______________|
*/

int velocityFast = 255;
int velocitySlow = 150;

void setup() {

}

void loop() {  
  follower.forward_2W(velocitySlow,velocitySlow);
  delay(1000);
  follower.setSpeeds_2W(velocitySlow,velocitySlow);
  delay(1000);
  follower.setSpeedLeft_2W(velocityFast);
  delay(1000);
  follower.setSpeedRight_2W(velocityFast);
  delay(1000);
  follower.back_2W(velocitySlow,velocitySlow);  
  delay(1000); 
  follower.setSpeeds_2W(velocitySlow,velocitySlow);
  delay(1000);
  follower.setSpeedLeft_2W(velocityFast);
  delay(1000);
  follower.setSpeedRight_2W(velocityFast);
  delay(1000);  
  follower.rotateLeft_2W(velocitySlow,velocitySlow); 
  delay(1000);  
  follower.rotateRight_2W(velocitySlow,velocitySlow);
  delay(1000);  
  follower.stopped_2W();
  delay(2000);    
}

