/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5;
import controlP5.ControlP5XMLElement;
import controlP5.Controller;
import controlP5.ControllerDisplay;
import controlP5.ControllerGroup;
import processing.core.PApplet;

public class Knob
extends Controller {
    protected float _myDiameter;
    protected float _myRadius;
    protected float myAngle;
    protected float startAngle;
    protected float range;
    protected float resolution = 200.0f;
    protected int _myTickMarksNum = 8;
    protected boolean isShowTickMarks;
    protected boolean isSnapToTickMarks;
    protected int myTickMarkLength = 2;
    protected float myTickMarkWeight = 2.0f;
    protected boolean isShowRange = true;
    protected boolean isActive;
    protected float currentValue;
    protected float previousValue;
    protected float modifiedValue;
    protected boolean isLimited;
    protected int _myDragDirection = 0;
    protected int displayStyle = 1;

    public Knob(ControlP5 controlP5, ControllerGroup controllerGroup, String string, float f, float f2, float f3, int n, int n2, int n3) {
        super(controlP5, controllerGroup, string, n, n2, n3, n3);
        this._myValue = f3;
        this.setMin(f);
        this.setMax(f2);
        this._myDiameter = n3;
        this._myRadius = this._myDiameter / 2.0f;
        this._myUnit = (this._myMax - this._myMin) / ((float)Math.PI * 2);
        this.startAngle = 2.3561945f;
        this.range = 4.712389f;
        this.myAngle = this.startAngle;
        this.isLimited = true;
    }

    public void setStartAngle(float f) {
        this.startAngle = f;
        this.setInternalValue(this.modifiedValue);
    }

    public float getStartAngle() {
        return this.startAngle;
    }

    public void setRange(float f) {
        this.range = f;
        this.setInternalValue(this.modifiedValue);
    }

    public float getRange() {
        return this.range;
    }

    public void setDragDirection(int n) {
        this._myDragDirection = n == 0 ? 0 : 1;
    }

    public int getDragDirection() {
        return this._myDragDirection;
    }

    public void setResolution(float f) {
        this.resolution = f;
    }

    public float getResolution() {
        return this.resolution;
    }

    public void setNumberOfTickMarks(int n) {
        this._myTickMarksNum = n;
    }

    public void showTickMarks(boolean bl) {
        this.isShowTickMarks = bl;
    }

    public void snapToTickMarks(boolean bl) {
        this.isSnapToTickMarks = bl;
    }

    public void setTickMarkLength(int n) {
        this.myTickMarkLength = n;
    }

    public void setTickMarkWeight(float f) {
        this.myTickMarkWeight = f;
    }

    public void updateInternalEvents(PApplet pApplet) {
        if (this.isMousePressed && !ControlP5.keyHandler.isAltDown && this.isActive) {
            float f = this._myDragDirection == 0 ? (float)(this._myControlWindow.mouseX - this._myControlWindow.pmouseX) : (float)(this._myControlWindow.mouseY - this._myControlWindow.pmouseY);
            this.currentValue += f / this.resolution;
            if (this.isLimited) {
                this.currentValue = PApplet.constrain((float)this.currentValue, (float)0.0f, (float)1.0f);
            }
            this.setInternalValue(this.currentValue);
        }
    }

    protected void onEnter() {
        this.isActive = true;
    }

    protected void onLeave() {
        this.isActive = false;
    }

    public void mousePressed() {
        float f;
        float f2 = this._myParent.absolutePosition().x() + this.position().x() + this._myRadius;
        if (PApplet.dist((float)f2, (float)(f = this._myParent.absolutePosition().y() + this.position().y() + this._myRadius), (float)this._myControlWindow.mouseX, (float)this._myControlWindow.mouseY) < this._myRadius) {
            this.isActive = true;
            if (PApplet.dist((float)f2, (float)f, (float)this._myControlWindow.mouseX, (float)this._myControlWindow.mouseY) > this._myRadius / 2.0f) {
                this.myAngle = PApplet.atan2((float)((float)this._myControlWindow.mouseY - f), (float)((float)this._myControlWindow.mouseX - f2)) - this.startAngle;
                if (this.myAngle < 0.0f) {
                    this.myAngle = (float)Math.PI * 2 + this.myAngle;
                }
                if (this.isLimited) {
                    this.myAngle %= (float)Math.PI * 2;
                }
                this.currentValue = PApplet.map((float)this.myAngle, (float)0.0f, (float)this.range, (float)0.0f, (float)1.0f);
                this.setInternalValue(this.currentValue);
            }
        }
    }

    public void mouseReleased() {
        this.isActive = false;
    }

    public void mouseReleasedOutside() {
        this.mouseReleased();
    }

    public void setMin(float f) {
        this._myMin = f;
    }

    public void setMax(float f) {
        this._myMax = f;
    }

    protected void setInternalValue(float f) {
        this.modifiedValue = this.isSnapToTickMarks ? (float)PApplet.round((float)(f * (float)this._myTickMarksNum)) / (float)this._myTickMarksNum : f;
        this.currentValue = f;
        this.myAngle = PApplet.map((float)(this.isSnapToTickMarks ? this.modifiedValue : this.currentValue), (float)0.0f, (float)1.0f, (float)this.startAngle, (float)(this.startAngle + this.range));
        if (this.isSnapToTickMarks && this.previousValue != this.modifiedValue && this.isSnapToTickMarks) {
            this.broadcast(1);
            this.previousValue = this.modifiedValue;
            return;
        }
        if (this.previousValue != this.currentValue) {
            this.broadcast(1);
            this.previousValue = this.modifiedValue;
        }
    }

    public void setValue(float f) {
        this.setInternalValue(PApplet.map((float)f, (float)this._myMin, (float)this._myMax, (float)0.0f, (float)1.0f));
    }

    public float value() {
        this._myValue = PApplet.map((float)(this._myTickMarksNum > 0 ? this.modifiedValue : this.currentValue), (float)0.0f, (float)1.0f, (float)this._myMin, (float)this._myMax);
        return this._myValue;
    }

    public void update() {
        this.setValue(this._myValue);
    }

    public void setOffsetAngle(float f) {
        this.setStartAngle(f);
    }

    public void addToXMLElement(ControlP5XMLElement controlP5XMLElement) {
        controlP5XMLElement.setAttribute("type", "knob");
        controlP5XMLElement.setAttribute("min", new Float(this.min()));
        controlP5XMLElement.setAttribute("max", new Float(this.max()));
    }

    public void setDisplayStyle(int n) {
        this.displayStyle = n;
    }

    public void updateDisplayMode(int n) {
        this._myDisplayMode = n;
        switch (n) {
            case 0: {
                this._myDisplay = new KnobDisplay();
                break;
            }
            case 1: 
            case 2: {
                this._myDisplay = new KnobDisplay();
                break;
            }
        }
    }

    class KnobDisplay
    implements ControllerDisplay {
        KnobDisplay() {
        }

        public void display(PApplet pApplet, Controller controller) {
            pApplet.translate(Knob.this._myRadius, Knob.this._myRadius);
            pApplet.pushMatrix();
            pApplet.pushStyle();
            pApplet.ellipseMode(3);
            pApplet.noStroke();
            pApplet.fill(Knob.this.color().colorBackground);
            pApplet.ellipse(0.0f, 0.0f, Knob.this._myRadius * 2.0f, Knob.this._myRadius * 2.0f);
            pApplet.popMatrix();
            pApplet.pushMatrix();
            if (Knob.this.displayStyle == 1) {
                pApplet.rotate(Knob.this.myAngle);
                pApplet.stroke(Knob.this.color().colorForeground);
                pApplet.line(0.0f, 0.0f, Knob.this._myRadius, 0.0f);
            } else if (Knob.this.displayStyle == 2) {
                pApplet.rotate(Knob.this.myAngle);
                pApplet.noStroke();
                pApplet.fill(Knob.this.color().colorForeground);
                pApplet.ellipse(Knob.this._myRadius * 0.75f, 0.0f, Knob.this._myRadius * 0.2f, Knob.this._myRadius * 0.2f);
            } else if (Knob.this.displayStyle == 3) {
                pApplet.noStroke();
                pApplet.fill(Knob.this.color().colorForeground);
                pApplet.arc(0.0f, 0.0f, Knob.this._myRadius * 1.8f, Knob.this._myRadius * 1.8f, Knob.this.startAngle, Knob.this.myAngle);
                pApplet.fill(Knob.this.color().colorBackground);
                pApplet.ellipse(0.0f, 0.0f, Knob.this._myRadius * 1.2f, Knob.this._myRadius * 1.2f);
            }
            pApplet.popMatrix();
            pApplet.pushMatrix();
            pApplet.rotate(Knob.this.startAngle);
            if (Knob.this.isShowTickMarks) {
                float f = Knob.this.range / (float)Knob.this._myTickMarksNum;
                pApplet.stroke(Knob.this.color().colorForeground);
                pApplet.strokeWeight(Knob.this.myTickMarkWeight);
                for (int i = 0; i <= Knob.this._myTickMarksNum; ++i) {
                    pApplet.line(Knob.this._myRadius + 2.0f, 0.0f, Knob.this._myRadius + (float)Knob.this.myTickMarkLength + 2.0f, 0.0f);
                    pApplet.rotate(f);
                }
            } else if (Knob.this.isShowRange) {
                pApplet.stroke(Knob.this.color().colorForeground);
                pApplet.strokeWeight(Knob.this.myTickMarkWeight);
                pApplet.line(Knob.this._myRadius + 2.0f, 0.0f, Knob.this._myRadius + (float)Knob.this.myTickMarkLength + 2.0f, 0.0f);
                pApplet.rotate(Knob.this.range);
                pApplet.line(Knob.this._myRadius + 2.0f, 0.0f, Knob.this._myRadius + (float)Knob.this.myTickMarkLength + 2.0f, 0.0f);
            }
            pApplet.noStroke();
            pApplet.popStyle();
            pApplet.popMatrix();
        }
    }
}

