a_currentACOutputState <- "Uninitialized ";
timezone <- -4;
ApiKey <- "Your API Key";
//--------------------------------------------------------------------------------------------------------
// Processes external HTTP requests. These requests contain button press and status requests
//-------------------------------------------------------------------------------------------------------- 
function webServer( request, response )
{
    server.log( "HTTP Request Headers: " + request.headers );
    server.log( "HTTP Request Body: " + request.body );
    server.log( "HTTP Request Method:" + request.method);
    
    // Needed to avoid  Access-Control-Allow-Origin header error due to AJAX browser security requirements
    // that only allows requests from the domain that served the web page
    response.header( "Access-Control-Allow-Origin", "*" );
    if( request.method=="OPTIONS" )
    {
        response.header("Access-Control-Allow-Methods", "POST, GET, OPTIONS");
        response.header("Access-Control-Allow-Headers", "origin, x-csrftoken, content-type, accept,x-apikey"); 
        response.send(200,"OK");
        return;
    }

    // API Key idea from http://forums.electricimp.com/discussion/comment/8281#Comment_8281
    server.log("API Key " +  request.headers["x-apikey"] );
    if ("x-apikey" in request.headers && request.headers["x-apikey"] == ApiKey) 
    {
        local jsonRequest = http.jsondecode( request.body );
        if ( "request" in jsonRequest ) 
        {
            server.log( "Requested: " + jsonRequest.request );
            
            if( jsonRequest.request == "GetStatus" )
            {
                response.send(200, a_currentACOutputState );
                server.log("response 200");
            }
            else if( jsonRequest.request == "buttonPressed" )
            {
                // Send the button ID to the imp
                device.send( jsonRequest.request, jsonRequest.button );
                response.send(200, a_currentACOutputState ); 
            }
            else
            {
                server.log( "Unknown Command String" );
                response.send(500, "Unknown Command String");
            }
        }
        else
        {
            server.log( "Unknown Request" );
            response.send(500, "Unknown Request. Did not find request in body"); 
        }
    } 
    else 
    {
        // Unauthorized access attempt
        response.send(401, "Authorization Failed. Invalid Api Key");
    }
   
}
 
//--------------------------------------------------------------------------------------------------------
// HTTP Handler
//-------------------------------------------------------------------------------------------------------- 
http.onrequest(webServer);

//--------------------------------------------------------------------------------------------------------
// Function called by the communication protocol when a message is send from the Imp to Agent
//-------------------------------------------------------------------------------------------------------- 
device.on("acCircuitStatus", function(value) {
    a_currentACOutputState = value;
    server.log("Impowered state set to :" + a_currentACOutputState);

});
