#include <Wire.h>
#include <Adafruit_Sensor.h>
#include <Adafruit_TSL2561_U.h>
#include <ESP8266WiFi.h>

const char* ssid     = "<<wifi ssid>>";                     // wifi ssid
const char* password = "<<wifi password>>";                 // wifi password
String auth          = "<<authentication>>";                // Authentication credentials Create a string from <email_address>:<API_Password> and encode it base64
                                                            // The sample: 
                                                            //    String auth = "dXNlcjpwYXNzd29yZA==" 
                                                            // is the encoding for "user:password"

const char* host      = "www.ic2pro.com";
const int   httpPort  = 80;
String devId          = "111-222-555";                                // Device ID. CREATE YOUR OWN GUID; Use this http://www.guidgenerator.com/

Adafruit_TSL2561_Unified tsl = Adafruit_TSL2561_Unified(TSL2561_ADDR_FLOAT, 12345);

void configureSensor(void)
{
  tsl.enableAutoRange(true);            /* Auto-gain ... switches automatically between 1x and 16x */
  tsl.setIntegrationTime(TSL2561_INTEGRATIONTIME_13MS);      /* fast but low resolution */
}


void sendLuminosity(String lum) {
  Serial.print("connecting to ");
  Serial.println(host);
  
  // Use WiFiClient class to create TCP connections
  WiFiClient client;
  if (!client.connect(host, httpPort)) {
    Serial.println("connection failed");
    return;
  }
  
  // We now create a URI for the request
  String url = "/Wire/connector/set?id=" + devId + "&ILLUMINANCE="+lum;
  
  Serial.print("Requesting URL: ");
  Serial.println(url);
  
  // This will send the request to the server
  client.print(String("GET ") + url + " HTTP/1.1\r\n" +
               "Authorization: Basic " + auth + "\r\n" + 
               "Host: " + host + "\r\n" + 
               "Connection: close\r\n\r\n");
  delay(10);
  
  // Read all the lines of the reply from server and print them to Serial
  while(client.available()){
    String line = client.readStringUntil('\r');
    Serial.print(line);
  }
  
  Serial.println();
  Serial.println("closing connection");
}


void setup(void) 
{
  Serial.begin(115200);
  Serial.println("Light Sensor Test"); Serial.println("");
  
  if(!tsl.begin())
  {
    Serial.println("Ooops, no TSL2561 detected ... Check your wiring or I2C ADDR!");
    while(1);
  }
  
  configureSensor();

  WiFi.begin(ssid, password);
  
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }

  Serial.println("");
  Serial.println("WiFi connected");  
  Serial.println("IP address: ");
  Serial.println(WiFi.localIP());
}


void loop(void) 
{  
  sensors_event_t event;
  tsl.getEvent(&event);
 
  if (event.light)
  {
    sendLuminosity(String(event.light));
  }
  else
  {
    Serial.println("Sensor overload");
  }
  delay(2000);
}
