//load libraries
#include <Wire.h>                 // LCD
#include <LCD.h>                  // LCD
#include <LiquidCrystal_I2C.h>    // LCD
#include <SPI.h>                  // Ethernet
#include <Ethernet.h>             // Ethernet

// MAC Address of the Ethernet Shield
byte mac[] = {0x00, 0xAA, 0xBB, 0xCC, 0xDE, 0x02};
IPAddress ip(127,0,0,1);         //Fall back IP address

EthernetClient client;           // Ethernet initialization  (port 80 is default for HTTP)
//Define variables 

#define I2C_ADDR          0x27        //Define I2C Address where the PCF8574A is
#define BACKLIGHT_PIN      3
#define En_pin             2
#define Rw_pin             1
#define Rs_pin             0
#define D4_pin             4
#define D5_pin             5
#define D6_pin             6
#define D7_pin             7

//Initialise the LCD
LiquidCrystal_I2C      lcd(I2C_ADDR, En_pin,Rw_pin,Rs_pin,D4_pin,D5_pin,D6_pin,D7_pin);

void setup()
 {
    Serial.begin(9600);  //begin serial
    
    //Define the LCD as 16 column by 2 rows 
    lcd.begin (16,2);
    
    //Switch on the backlight
    lcd.setBacklightPin(BACKLIGHT_PIN,POSITIVE);
    lcd.setBacklight(HIGH);

  }
    
void loop()
  { 
    Ethernet.maintain();               // Keep looking for an IP address
    if (Ethernet.begin(mac) == 0)      // start the Ethernet connection, connect to DHCP. 
    { 
      Ethernet.begin(mac, ip);         //if it fails to get an IP from DHCP, use the fall back value
    }  
    printIPAddress();                  // print your local IP address:
  }

void printIPAddress()
  {
    lcd.clear();                           //Clear the LCD
    lcd.setCursor(0,0);                    // Set the cursor on the LCD to Col 1 Row 1
    lcd.print("My IP address: ");          // Print on text on the LCD
    Serial.print("My IP address is: ");    // Print text on the serial monitor
    lcd.setCursor(0,1);                    //set the cursor on the LCD to Col 0 Row 2
    Serial.println(Ethernet.localIP());    // Print the IP address on the Serial monitor
    lcd.print(Ethernet.localIP());         // Print the IP address on the LCD
  }
