void wakeUpNow()        // Required for the interrupt for waking up
{
  // No code will be run here
}

void sleepNow()
{
  // Disables the LED driver
  pinMode(PWMPin, INPUT);

  // Set LEDs to minimum brightness.
  PWMOnTime = 0;
  OCR0B = 0;
  TCCR0B = _BV(WGM02) | _BV(CS00) | _BV(CS01);
  delay(debounceDelay);

  // Go to sleep
  adc_disable(); // Disable ADC to save energy
  set_sleep_mode(SLEEP_MODE_PWR_DOWN);   // Sleep mode with the most power saving
  sleep_enable();          // enables the sleep bit in the mcucr register
  attachInterrupt(0, wakeUpNow, LOW); // use interrupt 0 (pin 2) and run function
  sleep_mode();     // The chip is put to sleep here

  // Wake up
  sleep_disable(); // When button is pressed, wake up
  detachInterrupt(0); // disables interrupt 0 on pin 2 to prevent executing wakeUpNow while running
  adc_enable();

  delayCounts = 0;

  buttonState = digitalRead(buttonPin);
  while (buttonState == LOW) {
    delay(debounceDelay);
    delayCounts++;
    buttonState = digitalRead(buttonPin);
  }

  // If short pressed, go back to sleep.
  if (delayCounts <= 2) {
    sleepNow();
  }

  //setPatterns();
  pinMode(PWMPin, OUTPUT);

  // set output 1 of timer 0 to fast PWM
  TCCR0A = _BV(COM0B1) | _BV(WGM01) | _BV(WGM00);
  TCCR0B = _BV(WGM02) | _BV(CS00);
  OCR0A = PWMPeriod;
  OCR0B = PWMOnTime;

}




