
void readButtons() {
  buttonState = digitalRead(buttonPin);

  if (buttonState == LOW) {
    lampState = LOW;
    pinMode(PWMPin, INPUT); // Disable the PWM pin.
    TCCR0B = _BV(WGM02) | _BV(CS00) | _BV(CS01); // Change prescaler so that a millis() value of 1000 equals 1000 milliseconds.
    desiredLEDCurrent = 0;
    PWMOnTime = 0;

    OCR0B = 0;

    delayCounts = 0;

    // While the button is pressed, time how long it was pressed.
    while (buttonState == LOW) {
      delay(debounceDelay);
      delayCounts++;
      buttonState = digitalRead(buttonPin);
    }

    TCCR0B = _BV(WGM02) | _BV(CS00); // Change prescaler so that the PWM frequency is back to the kHz range.
    pinMode(PWMPin, OUTPUT); // Re-enable the PWM pin.

    // If short pressed, increment mode and save it to EEPROM.
    if (delayCounts <= 2) {

      if (mode < modeTop) {
        mode++;
      }
      else if (mode >= modeTop) {
        mode = 0;
      }
    }

    // If long pressed, go to sleep.
    else if (delayCounts > 2) {
      sleepNow();
    }
  }
}

