/*
HOME GUARDUINO - MAIN PANEL FIRMWARE
Copyright 2015 Allan Murray, Auckland, New Zealand. 
Free for personal use only.

MODIFIED 1 WITH MACRO WORKING 19/5/15
1.01 Fixed RFID temp 23/5/15
1.02 Fixed temp 23/5/15
1.03 Not ready  30/5/15
1.05 Not ready  30/5/15 OK
 */
 
#include <EEPROM.h>
#include <SoftwareSerial.h>
SoftwareSerial wifiPort(3, 2); // RX, TX


#define SENSOR_NORMAL 0
#define SENSOR_ALARM 1
#define SENSOR_FAULT 2



#define AC_POWER  11

#define LEDPIN  13
#define SIRENPIN  10
#define AUXPIN  12
#define RESETPIN  9


byte ac_on=0;
byte last_ac_on=0;
byte  wifi_used =0;
byte status_to_send=0;
byte last_status_sent =0;


#define ZONE_FLAGS_ADDRESS 0
#define MAIN_FLAGS_ADDRESS 300
#define CARD_FLAGS_ADDRESS 400

#define STATUS_READY 0 
#define STATUS_PROGRAM 1
#define STATUS_MASTER 2
#define STATUS_ARMING 3
#define STATUS_ARMED 4

#define STATUS_TRIGGERED 7
#define STATUS_ALARM 9
#define STATUS_FIRE 10

byte STATUS  =0;
byte lastSTATUS   =255;

#define WIFI_DISCONNECTED 0 
#define WIFI_CONNECTING1 1 
#define WIFI_CONNECTING2 2 
#define WIFI_CONNECTED 3 

#define WIFI_CONNECTINGWEB 4 
#define WIFI_SENDWEB 5 
#define WIFI_WAITINGCOMPLETION 6

#define WIFI_ERROR 100
#define WIFI_RESETTING 200
#define WIFI_UNKNOWN 255 



byte WIFISTATUS    =255;
byte action_wifi=0;  //0=disconnect  1=connect only  2=connect & send data
byte data_wifi=0;    //data to send
int tWifi          =0;
int tWifiConnected  =0;

byte monitor_mode=0;

char inputbuffer[17];
bool input   =false;
byte inputlen    =0;
int w1,w2=0;

bool cyclePulse=false;

bool readyOK=true;
bool lastReadyOK=true;

byte tCount    =0;
unsigned long  tTime   =0;
unsigned long tLog =0;
byte tZone    =0;
byte tZoneFault    =0;

byte thisZone  =99;

int tryCount=0;

//Attributes
char MASTERPASS[5];
char USERPASS[5];
byte ARMING_DELAY =30; //(seconds) 
byte LOG_WIFI=1;
byte ACTION_FAULT =2;  //0= no action 1=error 2=alarm
byte DEBUG_LEVEL=0;
byte ALARM_DURATION =5; //(minutes)

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

#define POLLING_CYCLE 250  //miliseconds
#define AUX_RESET_TIME 5  //(seconds)
#define LOG_FREQUENCY 60 //minutes
#define ERROR_TIME 600 //(seconds)
#define WIFI_MAXCONNECTIONTIME 120  //seconds

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++


//*-- IoT Information
//NEED TO UPDATE WITH YOUR PERSONAL SETTINGS AND KEYS

#define SSID1 "XXXXXXXXXX" //Primary WIFI network name
#define PASS1 "XXXXXXXXXX" //Primary WIFI network password
#define SSID2 "XXXXXXXXXX"  //Secondary WIFI network name
#define PASS2 "XXXXXXXXXX" //Secondary WIFI network password

#define IP   "184.106.153.149" // thingspeak.com IP address
String GET = "GET /update?key=XXXXXXXXXXXXXXXX";  //Replace XXXXXXXXXXXXXXXX with your ThingSpeak "Write API Key" for your Alarm Channel

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

#define MAXCARDS 5
char RFIDCARDS[MAXCARDS][15];

#define MAXFLAGS 5
byte zoneFlags[13][MAXFLAGS];
byte disableZone[13];
#define FLAG_NONC 0   //0=NO 1=NC
#define FLAG_MODE 1    // 0=Not Used  1=Alarm   2=Fire(24hrs)  3=Silent  99=disabled
#define FLAG_DEBOUNCE 2  //Debounce count default=2 
#define FLAG_DELAY 3  //Trigger delay in seconds
#define CAUSE_NOT_READY 4  //1= will cause not ready mode

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

unsigned int talarm =0;
int tCard=0;
byte lastCard=0;

byte zoneState[13];
byte zoneCount[13];

int sensorValue =0;
 unsigned long timeOfLastCycle = 0;
 unsigned long timeOfLastSecond = 0; 
 
bool fDisabled=false;
bool fNoWifi=false;
bool fFault=false;
int fTimer  =0;
bool pulse=false;

 

// the setup function runs once when you press reset or power the board
void setup() {
  
for (byte d = 0; d < 13; d++) { 
 disableZone[d]=0;
}

   USERPASS[4]=0;
   MASTERPASS[4]=0;
   
  pinMode(AC_POWER , INPUT_PULLUP);
  pinMode(RESETPIN , INPUT_PULLUP);
  
  //DIGITAL ZONES
  pinMode(4 , INPUT_PULLUP);  
  pinMode(5 , INPUT_PULLUP);  
  pinMode(6 , INPUT_PULLUP);  
  pinMode(7 , INPUT_PULLUP);  
  pinMode(8 , INPUT_PULLUP);  
  
  pinMode(LEDPIN , OUTPUT);
  pinMode(SIRENPIN, OUTPUT);
  pinMode(AUXPIN, OUTPUT);
  digitalWrite(SIRENPIN, HIGH);
  digitalWrite(LEDPIN, HIGH);  
  digitalWrite(AUXPIN, HIGH);  
  // initialize digital pin 13 as an output.
  
  Serial.begin(9600);
  
  
wifiPort.begin(9600);
wifiPort.println(F("AT+RST"));
delay(1000);
wifiPort.println(F("AT"));
inputbuffer[0]=0;

ac_on=isACon();
last_ac_on=ac_on;

tLog=LOG_FREQUENCY;
Serial.println(F(">RESET"));
alarmReset();


tZoneFault=0;

fDisabled=false;
fFault=false;
fNoWifi=false;
fTimer=ERROR_TIME;
masterReset();
if (digitalRead(RESETPIN)==LOW)  STATUS=STATUS_MASTER;
else STATUS=STATUS_READY;

readFromEPROM();
}

// the loop function runs over and over again forever
void loop() {
  
  bool doReset=((lastSTATUS==STATUS_ALARM)&&(STATUS==STATUS_READY));
  
  if (lastSTATUS!=STATUS) {
    sendStatus();
    if ((LOG_WIFI==1) && (STATUS!=STATUS_PROGRAM))
      {
      action_wifi=2;
      if (STATUS>status_to_send) status_to_send=STATUS;
    }
  }
  
  
  if ((readyOK!=lastReadyOK) && (STATUS==STATUS_READY)){
    sendStatus();
    lastReadyOK=readyOK;
  }
  
  
  
  if ((last_status_sent!=STATUS) && (action_wifi<2) && (status_to_send==0)&& (LOG_WIFI==1)) {
    action_wifi=2;
    status_to_send=STATUS;
  }
  
  ac_on=isACon();
  if (last_ac_on!=ac_on) {
   last_ac_on=ac_on;
      action_wifi=2;
      if (STATUS>status_to_send) status_to_send=STATUS;
  }
  
  if (doReset) alarmReset(); 
  
 unsigned long currentTime=millis();
  
  
//POLL ZONES======================DO EVERY SECOND ============================================   

 if ((currentTime-timeOfLastSecond)>=1000)
 {
   timeOfLastSecond=currentTime;
   
   if (tCard>0)  {
     tCard=tCard-1;
   if (tCard==0) lastCard=0;
   }
   

   if (tLog>0) {
    tLog--;
   if ((tLog==0) && (LOG_WIFI==1)) {
     tLog=60*LOG_FREQUENCY;
    action_wifi=2;
    if (STATUS>status_to_send) status_to_send=STATUS;
   }
   }
   
   
   if (tWifi>0) tWifi=tWifi-1;
   if (WIFISTATUS==WIFI_CONNECTED) tWifiConnected=tWifiConnected+1;
   
  if ((STATUS==STATUS_TRIGGERED) || (STATUS==STATUS_ARMING))  {    
   tCount=tCount-1;
   sendStatus();
   if ((tCount<1) &&(STATUS==STATUS_TRIGGERED) ) {
     STATUS=STATUS_ALARM;
     talarm=ALARM_DURATION*60;
     digitalWrite(SIRENPIN, LOW);
     Serial.println("!"+String(talarm));
   }
   if ((tCount<1) &&(STATUS==STATUS_ARMING) ) STATUS=STATUS_ARMED;
   }
   
  
  if ((STATUS==STATUS_FIRE) && (talarm>0)) {   
    pulse=!pulse;
   if  (pulse) digitalWrite(SIRENPIN, LOW);
   else digitalWrite(SIRENPIN, HIGH);
   }
  
  if (talarm>0) {
    talarm=talarm-1;
    if (talarm==0) digitalWrite(SIRENPIN, HIGH);
  }
  
  
  
  if (fTimer>0) {
  fTimer=fTimer-1;

  if (fTimer==0) {
    fTimer=ERROR_TIME;
    if (fDisabled) {
      String zn="";
        for (byte z=0; z<13 ;z++){
        if (disableZone[z]==1) zn=String(z);
        }
      Serial.print(F("!!ER: DISABLED Z"));
      Serial.println(zn);
      Serial.println(F("!BEEP3"));
    } 
  }
    
    if ((fTimer==10)&& (!ac_on)){
      Serial.println(F("!!ER: ON BATTERY"));
      Serial.println(F("!BEEP3"));
    }  

 if ((fTimer==20)&& (fNoWifi) && (LOG_WIFI==1)) {
      Serial.println(F("!!ER: NO WIFI"));
      Serial.println(F("!BEEP3"));
   }
   
 if ((fTimer==30)&& (fFault)) {
      Serial.print(F("!!ER: FAULT Z"));
      Serial.println(tZoneFault); 
      Serial.println(F("!BEEP3"));
   }

  }

  
 } 
//END=====================DO EVERY SECOND ============================================  
  
  
  
  
//======================DO EVERY LOOP============================================  
   //Read input from keypad
  if ((Serial.available()>0 ) & !input){
    if (inputlen<16) {    
      char s=Serial.read();
      if ((s<31) | (inputlen>=16)) {
       if (inputlen>0) { 
       input=true;
       inputbuffer[inputlen]=0;
       }
      }
      else
      {
      inputbuffer[inputlen]=s;
      inputlen++;
      inputbuffer[inputlen]=0;
      }
    }
  }


//HAS INPUT STRING
  if (input) {
    
    bool inputok=false;
    
    char endcode=inputbuffer[inputlen-1];
    if (DEBUG_LEVEL>0) Serial.println(inputbuffer);
    
    
    
    
     if ((endcode=='A') && 
     ((hasPass(inputbuffer,USERPASS) && (inputlen==5)) 
     || ((lastCard>0) && (inputlen==1) ))
     && (STATUS==STATUS_READY))
     {
      if (readyOK) {
      Serial.println(F("!BEEP2"));
       STATUS=STATUS_ARMING;
       tCount=ARMING_DELAY;
      }
      else
      {
     Serial.println(F("!ZONE NOT READY"));
    Serial.println(F("!BEEP3"));   
      }
     tCard=0;
     lastCard=0;
     inputok=true;
     }  
     
     
      if ((endcode=='D') && (lastCard>0) && (inputlen==1)&& (STATUS==STATUS_PROGRAM) && (thisZone=90))
     {
     tCard=0;
     Serial.println(F("!CARD DELETED"));
     RFIDCARDS[lastCard-1][0]=0;
     Serial.println(F("!BEEP2"));
     inputok=true;
     lastCard=0;
     }      
         
     if ((strcmp(inputbuffer, "**D")==0) && (thisZone==90) && (STATUS==STATUS_PROGRAM))
     {
     tCard=0;
     Serial.println(F("!DELETE ALL OK"));
     for (byte c=0; c<MAXCARDS; c++){
     RFIDCARDS[c][0]=0;
     }
     Serial.println(F("!BEEP2"));
     inputok=true;
     }         
      
      if ((endcode=='R')) {
        inputbuffer[inputlen-1]=0;
        lastCard=hasCard(inputbuffer);
        if (lastCard>0) tCard=5;
          else tCard=0;  
          inputok=true;
      }
      
      
      
    
     if ((endcode=='R') && (lastCard>0) && (inputlen>4) && (inputlen<=15) && 
     ((STATUS==STATUS_ARMED) ||(STATUS==STATUS_ARMING)||(STATUS==STATUS_TRIGGERED)||(STATUS==STATUS_ALARM)))
     { 
     STATUS=STATUS_READY;
     Serial.println(F("!BEEP2"));
     lastCard=0;
     tCard=0;
     inputok=true;
     } 
    
      if ((endcode=='R') && (lastCard==0) && (inputlen>8) && (inputlen<=15) && (STATUS==STATUS_PROGRAM) && (thisZone=90))
     {
       Serial.print(F("p="));
     inputbuffer[inputlen-1]=0; 
     lastCard=addCard(inputbuffer);
     Serial.println(lastCard);
     Serial.print(F("!"));
     if (lastCard>0) {
     Serial.println(F("!CARD ADDED"));  
     Serial.println(F("!BEEP2"));
     inputok=true;
     }
     }   
    
    
     if ((strcmp(inputbuffer, "*0100D")==0) && (STATUS==STATUS_MASTER)) {//PASSWORD RESET
       passwordReset();
       writeToEPROM();
       Serial.println(F("!PASSWORD RESET"));
       Serial.println(F("!BEEP1")); 
      inputok=true;
     }
     
     if ((strcmp(inputbuffer, "#0200D")==0) && (STATUS==STATUS_MASTER)) {// MASTER RESET
       masterReset();
       writeToEPROM();
       Serial.println(F("!MASTER RESET"));
       Serial.println(F("!BEEP1")); 
     inputok=true;
     }
    
    
     if ((endcode=='D') && hasPass(inputbuffer,USERPASS) && (inputlen==5) && 
     ((STATUS==STATUS_ARMED) ||(STATUS==STATUS_ARMING)||(STATUS==STATUS_TRIGGERED)||(STATUS==STATUS_ALARM)))
     { 
     STATUS=STATUS_READY;
     Serial.println(F("!BEEP2"));
     inputok=true;
     } 
        
    
     if ((endcode=='D') && hasPass(inputbuffer,USERPASS) && (inputlen==5) && (STATUS==STATUS_FIRE))
     { 
     STATUS=STATUS_READY;
     Serial.println(F("!BEEP2"));
     sendStatus();
     alarmReset(); 
     if ((tZone<=13) && ((readZone(tZone)==SENSOR_ALARM)
    || ((readZone(tZone)==SENSOR_FAULT) && (ACTION_FAULT==2))))
    {
        disableZone[tZone]=1;
        fDisabled=true;
        fTimer=1;
     }
     inputok=true;
     } 
    
    
     if ((strcmp(inputbuffer, "####D")==0) && 
     ((STATUS==STATUS_READY) || (STATUS==STATUS_PROGRAM) )  )
     {
     lastSTATUS=255;  
     Serial.println(F("!RESET"));   
     setup();
     inputok=true;
     }  
    
     if (strcmp(inputbuffer, "***A")==0)
     {
     STATUS=STATUS_FIRE;
       talarm=ALARM_DURATION*60;
       digitalWrite(SIRENPIN, LOW);
       tZone=99;
     inputok=true;
     }    
    
    
    
    
     if ((endcode=='B') && hasPass(inputbuffer,MASTERPASS) && (inputlen==5) && 
     (STATUS==STATUS_READY))
     {
     Serial.println(F("!BEEP2"));  
     STATUS=STATUS_PROGRAM;
     thisZone  =99;
     inputok=true;
     } 
     
     if (endcode=='?')  {
       inputok=true;
       sendStatus();
     }
     
     if (endcode=='C')  {
       if (monitor_mode>0) Serial.println("! ");
       sendStatus();
       monitor_mode=0;
       inputok=true;
     }
     
     if ((endcode=='B') && (STATUS==STATUS_PROGRAM) && (!inputok))
     {
     inputok=programCommand();
     } 

     if ((endcode=='D') && (inputbuffer[0]=='*') && (inputlen==2) && 
     (STATUS==STATUS_PROGRAM))
     {
     writeToEPROM(); 
     monitor_mode=0;
     Serial.println(F("!CHANGES SAVED"));
     Serial.println(F("!BEEP2")); 
     readFromEPROM();  
     STATUS=STATUS_READY;
     inputok=true;
     }  
     
     if ((endcode=='D') && (inputbuffer[0]=='#') && (inputlen==2) && 
     (STATUS==STATUS_PROGRAM))
     {
     monitor_mode=0;
     Serial.println(F("!NOT SAVED"));
     Serial.println(F("!BEEP2")); 
     readFromEPROM();
     STATUS=STATUS_READY;
     inputok=true;
     } 

   if (strcmp(inputbuffer,"OFFLINE")==0) {
       offlinemode();
     inputok=true;
     } 

     if (strcmp(inputbuffer,"ESPDIRECT")==0) {
       Serial.println(F("WIFI DIRECT MODE"));
       espdirectmode();
     inputok=true;
     } 
     
     if (strcmp(inputbuffer,"CONNECT")==0) {
       Serial.println(F("CONNECT"));
       action_wifi=1;
            tWifi=0;
     inputok=true;
     } 
     
     if (strcmp(inputbuffer,"SEND")==0) {
       Serial.println(F("SEND"));
       action_wifi=2;
       data_wifi=1;
       tWifi=0;
     inputok=true;
     } 
  
     if (strcmp(inputbuffer,"DISCONNECT")==0) {
       Serial.println(F("DISCONNECT"));
       action_wifi=0;
     inputok=true;
     } 
     
     
  if (!inputok) {
    Serial.println(F("!ER: INVALID"));  
    Serial.println(F("!BEEP3"));  
    lastCard=0;
  }
  
   
   
  input=false;
  inputlen=0;
 inputbuffer[inputlen]=0;
  }
  
 //END======================DO EVERY LOOP============================================   
  
  
  
  
//POLL ZONES======================DO EVERY CYCLE 200ms ============================================   

 if (((currentTime-timeOfLastCycle)>=POLLING_CYCLE) && (STATUS!=7))
 {
  timeOfLastCycle=currentTime;
   
  cyclePulse=!cyclePulse;
  if (cyclePulse) digitalWrite(LEDPIN, HIGH); 
  else digitalWrite(LEDPIN, LOW);
  
  
  if (LOG_WIFI==0) action_wifi=0;
  updateWifiStatus(); 
   
 
   
 //READ ZONE STATES  
  for (byte z=0; z<13 ;z++){
  zoneState[z]=readZone(z);
  if (zoneState[z]==SENSOR_NORMAL) zoneCount[z]=0;
  else zoneCount[z]=zoneCount[z]+1;
  }
  
  
  
  
//CHECK FOR ALARM STATE
readyOK=true;
  for (byte z=0; z<13 ;z++){
  zoneState[z]=readZone(z);
  
  if ((zoneState[z]!=SENSOR_NORMAL) && (STATUS==STATUS_READY) && (zoneCount[z]>=zoneFlags[z][FLAG_DEBOUNCE]) && 
  (zoneFlags[z][FLAG_MODE]!=0) && (zoneFlags[z][CAUSE_NOT_READY]!=0)) readyOK=false;
  
  if ((zoneState[z]!=SENSOR_NORMAL) && (STATUS!=STATUS_PROGRAM) && (STATUS!=STATUS_MASTER) && (zoneCount[z]>=zoneFlags[z][FLAG_DEBOUNCE]) && 
  (zoneFlags[z][FLAG_MODE]!=0)) {
    
    if ((zoneState[z]==SENSOR_ALARM) || ((zoneState[z]==SENSOR_FAULT) && (ACTION_FAULT==2))) alarmTriggered(z);

    if ((zoneState[z]==SENSOR_FAULT) && (ACTION_FAULT!=0)) {
        fFault=true;
        tZoneFault=z;
        fTimer==31;
      }
    }
  }
  
    if ((monitor_mode==1) && (STATUS==STATUS_PROGRAM)) {
      String st="";
    for (byte z=0; z<13 ;z++){ 
     st=st+String(zoneState[z]);
    }  
    Serial.println("!"+st);
   } 
  

    if ((monitor_mode==2) && (STATUS==STATUS_PROGRAM)) {
      if (wifi_used>0) {
      tWifiConnected=0;
      monitor_mode=3;
      w1,w2=0;
      wifiPort.println(F("AT+CWLAP"));
      }
      else
      {
       action_wifi=1;
      }
   } 

    if ((monitor_mode==3) && (STATUS==STATUS_PROGRAM)) {
      byte res=wifiresponseSignal(&w1,&w2,400);
      if (res==14) {
        monitor_mode=2;
        Serial.print(F("!W1:"));  
        Serial.print(w1);  
        Serial.print(F(" W2:"));  
        Serial.println(w2);  
        Serial.println(F("!BEEP5"));
      }
   } 
   
  
 }//END======================DO EVERY CYCLE 200ms ============================================  


 
         
}

//=====================================PROGRAM COMMAND


bool programCommand()
{
  
 if ((inputbuffer[0]=='*') && (inputlen==2) && (thisZone>=0) && (thisZone<=12))
 {  
 for (byte f = 0; f < MAXFLAGS; f++) {
 Serial.print(F("!"));
 PrintflagName(f);
 Serial.print(F("="));
 Serial.println(zoneFlags[thisZone][f]);
 delay(1500);
 }
 Serial.println("!");
 return true;  
 }
 
 if ((inputbuffer[0]=='*') && (inputlen==2) && (thisZone==99))
 {  
 for (byte f = 0; f < 7; f++) {
 Serial.print(F("!"));
 PrintattrName(f);
 delay(1500);
 }
 Serial.println("!");
 return true; 
 }
 
 
 if ((inputbuffer[0]=='*') && (inputlen==2) && (thisZone==90))
 {  
   byte cards=0;
 for (byte c = 0; c < MAXCARDS; c++) {
if (RFIDCARDS[c][0]!=0) {
  cards++;
 Serial.println("!"+String(cards)+" - "+String(RFIDCARDS[c]));
 delay(1500);
}
 }

if (cards==0) {
 Serial.println(F("!NO CARDS"));
 delay(1500);
}

 Serial.println("!");
 return true; 
 }
  

 if ((inputbuffer[0]=='#') && ((inputlen==3) || (inputlen==4)))
 {
   inputbuffer[inputlen-1]=0;
   if (isnumber(&inputbuffer[1])) {
   int i=String(&inputbuffer[1]).toInt();
   if ((i<0) || (i>12) && (i!=99) && (i!=90)) return false;
   thisZone=i;
   sendStatus();
   return true;
   }
   else return false;
 } 
  
  

  
  
 if ((inputbuffer[3]=='*') && (inputlen==5)  && (thisZone==99))
 {
 inputbuffer[3]=0;

 if (isnumber(&inputbuffer[0])){
     byte n1=String(&inputbuffer[0]).toInt();
    switch (n1) {
    
    case 101:   
      monitor_mode=1;
      return true; 
      break;
      
    case 102:   
      Serial.print(F("!AC="));
      Serial.print(ac_on); 
      Serial.print(F(" WIFI="));
      Serial.println(wifi_used);
      return true; 
      break;
      
   case 103:   
      monitor_mode=2;
      return true; 
      break;
      
    case 199:   
      lastSTATUS=255;
      Serial.println(F("!RESET"));
      setup();
      return true; 
      break;
   
    case 198:   
      Serial.println(F(">PROGRAM OFFLINE")); 
      Serial.println(F("!!MANUAL RESET"));  
      Serial.end();
      pinMode (0, INPUT) ;
      pinMode (1, INPUT) ;
      while (1==1) {}
      break;
      
    case 200:    
      Serial.println(F("!!SIREN TEST"));  
      digitalWrite(SIRENPIN, LOW);
      delay(1000);
      digitalWrite(SIRENPIN, HIGH);
      Serial.println("! "); 
      return true;
      break; 
   
    }
   
  
 }
 }
  
 if ((inputbuffer[1]=='*') && (inputlen>=4) && (inputlen<=6) && (thisZone<90))
 {
   inputbuffer[inputlen-1]=0;
   inputbuffer[1]=0;

   if (isnumber(&inputbuffer[0])&&isnumber(&inputbuffer[2])) {
     
    byte n1=String(&inputbuffer[0]).toInt();
    byte n2=String(&inputbuffer[2]).toInt();
    
    if ((n1>=0) && (n1<MAXFLAGS) && (n2>=0) && (n2<=255)&& (thisZone>=0) && (thisZone<=12))
    {
    zoneFlags[thisZone][n1]=n2;
    Serial.print(F("!OK "));
    PrintflagName(n1);
    Serial.print(F("="));
    Serial.println(zoneFlags[thisZone][n1]);
    return true;
    }
    else return false;
   }
   else return false;
 } 
  
  
 if ((inputbuffer[1]=='*') && (inputlen>=4) && (inputlen<=7) && (thisZone==99)) 
 { 
   inputbuffer[inputlen-1]=0;
   inputbuffer[1]=0;
  
   if (isnumber(&inputbuffer[0])) {
     
    byte n1=String(&inputbuffer[0]).toInt();
    byte n2=String(&inputbuffer[2]).toInt();
    
    if ((n1==2) && (n2>=0) && (n2<=255) &&(isnumber(&inputbuffer[2])))
    {
    ARMING_DELAY=n2;
    Serial.print(F("!OK "));
    PrintattrName(n1);
    return true;
    }
    
    if ((n1==3) && (n2>=0) && (n2<=1) &&(isnumber(&inputbuffer[2])))
    {
    LOG_WIFI=n2;
    Serial.print(F("!OK "));
    PrintattrName(n1);
    return true;
    }
    
    if ((n1==4) && (n2>=0) && (n2<=2) &&(isnumber(&inputbuffer[2])))
    {
    ACTION_FAULT=n2;
    Serial.print(F("!OK "));
    PrintattrName(n1);
    return true;
    }
    
    if ((n1==5) && (n2>=0) && (n2<=2) &&(isnumber(&inputbuffer[2]))) 
    { 
    DEBUG_LEVEL=n2;
    Serial.print(F("!OK "));
    PrintattrName(n1);
    return true;
    }
    
    if ((n1==6) && (n2>=0) && (n2<=255) &&(isnumber(&inputbuffer[2]))) 
    { 
    ALARM_DURATION=n2;
    Serial.print(F("!OK "));
    PrintattrName(n1);
    return true;
    }    

    if ((n1==0) && (inputlen==7))
    {
     MASTERPASS[0]=inputbuffer[2];
     MASTERPASS[1]=inputbuffer[3];
     MASTERPASS[2]=inputbuffer[4];
     MASTERPASS[3]=inputbuffer[5];
    Serial.print(F("!OK "));
    PrintattrName(n1);
    return true;
    }

    if ((n1==1) && (inputlen==7))
    {
     USERPASS[0]=inputbuffer[2];
     USERPASS[1]=inputbuffer[3];
     USERPASS[2]=inputbuffer[4];
     USERPASS[3]=inputbuffer[5];
    Serial.print(F("!OK "));
    PrintattrName(n1);
    return true;
    }

   }
 } 
  
return false;  
}


void PrintflagName(byte f)
{
    switch (f) {
    case 0:    
     Serial.print(F("0:NO/NC"));
      break;
    case 1:    
     Serial.print(F("1:MODE"));
      break;
    case 2:    
     Serial.print(F("2:DEBOUNCE"));
      break;
    case 3:    
     Serial.print(F("3:DELAY"));
      break;
    case 4:       
     Serial.print(F("4:NOT READY"));
      break;
    }
}


void PrintattrName(byte f)
{
    switch (f) {
    case 0:    
      Serial.print(F("0:MASTER="));
      Serial.println(MASTERPASS);
      break;
    case 1:    
      Serial.print(F("1:USER="));
      Serial.println(USERPASS);
      break;
    case 2:    
      Serial.print(F("2:ARM DELAY="));
      Serial.println(ARMING_DELAY);
      break;
    case 3:    
      Serial.print(F("3:WIFI LOG="));
      Serial.println(LOG_WIFI);
      break; 
    case 4:     
      Serial.print(F("4:FAULT="));
      Serial.println(ACTION_FAULT);
      break; 
    case 5:       
      Serial.print(F("5:DEBUG="));
      Serial.println(DEBUG_LEVEL);
      break; 
    case 6:       
      Serial.print(F("6:ALARM="));
      Serial.println(ALARM_DURATION);
      break; 
    }
}

bool isnumber(char *i)
{
byte d=0;
while ((d<10) && (i[d]!=0)) {
   if ((i[d]<'0') || (i[d]>'9')) return false;
   d++;
 }
  return true;
}


int freeRam () 
{
  extern int __heap_start, *__brkval; 
  int v; 
  return (int) &v - (__brkval == 0 ? (int) &__heap_start : (int) __brkval); 
}



void sendStatus()
{
    switch (STATUS) {
    case STATUS_READY:    
      if (readyOK) Serial.println(F(">READY"));
      else Serial.println(F(">NOT READY"));
      lastReadyOK=readyOK;
      break;
    case STATUS_ARMED:    
      Serial.println(F(">ARMED"));
      break;
    case STATUS_ARMING:    
      Serial.print(F(">ARMING "));
      Serial.println(tCount);
      break;
    case STATUS_TRIGGERED:    
      Serial.print(F(">TRIGGERED "));
      Serial.println(tCount);
      break;
    case STATUS_ALARM:    
      Serial.println(F(">ALARM"));
      break;
    case STATUS_FIRE:    
      Serial.println(F(">FIRE"));
      break;
    case STATUS_PROGRAM:    
      if ((thisZone<=12) && (thisZone>=0)) {
        if (disableZone[thisZone]==1) Serial.print(F(">PROGRAM*ZONE "));
       else Serial.print(F(">PROGRAM ZONE "));
       Serial.println(thisZone);
       
      }
      else if (thisZone==90) Serial.println(F(">PROGRAM CARD"));
      else Serial.println(F(">PROGRAM")); 
      break;  
    case STATUS_MASTER:    
      Serial.println(F(">PROGRAM MASTER")); 
      Serial.println(F("!RESET CODE:"));
      break;
    }
    lastSTATUS=STATUS;
}

bool hasPass(char *i, char *p)
{
  return ((i[0]==p[0]) && (i[1]==p[1]) && (i[2]==p[2])&& (i[3]==p[3]));

}

byte hasCard(char *i)
{

for (byte c = 0; c < MAXCARDS; c++) {
 bool found=true;
for (byte d = 0; d < 15; d++) { 
 if ((i[d]!=RFIDCARDS[c][d]) || ((RFIDCARDS[c][d]==0) && (d<4))) found=false;
 if (RFIDCARDS[c][d]==0) break;
}
if (found) return c+1;
}
return 0;
}


byte getCardIndex(byte n)
{
byte n1=0;
for (byte c = 0; c < MAXCARDS; c++) {
 if (RFIDCARDS[c][0]!=0) n1++;
 if (n==n1) return c+1;
}
return 99;
}



byte addCard(char *i)
{
byte card=0;

for (byte c = 0; c < MAXCARDS; c++) {
if (RFIDCARDS[c][0]==0) card=c+1;
}
if (card==0) return 0;  
  
byte d=0;
while ((d<14) && (i[d]!='R')) {
 RFIDCARDS[card-1][d]=i[d];
 d++;
}
RFIDCARDS[card-1][d]=0;

return card;
}


 

void alarmTriggered(byte zone)
{
  
  if ((zoneFlags[zone][FLAG_MODE]==1)&& (disableZone[zone]==0)){
  if ((STATUS==STATUS_ARMED) ||  ((STATUS==STATUS_TRIGGERED)  && (zoneFlags[zone][FLAG_DELAY]<tCount))) {
  STATUS=STATUS_TRIGGERED;
  Serial.println(F("!BEEP3"));
  tCount=zoneFlags[zone][FLAG_DELAY];
  tTime=millis();
  tZone=zone;
  if (tCount==0) {
    STATUS=STATUS_ALARM;
    talarm=ALARM_DURATION*60;
     digitalWrite(SIRENPIN, LOW);
  }
  }
  }
  
  if ((zoneFlags[zone][FLAG_MODE]==2) && (disableZone[zone]==0)){
  if ((STATUS!=STATUS_PROGRAM) &&  (STATUS!=STATUS_MASTER) &&  (STATUS!=STATUS_FIRE)) {
  STATUS=STATUS_FIRE;
  talarm=ALARM_DURATION*60;
  digitalWrite(SIRENPIN, LOW);
  tZone=zone;
  }
  }
  
  
}



void alarmReset()
{
 
  digitalWrite(SIRENPIN, HIGH); 
  
 for (byte z = 0; z < 13; z++) {
 zoneState[z]=0;
 zoneCount[z]=0;
 }
  
  digitalWrite(LEDPIN, HIGH);
  
  digitalWrite(AUXPIN, LOW); 
  delay(AUX_RESET_TIME*1000);
  digitalWrite(AUXPIN, HIGH); 

}



byte readZone(byte zone)
{
 byte pin=0; 
  
     switch (zone) {
    case 0:    
      pin=A0;
      break;
    case 1:    
      pin=A1;
      break;
    case 2:    
      pin=A2;
      break;
    case 3:    
      pin=A3;
      break;
    case 4:    
      pin=A4;
      break;
    case 5:    
      pin=A5;
      break;
    case 6:    
      pin=A6;
      break;  
    case 7:    
      pin=A7;
      break;
      
    case 8:     
      pin=8;
      break;
    case 9:     //WIRELESS 0
      pin=7;
      break;
    case 10:    //WIRELESS 1     
      pin=6;
      break;  
    case 11:    //WIRELESS 2  / SWITCHABLE 1
      pin=5;
      break;
    case 12:   //WIRELESS 3  / SWITCHABLE 2 
      pin=4; 
      break;
    } 
  byte no_nc = zoneFlags[zone][FLAG_NONC]; // no=0 nc=1
  
  if (zone<=7) { //ANALOG ZONE   
    byte state=0;
    byte sensor=checkSensor(pin);
     switch (sensor) {
    case 0:    //GND
        if (no_nc==0)state=SENSOR_ALARM;
        else state=SENSOR_FAULT;
      break;
    case 1:  // NORMAL (RESISTOR)  
      state=SENSOR_NORMAL;
      break;
    case 2:  // OPEN  
        if (no_nc==0)state=SENSOR_FAULT;
        else state=SENSOR_ALARM;
      break;
     }
    return state;
  }
  
  //DIGIRAL ZONE  
 int sensor=digitalRead(pin);
 if (((sensor==LOW) && (no_nc=1)) || ((sensor==HIGH) && (no_nc=0))) return SENSOR_NORMAL;
 else return SENSOR_ALARM;

}


 

byte isACon(){
  if (digitalRead(AC_POWER)==LOW) return 1;
  else return 0;
}

//function to check sensor state
byte checkSensor( byte sensorInput)
{
byte state;
int sensorReading = analogRead(sensorInput);
delay(5);
sensorReading = analogRead(sensorInput);
delay(5);
if( sensorReading < 370 ) {
state = 0; // GND
} else if ( sensorReading >= 370 && sensorReading < 530 ) {
state = 1; // NORMAL (RESISTOR)
} else {
state = 2; // OPEN
}
return state;
}


int readSensor( byte sensorInput)
{
byte state;
int sensorReading = analogRead(sensorInput);
delay(5);
sensorReading = analogRead(sensorInput);
delay(5);
return sensorReading;
}

//========================WIFI===============


void updateWifiStatus()
{

  byte response=0;
  bool fail=false;
  
    switch (WIFISTATUS) {
      
    case WIFI_UNKNOWN: 
      wifi_used=0;
      if (tWifi!=0) break;
      response=wificonnected();
      if ((response==1) || (response==2)) {
        wifi_used=response;
        WIFISTATUS=WIFI_CONNECTED;
        tWifiConnected=0;
        }
      else if (response==8) tWifi=2;
      else WIFISTATUS=WIFI_DISCONNECTED;
            if (DEBUG_LEVEL>0) {
            Serial.print(F("WIFI STATUS: "));
            Serial.println(WIFISTATUS);
            }
      break;
    case WIFI_DISCONNECTED:  
      wifi_used=0;  
      if ((action_wifi>0) && (tWifi==0)){
        wificlearbuffer(100);
            if (DEBUG_LEVEL>0) Serial.println(F("Connect 1"));
        tryCount=0;
        wificonnect(1);
        WIFISTATUS=WIFI_CONNECTING1;
      }
      break;
    case WIFI_CONNECTING1:  
      fail=false;
      if (tWifi!=0) break;
      response=wificonnected();
            if (DEBUG_LEVEL>1) {
            Serial.print(F("Response="));
            Serial.println(response);
            }
      if ((response==1) || (response==2)) {
        fNoWifi=false;
        wifi_used=response;
        WIFISTATUS=WIFI_CONNECTED;
        tWifiConnected=0;
      }
      else if ((response==8) || (response==0))   tWifi=2;
      else fail=true;
     
      tryCount=tryCount+1;
      if (tryCount>15) fail=true;
      
      if (fail) {
        wificlearbuffer(100);
        tryCount=0;
            if (DEBUG_LEVEL>0) Serial.println(F("Connect 2"));
        wificonnect(2);
        WIFISTATUS=WIFI_CONNECTING2;
      }
      break;
      
    case WIFI_CONNECTING2:  
      if (tWifi!=0) break;
      response=wificonnected();
      if ((response==1) || (response==2)) {
        fNoWifi=false;
        wifi_used=response;
        WIFISTATUS=WIFI_CONNECTED;
        tWifiConnected=0;
      }
      else if  ((response==8) || (response==0))  tWifi=2; 
      else fail=true;
   
      tryCount=tryCount+1;
      if (tryCount>15) fail=true;
      
      if (fail) 
      {
        fNoWifi=true;
        tWifi=2;
        if (DEBUG_LEVEL>0) Serial.println(F("NOW DISCONNECTED"));
        WIFISTATUS=WIFI_DISCONNECTED;
      }
      break;
      
    case WIFI_CONNECTED: 
     if (tWifi==0) {
             if (DEBUG_LEVEL>1) {
             Serial.print(F("NOW CONNECTED "));
             Serial.print(tWifiConnected);
             Serial.println(F(" SECONDS"));
             }
       tWifi=10;
     }
      if ((action_wifi>1) && (monitor_mode==0)) {
             if (DEBUG_LEVEL>0) Serial.println(F("CONNECTING WEB"));
       tWifi=0;
       response=wifistart();
       if (response==12)  WIFISTATUS=WIFI_SENDWEB;
       else  
       if (response==4) WIFISTATUS=WIFI_ERROR;
       else
       {
         WIFISTATUS=WIFI_CONNECTINGWEB;
        tWifi=4;
       }
      }
      if (((tWifiConnected>WIFI_MAXCONNECTIONTIME ) && (action_wifi==1) && (monitor_mode==0)) || (action_wifi==0)) {
        wifidisconnect();
        WIFISTATUS=WIFI_DISCONNECTED;
              if (DEBUG_LEVEL>0) Serial.println(F("DISCONNECTING"));
        action_wifi=0;
      }
      break;
     
    case WIFI_CONNECTINGWEB: 
           if (DEBUG_LEVEL>1) Serial.println(F("."));
        response=wifiresponse(100);
       if (response==12)  {
         tWifi=0;
         WIFISTATUS=WIFI_SENDWEB;
       }
       else  
       if ((response==4) || (tWifi==0)) {
         tWifi=0;
         WIFISTATUS=WIFI_ERROR; 
       }
      break;
      
    case WIFI_SENDWEB:        
       wifisend(data_wifi);  
           if (DEBUG_LEVEL>0) Serial.println(F("SENDING"));
       action_wifi=1;
       tWifi=10;
       WIFISTATUS=WIFI_WAITINGCOMPLETION; 
      break;
     
     
    case WIFI_WAITINGCOMPLETION:  
     if (tWifi==0) {
       WIFISTATUS=WIFI_CONNECTED; 
       tWifiConnected=0;
           if (DEBUG_LEVEL>0) Serial.println(F("COMPLETE"));
     }
     else wificlearbuffer(100); 
     break;  
      
    case WIFI_ERROR:
        if (DEBUG_LEVEL>0) Serial.println(F("ERROR"));
        if (DEBUG_LEVEL>0) Serial.println(F("RESETTING"));
      wifireset();
      WIFISTATUS=WIFI_RESETTING;
      tWifi=10;    
      break;
      
    case WIFI_RESETTING:
      if (tWifi==0) {
        WIFISTATUS= WIFI_UNKNOWN;
        if (DEBUG_LEVEL>0) Serial.println(F("RESET COMPLETE"));
      }
      else wificlearbuffer(100); 
      break;
      
    }

}
  
 

void espdirectmode()
{
 
byte ch=0;
  
while (1==1)
{
wifiPort.listen();
if (wifiPort.available() ) {
Serial.write(wifiPort.read());
}
if (Serial.available() ){
ch=Serial.read();
if (ch=='>') {
 Serial.println(F("EXIT WIFI DIRECT MODE"));
  return;
}
if (ch=='!') { 
  wifiPort.println(F("AT+CWJAP?"));
  Serial.println(wifiresponse( 200));
}
else 
if (ch=='$') { 
//  wifistart();
  Serial.println(wifistart());
}
else 
if (ch=='@') { 
  Serial.println(wificonnect(1));
}
else 
if (ch=='%') { 
  Serial.println(wifisend(22));
}
else 
wifiPort.write(ch);

}


}
}


  
byte wifistart(){
  String cmd;
  cmd.reserve(64);
  cmd = "AT+CIPSTART=\"TCP\",\"";
  cmd += IP;
  cmd += "\",80";
  wifiPort.println(cmd);
  return wifiresponse(true,200);
} 

  
byte wifisend(byte wstatus){
  
  String cmd;
  cmd.reserve(64);
  cmd = GET;
  
  String cmd1;
  cmd1.reserve(64);
  cmd1= "&field1="+String(status_to_send);
 cmd1 += "&field2="+String(ac_on);
 cmd1 += "&field3="+String(wifi_used);
 if ((status_to_send==STATUS_TRIGGERED) || (status_to_send==STATUS_ALARM) ||(status_to_send==STATUS_FIRE)) cmd1 += "&field4="+String(tZone);
 if (DEBUG_LEVEL>0) Serial.println(cmd1);
 
  String cmd2;
  cmd2.reserve(64);
  cmd2=" HTTP/1.1\r\nHost: ";
  cmd2 += IP;
  cmd2 += "\r\nConnection: close\r\n\r\n";
 //api.thingspeak.com
 
  wifiPort.print(F("AT+CIPSEND="));
  wifiPort.println(cmd.length()+cmd1.length()+cmd2.length());
   if ( wifiresponse(100)==4) return 4;
   wifiPort.print(cmd);
   delay(10);
   wifiPort.print(cmd1);
   delay(10);
   wifiPort.print(cmd2);
   
   last_status_sent=status_to_send; 
   status_to_send=0;
  return 0;
  }

byte wifireset()
{
  wifiPort.println(F("AT+RST"));
  wifiPort.println(F("AT+CWMODE=1"));
  wifiPort.println(F("AT+CIPMUX=0"));
  wifiPort.println(F("AT+CIPSTO=30"));
  delay(500);//delay after mode change
  wifiPort.println(F("AT+RST"));
  return 1;
}
  
bool wificonnect(byte id)
{
  String cmd;
  cmd.reserve(64);
  cmd="AT+CWJAP=\""; // Join accespoint
  if (id==1) cmd+=SSID1; else cmd+=SSID2; 
  cmd+="\",\"";
  if (id==1) cmd+=PASS1; else  cmd+=PASS2;
  cmd+="\"";
  wifiPort.println(cmd);
   return 1;
}

bool wifidisconnect()
{
  wifiPort.println(F("AT+CWQAP"));
  return wifiresponse(200);
}


byte wificonnected()
{
  wifiPort.println(F("AT+CWJAP?"));
  return wifiresponse(200);
}

byte wifiresponse(unsigned long timeout)
{
  return wifiresponse(false, timeout);
}


byte wificlearbuffer(unsigned long timeout)
{
unsigned long initial=millis();
wifiPort.listen();
unsigned long current=millis();
while (((current-initial)<=timeout) &&(wifiPort.available()>0)) {
char ch=wifiPort.read();
current=millis();
}
}

byte wifiresponse(bool testOK,unsigned long timeout)
{
unsigned long initial=millis();
char buf[250];
byte blen=0;
buf[0]=0;
byte response=0;

unsigned long current=millis();
while ((current-initial)<=timeout) {
wifiPort.listen();
while (wifiPort.available()>0 ) {
char ch=wifiPort.read();

if ((ch<32) || (blen>248)) {
  buf[blen]=0;
  if (DEBUG_LEVEL>1) Serial.print("|");
  if (DEBUG_LEVEL>1) Serial.println(buf);
  if (strcmp2( buf, "AT+")!=0) {
  if (strstr( buf, SSID1) != NULL) response=1;
  if (strstr( buf, SSID2) != NULL) response=2;
  }
  if ((strcmp2( buf, "ERROR")==0) ||(strcmp2( buf, "FAIL")==0) ||(strcmp2( buf, "link is not")==0)||(strstr( buf, "Fail") != NULL)||(strcmp2( buf, "Unlink")==0) ) response=4;
  if (strcmp2( buf, "busy")==0) response=8;  
  if (strcmp( buf, "Linked")==0) response=12;   
  if ((strcmp2(buf,"OK")==0)&& testOK) return response;
 
  if (response>2) return response;
blen=0;
buf[0]=0;
}
else {
buf[blen]=ch;
blen++;
}
}
  
current=millis(); 
}
  
return response;  
}






byte wifiresponseSignal(int *wifi1,int *wifi2,unsigned long timeout)
{
unsigned long initial=millis();
char buf[250];
byte blen=0;
buf[0]=0;
byte response=0;

unsigned long current=millis();
while ((current-initial)<=timeout) {
wifiPort.listen();
while (wifiPort.available()>0 ) {
char ch=wifiPort.read();

if ((ch<32) || (blen>248)) {
  buf[blen]=0;
  if (DEBUG_LEVEL>1) Serial.print("|");
  if (DEBUG_LEVEL>1) Serial.println(buf);
  if (strcmp2( buf, "AT+")!=0) {
    
   char *cc=strstr( buf, SSID1);  
  if (cc != NULL) {
    cc=cc+sizeof(SSID1)+1;
    char *cc2=strstr( cc, ",");
   if (cc2 != NULL) *cc2=0; 
   *wifi1=String(cc).toInt();
  }
  
   cc=strstr( buf, SSID2);  
  if (cc != NULL) {
    cc=cc+sizeof(SSID1)+1;
    char *cc2=strstr( cc, ",");
   if (cc2 != NULL) *cc2=0; 
   *wifi2=String(cc).toInt();
  }
  

  }
  if ((strcmp2( buf, "ERROR")==0) ||(strcmp2( buf, "FAIL")==0) ||(strcmp2( buf, "link is not")==0)||(strstr( buf, "Fail") != NULL)||(strcmp2( buf, "Unlink")==0) ) response=4;
  if (strcmp2( buf, "busy")==0) response=8;  
  if (strcmp( buf, "Linked")==0) response=12;   
  if ((strcmp2(buf,"OK")==0)) response=14; 
 
  if (response>2) return response;
blen=0;
buf[0]=0;
}
else {
buf[blen]=ch;
blen++;
}
}
  
current=millis(); 
}
  
return response;  
}



void offlinemode()
{
   
Serial.println(F("!PANEL OFFLINE"));
Serial.end();
pinMode (0, INPUT) ;
pinMode (1, INPUT) ;

wifiPort.end();
pinMode (2, INPUT) ;
pinMode (3, INPUT) ;
 while (1==1) {}

}


byte strcmp2( char *a,  char *b)
{
  byte c=0;
 while (b[c]!=0) {
  if (a[c]!= b[c]) return 1; 
   c++;
 }
 return 0; 
}


//=======================================


void masterReset()
{
 USERPASS[0]='0';
 USERPASS[1]='1';
 USERPASS[2]='2';
 USERPASS[3]='3';
 USERPASS[4]=0;
 
 MASTERPASS[0]='9';
 MASTERPASS[1]='9';
 MASTERPASS[2]='9';
 MASTERPASS[3]='9'; 
 MASTERPASS[4]=0;
 
 ARMING_DELAY=30;
 LOG_WIFI=1; 
 ACTION_FAULT =2;
 
 ALARM_DURATION=5;
 DEBUG_LEVEL=0;

 for (byte z = 0; z < 13; z++) {
  zoneFlags[z][FLAG_NONC]=0; 
  zoneFlags[z][FLAG_MODE]=0; 
  zoneFlags[z][FLAG_DEBOUNCE]=3; 
  zoneFlags[z][FLAG_DELAY]=15;
  zoneFlags[z][CAUSE_NOT_READY]=0;
 }
 
 
  zoneFlags[0][FLAG_MODE]=1; 

for (byte c = 0; c < MAXCARDS; c++) {
for (byte d = 0; d < 15; d++) { 
 RFIDCARDS[c][d]=0;
 

}
}

}

void passwordReset()
{
 MASTERPASS[0]='0';
 MASTERPASS[1]='0';
 MASTERPASS[2]='0';
 MASTERPASS[3]='7'; 
 MASTERPASS[4]=0;
}



void readFromEPROM()
{
  
 long add=ZONE_FLAGS_ADDRESS;  
 
 for (byte f = 0; f < MAXFLAGS; f++) {
 for (byte z = 0; z < 13; z++) { 
   zoneFlags[z][f]=EEPROM.read(add);
  add++;
 }
 }  
  
add=MAIN_FLAGS_ADDRESS;
 for (byte c = 0; c < 5; c++) {
   MASTERPASS[c]=EEPROM.read(add);
  add++;
 }  
 for (byte c = 0; c < 5; c++) {
  USERPASS[c]=EEPROM.read(add);
  add++;
 }  
  
  ARMING_DELAY=EEPROM.read(add);
  add++; 
  
  LOG_WIFI=EEPROM.read(add);
  add++; 
  
 ACTION_FAULT=EEPROM.read(add);
  add++; 
  
  DEBUG_LEVEL=EEPROM.read(add);
  add++; 
  
  ALARM_DURATION=EEPROM.read(add);
  add++; 
  
  add=CARD_FLAGS_ADDRESS;
for (byte c = 0; c < MAXCARDS; c++) {
for (byte d = 0; d < 15; d++) { 
RFIDCARDS[c][d]=EEPROM.read(add);
add++; 
}
}


}

void writeToEPROM()
{

 long add=ZONE_FLAGS_ADDRESS;  
 
 for (byte f = 0; f < MAXFLAGS; f++) {
 for (byte z = 0; z < 13; z++) { 
   if (zoneFlags[z][f]!=EEPROM.read(add)) EEPROM.write(add, zoneFlags[z][f]);
  add++;
 }
 }
 
add=MAIN_FLAGS_ADDRESS;
 for (byte c = 0; c < 5; c++) {
   if (MASTERPASS[c]!=EEPROM.read(add)) EEPROM.write(add,MASTERPASS[c]);
  add++;
 }  
 for (byte c = 0; c < 5; c++) {
   if (USERPASS[c]!=EEPROM.read(add)) EEPROM.write(add,USERPASS[c]);
  add++;
 }  
  
   if (ARMING_DELAY!=EEPROM.read(add)) EEPROM.write(add,ARMING_DELAY);
  add++; 
   if (LOG_WIFI!=EEPROM.read(add)) EEPROM.write(add,LOG_WIFI);
  add++; 
   if (ACTION_FAULT!=EEPROM.read(add)) EEPROM.write(add,ACTION_FAULT);
  add++; 
   if (DEBUG_LEVEL!=EEPROM.read(add)) EEPROM.write(add,DEBUG_LEVEL);
  add++; 
   if (ALARM_DURATION!=EEPROM.read(add)) EEPROM.write(add,ALARM_DURATION);
  add++; 
  
  add=CARD_FLAGS_ADDRESS;
for (byte c = 0; c < MAXCARDS; c++) {
for (byte d = 0; d < 15; d++) { 
 if (RFIDCARDS[c][d]!=EEPROM.read(add))  EEPROM.write(add,RFIDCARDS[c][d]);
 add++; 
}
}
  
}
