/*
HOME GUARDUINO - KEYPAD FIRMWARE
Copyright 2015 Allan Murray, Auckland, New Zealand. 
Free for personal use only.

1.00 19/5/15
1.01 Fixed RFID temp 23/5/15
1.02 Fixed RFID 23/5/15
1.03 Not Ready/ double beep<10sec 30/05/15
1.05 Not Ready/ double beep<10sec 30/05/15 OK
1.1 release 30/05/15
1.2 reset display when waking display / poll status during countdown / do not clear input buffer when triggered / offline only possible in program mode 15/10/16
 */
 
#include <Keypad.h>
#include <LiquidCrystal595.h>   // include the library
#include <SPI.h>
#include <MFRC522.h>

#define program_version "Version 1.2"


#define SS_PIN 10
#define RST_PIN 9

LiquidCrystal595 lcd(4,5,6);     // datapin, latchpin, clockpin
MFRC522 mfrc522(SS_PIN, RST_PIN);	// Create MFRC522 instance.

#define buzzer 7 
#define redLED  3 
#define greenLED  9

#define OFF 0
#define RED  1 
#define GREEN 2
#define YELLOW 3
#define ORANGE 4

#define STATUS_READY 0 
#define STATUS_PROGRAM 1
#define STATUS_MASTER 2
#define STATUS_ARMING 3
#define STATUS_ARMED 4
#define STATUS_TRIGGERED 7
#define STATUS_ALARM 9
#define STATUS_FIRE 10

#define RFID_SAMPLE_INTERVAL 1200
#define DISPLAY_TIMEOUT 1  //MINUTES

#define CONNECTION_TEST_INTERVAL 60 //seconds must be greater than 5


char inputbuffer[19];
char statusbuffer[19];
byte statuslen=0;
byte bufferlen=0;
bool statusinput   =false;
bool errorstatus =false;
bool connectionok  =true;

byte alarmstatus;

byte count    =0;

bool flash=false;
bool second_start=false;
bool halfsec=false;
byte countdown  =0;

unsigned long time_current=0;
unsigned long time_last=0;
unsigned long time_last_second=0;
unsigned long time_error=0;
unsigned long time_display=0;
unsigned long time_connection=0;

const byte ROWS = 4; //four rows
const byte COLS = 4; //three columns
char keys[ROWS][COLS] = {
  {'1','2','3','A'},
  {'4','5','6','B'},
  {'7','8','9','C'},
  {'*','0','#','D'}
};
byte rowPins[ROWS] = {A4, A5, 8, 2}; //connect to the row pinouts of the keypad
byte colPins[COLS] =  {A0, A1, A2, A3};//connect to the column pinouts of the keypad
Keypad keypad = Keypad( makeKeymap(keys), rowPins, colPins, ROWS, COLS );


byte house[8] = {
  B00100,
  B01010,
  B10101,
  B01110,
  B11111,
  B11011,
  B11011,
  B00000

};


unsigned long beepon   =0;
unsigned long beepoff  =0;


void(* resetFunc) (void) = 0;

void setup(){
    
    time_display=DISPLAY_TIMEOUT*60;
    lcd.begin(16,2);   
  
    lcd.createChar(0, house);
    lcd.setLED2Pin(HIGH);
    lcd.clear();
    lcd.setCursor(0,0);
    lcd.write(0);
    lcd.print (" HomeGuarduino");
    lcd.setCursor(0,1);
    lcd.print (program_version);
 
  Serial.begin(9600);
 
  pinMode (buzzer, OUTPUT) ;
  pinMode (redLED, OUTPUT) ;
  pinMode (greenLED, OUTPUT) ;
   LED(OFF);
  digitalWrite (buzzer, HIGH) ;// send voice

    
    	SPI.begin();			// Init SPI bus
	mfrc522.PCD_Init();	// Init MFRC522 card
  statusbuffer[0]=0;
  inputbuffer[0]=0;
  alarmstatus=STATUS_READY;
  time_connection=CONNECTION_TEST_INTERVAL;
  
  delay(2000);
  LED(GREEN);
    lcd.clear();
    lcd.setCursor(0,1);  
    
}

void loop(){
  
time_current=millis();


 if (((time_current-time_last_second)>30) &&(second_start)){ //EVERY SECOND+200ms
 second_start=false;
 
if ((alarmstatus==STATUS_ARMING) ||(alarmstatus==STATUS_TRIGGERED) ){
   digitalWrite (buzzer, HIGH) ;
   LED(OFF); 
}  


 }



 if (((time_current-time_last_second)>500)  && halfsec) { //EVERY half SECOND
 halfsec=false;
if ( ((alarmstatus==STATUS_ARMING) ||(alarmstatus==STATUS_TRIGGERED) )&& (countdown<10)){
   digitalWrite (buzzer, LOW);
   delay(20);
   digitalWrite (buzzer, HIGH); 
  }
 }

 if ((time_current-time_last_second)>1000) { //EVERY SECOND
 
 if ( ((alarmstatus==STATUS_ARMING) ||(alarmstatus==STATUS_TRIGGERED) )&& (countdown<10)) Serial.println("?");
 
   halfsec=true;
    
   if (time_display>0) {
    time_display=time_display-1;
    if ( time_display==0) {
      lcd.setLED2Pin(LOW); //DISPLAY_TIMEOUT
      lcd.setCursor(0,1); 
      lcd.print("                ");
      bufferlen=0;
      inputbuffer[bufferlen]=0;
    }
   }
   
   if (time_error>0) {
    time_error=time_error-1;
    if (( time_error==0) && (bufferlen==0)){
      lcd.setCursor(0,1); 
      lcd.print("                ");
    }
   }
   
   if (time_connection>0) {
    time_connection=time_connection-1;
    if (time_connection==5){
      Serial.println("?");
      connectionok  =false;
    }
    if (time_connection==0){
      time_connection=CONNECTION_TEST_INTERVAL;
     if (!connectionok) { 
      wakeDisplay();
      errorstatus=true;
      time_error=10;
      lcd.setCursor(0,1); 
      lcd.print("ER: NO RESPONSE ");
       digitalWrite (buzzer, LOW) ;// send voice
       delay(300);
       digitalWrite (buzzer, HIGH) ;// send voice
     }
    }
   }
 
   second_start=true;
   time_last_second=time_current;
  
 
if (alarmstatus==STATUS_ARMING) {
   LED(ORANGE);
   digitalWrite (buzzer, LOW) ;
}  
  
if (alarmstatus==STATUS_TRIGGERED) {
   LED(RED);
   digitalWrite (buzzer, LOW) ;
  }
  
  
if ((alarmstatus==STATUS_FIRE) ||(alarmstatus==STATUS_ALARM) ){
  flash=!flash;
  if (flash) LED(RED);
  else LED(OFF);
 if  (flash) digitalWrite (buzzer, LOW); 
   else digitalWrite (buzzer, HIGH) ;
}  
    
  
}   
  
  

  
  //Read status info from main unit
  if ((Serial.available()>0 ) & !statusinput){
    
    connectionok=true;
    
    while (Serial.available()>0 ) {
      char s=Serial.read();
      if ((s<31) || (statuslen>=18)) {
       if (statuslen>0) { 
       statusinput=true;
       statusbuffer[statuslen]=0;
       break;
       }
      }
      else
      {
      statusbuffer[statuslen]=s;
      statuslen++;
      statusbuffer[statuslen]=0;
      }
    }
    
  }

  if ((statusinput) && (statusbuffer[0]=='>')) {

     bool validstatus=false;
     
     if ( (strcmp2(statusbuffer,">READY")==0)||
    (strcmp2(statusbuffer,">NOT READY")==0))
     {
       beepon=0;
      validstatus=true;
      if (alarmstatus!=STATUS_READY) clearbuffer();
      alarmstatus=STATUS_READY;
      LED(GREEN);
      digitalWrite (buzzer, HIGH) ;
     }     
     
     if (strcmp2(statusbuffer,">ARMED")==0) {
            wakeDisplay();
      validstatus=true;
      beepon=0;
      if (alarmstatus!=STATUS_ARMED) clearbuffer();
      alarmstatus=STATUS_ARMED;
      LED(RED);
       digitalWrite (buzzer, HIGH) ;
     }    
     
     if (strcmp2(statusbuffer,">ALARM")==0) {
            wakeDisplay();
       beepoff  =1000;
       beepon =1000;
      validstatus=true;
      //if (alarmstatus!=STATUS_ALARM) clearbuffer();
      alarmstatus=STATUS_ALARM;
      LED(RED);
     }     
     
     if (strcmp2(statusbuffer,">FIRE")==0) {
            wakeDisplay();
      validstatus=true;
      if (alarmstatus!=STATUS_FIRE) clearbuffer();
      alarmstatus=STATUS_FIRE;
      beepon =1000;
      LED(RED);
     }     
     
     if (strcmp2(statusbuffer,">RESET")==0)  resetFunc(); 
     
     if (strcmp2(statusbuffer,">PROGRAM")==0) {
            wakeDisplay();
       beepon=0;
      validstatus=true;
      if (alarmstatus!=STATUS_PROGRAM) clearbuffer();
      alarmstatus=STATUS_PROGRAM;
      LED(YELLOW);
      digitalWrite (buzzer, HIGH) ;
     }  
     
     if (strcmp2(statusbuffer,">TRIGGERED")==0) {
       countdown=readnumber(&statusbuffer[11]);
            wakeDisplay();
       beepoff  =920;
       beepon =0;
      validstatus=true;
      //if (alarmstatus!=STATUS_TRIGGERED) clearbuffer();
      alarmstatus=STATUS_TRIGGERED;
      LED(RED);
     }      
     
     if (strcmp2(statusbuffer,">ARMING")==0) {
       countdown=readnumber(&statusbuffer[8]);
        wakeDisplay();
       beepoff  =920;
       beepon =0;
      validstatus=true;
      if (alarmstatus!=STATUS_ARMING) clearbuffer();
      alarmstatus=STATUS_ARMING;
      LED(RED);
     }     
     
     
    if (validstatus) {
      lcd.setCursor(0,0); 
      lcd.print("                ");
      lcd.setCursor(0,0);
      lcd.print( &statusbuffer[1]);
    }
   } 
    
    
  if ((statusinput) && (statusbuffer[0]=='!')) {
    
     if (strcmp2(statusbuffer,"!BEEP1")==0) {
       digitalWrite (buzzer, LOW) ;// send voice
       delay(200);
       digitalWrite (buzzer, HIGH) ;// send voice
       delay(70);
       digitalWrite (buzzer, LOW) ;// send voice
       delay(200);
       digitalWrite (buzzer, HIGH) ;// send voice
       delay(70);
       digitalWrite (buzzer, LOW) ;// send voice
       delay(400);
       digitalWrite (buzzer, HIGH) ;// send voice
     } 
   else
     if (strcmp2(statusbuffer,"!BEEP2")==0) {
       digitalWrite (buzzer, LOW) ;// send voice
       delay(100);
       digitalWrite (buzzer, HIGH) ;// send voice
       delay(100);
       digitalWrite (buzzer, LOW) ;// send voice
       delay(100);
       digitalWrite (buzzer, HIGH) ;// send voice
     } 
   else
     if (strcmp2(statusbuffer,"!BEEP3")==0) {
       digitalWrite (buzzer, LOW) ;// send voice
       delay(300);
       digitalWrite (buzzer, HIGH) ;// send voice
     } 
    else
     if (strcmp2(statusbuffer,"!BEEP4")==0) {
       digitalWrite (buzzer, LOW) ;// send voice
       delay(100);
       digitalWrite (buzzer, HIGH) ;// send voice
     } 
    else
     if (strcmp2(statusbuffer,"!BEEP5")==0) {
       digitalWrite (buzzer, LOW) ;// send voice
       delay(50);
       digitalWrite (buzzer, HIGH) ;// send voice
     } 
    else
    {
      
      if (statusbuffer[1]=='!') {
      if (bufferlen==0) { 
      wakeDisplay();
      errorstatus=true;
      time_error=10;
      lcd.setCursor(0,1); 
      lcd.print("                ");
      lcd.setCursor(0,1);
      lcd.print( &statusbuffer[2]);
       digitalWrite (buzzer, LOW) ;// send voice
       delay(300);
       digitalWrite (buzzer, HIGH) ;// send voice
      } 
      }
      else
      {
      errorstatus=true;
      time_error=4;
      lcd.setCursor(0,1); 
      lcd.print("                ");
      lcd.setCursor(0,1);
      lcd.print( &statusbuffer[1]);
      bufferlen=0;
      inputbuffer[bufferlen]=0;
      }
    }
     }     
    
    
  if (statusinput) {
  statuslen=0;
  statusbuffer[statuslen]=0;
  statusinput=false;  
  }

  //Read keypad input
  unsigned char i, j;
  char key = keypad.getKey();

  if (key != NO_KEY){
    
     wakeDisplay();
    
   if (errorstatus=true) {
    lcd.setCursor(0,1);
    lcd.print("                ");
    lcd.setCursor(0,1);
    errorstatus=false;
   } 
    
    if (bufferlen<16) {
      inputbuffer[bufferlen]=key;
      bufferlen++;
      inputbuffer[bufferlen]=0;
       
    }
    
    if ((key=='A') |(key=='B') |(key=='C') |(key=='D') | (bufferlen>=16))  {
      
      
      Serial.println(inputbuffer);
    if ((strcmp(inputbuffer,"*#*#B")==0) && (alarmstatus==STATUS_PROGRAM))  offlinemode();
    if ((strcmp(inputbuffer,"*#*#D")==0) && (alarmstatus==STATUS_PROGRAM))  Serial.println("OFFLINE");
    
      bufferlen=0;
      inputbuffer[bufferlen]=0;
    lcd.setCursor(0,1);
    lcd.print("                ");
    lcd.setCursor(0,1);
    }
    else {
    lcd.setCursor(0,1);
    lcd.print("                ");
    lcd.setCursor(0,1);
    if (alarmstatus==STATUS_PROGRAM)lcd.print(inputbuffer);
    else for (i = 0; i <bufferlen; i++)   lcd.print("*"); 
    }
   // beep(800,20); 
    //beep(2200,80); 
    if (beepon==0){
   // digitalWrite (buzzer, HIGH) ;// send voice
  //  delay(30);
     digitalWrite (buzzer, LOW) ;// send voice
    delay(50);
    digitalWrite (buzzer, HIGH) ;// send voice
    }
    
       
 
  }
  
  
  
  if ((time_current-time_last)>RFID_SAMPLE_INTERVAL) {
   time_last=time_current;
   
  
    
    //Read RFID input
    if (mfrc522.PICC_IsNewCardPresent() &  mfrc522.PICC_ReadCardSerial()) {
   wakeDisplay();
    lcd.setCursor(0,1);
    lcd.print("                ");
    lcd.setCursor(0,1);
    bufferlen=0;
    inputbuffer[bufferlen]=0;
    lcd.setCursor(0,1);
    lcd.print("                ");
    lcd.setCursor(0,1);
    int len=mfrc522.uid.size;
    if (len>7) len=7;
    if (len<4) lcd.print("BAD CARD");
    else
    {
        lcd.print("CARD");
	for (byte i = 0; i < len; i++) {
		Serial.print(mfrc522.uid.uidByte[i] < 0x10 ? "0" : "");
		Serial.print(mfrc522.uid.uidByte[i], HEX);
        }
    Serial.println("R");
    }
    LED(ORANGE);
    digitalWrite (buzzer, LOW) ;// send voice
    delay(200);
    digitalWrite (buzzer, HIGH) ;// send voice
    if (alarmstatus==STATUS_READY) LED(GREEN);
    else if (alarmstatus==STATUS_ARMED) LED(RED);
    else LED(YELLOW);
    }
  }

  
}


byte readnumber(char *i)
{
 if (isnumber(i)) return String(i).toInt();
 else return 0; 
}


bool isnumber(char *i)
{
byte d=0;
while ((d<10) && (i[d]!=0)) {
   if ((i[d]<'0') || (i[d]>'9')) return false;
   d++;
 }
  return true;
}

byte strcmp2( char *a,  char *b)
{
  byte c=0;
 while (b[c]!=0) {
  if (a[c]!= b[c]) return 1; 
   c++;
 }
 return 0; 
  
}


void clearbuffer()
{
 lcd.clear();
    bufferlen=0;
    inputbuffer[bufferlen]=0;
}


void offlinemode()
{
  
       digitalWrite (buzzer, LOW) ;// send voice
    delay(50);
    digitalWrite (buzzer, HIGH) ;// send voice
    lcd.setCursor(0,0);
    lcd.print("                ");  
    lcd.setCursor(0,0);
    lcd.print("KEYPAD OFFLINE"); 
Serial.end();
pinMode (0, INPUT) ;
pinMode (1, INPUT) ;

 while (keypad.getKey()!='C') {}

 Serial.begin(9600);
    lcd.setCursor(0,0);
    lcd.print("OK                "); 
}


void wakeDisplay()
{
    if (time_display==0) {
      clearbuffer();
      lcd.begin(16,2);  
      lcd.clear();
      Serial.println("?");
      lcd.setLED2Pin(HIGH); 
    }
    time_display=DISPLAY_TIMEOUT*60;
 

}


void LED(byte colour)
{
  
  if (colour==OFF) {
    analogWrite(greenLED,0);
   analogWrite(redLED,0);
  }  
  
  if (colour==RED) {
    analogWrite(greenLED,0);
   analogWrite(redLED,255); 
  }  
  
  if (colour==GREEN) {
    analogWrite(greenLED,255);
   analogWrite(redLED,0);
  }  
 
  if (colour==YELLOW) {
    analogWrite(greenLED,255);
   analogWrite(redLED,70);
  }  
  
  if (colour==ORANGE) {
    analogWrite(greenLED,180);
   analogWrite(redLED,240);
  }  
    
}

 
  
  
 
 
