#include <XBee.h>


XBee xbee = XBee();
XBeeResponse response = XBeeResponse();
// create reusable response objects for responses we expect to handle 
ZBRxResponse rx = ZBRxResponse();
ModemStatusResponse msr = ModemStatusResponse();




int temp = 0;
int NectarContainer = 0;
const int MaxContainer = 3;
int FlowerId = 0;
long start = 0;
long timeTemp =0;
int mod;

int potPin = 0;
int potVal = 0;

int flowerPin1 =  7;    // LED connected to digital pin 5
int flowerPin2 =  6;    // LED connected to digital pin 6
int flowerPin3 =  5;    // LED connected to digital pin 7


int necVal1 =  2;    // LED connected to digital pin 5
int necVal2 =  3;    // LED connected to digital pin 6
int necVal3 =  4;    // LED connected to digital pin 7


int fakeGround = 13;
int fakeGround2 = 8;
int fakeHigh = 12;
int hertz = 100;

long previousMillis = 0;           // interval at which to blink (milliseconds)
int ledState = LOW;             // ledState used to set the LED

//long time = (60000*1); //60000 milliseconds times number of minutes
long time = (60000*1); //60000 milliseconds times number of minutes
int blinkTime = 100;           // interval at which to blink (milliseconds)
int flowerLevel = 0;
long flowerTimer = 0;         //Timer to keep track of flower nectar level display time
int flowerTime = 5000;        //Number of milliseconds to show flower nectar level

char const  numDataPts = 20;
int potValArray[numDataPts];

char lowBit;
char highBit;

uint8_t payload[] = {
  MaxContainer, NectarContainer, FlowerId, start,lowBit,highBit,'B','Z','2' }; //Data Array to send to Coordinator.


XBeeAddress64 addr64 = XBeeAddress64(0,0); //Address Coordinator

// Create a TX Request
ZBTxRequest zbTx = ZBTxRequest(addr64, payload, sizeof(payload));

// Create a Status Response object
ZBTxStatusResponse txStatus = ZBTxStatusResponse();



void setup() {
  pinMode(flowerPin1, OUTPUT);     
  pinMode(flowerPin2, OUTPUT);     
  pinMode(flowerPin3, OUTPUT);     

  pinMode(necVal1, OUTPUT);     
  pinMode(necVal2, OUTPUT);     
  pinMode(necVal3, OUTPUT);     

  pinMode(fakeGround, OUTPUT);
  pinMode(fakeHigh, OUTPUT);
  pinMode(fakeGround2,OUTPUT);
  digitalWrite(fakeGround,LOW); 
  digitalWrite(fakeGround2,LOW); 
  digitalWrite(fakeHigh,HIGH); 


  digitalWrite(14, HIGH); //enable pull-up resistor on Analog Pin 0

  intialize();
  
  Serial.begin(9600);
  xbee.begin(9600);

  removeBee();
  displayFlowerNectar(1);
  delay(100);
  displayFlowerNectar(2);
  delay(100);
  displayFlowerNectar(3);
  delay(100);
  start = millis();

}

void loop() {
  checkINMessage();
  touchFlower();

}

float average(int * _potValArray) {
  float tempAvg = 0;
  int minVal = 0;
  int maxVal = 0;
  int nonVals = 0;
  for(int i = 0; i < numDataPts; i++) {
    tempAvg += _potValArray[i];
    
        // record the maximum sensor value
    if (_potValArray[i] > maxVal) {
      maxVal = _potValArray[i];
    }

    // record the minimum sensor value
    if (_potValArray[i] < maxVal & _potValArray[i] != 0) {
      minVal = _potValArray[i];
    }
    
    if(_potValArray[i] == 0) {
      nonVals += 1;
    }
  }

  tempAvg = tempAvg - minVal - maxVal; //throw out max and min values and average
  return tempAvg/(float)(numDataPts-nonVals-2);

}

void touchFlower() {
  potVal = analogRead(potPin);
  if (potVal < 50 | potVal > 1000) {         //too low or too high do nothing     
    delay(20);
  }
  else {                                     //Flower detected, start wireless communication

    for(int i = 0; i < numDataPts; i++) {
      potVal = analogRead(potPin);
      if (potVal < 50 | potVal > 890) {
      }
      else {
        Serial.print("potVal: ");
        Serial.println(potVal);
        delay(40);
        potValArray[i] = potVal;
      }
    }
    float avg = average(potValArray);
    Serial.print("Averae: ");
    Serial.println(avg);
    Serial.print("Twelves: ");
    Serial.println(avg/12.0);

    clearArray();
    removeBee();
    delay(1000);
    payload[2] = 147; //avg/12; //Send potVal to central computer, mapping done there
    char hbit = (byte)((int)avg/12 >> 8);
    char lbit = (byte)((int)avg/12 & 0xff);
    payload[4] = lbit;
    payload[5] = hbit;  
    
    timeTemp = time - millis() + start;
    
    if ( timeTemp > 0 ) {    //if light is not red...
      payload[3] = 1;                          // Send OK to central PC
    }
    else{
      payload[3] = 0;
    }
    xbee.send(zbTx);
    delay(100);

  }
}

void removeBee() {
  for(int i = 0; i< 10; i++) {
    digitalWrite(necVal1, HIGH);   // set the LED on
    delay(hertz);                  // wait for a second
    digitalWrite(necVal1, LOW);    // set the LED off
    digitalWrite(necVal2, HIGH);   // set the LED on
    delay(hertz);                  // wait for a second
    digitalWrite(necVal2, LOW);    // set the LED off
    digitalWrite(necVal3, HIGH);   // set the LED   on
    delay(hertz);                  // wait for a second
    digitalWrite(necVal3, LOW);    // set the LED off
  }
}

void clearArray() {
  for(int i = 0; i < numDataPts; i++) {
    potValArray[i] = 0;
    ;
  }
}

void checkINMessage() {

  
  //CODE TO CHECK FOR A MESSAGE  
  xbee.readPacket(1500);
  if (xbee.getResponse().isAvailable()) {
    // got something
    //Serial.println("About to get data");  
    

    if (xbee.getResponse().getApiId() == ZB_RX_RESPONSE) {
      // got a zb rx packet
      // now fill our zb rx class
      
      xbee.getResponse().getZBRxResponse(rx);
      temp = rx.getData(0);
      NectarContainer=temp;
      
      temp = rx.getData(1);
      if (!(temp == flowerLevel)) {  //reset flower timer
        flowerTimer = millis();
        flowerLevel = temp;
      }

      
      temp = rx.getData(2);
      
      if(!(temp)) {
        int delayTime = 250;
        int numTimes = 45;
        for ( int i = 1; i <= 45; i++){
          color(255,255,255);
          delay(delayTime);
          color(0,0,0);
          delay(delayTime); 
        }
        start = millis();
      }
      temp = rx.getData(3);
      time = temp*60000;
    }
  }
   displayNectar();
   if ( (millis() - flowerTimer) > flowerTime){
    flowerLevel = 0;
  }

  displayFlowerNectar(flowerLevel);
  //SET ENERGY LED
  if (millis() - start <= time / 2.0){
    color(0,255, 0); 	         // turn the RGB LED green
  } 
  else if ( (millis() - start > time / 2.0) && (millis() - start < 3.0 * time / 4.0) ){
    color(150,255, 0); 	         // turn the RGB LED yellow
  }
  else if ( (millis() - start > 3.0 * time / 4.0) && (millis() - start < time )){
    color (255, 165, 0);         //turn the RGB LED orange
  }
  else {
    color(255,0,0); 	         // turn the RGB LED red 
  }

}


void displayFlowerNectar(int nect) {
  (nect > 0 ? digitalWrite(flowerPin1, HIGH) : digitalWrite(flowerPin1, LOW));   // set the LED on
  (nect > 1 ? digitalWrite(flowerPin2, HIGH) : digitalWrite(flowerPin2, LOW));   // set the LED on
  (nect > 2 ? digitalWrite(flowerPin3, HIGH) : digitalWrite(flowerPin3, LOW));   // set the LED on

  //flowers 2,3,4
}

void displayNectar() {
  (NectarContainer > 0 ? digitalWrite(necVal1, HIGH) : digitalWrite(necVal1, LOW));   // set the LED on
  (NectarContainer > 1 ? digitalWrite(necVal2, HIGH) : digitalWrite(necVal2, LOW));   // set the LED on
  (NectarContainer > 2 ? digitalWrite(necVal3, HIGH) : digitalWrite(necVal3, LOW));   // set the LED on

  //flowers 2,3,4
}
